/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging.java2d;

import com.mullassery.imaging.ImageLoader;
import com.mullassery.imaging.util.Util;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageIOLoader
implements ImageLoader {
    public BufferedImage read(File file) {
        try {
            return Util.createBufferedImage(ImageIO.read(file), Util.getExtentionType(file.toString()));
        }
        catch (IOException iOException) {
            throw new ImagingOpException(iOException.getMessage());
        }
    }

    public BufferedImage read(String string) {
        return this.read(new File(string));
    }

    public BufferedImage read(URL uRL) {
        try {
            return Util.createBufferedImage(ImageIO.read(uRL), Util.getExtentionType(uRL.toString()));
        }
        catch (IOException iOException) {
            throw new ImagingOpException(iOException.getMessage());
        }
    }

    public void write(BufferedImage bufferedImage, OutputStream outputStream, String string, float f) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
        catch (IOException iOException) {
            throw new ImagingOpException(iOException.getMessage());
        }
    }

    public void write(BufferedImage bufferedImage, String string, String string2, float f) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
        }
        catch (IOException iOException) {
            throw new ImagingOpException(iOException.getMessage());
        }
    }

    public BufferedImage read(InputStream inputStream) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException iOException) {
            throw new ImagingOpException(iOException.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

