/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging.java2d;

import com.mullassery.imaging.Imaging;
import com.mullassery.imaging.ImagingFactory;
import com.mullassery.imaging.VisualTestCase;
import com.mullassery.imaging.java2d.AWTLoader;
import com.mullassery.imaging.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.Assert;

public class Java2DImagingTest
extends VisualTestCase {
    private Imaging j2d;
    private URL url1;
    private URL url2;
    private URL url_gif;

    protected void setUp() throws Exception {
        this.j2d = ImagingFactory.createImagingInstance(1);
        this.url1 = Util.getFileURL(new File("images/new.jpg"));
        this.url2 = Util.getFileURL(new File("images/splash.jpg"));
        this.url_gif = Util.getFileURL(new File("images/new.gif"));
    }

    protected void tearDown() throws Exception {
        this.j2d = null;
    }

    public final void testConversion() throws Exception {
        String string = "images/pnglogo";
        String string2 = "png";
        File file = new File(string + '.' + string2);
        Imaging imaging = ImagingFactory.createImagingInstance();
        BufferedImage bufferedImage = imaging.read(file);
        BufferedImage bufferedImage2 = imaging.resize(bufferedImage, 50, 50, true);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has the image resized?");
        File file2 = new File(string + "_sm" + '.' + "jpg");
        imaging.write(bufferedImage2, file2.getAbsolutePath(), "JPEG", 0.8f);
        Assert.assertTrue((boolean)file2.exists());
        this.checkImage(new BufferedImage[]{bufferedImage2, imaging.read(file2)}, "Has the image been saved?");
    }

    public final void testAWTLoading() {
        AWTLoader aWTLoader = new AWTLoader();
        try {
            BufferedImage bufferedImage = aWTLoader.read(((Object)((Object)this)).getClass().getResource("/images/splash.jpg"));
            BufferedImage bufferedImage2 = aWTLoader.read(new FileInputStream(new File("images/new.png")));
            BufferedImage bufferedImage3 = aWTLoader.read(new File("images/new.gif"));
            this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2, bufferedImage3}, "Has AWT loaded the Images?");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Assert.fail((String)fileNotFoundException.getMessage());
        }
    }

    public final void testLoading() {
        try {
            BufferedImage bufferedImage = this.j2d.read(((Object)((Object)this)).getClass().getResource("/images/splash.jpg"));
            BufferedImage bufferedImage2 = this.j2d.read(new FileInputStream(new File("images/new.png")));
            BufferedImage bufferedImage3 = this.j2d.read(new File("images/new.gif"));
            this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2, bufferedImage3}, "Has it loaded the Images?");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Assert.fail((String)fileNotFoundException.getMessage());
        }
    }

    public final void testResize() {
        BufferedImage bufferedImage = this.j2d.read(this.url2);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        float f = 0.8f;
        BufferedImage bufferedImage2 = this.j2d.scale(bufferedImage, f);
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = (int)((float)n * f) - n3;
        int n6 = (int)((float)n2 * f) - n4;
        Assert.assertTrue((n5 < 5 && n5 > -5 ? 1 : 0) != 0);
        Assert.assertTrue((n6 < 5 && n6 > -5 ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it resized (" + f + ")?");
        bufferedImage2 = this.j2d.resize(bufferedImage, 800, n2 / 2, true);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it resized to 50%?");
    }

    public final void testCrop() {
        BufferedImage bufferedImage = this.j2d.read(this.url2);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = this.j2d.crop(bufferedImage, 20.0f, 20.0f, n - 40, n2 - 40);
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = n - n3;
        int n6 = n2 - n4;
        Assert.assertTrue((n5 == 40 ? 1 : 0) != 0);
        Assert.assertTrue((n6 == 40 ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it cropped?");
    }

    public final void testRotate() {
        BufferedImage bufferedImage = this.j2d.read(this.url1);
        BufferedImage bufferedImage2 = this.j2d.rotate(bufferedImage, Util.degrees2Radians(45.0f));
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it rotated by 45 Deg about its center?");
        bufferedImage2 = this.j2d.rotate(bufferedImage, Util.degrees2Radians(-45.0f));
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has it rotated by -45 Deg about its top-left?");
    }

    public final void testBorder() {
        BufferedImage bufferedImage = this.j2d.read(this.url_gif);
        BufferedImage bufferedImage2 = this.j2d.border(bufferedImage, 10, 5, Color.red);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Has a border been added?");
    }

    public final void testOverlay() {
        BufferedImage bufferedImage = this.j2d.read(this.url_gif);
        BufferedImage bufferedImage2 = this.j2d.read(this.url2);
        Color color = Color.yellow;
        BufferedImage bufferedImage3 = this.j2d.overlay(bufferedImage2, bufferedImage, 20, 20);
        this.checkImage(new BufferedImage[]{bufferedImage3}, "Has it overlaid the image?");
        bufferedImage3 = this.j2d.overlay(bufferedImage2, bufferedImage, 20, 20, color, 30);
        this.checkImage(new BufferedImage[]{bufferedImage3}, "Has it overlaid the image without the yellow parts?");
    }

    public final void testGrayscale() {
        BufferedImage bufferedImage = this.j2d.read(this.url1);
        BufferedImage bufferedImage2 = this.j2d.grayscale(bufferedImage, 0.5);
        this.checkImage(new BufferedImage[]{bufferedImage2}, "Was the image converted to grayscale?");
    }

    public final void testTextOverlay() throws MalformedURLException {
        BufferedImage bufferedImage = this.j2d.read(Util.getFileURL(new File("images/woods.jpg")));
        BufferedImage bufferedImage2 = this.j2d.scale(bufferedImage, 0.5f);
        String string = "<html><body><p><b><font color=\"#550000\" size=\"12\">Stopping By Woods On A Snowy Evening</font></b><p><font face=\"arial\" color=\"#002200\">Whose woods these are I think I know.<br>His house is in the village though;<br>He will not see me stopping here<br>To watch his woods fill up with snow.<br><br>My little horse must think it queer<br>To stop without a farmhouse near<br>Between the woods and frozen lake<br>The darkest evening of the year.<br><br>He gives his harness bells a shake<br>To ask if there is some mistake.<br>The only other sound's the sweep<br>Of easy wind and downy flake.<br><br>The woods are lovely, dark and deep.<br>But I have promises to keep,<br>And miles to go before I sleep,<br>And miles to go before I sleep.</font></body></html>";
        BufferedImage bufferedImage3 = this.j2d.textOverlay(bufferedImage2, string, 100, 100, bufferedImage2.getWidth() - 100, new Font("Dialog", 1, 12), Color.blue, true);
        this.checkImage(new BufferedImage[]{bufferedImage3}, "Was the text overlaid?");
        bufferedImage3 = this.j2d.htmlOverlay(bufferedImage2, string, 100, 100, bufferedImage2.getWidth() - 100, bufferedImage2.getHeight() - 100, true);
        this.checkImage(new BufferedImage[]{bufferedImage3}, "Was the html overlaid?");
        bufferedImage3 = this.j2d.textButton(this.j2d.read(this.url2), "Abey Mullassery", 20, 0, 50, 2, 150, new Font("Dialog", 1, 20), Color.red, true);
        this.checkImage(new BufferedImage[]{bufferedImage3}, "Was the text button created?");
    }

    public final void testTransparency() {
        BufferedImage bufferedImage = this.j2d.read(this.url2);
        BufferedImage bufferedImage2 = null;
        bufferedImage2 = this.j2d.read(this.url1);
        bufferedImage2 = this.j2d.addTransparency(bufferedImage2, 125);
        this.checkImage(new BufferedImage[]{this.j2d.overlay(bufferedImage, bufferedImage2, 10, 10, Color.white, 30)}, "Was the JPEG image translucent and without background?");
    }

    public final void testConvolveBlur() {
        BufferedImage bufferedImage = this.j2d.read(this.url2);
        BufferedImage bufferedImage2 = this.j2d.convolve(bufferedImage, new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f});
        Assert.assertTrue((bufferedImage2 != null ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Was the image blurred?");
    }

    public final void testConvolveSharpen() throws FileNotFoundException {
        BufferedImage bufferedImage = new AWTLoader().read(new FileInputStream("images/splash.jpg"));
        BufferedImage bufferedImage2 = this.j2d.convolve(bufferedImage, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
        Assert.assertTrue((bufferedImage2 != null ? 1 : 0) != 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Was the image sharpened?");
    }

    public final void testLoad() {
        BufferedImage bufferedImage = this.j2d.read(this.url1);
        Assert.assertNotNull((Object)bufferedImage);
    }

    public final void testFlip() {
        BufferedImage bufferedImage = this.j2d.read(this.url2);
        BufferedImage bufferedImage2 = this.j2d.flip(bufferedImage, 0);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Was the image flipped vertically?");
        bufferedImage2 = this.j2d.flip(bufferedImage, 1);
        this.checkImage(new BufferedImage[]{bufferedImage, bufferedImage2}, "Was the image flipped horizontally?");
    }
}

