/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging.java2d;

import com.mullassery.imaging.AbstractTransformer;
import com.mullassery.imaging.util.TransformerUtil;
import com.mullassery.imaging.util.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;

public class Java2DTransformer
extends AbstractTransformer {
    public RenderingHints rh;

    public BufferedImage border(BufferedImage bufferedImage, int n, int n2, Color color) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = n3 + 2 * n;
        int n6 = n4 + 2 * n2;
        if (color == null) {
            color = Color.BLACK;
        }
        BufferedImage bufferedImage2 = Util.createSimilar(bufferedImage, n5, n6);
        int n7 = color.getRGB();
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                if (i >= n && i < n5 - n && j >= n2 && j < n6 - n2) {
                    bufferedImage2.setRGB(i, j, bufferedImage.getRGB(i - n, j - n2));
                    continue;
                }
                bufferedImage2.setRGB(i, j, n7);
            }
        }
        return bufferedImage2;
    }

    public BufferedImage crop(BufferedImage bufferedImage, float f, float f2, float f3, float f4) {
        return bufferedImage.getSubimage((int)f, (int)f2, (int)f3, (int)f4);
    }

    public BufferedImage grayscale(BufferedImage bufferedImage, double d) {
        BufferedImage bufferedImage2 = Util.createSimilar(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), ColorSpace.getInstance(1003), this.rh);
        graphics2D.drawImage(bufferedImage, colorConvertOp, 0, 0);
        return bufferedImage2;
    }

    public BufferedImage overlay(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, Color color, int n3) {
        if (color == null) {
            BufferedImage bufferedImage3 = Util.duplicate(bufferedImage);
            bufferedImage3.createGraphics().drawImage(bufferedImage2, null, n, n2);
            return bufferedImage3;
        }
        return TransformerUtil.overlay(bufferedImage, bufferedImage2, n, n2, color, n3);
    }

    public BufferedImage rotate(BufferedImage bufferedImage, float f) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f, 0.0, 0.0);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.rh);
        double d = Math.cos(f);
        double d2 = Math.sin(f);
        int n3 = (int)((double)n2 * d2);
        int n4 = (int)((double)n * d2);
        BufferedImage bufferedImage2 = Util.createSimilar(bufferedImage, (int)((double)Math.abs(n3) + Math.abs((double)n * d)), (int)((double)Math.abs(n4) + Math.abs((double)n2 * d)));
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, affineTransformOp, f < 0.0f ? 0 : n3, f < 0.0f ? -n4 : 0);
        return bufferedImage2;
    }

    public BufferedImage scale(BufferedImage bufferedImage, float f, float f2) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, new RenderingHints(RenderingHints.KEY_INTERPOLATION, this.rh.get(RenderingHints.KEY_INTERPOLATION)));
        BufferedImage bufferedImage2 = Util.createSimilar(bufferedImage, (int)((float)bufferedImage.getWidth() * f), (int)((float)bufferedImage.getHeight() * f2));
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, affineTransformOp, 0, 0);
        return bufferedImage2;
    }

    public void setImagingQuality(int n) {
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hashMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hashMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hashMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hashMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        this.rh = new RenderingHints(hashMap);
    }

    public BufferedImage addTransparency(BufferedImage bufferedImage, int n) {
        return TransformerUtil.addTransparency(bufferedImage, n);
    }

    public BufferedImage convolve(BufferedImage bufferedImage, float[] fArray) {
        int n = (int)Math.sqrt(fArray.length);
        Kernel kernel = new Kernel(n, n, fArray);
        ConvolveOp convolveOp = new ConvolveOp(kernel, 1, this.rh);
        BufferedImage bufferedImage2 = convolveOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        return convolveOp.filter(bufferedImage, bufferedImage2);
    }
}

