/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging.util;

import com.mullassery.imaging.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import javax.swing.JEditorPane;

public class TransformerUtil {
    private TransformerUtil() {
    }

    public static final BufferedImage overlay(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, Color color, int n3) {
        int n4 = bufferedImage2.getWidth();
        int n5 = bufferedImage2.getHeight();
        int n6 = color.getRGB();
        int n7 = 0;
        BufferedImage bufferedImage3 = Util.duplicate(bufferedImage);
        BufferedImage bufferedImage4 = new BufferedImage(n4, n5, 2);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                n7 = bufferedImage2.getRGB(i, j);
                if (Util.isSameColor(n7, n6, n3)) continue;
                bufferedImage4.setRGB(i, j, n7);
            }
        }
        bufferedImage3.getGraphics().drawImage(bufferedImage4, n, n2, null);
        return bufferedImage3;
    }

    public static final Rectangle textOverlay(BufferedImage bufferedImage, String string, int n, int n2, int n3, Font font, Color color, BufferedImage bufferedImage2, boolean bl) {
        Graphics2D graphics2D = TransformerUtil.getPreparedGraphics(bufferedImage, bl);
        AttributedString attributedString = new AttributedString(string);
        if (font != null) {
            attributedString.addAttribute(TextAttribute.FONT, font);
        }
        if (bufferedImage2 != null) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, bufferedImage2.getWidth(), bufferedImage2.getHeight());
            TexturePaint texturePaint = new TexturePaint(bufferedImage2, float_);
            graphics2D.setPaint(texturePaint);
        } else if (color != null) {
            attributedString.addAttribute(TextAttribute.FOREGROUND, color);
        }
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), graphics2D.getFontRenderContext());
        while (lineBreakMeasurer.getPosition() < string.length()) {
            TextLayout textLayout = lineBreakMeasurer.nextLayout(n3);
            n5 = (int)((float)n5 + textLayout.getAscent());
            float f = textLayout.isLeftToRight() ? 0.0f : (float)n3 - textLayout.getAdvance();
            textLayout.draw(graphics2D, (float)n4 + f, n5);
            n5 = (int)((float)n5 + (textLayout.getDescent() + textLayout.getLeading()));
            int n7 = (int)textLayout.getAdvance();
            n6 = n7 > n6 ? n7 : n6;
        }
        return new Rectangle(n, n2, n6, n5);
    }

    public static final void htmlOverlay(BufferedImage bufferedImage, String string, int n, int n2, int n3, int n4, boolean bl) {
        Graphics2D graphics2D = TransformerUtil.getPreparedGraphics(bufferedImage, bl);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setSize(n3, n4);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        jEditorPane.setOpaque(false);
        graphics2D.translate(n, n2);
        jEditorPane.paint(graphics2D);
        graphics2D.translate(-n, -n2);
    }

    private static Graphics2D getPreparedGraphics(BufferedImage bufferedImage, boolean bl) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return graphics2D;
    }

    public static final BufferedImage addTransparency(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        int n2 = bufferedImage2.getWidth();
        int n3 = bufferedImage2.getHeight();
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                n5 = bufferedImage2.getRGB(i, j);
                n4 = ((n5 & 0xFF000000) >>> 24) - n;
                n4 = n4 < 0 ? 0 : n4;
                n4 = n4 > 255 ? 255 : n4;
                bufferedImage2.setRGB(i, j, n5 & 0xFFFFFF | n4 << 24);
            }
        }
        return bufferedImage2;
    }
}

