/*
 * Decompiled with CFR 0.152.
 */
package com.mullassery.imaging.util;

import com.mullassery.imaging.Imaging;
import com.mullassery.imaging.util.GIFEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public final class Util {
    public static void encodeGIF(BufferedImage bufferedImage, OutputStream outputStream) {
        try {
            Class.forName("Acme.JPM.Encoders.GifEncoderNoCM");
            Class.forName("com.eteks.filter.Web216ColorsFilter");
            new GIFEncoder().encode(bufferedImage, outputStream);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("ACME and PJA classes for GIF Encoding should be in the classpath");
        }
        catch (Throwable throwable) {
            throw new ImagingOpException("Error while encoding GIF " + throwable.getMessage());
        }
    }

    public static void checkImage(RenderedImage renderedImage, String string) {
        if (renderedImage == null) {
            if (string == null) {
                throw new IllegalArgumentException("Cannot apply transformation without any Images!");
            }
            throw new IllegalArgumentException(string);
        }
    }

    public static void checkTransformation(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (string2 == null) {
                throw new IllegalArgumentException("No transformation specified!");
            }
            throw new IllegalArgumentException(string2);
        }
    }

    public static final float convertToFraction(String string, int n) {
        float f;
        if (string == null || string.length() == 0) {
            return 1.0f;
        }
        if (string.indexOf(37) != -1) {
            string = string.substring(0, string.indexOf(37));
            f = Float.parseFloat(string) / 100.0f;
        } else {
            f = Float.parseFloat(string) / (float)n;
        }
        return f;
    }

    public static final float convertToWhole(String string, int n) {
        float f;
        if (string == null || string.length() == 0) {
            return 0.0f;
        }
        if (string.indexOf(37) != -1) {
            string = string.substring(0, string.indexOf(37));
            f = Float.parseFloat(string) * (float)n / 100.0f;
        } else {
            f = Float.parseFloat(string);
        }
        return f;
    }

    public static final String correctImageType(String string) {
        if (string.equalsIgnoreCase("jpg")) {
            string = "JPEG";
        } else if (string.equalsIgnoreCase("tif")) {
            string = "TIFF";
        } else if (string.equalsIgnoreCase("pbm")) {
            string = "PNM";
        } else if (string.equalsIgnoreCase("pgm")) {
            string = "PNM";
        } else if (string.equalsIgnoreCase("ppm")) {
            string = "PNM";
        } else if (string.equalsIgnoreCase("png")) {
            string = "PNG";
        } else if (string.equalsIgnoreCase("gif")) {
            string = "GIF";
        }
        return string.toUpperCase();
    }

    public static final BufferedImage createSimilar(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImage.getColorModel().getTransparency() == 1 ? new BufferedImage(n, n2, 1) : new BufferedImage(n, n2, 2);
        return bufferedImage2;
    }

    public static final float degrees2Radians(float f) {
        return (float)((double)(f %= 360.0f) * Math.PI / 180.0);
    }

    public static String extractFileName(String string) {
        int n = string.indexOf(63);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string.substring(string.lastIndexOf(File.separatorChar) + 1);
    }

    public static Color getColor(String string) {
        string = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '9' || string.startsWith("0x")) continue;
            string = "0x" + string;
            break;
        }
        return Color.decode(string);
    }

    public static final String getExtentionType(File file) {
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException("A image file name is required (" + file + ").");
        }
        return Util.getExtentionType(file.getName());
    }

    public static final String getExtentionType(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        return string2.toUpperCase();
    }

    public static final URL getFileURL(File file) throws MalformedURLException {
        String string = "file:" + file.getAbsolutePath().replace('\\', '/');
        int n = string.indexOf(35);
        while (n != -1) {
            string = string.substring(0, n) + "%23" + string.substring(n + 1);
            n = string.indexOf(35);
        }
        if (file.isDirectory()) {
            string = string + "/";
        }
        return new URL(string);
    }

    public static final BufferedImage getIntTypeBufferedImage(int n, int n2, String string) {
        int n3 = 1;
        if (Util.isTransparentType(string)) {
            n3 = 2;
        }
        return new BufferedImage(n, n2, n3);
    }

    public static boolean isTransparentType(String string) {
        return string.equalsIgnoreCase("GIF") || string.equalsIgnoreCase("PNG") || string.equalsIgnoreCase("PNM");
    }

    public static final boolean isSameColor(Color color, Color color2, int n) {
        return Util.isSameColor(color.getRGB(), color2.getRGB(), n);
    }

    public static final boolean isSameColor(int n, int n2, int n3) {
        int n4 = (n & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = n & 0xFF;
        int n7 = (n2 & 0xFF0000) >> 16;
        int n8 = (n2 & 0xFF00) >> 8;
        int n9 = n2 & 0xFF;
        return Math.abs(n4 - n7) <= n3 && Math.abs(n5 - n8) <= n3 && Math.abs(n6 - n9) <= n3;
    }

    public static final boolean isTransparent(int n, int n2) {
        int n3 = (n & 0xFF000000) >>> 24;
        return n3 <= n2;
    }

    public static final void saveImage(Imaging imaging, BufferedImage bufferedImage, String string, File file) throws FileNotFoundException {
        Util.saveImage(imaging, bufferedImage, string, file, 0.6f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveImage(Imaging imaging, BufferedImage bufferedImage, String string, File file, float f) throws FileNotFoundException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            if (string.equalsIgnoreCase("GIF")) {
                Util.encodeGIF(bufferedImage, bufferedOutputStream);
            } else {
                imaging.write(bufferedImage, bufferedOutputStream, string, f);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    bufferedOutputStream = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (bufferedOutputStream != null) {
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedOutputStream = null;
            }
        }
        catch (IOException iOException) {}
    }

    public static BufferedImage createBufferedImage(Image image, String string) {
        if (image == null) {
            throw new ImagingOpException("Could not load the image. The contents are null.");
        }
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            boolean bl;
            System.out.println("Already a Buff Image.");
            bufferedImage = (BufferedImage)image;
            int n = bufferedImage.getType();
            boolean bl2 = bl = bufferedImage.getColorModel().getTransparency() == 1;
            if (bl && n == 2 || !bl && n == 1) {
                System.out.println("returning same Image.");
                return bufferedImage;
            }
            System.out.println("returning new Image.");
            return Util.duplicate(bufferedImage);
        }
        bufferedImage = Util.getIntTypeBufferedImage(image.getWidth(null), image.getHeight(null), string);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static BufferedImage duplicate(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = Util.createSimilar(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        return bufferedImage2;
    }
}

