/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractDoubleVector;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.MathVector;
import JSci.maths.algebras.HilbertSpace;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;

public abstract class AbstractComplexVector
extends MathVector
implements HilbertSpace.Member {
    protected AbstractComplexVector(int n) {
        super(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(12 * this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(this.getComponent(n).toString());
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.getComponent(n).toString());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public abstract AbstractDoubleVector real();

    public abstract AbstractDoubleVector imag();

    public abstract Complex getComponent(int var1);

    public abstract void setComponent(int var1, Complex var2);

    public abstract void setComponent(int var1, double var2, double var4);

    public double norm() {
        double d = this.getComponent(0).mod();
        double d2 = d * d;
        int n = 1;
        while (n < this.N) {
            d = this.getComponent(n).mod();
            d2 += d * d;
            ++n;
        }
        return Math.sqrt(d2);
    }

    public void normalize() {
        double d = this.norm();
        int n = 0;
        while (n < this.N) {
            this.setComponent(n, this.getComponent(n).divide(d));
            ++n;
        }
    }

    public double infNorm() {
        double d = this.getComponent(0).mod();
        int n = 1;
        while (n < this.N) {
            double d2 = this.getComponent(n).mod();
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public abstract AbstractComplexVector conjugate();

    public abstract AbstractComplexVector add(AbstractComplexVector var1);

    public abstract AbstractComplexVector subtract(AbstractComplexVector var1);

    public abstract AbstractComplexVector scalarMultiply(Complex var1);

    public abstract AbstractComplexVector scalarMultiply(double var1);

    public abstract AbstractComplexVector scalarDivide(Complex var1);

    public abstract AbstractComplexVector scalarDivide(double var1);

    public abstract Complex scalarProduct(AbstractComplexVector var1);

    public abstract AbstractComplexVector mapComponents(ComplexMapping var1);

    public abstract Complex scalarProduct(HilbertSpace.Member var1);

    public abstract VectorSpace.Member scalarDivide(Field.Member var1);
}

