/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public class ComplexMatrix
extends Matrix {
    protected static final int ARRAY_2D = 1;
    protected double[][] matrixRe;
    protected double[][] matrixIm;

    protected ComplexMatrix(int n, int n2, int n3) {
        super(n, n2);
        this.storageFormat = n3;
    }

    public ComplexMatrix(int n, int n2) {
        this(n, n2, 1);
        this.matrixRe = new double[n][n2];
        this.matrixIm = new double[n][n2];
    }

    public ComplexMatrix(double[][] dArray, double[][] dArray2) {
        this(dArray.length, dArray[0].length, 1);
        this.matrixRe = dArray;
        this.matrixIm = dArray2;
    }

    public ComplexMatrix(Complex[][] complexArray) {
        this(complexArray.length, complexArray[0].length);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                this.matrixRe[n][n2] = complexArray[n][n2].real();
                this.matrixIm[n][n2] = complexArray[n][n2].imag();
                ++n2;
            }
            ++n;
        }
    }

    public ComplexMatrix(ComplexVector[] complexVectorArray) {
        this(complexVectorArray[0].dimension(), complexVectorArray.length);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                this.matrixRe[n][n2] = complexVectorArray[n2].getComponent(n).real();
                this.matrixIm[n][n2] = complexVectorArray[n2].getComponent(n).imag();
                ++n2;
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ComplexMatrix && this.numRows == ((ComplexMatrix)object).rows() && this.numCols == ((ComplexMatrix)object).columns()) {
            ComplexMatrix complexMatrix = (ComplexMatrix)object;
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if (!complexMatrix.getElement(n, n2).equals(this.matrixRe[n][n2], this.matrixIm[n][n2])) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(Complex.toString(this.matrixRe[n][n2], this.matrixIm[n][n2]));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public DoubleMatrix real() {
        return new DoubleMatrix(this.matrixRe);
    }

    public DoubleMatrix imag() {
        return new DoubleMatrix(this.matrixIm);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return new Complex(this.matrixRe[n][n2], this.matrixIm[n][n2]);
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrixRe[n][n2] = complex.real();
        this.matrixIm[n][n2] = complex.imag();
    }

    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrixRe[n][n2] = d;
        this.matrixIm[n][n2] = d2;
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.numCols) {
                d2 += Math.sqrt(this.matrixRe[n][n2] * this.matrixRe[n][n2] + this.matrixIm[n][n2] * this.matrixIm[n][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                d += this.matrixRe[n][n2] * this.matrixRe[n][n2] + this.matrixIm[n][n2] * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.matrixRe[n][0];
            dArray2[n][0] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.matrixRe[n][n2];
                dArray2[n][n2] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof ComplexMatrix) {
            return this.add((ComplexMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
        }
        if (this.numRows == complexMatrix.rows() && this.numCols == complexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] + complexMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] + complexMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows && this.numCols == complexMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] + complexMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] + complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof ComplexMatrix) {
            return this.subtract((ComplexMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexMatrix);
            }
        }
        if (this.numRows == complexMatrix.rows() && this.numCols == complexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] - complexMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] - complexMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows && this.numCols == complexMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] - complexMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] - complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Complex) {
            return this.scalarMultiply((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.matrixRe[n][0] - d2 * this.matrixIm[n][0];
            dArray2[n][0] = d2 * this.matrixRe[n][0] + d * this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.matrixRe[n][n2] - d2 * this.matrixIm[n][n2];
                dArray2[n][n2] = d2 * this.matrixRe[n][n2] + d * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.matrixRe[n][0];
            dArray2[n][0] = d * this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.matrixRe[n][n2];
                dArray2[n][n2] = d * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Complex) {
            return this.scalarDivide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix scalarDivide(Complex complex) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            complexArray[n][0] = new Complex(this.matrixRe[n][0], this.matrixIm[n][0]).divide(complex);
            int n2 = 1;
            while (n2 < this.numCols) {
                complexArray[n][n2] = new Complex(this.matrixRe[n][n2], this.matrixIm[n][n2]).divide(complex);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public ComplexMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.matrixRe[n][0] / d;
            dArray2[n][0] = this.matrixIm[n][0] / d;
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrixRe[n][n2] / d;
                dArray2[n][n2] = this.matrixIm[n][n2] / d;
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.numCols == complexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexVector.getComponent(0);
                dArray[n] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                dArray2[n] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = complexVector.getComponent(n2);
                    int n3 = n;
                    dArray[n3] = dArray[n3] + (this.matrixRe[n][n2] * complex.real() - this.matrixIm[n][n2] * complex.imag());
                    int n4 = n;
                    dArray2[n4] = dArray2[n4] + (this.matrixIm[n][n2] * complex.real() + this.matrixRe[n][n2] * complex.imag());
                    ++n2;
                }
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof ComplexMatrix) {
            return this.multiply((ComplexMatrix)member);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(complexMatrix);
            }
        }
        if (this.numCols == complexMatrix.rows()) {
            double[][] dArray = new double[this.numRows][complexMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][complexMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < complexMatrix.columns()) {
                    Complex complex = complexMatrix.getElement(0, n2);
                    dArray[n][n2] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                    dArray2[n][n2] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        complex = complexMatrix.getElement(n3, n2);
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complex.real() - this.matrixIm[n][n3] * complex.imag());
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixIm[n][n3] * complex.real() + this.matrixRe[n][n3] * complex.imag());
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == complexMatrix.columns()) {
                return new ComplexSquareMatrix(dArray, dArray2);
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.numCols == complexMatrix.numRows) {
            double[][] dArray = new double[this.numRows][complexMatrix.numCols];
            double[][] dArray2 = new double[this.numRows][complexMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < complexMatrix.numCols) {
                    dArray[n][n2] = this.matrixRe[n][0] * complexMatrix.matrixRe[0][n2] - this.matrixIm[n][0] * complexMatrix.matrixIm[0][n2];
                    dArray2[n][n2] = this.matrixIm[n][0] * complexMatrix.matrixRe[0][n2] + this.matrixRe[n][0] * complexMatrix.matrixIm[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complexMatrix.matrixRe[n3][n2] - this.matrixIm[n][n3] * complexMatrix.matrixIm[n3][n2]);
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixIm[n][n3] * complexMatrix.matrixRe[n3][n2] + this.matrixRe[n][n3] * complexMatrix.matrixIm[n3][n2]);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == complexMatrix.numCols) {
                return new ComplexSquareMatrix(dArray, dArray2);
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexMatrix directSum(ComplexMatrix complexMatrix) {
        double[][] dArray = new double[this.numRows + complexMatrix.numRows][this.numCols + complexMatrix.numCols];
        double[][] dArray2 = new double[this.numRows + complexMatrix.numRows][this.numCols + complexMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrixRe[n][n2];
                dArray2[n][n2] = this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < complexMatrix.numRows) {
            int n4 = 0;
            while (n4 < complexMatrix.numCols) {
                Complex complex = complexMatrix.getElement(n3, n4);
                dArray[n3 + this.numRows][n4 + this.numCols] = complex.real();
                dArray2[n3 + this.numRows][n4 + this.numCols] = complex.imag();
                ++n4;
            }
            ++n3;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexMatrix tensorProduct(ComplexMatrix complexMatrix) {
        double[][] dArray = new double[this.numRows * complexMatrix.numRows][this.numCols * complexMatrix.numCols];
        double[][] dArray2 = new double[this.numRows * complexMatrix.numRows][this.numCols * complexMatrix.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                int n3 = 0;
                while (n3 < complexMatrix.numRows) {
                    int n4 = 0;
                    while (n4 < complexMatrix.numCols) {
                        Complex complex = complexMatrix.getElement(n3, n4);
                        dArray[n * complexMatrix.numRows + n3][n2 * complexMatrix.numCols + n4] = this.matrixRe[n][n2] * complex.real() - this.matrixIm[n][n2] * complex.imag();
                        dArray2[n * complexMatrix.numRows + n3][n2 * complexMatrix.numCols + n4] = this.matrixIm[n][n2] * complex.real() + this.matrixRe[n][n2] * complex.imag();
                        ++n4;
                    }
                    ++n2;
                }
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexMatrix conjugate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(this.matrixRe, dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            complexArray[n][0] = complexMapping.map(this.matrixRe[n][0], this.matrixIm[n][0]);
            int n2 = 1;
            while (n2 < this.numCols) {
                complexArray[n][n2] = complexMapping.map(this.matrixRe[n][n2], this.matrixIm[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }
}

