/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractComplexVector;
import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.LinearMath;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.SquareMatrix;
import JSci.maths.algebras.CStarAlgebra;

public class ComplexSquareMatrix
extends ComplexMatrix
implements SquareMatrix,
CStarAlgebra.Member {
    protected transient ComplexSquareMatrix[] LU;
    protected transient int[] LUpivot;

    protected ComplexSquareMatrix(int n, int n2) {
        super(n, n, n2);
    }

    public ComplexSquareMatrix(int n) {
        super(n, n);
    }

    public ComplexSquareMatrix(double[][] dArray, double[][] dArray2) {
        super(dArray, dArray2);
        if (dArray.length != dArray[0].length && dArray2.length != dArray2[0].length) {
            this.matrixRe = null;
            this.matrixIm = null;
            throw new MatrixDimensionException("The arrays are not square.");
        }
    }

    public ComplexSquareMatrix(Complex[][] complexArray) {
        super(complexArray);
        if (complexArray.length != complexArray[0].length) {
            this.matrixRe = null;
            this.matrixIm = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public ComplexSquareMatrix(ComplexVector[] complexVectorArray) {
        super(complexVectorArray);
        if (complexVectorArray.length != complexVectorArray[0].dimension()) {
            this.matrixRe = null;
            this.matrixIm = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public boolean isHermitian() {
        return this.equals(this.hermitianAdjoint());
    }

    public boolean isUnitary() {
        return this.multiply(this.hermitianAdjoint()).equals(ComplexDiagonalMatrix.identity(this.numRows));
    }

    public Complex det() {
        if (this.numRows == 2) {
            return new Complex(this.matrixRe[0][0] * this.matrixRe[1][1] - this.matrixIm[0][0] * this.matrixIm[1][1] - this.matrixRe[0][1] * this.matrixRe[1][0] + this.matrixIm[0][1] * this.matrixIm[1][0], this.matrixRe[0][0] * this.matrixIm[1][1] + this.matrixIm[0][0] * this.matrixRe[1][1] - this.matrixRe[0][1] * this.matrixIm[1][0] - this.matrixIm[0][1] * this.matrixRe[1][0]);
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = this.luDecompose(null);
        double d = complexSquareMatrixArray[1].matrixRe[0][0];
        double d2 = complexSquareMatrixArray[1].matrixIm[0][0];
        int n = 1;
        while (n < this.numRows) {
            double d3 = d * complexSquareMatrixArray[1].matrixRe[n][n] - d2 * complexSquareMatrixArray[1].matrixIm[n][n];
            d2 = d * complexSquareMatrixArray[1].matrixIm[n][n] + d2 * complexSquareMatrixArray[1].matrixRe[n][n];
            d = d3;
            ++n;
        }
        return new Complex(d * (double)this.LUpivot[this.numRows], d2 * (double)this.LUpivot[this.numRows]);
    }

    public Complex trace() {
        double d = this.matrixRe[0][0];
        double d2 = this.matrixIm[0][0];
        int n = 1;
        while (n < this.numRows) {
            d += this.matrixRe[n][n];
            d2 += this.matrixIm[n][n];
            ++n;
        }
        return new Complex(d, d2);
    }

    public double norm() {
        try {
            return this.operatorNorm();
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return 0.0;
        }
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveHermitian((ComplexSquareMatrix)this.hermitianAdjoint().multiply(this))));
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
        }
        if (this.numRows == complexMatrix.rows() && this.numCols == complexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] + complexMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] + complexMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows && this.numCols == complexMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] + complexMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] + complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexSquareMatrix);
            }
        }
        if (this.numRows == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] + complexSquareMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] + complexSquareMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexSquareMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexSquareMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexMatrix);
            }
        }
        if (this.numRows == complexMatrix.rows() && this.numCols == complexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] - complexMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] - complexMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows && this.numCols == complexMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] - complexMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] - complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexSquareMatrix);
            }
        }
        if (this.numRows == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrixRe[n][0] - complexSquareMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] - complexSquareMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexSquareMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexSquareMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = this.matrixRe[n][0] * d - this.matrixIm[n][0] * d2;
            dArray2[n][0] = this.matrixRe[n][0] * d2 + this.matrixIm[n][0] * d;
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrixRe[n][n2] * d - this.matrixIm[n][n2] * d2;
                dArray2[n][n2] = this.matrixRe[n][n2] * d2 + this.matrixIm[n][n2] * d;
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.matrixRe[n][0];
            dArray2[n][0] = d * this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.matrixRe[n][n2];
                dArray2[n][n2] = d * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.numCols == complexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                Complex complex = complexVector.getComponent(0);
                dArray[n] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                dArray2[n] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                int n2 = 1;
                while (n2 < this.numCols) {
                    complex = complexVector.getComponent(n2);
                    int n3 = n;
                    dArray[n3] = dArray[n3] + (this.matrixRe[n][n2] * complex.real() - this.matrixIm[n][n2] * complex.imag());
                    int n4 = n;
                    dArray2[n4] = dArray2[n4] + (this.matrixIm[n][n2] * complex.real() + this.matrixRe[n][n2] * complex.imag());
                    ++n2;
                }
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(complexSquareMatrix);
            }
        }
        if (this.numCols == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    Complex complex = complexSquareMatrix.getElement(0, n2);
                    dArray[n][n2] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                    dArray2[n][n2] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        complex = complexSquareMatrix.getElement(n3, n2);
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complex.real() - this.matrixIm[n][n3] * complex.imag());
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixIm[n][n3] * complex.real() + this.matrixRe[n][n3] * complex.imag());
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numCols == complexSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrixRe[n][0] * complexSquareMatrix.matrixRe[0][n2] - this.matrixIm[n][0] * complexSquareMatrix.matrixIm[0][n2];
                    dArray2[n][n2] = this.matrixIm[n][0] * complexSquareMatrix.matrixRe[0][n2] + this.matrixRe[n][0] * complexSquareMatrix.matrixIm[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complexSquareMatrix.matrixRe[n3][n2] - this.matrixIm[n][n3] * complexSquareMatrix.matrixIm[n3][n2]);
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixIm[n][n3] * complexSquareMatrix.matrixRe[n3][n2] + this.matrixRe[n][n3] * complexSquareMatrix.matrixIm[n3][n2]);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public CStarAlgebra.Member involution() {
        return (ComplexSquareMatrix)this.hermitianAdjoint();
    }

    public ComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexMatrix conjugate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(this.matrixRe, dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexSquareMatrix inverse() {
        int n;
        int n2;
        int n3 = this.numRows;
        double[][] dArray = new double[n3][n3];
        double[][] dArray2 = new double[n3][n3];
        double[][] dArray3 = new double[n3][n3];
        double[][] dArray4 = new double[n3][n3];
        ComplexSquareMatrix[] complexSquareMatrixArray = this.luDecompose(null);
        double d = complexSquareMatrixArray[0].matrixRe[0][0] * complexSquareMatrixArray[0].matrixRe[0][0] + complexSquareMatrixArray[0].matrixIm[0][0] * complexSquareMatrixArray[0].matrixIm[0][0];
        dArray[0][0] = complexSquareMatrixArray[0].matrixRe[0][0] / d;
        dArray2[0][0] = -complexSquareMatrixArray[0].matrixIm[0][0] / d;
        d = complexSquareMatrixArray[1].matrixRe[0][0] * complexSquareMatrixArray[1].matrixRe[0][0] + complexSquareMatrixArray[1].matrixIm[0][0] * complexSquareMatrixArray[1].matrixIm[0][0];
        dArray3[0][0] = complexSquareMatrixArray[1].matrixRe[0][0] / d;
        dArray4[0][0] = -complexSquareMatrixArray[1].matrixIm[0][0] / d;
        int n4 = 1;
        while (n4 < n3) {
            d = complexSquareMatrixArray[0].matrixRe[n4][n4] * complexSquareMatrixArray[0].matrixRe[n4][n4] + complexSquareMatrixArray[0].matrixIm[n4][n4] * complexSquareMatrixArray[0].matrixIm[n4][n4];
            dArray[n4][n4] = complexSquareMatrixArray[0].matrixRe[n4][n4] / d;
            dArray2[n4][n4] = -complexSquareMatrixArray[0].matrixIm[n4][n4] / d;
            d = complexSquareMatrixArray[1].matrixRe[n4][n4] * complexSquareMatrixArray[1].matrixRe[n4][n4] + complexSquareMatrixArray[1].matrixIm[n4][n4] * complexSquareMatrixArray[1].matrixIm[n4][n4];
            dArray3[n4][n4] = complexSquareMatrixArray[1].matrixRe[n4][n4] / d;
            dArray4[n4][n4] = -complexSquareMatrixArray[1].matrixIm[n4][n4] / d;
            ++n4;
        }
        n4 = 0;
        while (n4 < n3 - 1) {
            n2 = n4 + 1;
            while (n2 < n3) {
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                n = n4;
                while (n < n2) {
                    d3 -= complexSquareMatrixArray[0].matrixRe[n2][n] * dArray[n][n4] - complexSquareMatrixArray[0].matrixIm[n2][n] * dArray2[n][n4];
                    d2 -= complexSquareMatrixArray[0].matrixIm[n2][n] * dArray[n][n4] + complexSquareMatrixArray[0].matrixRe[n2][n] * dArray2[n][n4];
                    d5 -= dArray3[n4][n] * complexSquareMatrixArray[1].matrixRe[n][n2] - dArray4[n4][n] * complexSquareMatrixArray[1].matrixIm[n][n2];
                    d4 -= dArray4[n4][n] * complexSquareMatrixArray[1].matrixRe[n][n2] + dArray3[n4][n] * complexSquareMatrixArray[1].matrixIm[n][n2];
                    ++n;
                }
                d = complexSquareMatrixArray[0].matrixRe[n2][n2] * complexSquareMatrixArray[0].matrixRe[n2][n2] + complexSquareMatrixArray[0].matrixIm[n2][n2] * complexSquareMatrixArray[0].matrixIm[n2][n2];
                dArray[n2][n4] = (d3 * complexSquareMatrixArray[0].matrixRe[n2][n2] + d2 * complexSquareMatrixArray[0].matrixIm[n2][n2]) / d;
                dArray2[n2][n4] = (d2 * complexSquareMatrixArray[0].matrixRe[n2][n2] - d3 * complexSquareMatrixArray[0].matrixIm[n2][n2]) / d;
                d = complexSquareMatrixArray[1].matrixRe[n2][n2] * complexSquareMatrixArray[1].matrixRe[n2][n2] + complexSquareMatrixArray[1].matrixIm[n2][n2] * complexSquareMatrixArray[1].matrixIm[n2][n2];
                dArray3[n4][n2] = (d5 * complexSquareMatrixArray[1].matrixRe[n2][n2] + d4 * complexSquareMatrixArray[1].matrixIm[n2][n2]) / d;
                dArray4[n4][n2] = (d4 * complexSquareMatrixArray[1].matrixRe[n2][n2] - d5 * complexSquareMatrixArray[1].matrixIm[n2][n2]) / d;
                ++n2;
            }
            ++n4;
        }
        double[][] dArray5 = new double[n3][n3];
        double[][] dArray6 = new double[n3][n3];
        n4 = 0;
        while (n4 < n3) {
            n2 = 0;
            while (n2 < n4) {
                n = n4;
                while (n < n3) {
                    double[] dArray7 = dArray5[n4];
                    int n5 = this.LUpivot[n2];
                    dArray7[n5] = dArray7[n5] + (dArray3[n4][n] * dArray[n][n2] - dArray4[n4][n] * dArray2[n][n2]);
                    double[] dArray8 = dArray6[n4];
                    int n6 = this.LUpivot[n2];
                    dArray8[n6] = dArray8[n6] + (dArray4[n4][n] * dArray[n][n2] + dArray3[n4][n] * dArray2[n][n2]);
                    ++n;
                }
                ++n2;
            }
            n2 = n4;
            while (n2 < n3) {
                n = n2;
                while (n < n3) {
                    double[] dArray9 = dArray5[n4];
                    int n7 = this.LUpivot[n2];
                    dArray9[n7] = dArray9[n7] + (dArray3[n4][n] * dArray[n][n2] - dArray4[n4][n] * dArray2[n][n2]);
                    double[] dArray10 = dArray6[n4];
                    int n8 = this.LUpivot[n2];
                    dArray10[n8] = dArray10[n8] + (dArray4[n4][n] * dArray[n][n2] + dArray3[n4][n] * dArray2[n][n2]);
                    ++n;
                }
                ++n2;
            }
            ++n4;
        }
        return new ComplexSquareMatrix(dArray5, dArray6);
    }

    public ComplexSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        double[] dArray5 = new double[n];
        if (nArray == null) {
            nArray = new int[n + 1];
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        nArray[n] = 1;
        int n3 = 0;
        while (n3 < n) {
            double d;
            double d2;
            double d3;
            int n4;
            double d4;
            double d5;
            n2 = 0;
            while (n2 < n3) {
                d5 = this.matrixRe[nArray[n2]][n3];
                d4 = this.matrixIm[nArray[n2]][n3];
                n4 = 0;
                while (n4 < n2) {
                    d5 -= dArray3[n2][n4] * dArray3[n4][n3] - dArray4[n2][n4] * dArray4[n4][n3];
                    d4 -= dArray4[n2][n4] * dArray3[n4][n3] + dArray3[n2][n4] * dArray4[n4][n3];
                    ++n4;
                }
                dArray3[n2][n3] = d5;
                dArray4[n2][n3] = d4;
                ++n2;
            }
            double d6 = 0.0;
            int n5 = n3;
            n2 = n3;
            while (n2 < n) {
                d5 = this.matrixRe[nArray[n2]][n3];
                d4 = this.matrixIm[nArray[n2]][n3];
                n4 = 0;
                while (n4 < n3) {
                    d5 -= dArray3[n2][n4] * dArray3[n4][n3] - dArray4[n2][n4] * dArray4[n4][n3];
                    d4 -= dArray4[n2][n4] * dArray3[n4][n3] + dArray3[n2][n4] * dArray4[n4][n3];
                    ++n4;
                }
                dArray3[n2][n3] = d5;
                dArray4[n2][n3] = d4;
                d3 = d5 * d5 + d4 * d4;
                if (d3 > d6) {
                    d6 = d3;
                    n5 = n2;
                }
                ++n2;
            }
            if (n5 != n3) {
                System.arraycopy(dArray3[n3], 0, dArray5, 0, n3 + 1);
                System.arraycopy(dArray3[n5], 0, dArray3[n3], 0, n3 + 1);
                System.arraycopy(dArray5, 0, dArray3[n5], 0, n3 + 1);
                System.arraycopy(dArray4[n3], 0, dArray5, 0, n3 + 1);
                System.arraycopy(dArray4[n5], 0, dArray4[n3], 0, n3 + 1);
                System.arraycopy(dArray5, 0, dArray4[n5], 0, n3 + 1);
                n4 = nArray[n3];
                nArray[n3] = nArray[n5];
                nArray[n5] = n4;
                nArray[n] = -nArray[n];
            }
            d5 = dArray3[n3][n3];
            d4 = dArray4[n3][n3];
            if (Math.abs(d5) < Math.abs(d4)) {
                d2 = d5 / d4;
                d = d5 * d2 + d4;
                n2 = n3 + 1;
                while (n2 < n) {
                    d3 = (dArray3[n2][n3] * d2 + dArray4[n2][n3]) / d;
                    dArray4[n2][n3] = (dArray4[n2][n3] * d2 - dArray3[n2][n3]) / d;
                    dArray3[n2][n3] = d3;
                    ++n2;
                }
            } else {
                d2 = d4 / d5;
                d = d5 + d4 * d2;
                n2 = n3 + 1;
                while (n2 < n) {
                    d3 = (dArray3[n2][n3] + dArray4[n2][n3] * d2) / d;
                    dArray4[n2][n3] = (dArray4[n2][n3] - dArray3[n2][n3] * d2) / d;
                    dArray3[n2][n3] = d3;
                    ++n2;
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            dArray[n3][n3] = 1.0;
            n2 = n3 + 1;
            while (n2 < n) {
                dArray[n2][n3] = dArray3[n2][n3];
                dArray2[n2][n3] = dArray4[n2][n3];
                dArray3[n2][n3] = 0.0;
                dArray4[n2][n3] = 0.0;
                ++n2;
            }
            ++n3;
        }
        this.LU = new ComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(dArray, dArray2);
        this.LU[1] = new ComplexSquareMatrix(dArray3, dArray4);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public ComplexSquareMatrix[] polarDecompose() {
        Complex complex;
        double[] dArray;
        int n = this.numRows;
        AbstractComplexVector[] abstractComplexVectorArray = new ComplexVector[n];
        try {
            dArray = LinearMath.eigenSolveHermitian(this, abstractComplexVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        double[][] dArray5 = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            double d = Math.abs(dArray[n2]);
            complex = ((ComplexVector)abstractComplexVectorArray[n2]).getComponent(0).conjugate();
            dArray2[n2][0] = dArray[n2] * complex.real() / d;
            dArray3[n2][0] = dArray[n2] * complex.imag() / d;
            dArray4[n2][0] = d * complex.real();
            dArray5[n2][0] = d * complex.imag();
            int n3 = 1;
            while (n3 < n) {
                complex = ((ComplexVector)abstractComplexVectorArray[n2]).getComponent(n3).conjugate();
                dArray2[n2][n3] = dArray[n2] * complex.real() / d;
                dArray3[n2][n3] = dArray[n2] * complex.imag() / d;
                dArray4[n2][n3] = d * complex.real();
                dArray5[n2][n3] = d * complex.imag();
                ++n3;
            }
            ++n2;
        }
        double[][] dArray6 = new double[n][n];
        double[][] dArray7 = new double[n][n];
        double[][] dArray8 = new double[n][n];
        double[][] dArray9 = new double[n][n];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                complex = ((ComplexVector)abstractComplexVectorArray[0]).getComponent(n4);
                dArray6[n4][n5] = dArray2[0][n5] * complex.real() - dArray3[0][n5] * complex.imag();
                dArray7[n4][n5] = dArray3[0][n5] * complex.real() + dArray2[0][n5] * complex.imag();
                dArray8[n4][n5] = dArray4[0][n5] * complex.real() - dArray5[0][n5] * complex.imag();
                dArray9[n4][n5] = dArray5[0][n5] * complex.real() + dArray4[0][n5] * complex.imag();
                int n6 = 1;
                while (n6 < n) {
                    complex = ((ComplexVector)abstractComplexVectorArray[n6]).getComponent(n4);
                    double[] dArray10 = dArray6[n4];
                    int n7 = n5;
                    dArray10[n7] = dArray10[n7] + (dArray2[n6][n5] * complex.real() - dArray3[n6][n5] * complex.imag());
                    double[] dArray11 = dArray7[n4];
                    int n8 = n5;
                    dArray11[n8] = dArray11[n8] + (dArray3[n6][n5] * complex.real() + dArray2[n6][n5] * complex.imag());
                    double[] dArray12 = dArray8[n4];
                    int n9 = n5;
                    dArray12[n9] = dArray12[n9] + (dArray4[n6][n5] * complex.real() - dArray5[n6][n5] * complex.imag());
                    double[] dArray13 = dArray9[n4];
                    int n10 = n5;
                    dArray13[n10] = dArray13[n10] + (dArray5[n6][n5] * complex.real() + dArray4[n6][n5] * complex.imag());
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(dArray6, dArray7), new ComplexSquareMatrix(dArray8, dArray9)};
        return complexSquareMatrixArray;
    }

    public ComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            complexArray[n][0] = complexMapping.map(this.matrixRe[n][0], this.matrixIm[n][0]);
            int n2 = 1;
            while (n2 < this.numCols) {
                complexArray[n][n2] = complexMapping.map(this.matrixRe[n][n2], this.matrixIm[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }
}

