/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AbstractDoubleVector;
import JSci.maths.DoubleSparseMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class DoubleSparseVector
extends AbstractDoubleVector {
    private double[] vector;
    private int[] pos;

    public DoubleSparseVector(int n) {
        super(n);
        this.vector = new double[0];
        this.pos = new int[0];
    }

    public DoubleSparseVector(double[] dArray) {
        super(dArray.length);
        int n = 0;
        int n2 = 0;
        while (n2 < this.N) {
            if (dArray[n2] != 0.0) {
                ++n;
            }
            ++n2;
        }
        this.vector = new double[n];
        this.pos = new int[n];
        n = 0;
        int n3 = 0;
        while (n3 < this.N) {
            if (dArray[n3] != 0.0) {
                this.vector[n] = dArray[n3];
                this.pos[n] = n3;
                ++n;
            }
            ++n3;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleSparseVector && this.N == ((DoubleSparseVector)object).N) {
            DoubleSparseVector doubleSparseVector = (DoubleSparseVector)object;
            if (this.pos.length != doubleSparseVector.pos.length) {
                return false;
            }
            if (Math.abs(this.getComponent(0) - doubleSparseVector.getComponent(0)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            int n = 1;
            while (n < this.N) {
                if (Math.abs(this.getComponent(n) - doubleSparseVector.getComponent(n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public double getComponent(int n) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            if (this.pos[n2] == n) {
                return this.vector[n2];
            }
            ++n2;
        }
        return 0.0;
    }

    public void setComponent(int n, double d) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
            return;
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            if (n == this.pos[n2]) {
                this.vector[n2] = d;
                return;
            }
            ++n2;
        }
        int[] nArray = new int[this.pos.length + 1];
        double[] dArray = new double[this.vector.length + 1];
        System.arraycopy(this.pos, 0, nArray, 0, this.pos.length);
        System.arraycopy(this.vector, 0, dArray, 0, this.pos.length);
        nArray[this.pos.length] = n;
        dArray[this.vector.length] = d;
        this.pos = nArray;
        this.vector = dArray;
    }

    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public void normalize() {
        double d = this.norm();
        int n = 0;
        while (n < this.pos.length) {
            int n2 = n++;
            this.vector[n2] = this.vector[n2] / d;
        }
    }

    public double sumSquares() {
        double d = 0.0;
        int n = 0;
        while (n < this.pos.length) {
            d += this.vector[n] * this.vector[n];
            ++n;
        }
        return d;
    }

    public double mass() {
        double d = 0.0;
        int n = 0;
        while (n < this.pos.length) {
            d += this.vector[n];
            ++n;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        int n = 0;
        while (n < this.pos.length) {
            doubleSparseVector.vector[n] = -this.vector[n];
            ++n;
        }
        return doubleSparseVector;
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector add(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.add((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.add((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = abstractDoubleVector.getComponent(0);
        int n = 1;
        while (n < this.N) {
            dArray[n] = abstractDoubleVector.getComponent(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            int n3 = this.pos[n2];
            dArray[n3] = dArray[n3] + this.vector[n2];
            ++n2;
        }
        return new DoubleVector(dArray);
    }

    public DoubleVector add(DoubleVector doubleVector) {
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        System.arraycopy(doubleVector.vector, 0, dArray, 0, this.N);
        int n = 0;
        while (n < this.pos.length) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public DoubleSparseVector add(DoubleSparseVector doubleSparseVector) {
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        int n = 0;
        while (n < this.pos.length) {
            dArray[this.pos[n]] = this.vector[n] + doubleSparseVector.getComponent(this.pos[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < doubleSparseVector.pos.length) {
            int n3 = doubleSparseVector.pos[n2];
            dArray[n3] = this.getComponent(n3) + doubleSparseVector.vector[n2];
            ++n2;
        }
        return new DoubleSparseVector(dArray);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.subtract((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = -abstractDoubleVector.getComponent(0);
        int n = 1;
        while (n < this.N) {
            dArray[n] = -abstractDoubleVector.getComponent(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            int n3 = this.pos[n2];
            dArray[n3] = dArray[n3] + this.vector[n2];
            ++n2;
        }
        return new DoubleVector(dArray);
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = -doubleVector.vector[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = -doubleVector.vector[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            int n3 = this.pos[n2];
            dArray[n3] = dArray[n3] + this.vector[n2];
            ++n2;
        }
        return new DoubleVector(dArray);
    }

    public DoubleSparseVector subtract(DoubleSparseVector doubleSparseVector) {
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        int n = 0;
        while (n < this.pos.length) {
            dArray[this.pos[n]] = this.vector[n] - doubleSparseVector.getComponent(this.pos[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < doubleSparseVector.pos.length) {
            int n3 = doubleSparseVector.pos[n2];
            dArray[n3] = this.getComponent(n3) - doubleSparseVector.vector[n2];
            ++n2;
        }
        return new DoubleSparseVector(dArray);
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarMultiply(double d) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        int n = 0;
        while (n < this.pos.length) {
            doubleSparseVector.vector[n] = d * this.vector[n];
            ++n;
        }
        return doubleSparseVector;
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarDivide(double d) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        int n = 0;
        while (n < this.pos.length) {
            doubleSparseVector.vector[n] = this.vector[n] / d;
            ++n;
        }
        return doubleSparseVector;
    }

    public double scalarProduct(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.scalarProduct((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.scalarProduct((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        int n = 0;
        while (n < this.pos.length) {
            d += this.vector[n] * abstractDoubleVector.getComponent(this.pos[n]);
            ++n;
        }
        return d;
    }

    public double scalarProduct(DoubleVector doubleVector) {
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        int n = 0;
        while (n < this.pos.length) {
            d += this.vector[n] * doubleVector.vector[this.pos[n]];
            ++n;
        }
        return d;
    }

    public double scalarProduct(DoubleSparseVector doubleSparseVector) {
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        if (this.pos.length <= doubleSparseVector.pos.length) {
            int n = 0;
            while (n < this.pos.length) {
                d += this.vector[n] * doubleSparseVector.getComponent(this.pos[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < doubleSparseVector.pos.length) {
                d += this.getComponent(doubleSparseVector.pos[n]) * doubleSparseVector.vector[n];
                ++n;
            }
        }
        return d;
    }

    public DoubleSparseMatrix tensorProduct(DoubleSparseVector doubleSparseVector) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.N, doubleSparseVector.N);
        int n = 0;
        while (n < this.pos.length) {
            int n2 = 0;
            while (n2 < doubleSparseVector.pos.length) {
                doubleSparseMatrix.setElement(this.pos[n], doubleSparseVector.pos[n2], this.vector[n] * doubleSparseVector.vector[n2]);
                ++n2;
            }
            ++n;
        }
        return doubleSparseMatrix;
    }

    public AbstractDoubleVector mapComponents(Mapping mapping) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        int n = 0;
        while (n < this.pos.length) {
            doubleSparseVector.vector[n] = mapping.map(this.vector[n]);
            ++n;
        }
        return doubleSparseVector;
    }
}

