/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.ExtraMath;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.MathInteger;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public class IntegerMatrix
extends Matrix {
    protected static final int ARRAY_2D = 1;
    protected int[][] matrix;

    protected IntegerMatrix(int n, int n2, int n3) {
        super(n, n2);
        this.storageFormat = n3;
    }

    public IntegerMatrix(int n, int n2) {
        this(n, n2, 1);
        this.matrix = new int[n][n2];
    }

    public IntegerMatrix(int[][] nArray) {
        this(nArray.length, nArray[0].length, 1);
        this.matrix = nArray;
    }

    public IntegerMatrix(IntegerVector[] integerVectorArray) {
        this(integerVectorArray[0].dimension(), integerVectorArray.length);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                this.matrix[n][n2] = integerVectorArray[n2].getComponent(n);
                ++n2;
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerMatrix && this.numRows == ((IntegerMatrix)object).rows() && this.numCols == ((IntegerMatrix)object).columns()) {
            IntegerMatrix integerMatrix = (IntegerMatrix)object;
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    if (this.matrix[n][n2] != integerMatrix.getElement(n, n2)) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.numRows * this.numCols);
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                stringBuffer.append(this.matrix[n][n2]);
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public DoubleMatrix toDoubleMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public ComplexMatrix toComplexMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                dArray[n][n2] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, int n3) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n][n2] = n3;
    }

    public int infNorm() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.numCols) {
                n3 += Math.abs(this.matrix[n2][n4]);
                ++n4;
            }
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                d = ExtraMath.hypot(d, this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            nArray[n][0] = -this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                nArray[n][n2] = -this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof IntegerMatrix) {
            return this.add((IntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerMatrix);
            }
        }
        if (this.numRows == integerMatrix.rows() && this.numCols == integerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] + integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] + integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] + integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] + integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof IntegerMatrix) {
            return this.subtract((IntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerMatrix);
            }
        }
        if (this.numRows == integerMatrix.rows() && this.numCols == integerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] - integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] - integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] - integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] - integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            nArray[n2][0] = n * this.matrix[n2][0];
            int n3 = 1;
            while (n3 < this.numCols) {
                nArray[n2][n3] = n * this.matrix[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return new IntegerMatrix(nArray);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        if (this.numCols == integerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                nArray[n] = this.matrix[n][0] * integerVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + this.matrix[n][n2] * integerVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof IntegerMatrix) {
            return this.multiply((IntegerMatrix)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerMatrix multiply(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerMatrix);
            }
        }
        if (this.numCols == integerMatrix.rows()) {
            int[][] nArray = new int[this.numRows][integerMatrix.columns()];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < integerMatrix.columns()) {
                    nArray[n][n2] = this.matrix[n][0] * integerMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == integerMatrix.columns()) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerMatrix rawMultiply(IntegerMatrix integerMatrix) {
        if (this.numCols == integerMatrix.numRows) {
            int[][] nArray = new int[this.numRows][integerMatrix.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < integerMatrix.numCols) {
                    nArray[n][n2] = this.matrix[n][0] * integerMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.numRows == integerMatrix.numCols) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        int[][] nArray = new int[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            nArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                nArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }
}

