/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.algebras;

import JSci.maths.AbstractDoubleVector;
import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.Double3Vector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.LieAlgebra;
import JSci.maths.fields.ComplexField;

public final class sp2_RDim3
extends LieAlgebra {
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, Complex.ZERO, ComplexField.MINUS_HALF}, {Complex.ZERO, Complex.ZERO, ComplexField.HALF}, {ComplexField.MINUS_TWO, ComplexField.TWO, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, Complex.ZERO, ComplexField.MINUS_HALF}, {Complex.ZERO, Complex.ZERO, ComplexField.MINUS_HALF}, {ComplexField.TWO, ComplexField.TWO, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{Complex.ONE, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, ComplexField.MINUS_ONE, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final ComplexSquareMatrix[] basisMatrices = new ComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3)};
    private static sp2_RDim3 _instance;
    static /* synthetic */ Class class$JSci$maths$algebras$sp2_RDim3;

    private sp2_RDim3() {
        super("sp(2,R) [3]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final sp2_RDim3 getInstance() {
        if (_instance == null) {
            Class clazz = class$JSci$maths$algebras$sp2_RDim3 == null ? (class$JSci$maths$algebras$sp2_RDim3 = sp2_RDim3.class$("JSci.maths.algebras.sp2_RDim3")) : class$JSci$maths$algebras$sp2_RDim3;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new sp2_RDim3();
                }
            }
        }
        return _instance;
    }

    public ComplexSquareMatrix getElement(AbstractDoubleVector abstractDoubleVector) {
        ComplexMatrix complexMatrix = basisMatrices[0].scalarMultiply(abstractDoubleVector.getComponent(0));
        complexMatrix = complexMatrix.add(basisMatrices[1].scalarMultiply(abstractDoubleVector.getComponent(1)));
        complexMatrix = complexMatrix.add(basisMatrices[2].scalarMultiply(abstractDoubleVector.getComponent(2)));
        return (ComplexSquareMatrix)complexMatrix.scalarMultiply(Complex.I);
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector, AbstractDoubleVector abstractDoubleVector2) {
        if (!(abstractDoubleVector instanceof Double3Vector) || !(abstractDoubleVector2 instanceof Double3Vector)) {
            throw new VectorDimensionException("Vectors must be 3-vectors.");
        }
        return new Double3Vector(abstractDoubleVector.getComponent(2) * abstractDoubleVector2.getComponent(1) - abstractDoubleVector.getComponent(1) * abstractDoubleVector2.getComponent(2), abstractDoubleVector.getComponent(2) * abstractDoubleVector2.getComponent(0) - abstractDoubleVector.getComponent(0) * abstractDoubleVector2.getComponent(2), abstractDoubleVector.getComponent(1) * abstractDoubleVector2.getComponent(0) - abstractDoubleVector.getComponent(0) * abstractDoubleVector2.getComponent(1));
    }

    public ComplexSquareMatrix[] basis() {
        return basisMatrices;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

