/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.fields.Field;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialBasis;
import JSci.maths.polynomials.RealPolynomial;
import JSci.maths.polynomials.RealPolynomialRing;

public class RealLagrangeBasis
implements PolynomialBasis {
    protected double[] _samplingsX;
    protected int _dim;
    private RealPolynomial[] _basis;
    private Field.Member[] _samplings;

    public RealLagrangeBasis(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        this._dim = memberArray.length;
        this._samplings = memberArray;
        this._samplingsX = RealPolynomialRing.toDouble(this._samplings);
        this.buildBasis();
    }

    public RealLagrangeBasis(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        this._dim = dArray.length;
        this._samplingsX = dArray;
        this.buildBasis();
    }

    protected RealLagrangeBasis() {
    }

    public Polynomial getBasisVector(int n) {
        return this._basis[n];
    }

    public int dimension() {
        return this._dim;
    }

    public Field.Member[] getSamplingPoints() {
        if (this._samplings == null) {
            this._samplings = RealPolynomialRing.toMathDouble(this._samplingsX);
        }
        return this._samplings;
    }

    public Polynomial superposition(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        if (memberArray.length != this._dim) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        double[] dArray = RealPolynomialRing.toDouble(memberArray);
        return this.superposition(dArray);
    }

    public RealPolynomial superposition(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        if (dArray.length != this._dim) {
            throw new IllegalArgumentException("Dimension of basis is " + this._dim + ". Got " + dArray.length + " coefficients");
        }
        RealPolynomial realPolynomial = (RealPolynomial)RealPolynomialRing.getInstance().zero();
        int n = 0;
        while (n < this._dim) {
            RealPolynomial realPolynomial2 = (RealPolynomial)this.getBasisVector(n);
            RealPolynomial realPolynomial3 = realPolynomial2.multiply(dArray[n]);
            realPolynomial = (RealPolynomial)realPolynomial.add(realPolynomial3);
            ++n;
        }
        return realPolynomial;
    }

    protected void buildBasis() {
        this._basis = new RealPolynomial[this._dim];
        int n = 0;
        while (n < this._dim) {
            this._basis[n] = (RealPolynomial)RealPolynomialRing.getInstance().one();
            double d = 1.0;
            int n2 = 0;
            while (n2 < this._dim) {
                if (n2 != n) {
                    RealPolynomial realPolynomial = new RealPolynomial(new double[]{-this._samplingsX[n2], 1.0});
                    this._basis[n] = (RealPolynomial)this._basis[n].multiply(realPolynomial);
                    d *= this._samplingsX[n] - this._samplingsX[n2];
                }
                ++n2;
            }
            this._basis[n] = this._basis[n].divide(d);
            ++n;
        }
    }
}

