/*
 * Decompiled with CFR 0.152.
 */
import Acme.JPM.Encoders.GifEncoderNoCM;
import com.eteks.filter.Web216ColorsFilter;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ToolkitDemo {
    public static void main(String[] stringArray) {
        System.out.println("Toolkit demo");
        System.out.println("\u00a9 Copyright 2000-2001 eTeks <info@eteks.com>.");
        System.out.println("\u00a9 Copyright 1996,1998 by Jef Poskanzer <jef@acme.com>.\n");
        System.out.println("Toolkit class in use is " + Toolkit.getDefaultToolkit().getClass().getName());
        GraphicsDrawer[] graphicsDrawerArray = new GraphicsDrawer[]{new GraphicsArcDrawer(), new GraphicsPolygonDrawer(), new GraphicsTextDrawer(), new GraphicsImageDrawer()};
        try {
            String string = Toolkit.getDefaultToolkit().getClass().getName().indexOf("PJA") >= 0 ? "PJAToolkit" : "NativeToolkit";
            ToolkitDemo.ComputeImageFiles(graphicsDrawerArray, new ImageBuilder(), string);
        }
        catch (AWTError aWTError) {
            System.out.println(String.valueOf(aWTError) + "\nThis demo requires a toolkit to run.");
        }
        System.exit(0);
    }

    protected static void ComputeImageFiles(GraphicsDrawer[] graphicsDrawerArray, ImageBuilder imageBuilder, String string) {
        int n = 0;
        while (n < graphicsDrawerArray.length) {
            Object object;
            Image image = imageBuilder.createImage(graphicsDrawerArray[n].getWidth(), graphicsDrawerArray[n].getHeight());
            try {
                System.out.println("Computing " + graphicsDrawerArray[n] + " image (instance of " + image.getClass().getName() + ")");
                object = image.getGraphics();
                try {
                    if (object instanceof Graphics2D) {
                        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                }
                catch (LinkageError linkageError) {}
                graphicsDrawerArray[n].paint((Graphics)object);
            }
            catch (AWTError aWTError) {
                System.out.println(String.valueOf(aWTError) + "\nIn case of an error related to font, you should run first PJAFontCapture to generate at least one .pjaf font file.");
            }
            try {
                object = String.valueOf(string) + graphicsDrawerArray[n] + ".gif";
                System.out.println("Saving image to " + (String)object);
                FileOutputStream fileOutputStream = new FileOutputStream((String)object);
                new GifEncoderNoCM(new FilteredImageSource(image.getSource(), new Web216ColorsFilter()), (OutputStream)fileOutputStream).encode();
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                System.err.println("Image image" + graphicsDrawerArray[n] + " couldn't be saved");
            }
            ++n;
        }
    }

    protected static class ImageBuilder {
        public Image createImage(int n, int n2) {
            Frame frame = new Frame();
            frame.addNotify();
            return frame.createImage(n, n2);
        }

        protected ImageBuilder() {
        }
    }

    protected static interface GraphicsDrawer {
        public int getWidth();

        public int getHeight();

        public void paint(Graphics var1);
    }

    protected static class GraphicsArcDrawer
    implements GraphicsDrawer {
        public int getWidth() {
            return 426;
        }

        public int getHeight() {
            return 81;
        }

        public void paint(Graphics graphics) {
            int[] nArray = new int[]{30, 30, 30, 30, 160, 240};
            int[] nArray2 = new int[]{42, 120, 200, 270, 280, 240};
            int[] nArray3 = new int[]{69, 69, 69, 69, 69, 69};
            int[] nArray4 = new int[]{50, 80, 70, 70, 35, 70};
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            int n = 0;
            int n2 = 0;
            while (n < nArray3.length) {
                graphics.setColor(Color.lightGray);
                graphics.fillOval(n2, 0, nArray3[n], nArray4[n]);
                graphics.setColor(Color.darkGray);
                graphics.drawOval(n2, 0, nArray3[n], nArray4[n]);
                graphics.setColor(Color.red);
                graphics.fillArc(n2, 0, nArray3[n], nArray4[n], nArray[n], nArray2[n]);
                graphics.setColor(Color.blue);
                graphics.drawArc(n2, 0, nArray3[n], nArray4[n], nArray[n], nArray2[n]);
                graphics.drawArc(n2 + 1, 1, nArray3[n] - 2, nArray4[n] - 2, nArray[n], nArray2[n]);
                n2 += nArray3[n++] + 1;
            }
        }

        public String toString() {
            return "ArcDrawer";
        }

        protected GraphicsArcDrawer() {
        }
    }

    protected static class GraphicsPolygonDrawer
    implements GraphicsDrawer {
        public int getWidth() {
            return 400;
        }

        public int getHeight() {
            return 101;
        }

        public void paint(Graphics graphics) {
            Polygon[] polygonArray;
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.yellow.darker());
            graphics.fillRoundRect(2, 2, 95, 95, 25, 18);
            graphics.setColor(Color.darkGray);
            graphics.drawRoundRect(2, 2, 95, 95, 25, 18);
            int n = 0;
            while (n < 360) {
                graphics.setColor(new Color(n * 255 / 360, n * 255 / 360, n * 255 / 360));
                polygonArray = graphics.create();
                polygonArray.translate((int)((double)(n / 25) * Math.cos((double)n * Math.PI / 180.0)), (int)((double)(n / 25) * Math.sin((double)n * Math.PI / 180.0)));
                polygonArray.drawLine(50, 50, (int)(50.0 + 35.0 * Math.cos((double)n * Math.PI / 180.0)), (int)(50.0 + 35.0 * Math.sin((double)n * Math.PI / 180.0)));
                polygonArray.dispose();
                n += 15;
            }
            graphics.setColor(Color.yellow.darker());
            graphics.fill3DRect(102, 2, 294, 96, false);
            graphics.draw3DRect(101, 1, 295, 97, true);
            polygonArray = new Polygon[]{new Polygon(new int[]{107, 150, 200, 160, 107}, new int[]{5, 5, 25, 49, 49}, 5), new Polygon(new int[]{202, 225, 260, 300, 300, 260, 225, 202}, new int[]{5, 49, 7, 49, 5, 49, 4, 49}, 8), new Polygon(new int[]{302, 330, 302, 350, 390, 390, 360, 302}, new int[]{6, 25, 47, 32, 47, 6, 17, 6}, 8)};
            int n2 = 0;
            while (n2 < polygonArray.length) {
                graphics.setColor(Color.pink);
                graphics.fillPolygon(polygonArray[n2]);
                Graphics graphics2 = graphics.create();
                graphics2.translate(0, 45);
                graphics2.setColor(Color.orange);
                graphics2.fillPolygon(polygonArray[n2]);
                graphics2.setColor(Color.darkGray);
                graphics2.drawPolygon(polygonArray[n2]);
                graphics2.dispose();
                ++n2;
            }
        }

        public String toString() {
            return "PolygonDrawer";
        }

        protected GraphicsPolygonDrawer() {
        }
    }

    protected static class GraphicsTextDrawer
    implements GraphicsDrawer {
        public int getWidth() {
            return 300;
        }

        public int getHeight() {
            return 170;
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            String string = graphics.getFont().getName();
            int[] nArray = new int[8];
            nArray[5] = 2;
            nArray[6] = 1;
            nArray[7] = 3;
            int[] nArray2 = nArray;
            int[] nArray3 = new int[]{9, 10, 12, 16, 24, 12, 12, 12};
            int n = 0;
            int n2 = 0;
            while (n < nArray2.length) {
                String string2 = string;
                string2 = (nArray2[n] & 1) != 0 ? String.valueOf(string2) + ((nArray2[n] & 2) != 0 ? " bolditalic " : " bold ") : String.valueOf(string2) + ((nArray2[n] & 2) != 0 ? " italic " : " plain ");
                string2 = String.valueOf(string2) + nArray3[n];
                graphics.setFont(new Font("", nArray2[n], nArray3[n]));
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n3 = fontMetrics.stringWidth(string2);
                graphics.setColor(Color.cyan.darker());
                graphics.drawRect(5, n2, n3, fontMetrics.getHeight());
                graphics.drawRect(5, n2 + fontMetrics.getLeading(), n3, fontMetrics.getAscent());
                graphics.setColor(Color.black);
                graphics.drawString(string2, 5, n2 + fontMetrics.getAscent() + fontMetrics.getLeading());
                n2 += fontMetrics.getHeight() + 2;
                ++n;
            }
        }

        public String toString() {
            return "TextDrawer";
        }

        protected GraphicsTextDrawer() {
        }
    }

    protected static class GraphicsImageDrawer
    implements GraphicsDrawer {
        public int getWidth() {
            return 250;
        }

        public int getHeight() {
            return 100;
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(0, 0, 150, 100), new Rectangle(140, 10, 80, 70), new Rectangle(130, 65, 90, 25)};
            Image[] imageArray = new Image[3];
            Dimension dimension = new Dimension(100, 100);
            int[] nArray = new int[dimension.width * dimension.height];
            int n = 0;
            while (n < dimension.height) {
                int n2 = 0;
                while (n2 < dimension.width) {
                    nArray[n * dimension.width + n2] = 0xC0000000 | n2 * 255 / dimension.width << 16 | n * 255 / dimension.height << 8;
                    ++n2;
                }
                ++n;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            imageArray[0] = toolkit.getImage("photo.jpg");
            imageArray[1] = toolkit.createImage(new MemoryImageSource(dimension.width, dimension.height, nArray, 0, dimension.width));
            imageArray[2] = toolkit.getImage("logoeteks.gif");
            1 var8_9 = new 1();
            int n3 = 0;
            while (n3 < imageArray.length) {
                try {
                    MediaTracker mediaTracker = new MediaTracker(new Frame());
                    mediaTracker.addImage(imageArray[n3], 0);
                    mediaTracker.waitForID(0);
                }
                catch (Exception exception) {}
                graphics.drawImage(imageArray[n3], rectangleArray[n3].x, rectangleArray[n3].y, rectangleArray[n3].width, rectangleArray[n3].height, var8_9);
                ++n3;
            }
            graphics.copyArea(210, 0, 10, 60, 12, 0);
            if (graphics.getFont() != null) {
                graphics.setFont(new Font(graphics.getFont().getName(), 3, 20));
                graphics.setXORMode(Color.red);
                graphics.clipRect(10, 47, 250, 12);
                graphics.drawString("XOR Clipped text", 5, 60);
            }
        }

        public String toString() {
            return "ImageDrawer";
        }

        protected GraphicsImageDrawer() {
        }
    }
}

