/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.catalina.startup.Tomcat;
import org.apache.log4j.Logger;

public class StandaloneServer {
    private static final Logger LOG = Logger.getLogger(StandaloneServer.class);

    public static void main(String[] stringArray) {
        try {
            File file;
            File file2 = new File("web");
            if (!file2.exists() || !file2.isDirectory()) {
                LOG.error((Object)("The web directory '" + file2.getCanonicalPath() + "' does not exist"));
                System.exit(1);
            }
            if (!(file = new File("work")).exists()) {
                file.mkdirs();
            } else if (file.isFile()) {
                LOG.error((Object)("The working directory '" + file2.getCanonicalPath() + "' is invalid"));
                System.exit(1);
            }
            System.setProperty("java.io.tmpdir", file.getCanonicalPath());
            LOG.info((Object)"Configuring Cyclos standalone server. Please wait...");
            File file3 = new File("logs");
            file3.mkdirs();
            File file4 = new File(file2, "WEB-INF/classes/cyclos.properties");
            Properties properties = new Properties();
            int n = 8080;
            if (file4.exists()) {
                properties.load(new FileInputStream(file4));
                n = Integer.parseInt(properties.getProperty("cyclos.security.port.http", "8080"));
            }
            System.setProperty("cyclos.standalone", "true");
            final Tomcat tomcat = new Tomcat();
            tomcat.setPort(n);
            tomcat.setBaseDir("");
            tomcat.addWebapp("", file2.getAbsolutePath());
            tomcat.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        tomcat.stop();
                    }
                    catch (Exception exception) {
                        LOG.error((Object)"There was a problem while stopping the server", (Throwable)exception);
                    }
                }
            });
            LOG.info((Object)("Server successfully started at URL " + new URL("http", "localhost", n, "/")));
            tomcat.getServer().await();
        }
        catch (Throwable throwable) {
            LOG.error((Object)"There was a problem with Cyclos server", throwable);
            System.exit(1);
        }
    }
}

