/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jibx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.AbstractWrapperHelper;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.jibx.JibxDataReader;
import org.apache.cxf.jibx.JibxDataWriter;
import org.apache.cxf.jibx.JibxSchemaInitializer;
import org.apache.cxf.jibx.JibxWrapperHelper;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.ServiceInfo;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JibxDataBinding
extends AbstractDataBinding
implements WrapperCapableDatabinding {
    private static final Logger LOG = LogUtils.getLogger(JibxDataBinding.class);
    private static final Class<?>[] SUPPORTED_DATA_READER_FORMATS = new Class[]{XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_DATA_WRITER_FORMATS = new Class[]{XMLStreamWriter.class};

    @Override
    public <T> DataReader<T> createReader(Class<T> cls) {
        if (XMLStreamReader.class.equals(cls)) {
            return new JibxDataReader();
        }
        return null;
    }

    @Override
    public <T> DataWriter<T> createWriter(Class<T> cls) {
        if (XMLStreamWriter.class.equals(cls)) {
            return new JibxDataWriter();
        }
        return null;
    }

    @Override
    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_DATA_READER_FORMATS;
    }

    @Override
    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_DATA_WRITER_FORMATS;
    }

    @Override
    public void initialize(Service service) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Initialize JiBX Databinding for [" + service.getName() + "] service");
        }
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            SchemaCollection schemaCollection = serviceInfo.getXmlSchemaCollection();
            if (schemaCollection.getXmlSchemas().length > 1) continue;
            Collection<DOMSource> schemas = this.getSchemas();
            if (schemas != null) {
                for (DOMSource source : schemas) {
                    this.addSchemaDocument(serviceInfo, schemaCollection, (Document)source.getNode(), source.getSystemId());
                }
            }
            JibxSchemaInitializer schemaInit = new JibxSchemaInitializer(serviceInfo, schemaCollection, this);
            schemaInit.walk();
        }
    }

    @Override
    public WrapperHelper createWrapperHelper(Class<?> wrapperType, QName typeName, List<String> partNames, List<String> elTypeNames, List<Class<?>> partClasses) {
        ArrayList<Method> getMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> setMethods = new ArrayList<Method>(partNames.size());
        ArrayList fields = new ArrayList(partNames.size());
        Method[] allMethods = wrapperType.getMethods();
        for (int x = 0; x < partNames.size(); ++x) {
            String partName = partNames.get(x);
            if (partName == null) {
                getMethods.add(null);
                setMethods.add(null);
                fields.add(null);
                continue;
            }
            String getAccessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
            String setAccessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.SETTER);
            Method getMethod = null;
            Method setMethod = null;
            allMethods = wrapperType.getMethods();
            try {
                getMethod = wrapperType.getMethod(getAccessor, AbstractWrapperHelper.NO_CLASSES);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            for (Method method : allMethods) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !setAccessor.equals(method.getName())) continue;
                setMethod = method;
                break;
            }
            getMethods.add(getMethod);
            setMethods.add(setMethod);
            fields.add(null);
        }
        return new JibxWrapperHelper(wrapperType, setMethods.toArray(new Method[setMethods.size()]), getMethods.toArray(new Method[getMethods.size()]), fields.toArray(new Field[fields.size()]));
    }
}

