/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.URI;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/authorize-implicit")
public class ImplicitGrantService
extends RedirectionBasedGrantService {
    public ImplicitGrantService() {
        super("token", "implicit", false);
    }

    @Override
    protected Response createGrant(MultivaluedMap<String, String> params, Client client, String redirectUri, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        ServerAccessToken token = null;
        if (preAuthorizedToken != null) {
            AccessTokenRegistration reg = new AccessTokenRegistration();
            reg.setClient(client);
            reg.setGrantType("implicit");
            reg.setSubject(userSubject);
            reg.setRequestedScope(requestedScope);
            reg.setApprovedScope(approvedScope);
            token = this.getDataProvider().createAccessToken(reg);
        } else {
            token = preAuthorizedToken;
        }
        StringBuilder sb = this.getUriWithFragment((String)params.getFirst((Object)"state"), redirectUri);
        sb.append("access_token").append("=").append(token.getTokenKey());
        sb.append("token_type").append("=").append(token.getTokenType());
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    @Override
    protected Response createErrorResponse(MultivaluedMap<String, String> params, String redirectUri, String error) {
        StringBuilder sb = this.getUriWithFragment((String)params.getFirst((Object)"state"), redirectUri);
        sb.append("error").append("=").append(error);
        return Response.seeOther((URI)URI.create(sb.toString())).build();
    }

    private StringBuilder getUriWithFragment(String state, String redirectUri) {
        StringBuilder sb = new StringBuilder();
        sb.append(redirectUri);
        sb.append("#");
        if (state != null) {
            sb.append("state").append("=").append(state);
        }
        return sb;
    }
}

