/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.saml.assertion.Claim;
import org.apache.cxf.rs.security.saml.assertion.Claims;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.NameID;
import org.opensaml.xml.XMLObject;

public final class SAMLUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLUtils.class);

    private SAMLUtils() {
    }

    public static Subject getSubject(Message message, AssertionWrapper assertionW) {
        org.opensaml.saml2.core.Subject s = assertionW.getSaml2().getSubject();
        Subject subject = new Subject();
        NameID nameId = s.getNameID();
        subject.setNameQualifier(nameId.getNameQualifier());
        subject.setNameFormat(nameId.getFormat());
        subject.setName(nameId.getValue());
        subject.setSpId(nameId.getSPProvidedID());
        subject.setSpQualifier(nameId.getSPNameQualifier());
        return subject;
    }

    public static Claims getClaims(AssertionWrapper assertionW) {
        ArrayList<Claim> claims = new ArrayList<Claim>();
        List statements = assertionW.getSaml2().getAttributeStatements();
        for (AttributeStatement as : statements) {
            for (Attribute atr : as.getAttributes()) {
                Claim claim = new Claim();
                claim.setName(atr.getName());
                claim.setNameFormat(atr.getNameFormat());
                claim.setFriendlyName(atr.getFriendlyName());
                for (XMLObject o : atr.getAttributeValues()) {
                    String attrValue = o.getDOM().getTextContent();
                    claim.getValues().add(attrValue);
                }
                claims.add(claim);
            }
        }
        return new Claims(claims);
    }

    public static AssertionWrapper createAssertion(Message message) throws Fault {
        CallbackHandler handler = SecurityUtils.getCallbackHandler(message, SAMLUtils.class, "ws-security.saml-callback-handler");
        SAMLParms samlParms = new SAMLParms();
        samlParms.setCallbackHandler(handler);
        try {
            AssertionWrapper assertion = new AssertionWrapper(samlParms);
            boolean selfSignAssertion = MessageUtils.getContextualBoolean(message, "ws-security.self-sign-saml-assertion", false);
            if (selfSignAssertion) {
                Crypto crypto = new CryptoLoader().getCrypto(message, "ws-security.signature.crypto", "ws-security.signature.properties");
                String user = SecurityUtils.getUserName(message, crypto, "ws-security.signature.username");
                if (StringUtils.isEmpty(user)) {
                    return assertion;
                }
                String password = SecurityUtils.getPassword(message, user, 3, SAMLUtils.class);
                assertion.signAssertion(user, password, crypto, false);
            }
            return assertion;
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault(new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }
}

