/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.io.IOException;
import java.net.URL;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.ws.security.cache.EHCacheReplayCacheFactory;
import org.apache.cxf.ws.security.tokenstore.EHCacheTokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;

public class EHCacheTokenStoreFactory
extends TokenStoreFactory {
    public TokenStore newTokenStore(String key, Message message) {
        URL configFileURL = this.getConfigFileURL(message);
        if (configFileURL == null) {
            String defaultConfigFile = "cxf-ehcache.xml";
            ResourceManager rm = message.getExchange().get(Bus.class).getExtension(ResourceManager.class);
            configFileURL = rm.resolveResource(defaultConfigFile, URL.class);
            try {
                if (configFileURL == null) {
                    configFileURL = ClassLoaderUtils.getResource(defaultConfigFile, EHCacheReplayCacheFactory.class);
                }
                if (configFileURL == null) {
                    configFileURL = new URL(defaultConfigFile);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (configFileURL != null) {
            message.setContextualProperty("ws-security.cache.config.file", configFileURL);
        }
        return new EHCacheTokenStore(key, configFileURL);
    }
}

