/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import jzebra.LanguageType;
import jzebra.LogIt;

public class ImageWrapper {
    private static final String HEXES = "0123456789ABCDEF";

    public static String getImage(ImageIcon i, LanguageType lang, Charset charset) throws IOException {
        int w = i.getIconWidth();
        int h = i.getIconHeight();
        LogIt.log("Image specified: " + i.getDescription());
        LogIt.log("Dimensions: " + w + "x" + h);
        BufferedImage buffer = new BufferedImage(w, h, 1);
        Graphics2D g = buffer.createGraphics();
        g.drawImage(i.getImage(), 0, 0, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)buffer, "bmp", out);
        boolean[] black = ImageWrapper.getBlackPixels(out, w, h);
        int[] hex = ImageWrapper.getHexValues(black);
        String data = ImageWrapper.getHex(hex);
        int bytes = data.length() / 2;
        int perRow = bytes / h;
        int pixels = black.length;
        LogIt.log("Bytes: " + bytes + ", Pixels: " + pixels);
        LogIt.log("Pixels/Row: " + pixels / h);
        LogIt.log("Bytes/Row: " + perRow);
        LogIt.log("Binary Data: " + data);
        switch (lang) {
            case ESCP: 
            case CPCL: {
                return "EG " + w / 8 + " " + h + " 0 0 " + data;
            }
            case ESCP2: {
                if (h > 510) {
                    return " ESCP IMAGES TALLER THAN 510 PIXELS NOT SUPPORTED ";
                }
                int n1 = h > 255 ? h - 255 : 0;
                int n2 = h <= 255 ? h : 255;
                return 113 + (byte)n1 + (byte)n2 + new String(ImageWrapper.getBytes(hex), charset.name());
            }
            case ZPLII: {
                return "^GFA," + bytes + "," + bytes + "," + perRow + "," + data;
            }
        }
        return " ERROR CONVERTING JZEBRA IMAGE TO COMMANDS ";
    }

    public static String getImage(byte[] imgData, LanguageType lang, Charset charset) throws IOException, MalformedURLException, IllegalArgumentException {
        return ImageWrapper.getImage(new ImageIcon(imgData, "Byte Array"), lang, charset);
    }

    public static String getImage(String url, LanguageType lang, Charset charset) throws IOException, MalformedURLException, IllegalArgumentException {
        return ImageWrapper.getImage(new ImageIcon(new URL(url), url), lang, charset);
    }

    private static String flipRows(String hex, int height) {
        String flipped = "";
        int width = hex.length() / height;
        for (int i = 0; i < height; ++i) {
            flipped = flipped + new StringBuilder(hex.substring(i * width, (i + 1) * width)).reverse().toString();
        }
        return flipped;
    }

    private static boolean[] getBlackPixels(ByteArrayOutputStream o, int width, int height) {
        int skip = 54;
        byte[] data = o.toByteArray();
        int length = data.length - skip;
        boolean[] pixels = new boolean[length / 3];
        int pos = 0;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int i = width * y + x;
                int r = Integer.parseInt(Byte.toString(data[3 * i + skip]));
                int g = Integer.parseInt(Byte.toString(data[3 * i + skip + 1]));
                int b = Integer.parseInt(Byte.toString(data[3 * i + skip + 2]));
                pixels[pos++] = r * g * b != -1;
            }
        }
        return pixels;
    }

    private static byte[] getBytes(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    private static int[] getHexValues(boolean[] black) {
        int[] hex = new int[black.length / 8];
        for (int i = 0; i < hex.length; ++i) {
            for (int k = 0; k < 8; ++k) {
                int n = i;
                hex[n] = hex[n] + ((black[8 * i + k] ? 1 : 0) << 7 - k);
            }
        }
        return hex;
    }

    public static String getHexString(byte[] b) throws Exception {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    private static String getHex(int[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (int i : raw) {
            hex.append(HEXES.charAt((i & 0xF0) >> 4)).append(HEXES.charAt(i & 0xF));
        }
        return hex.toString();
    }
}

