/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jzebra.Base64;
import jzebra.ImageWrapper;
import jzebra.LanguageType;
import jzebra.LogIt;
import jzebra.PrintHTML;
import jzebra.PrintPostScript;
import jzebra.PrintRaw;
import jzebra.PrintServiceMatcher;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class PrintApplet
extends Applet
implements Runnable {
    private static final AtomicReference<Thread> thisThread = new AtomicReference<Object>(null);
    public static final String VERSION = "1.4.3";
    private static final long serialVersionUID = 2787955484074291340L;
    public static final int APPEND_XML = 1;
    public static final int APPEND_RAW = 2;
    public static final int APPEND_IMAGE = 3;
    public static final int APPEND_IMAGE_PS = 4;
    public static final int APPEND_PDF = 8;
    public static final int APPEND_HTML = 16;
    private LanguageType lang;
    private int appendType;
    private long sleep;
    private PrintService ps;
    private PrintRaw printRaw;
    private PrintPostScript printPS;
    private PrintHTML printHTML;
    private Throwable t;
    private boolean startFinding;
    private boolean doneFinding;
    private boolean startPrinting;
    private boolean donePrinting;
    private boolean startAppending;
    private boolean doneAppending;
    private boolean running;
    private boolean reprint;
    private boolean psPrint;
    private boolean htmlPrint;
    private String jobName;
    private String file;
    private String xmlTag;
    private String printer;
    private Charset charset = Charset.defaultCharset();
    private int documentsPerSpool = 0;
    private String endOfDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logStart();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    PrintApplet.this.startJavaScriptListener();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            LogIt.log("Error starting main JavaScript thread.  All else will fail.", e);
            this.set(e);
        }
        finally {
            this.logStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJavaScriptListener() {
        this.notifyBrowser("jzebraReady");
        while (this.running) {
            try {
                Thread.sleep(this.sleep);
                if (this.startAppending) {
                    try {
                        switch (this.appendType) {
                            case 16: {
                                this.appendHTML(this.readRawFile());
                            }
                            case 1: {
                                this.append64(this.readXMLFile());
                                break;
                            }
                            case 2: {
                                this.append(this.readRawFile());
                                break;
                            }
                            case 4: {
                                this.readImage();
                                break;
                            }
                            case 3: {
                                if (this.isBase64Image(this.file)) {
                                    this.append(ImageWrapper.getImage(Base64.decode(this.file.split(",")[1]), this.lang, this.charset));
                                    break;
                                }
                                this.append(ImageWrapper.getImage(this.file, this.lang, this.charset));
                                break;
                            }
                            case 8: {
                                this.readBinaryFile();
                                break;
                            }
                        }
                    }
                    catch (Throwable t) {
                        LogIt.log("Error appending " + this.appendType + " data", t);
                        this.set(t);
                    }
                    this.startAppending = false;
                    this.setDoneAppending(true);
                }
                if (this.startFinding) {
                    this.logFindPrinter();
                    this.startFinding = false;
                    if (this.printer == null) {
                        this.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
                    } else {
                        this.setPrintService(PrintServiceMatcher.findPrinter(this.printer));
                    }
                    this.setDoneFinding(true);
                }
                if (!this.startPrinting) continue;
                this.logPrint();
                try {
                    this.startPrinting = false;
                    if (this.htmlPrint) {
                        this.logAndPrint(this.getPrintHTML());
                        continue;
                    }
                    if (this.psPrint) {
                        this.logAndPrint(this.getPrintPS());
                        continue;
                    }
                    if (this.isRawAutoSpooling()) {
                        String[] split = this.getPrintRaw().get().split(this.endOfDocument);
                        int currentPage = 1;
                        this.getPrintRaw().clear();
                        for (String s : split) {
                            this.getPrintRaw().append(s + this.endOfDocument);
                            if (currentPage < this.documentsPerSpool) {
                                ++currentPage;
                                continue;
                            }
                            this.logAndPrint(this.getPrintRaw());
                            currentPage = 1;
                        }
                        if (this.getPrintRaw().isClear()) continue;
                        this.logAndPrint(this.getPrintRaw());
                        continue;
                    }
                    this.logAndPrint(this.getPrintRaw());
                }
                catch (PrintException e) {
                    this.set(e);
                }
                catch (PrinterException e) {
                    this.set(e);
                }
                catch (UnsupportedEncodingException e) {
                    this.set(e);
                }
                finally {
                    this.setDonePrinting(true);
                    this.getPrintRaw().clear();
                }
            }
            catch (InterruptedException e) {
                this.set(e);
            }
        }
    }

    private boolean isRawAutoSpooling() {
        return this.documentsPerSpool > 0 && this.endOfDocument != null && !this.getPrintRaw().isClear() && this.getPrintRaw().get().contains(this.endOfDocument);
    }

    private void setDonePrinting(boolean donePrinting) {
        this.donePrinting = donePrinting;
        this.notifyBrowser("jzebraDonePrinting");
    }

    private void setDoneFinding(boolean doneFinding) {
        this.doneFinding = doneFinding;
        this.notifyBrowser("jzebraDoneFinding");
    }

    private void setDoneAppending(boolean doneAppending) {
        this.doneAppending = doneAppending;
        this.notifyBrowser("jzebraDoneAppending");
    }

    private void processParameters() {
        this.jobName = "jZebra ___ Printing";
        this.running = true;
        this.startPrinting = false;
        this.donePrinting = true;
        this.startFinding = false;
        this.doneFinding = true;
        this.startAppending = false;
        this.doneAppending = true;
        this.sleep = this.getParameter("sleep", 100L);
        this.psPrint = false;
        this.appendType = 0;
        String printer = this.getParameter("printer", null);
        if (printer != null) {
            this.findPrinter(printer);
        }
    }

    private void notifyBrowser(String function) {
        try {
            JSObject.getWindow((Applet)this).call(function, null);
        }
        catch (Exception e) {
            LogIt.log(Level.WARNING, "Tried calling JavaScript \"" + function + "\" through web browser and failed (" + e.getLocalizedMessage() + ")");
        }
    }

    private String getParameter(String name, String defaultVal) {
        if (name != null) {
            try {
                String retVal = super.getParameter(name);
                retVal = this.isBlank(retVal) ? super.getParameter(name.toUpperCase()) : retVal;
                return this.isBlank(retVal) ? defaultVal : retVal;
            }
            catch (NullPointerException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    private long getParameter(String name, long defaultVal) {
        return Long.parseLong(this.getParameter(name, "" + defaultVal));
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().equals("");
    }

    public String getPrinters() {
        return PrintServiceMatcher.getPrinterListing();
    }

    public void append64(String base64) {
        try {
            this.getPrintRaw().append(Base64.decode(base64));
        }
        catch (IOException e) {
            this.set(e);
        }
    }

    public void appendHTMLFile(String htmlFile) {
        this.appendType = 16;
        this.appendFromThread(htmlFile, this.appendType);
    }

    public void appendHtmlFile(String htmlFile) {
        this.appendHTMLFile(htmlFile);
    }

    public void appendHtml(String html) {
        this.appendHTML(html);
    }

    public void appendHTML(String html) {
        this.getPrintHTML().append(html);
    }

    public void appendXML(String xmlFile, String xmlTag) {
        this.appendFromThread(xmlFile, 1);
        this.xmlTag = xmlTag;
    }

    public void appendFile(String rawDataFile) {
        this.appendFromThread(rawDataFile, 2);
    }

    public void appendImage(String imageFile) {
        this.appendFromThread(imageFile, 4);
    }

    public void appendPDF(String pdfFile) {
        this.appendFromThread(pdfFile, 8);
    }

    public void appendImage(String imageFile, String appendType) {
        this.lang = LanguageType.getType(appendType);
        switch (this.lang) {
            case CPCL: 
            case ESCP: 
            case ESCP2: 
            case ZPLII: {
                this.appendFromThread(imageFile, 3);
                break;
            }
            default: {
                LogIt.log(new UnsupportedOperationException("Image conversion to format \"" + appendType + "\" not yet supported."));
            }
        }
    }

    private void appendFromThread(String file, int appendType) {
        this.startAppending = true;
        this.doneAppending = false;
        this.appendType = appendType;
        this.file = file;
    }

    @Deprecated
    public void setImageOrientation(String orientation) {
        this.getPrintPS().setOrientation(orientation);
    }

    private String readXMLFile() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.file);
            doc.getDocumentElement().normalize();
            LogIt.log("Root element " + doc.getDocumentElement().getNodeName());
            NodeList nodeList = doc.getElementsByTagName(this.xmlTag);
            if (nodeList.getLength() > 0) {
                return nodeList.item(0).getTextContent();
            }
            LogIt.log("Node \"" + this.xmlTag + "\" could not be found in XML file specified");
        }
        catch (Exception e) {
            LogIt.log(Level.WARNING, "Error reading/parsing specified XML file", e);
        }
        return "";
    }

    public void printToFile() {
        this.printToFile(null);
    }

    public void printToFile(String outputPath) {
        if (outputPath != null && !outputPath.equals("")) {
            this.printRaw.setOutputPath(outputPath);
        }
        this.print();
    }

    private void readImage() {
        try {
            if (this.isBase64Image(this.file)) {
                this.getPrintPS().setImage(Base64.decode(this.file.split(",")[1]));
            } else {
                this.getPrintPS().setImage(ImageIO.read(new URL(this.file)));
            }
        }
        catch (IOException ex) {
            LogIt.log(Level.WARNING, "Error reading specified image", ex);
        }
    }

    private boolean isBase64Image(String path) {
        return path.startsWith("data:image/") && path.contains(";base64,");
    }

    private PrintPostScript getPrintPS() {
        if (this.printPS == null) {
            this.printPS = new PrintPostScript();
            this.printPS.setPrintParameters(this);
        }
        return this.printPS;
    }

    private PrintHTML getPrintHTML() {
        if (this.printHTML == null) {
            this.printHTML = new PrintHTML();
            this.printHTML.setPrintParameters(this);
        }
        return this.printHTML;
    }

    public void readBinaryFile() {
        ByteBuffer data = null;
        try {
            int len;
            URLConnection con = new URL(this.file).openConnection();
            InputStream in = con.getInputStream();
            int size = con.getContentLength();
            ByteArrayOutputStream out = size != -1 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream(20480);
            byte[] buffer = new byte[512];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            in.close();
            out.close();
            byte[] array = out.toByteArray();
            data = ByteBuffer.wrap(array);
        }
        catch (Exception e) {
            LogIt.log(Level.WARNING, "Error reading/parsing specified PDF file", e);
        }
        this.getPrintPS().setPDF(data);
    }

    private String readRawFile() {
        String rawData = "";
        try {
            int len;
            byte[] buffer = new byte[512];
            DataInputStream in = new DataInputStream(new URL(this.file).openStream());
            while ((len = in.read(buffer)) != -1) {
                rawData = rawData + new String(buffer, 0, len, this.charset.name());
            }
            in.close();
        }
        catch (Exception e) {
            LogIt.log(Level.WARNING, "Error reading/parsing specified RAW file", e);
        }
        return rawData;
    }

    public void printPersistent() {
        this.startPrinting = true;
        this.donePrinting = false;
        this.reprint = true;
    }

    public void append(String s) {
        try {
            this.getPrintRaw().append(s.getBytes(this.charset.name()));
        }
        catch (UnsupportedEncodingException ex) {
            LogIt.log(Level.WARNING, "Could not append using specified charset encoding: " + this.charset + ". Using default.", this.t);
            this.getPrintRaw().append(s);
        }
    }

    public void replace(String tag, String value) {
        this.replaceAll(tag, value);
    }

    public void replaceAll(String tag, String value) {
        this.getPrintRaw().set(this.printRaw.get().replaceAll(tag, value));
    }

    public void replaceFirst(String tag, String value) {
        this.getPrintRaw().set(this.printRaw.get().replaceFirst(tag, value));
    }

    public void set(String s) {
        this.getPrintRaw().set(s);
    }

    public void clear() {
        this.getPrintRaw().clear();
    }

    public void print() {
        this.startPrinting = true;
        this.donePrinting = false;
        this.reprint = false;
    }

    public void printHTML() {
        this.htmlPrint = true;
        this.print();
    }

    public void printPS() {
        this.psPrint = true;
        this.print();
    }

    public void init() {
        if (thisThread.get() != null && thisThread.get().isAlive()) {
            LogIt.log(Level.WARNING, "init() called, but applet already seems to be running.  Ignoring.");
            return;
        }
        this.processParameters();
        thisThread.set(new Thread(this));
        super.init();
    }

    public void paint(Graphics g) {
    }

    public void start() {
        try {
            thisThread.get().start();
        }
        catch (Exception e) {
            this.set(e);
        }
        super.start();
    }

    public void stop() {
        this.running = false;
        thisThread.set(null);
        super.stop();
    }

    public void destroy() {
        this.stop();
        super.destroy();
    }

    public void findPrinter() {
        this.findPrinter(null);
    }

    public void findPrinter(String printer) {
        this.startFinding = true;
        this.doneFinding = false;
        this.printer = printer;
    }

    public boolean isDoneFinding() {
        return this.doneFinding;
    }

    public boolean isDonePrinting() {
        return this.donePrinting;
    }

    public boolean isDoneAppending() {
        return this.doneAppending;
    }

    public String getPrinter() {
        return this.ps == null ? null : this.ps.getName();
    }

    private PrintRaw getPrintRaw() {
        if (this.printRaw == null) {
            this.printRaw = new PrintRaw();
            this.printRaw.setPrintParameters(this);
        }
        return this.printRaw;
    }

    public PrintService getPrintService() {
        return this.ps;
    }

    @Deprecated
    public String getPrinterName() {
        LogIt.log(Level.WARNING, "Function \"getPrinterName()\" has been deprecated since v. 1.2.3.  Please use \"getPrinter()\" instead.");
        return this.getPrinter();
    }

    public Throwable getError() {
        return this.getException();
    }

    public Throwable getException() {
        return this.t;
    }

    public void clearException() {
        this.t = null;
    }

    public String getExceptionMessage() {
        return this.t.getLocalizedMessage();
    }

    public long getSleepTime() {
        return this.sleep;
    }

    public String getVersion() {
        return VERSION;
    }

    public void setSleepTime(long sleep) {
        this.sleep = sleep;
    }

    public String getEndOfDocument() {
        return this.endOfDocument;
    }

    public void setEndOfDocument(String endOfPage) {
        this.endOfDocument = endOfPage;
    }

    public void setPrinter(int index) {
        this.setPrintService(PrintServiceMatcher.getPrinterList()[index]);
        LogIt.log("Printer set to index: " + index + ",  Name: " + this.ps.getName());
    }

    private void setPrintService(PrintService ps) {
        if (ps == null) {
            LogIt.log(Level.WARNING, "Warning:  Ignoring null PrintService");
            return;
        }
        this.ps = ps;
        if (this.printHTML != null) {
            this.printHTML.setPrintService(ps);
        }
        if (this.printPS != null) {
            this.printPS.setPrintService(ps);
        }
        if (this.printRaw != null) {
            this.printRaw.setPrintService(ps);
        }
    }

    public int getDocumentsPerSpool() {
        return this.documentsPerSpool;
    }

    public void setDocumentsPerSpool(int pagesPer) {
        this.documentsPerSpool = pagesPer;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    private void set(Throwable t) {
        this.t = t;
        LogIt.log(t);
    }

    private void logStart() {
        LogIt.log("jZebra 1.4.3");
        LogIt.log("===== JAVASCRIPT LISTENER THREAD STARTED =====");
    }

    private void logStop() {
        LogIt.log("===== JAVASCRIPT LISTENER THREAD STOPPED =====");
    }

    private void logPrint() {
        LogIt.log("===== SENDING DATA TO THE PRINTER =====");
    }

    private void logFindPrinter() {
        LogIt.log("===== SEARCHING FOR PRINTER =====");
    }

    private void logCommands(PrintHTML ph) {
        this.logCommands(ph.get());
    }

    private void logCommands(PrintRaw pr) {
        this.logCommands(pr.get());
    }

    private void logCommands(String commands) {
        LogIt.log("\r\n\r\n" + commands + "\r\n\r\n");
    }

    private void logAndPrint(PrintRaw pr) throws PrintException, InterruptedException, UnsupportedEncodingException {
        this.logCommands(pr);
        if (this.reprint) {
            pr.print();
        } else {
            pr.print();
            pr.clear();
        }
    }

    private void logAndPrint(PrintPostScript printPS) throws PrinterException {
        this.logCommands("    <<" + this.file + ">>");
        printPS.print();
        this.psPrint = false;
    }

    private void logAndPrint(PrintHTML printHTML) throws PrinterException {
        if (this.file != null) {
            this.logCommands("    <<" + this.file + ">>");
        }
        this.logCommands(printHTML);
        printHTML.print();
        this.htmlPrint = false;
    }

    private void logAndPrint(String commands) throws PrintException, InterruptedException, UnsupportedEncodingException {
        this.logCommands(commands);
        this.getPrintRaw().print(commands);
    }

    public void setEncoding(String charset) {
        System.out.println("Default charset encoding: " + Charset.defaultCharset().name());
        try {
            this.charset = Charset.forName(charset);
            this.getPrintRaw().setCharset(Charset.forName(charset));
            LogIt.log("Current applet charset encoding: " + this.charset.name());
        }
        catch (IllegalCharsetNameException e) {
            LogIt.log(Level.WARNING, "Could not find specified charset encoding: " + charset + ". Using default.", e);
        }
    }

    public String getEncoding() {
        return this.charset.displayName();
    }

    public Charset getCharset() {
        return this.charset;
    }
}

