/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import jzebra.LogIt;

public class PrintServiceMatcher {
    private static PrintService[] printers = null;
    private static String printerListing = "";

    public static PrintService findPrinter(Object o) {
        String printerName;
        PrintService exact = null;
        PrintService begins = null;
        PrintService partial = null;
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            printerName = "\\Q" + (String)o + "\\E";
        } else {
            if (o instanceof PrintService) {
                return (PrintService)o;
            }
            printerName = "\\Q" + o.toString() + "\\E";
        }
        PrintServiceMatcher.getPrinterList();
        LogIt.log(Level.INFO, "Found " + printers.length + " attached printers.");
        LogIt.log(Level.INFO, "Printer specified: " + printerName);
        for (PrintService ps : printers) {
            String sysPrinter = ps.getAttribute(PrinterName.class).getValue();
            Pattern p1 = Pattern.compile("\\b" + printerName + "\\b", 2);
            Pattern p2 = Pattern.compile("\\b" + printerName, 2);
            Pattern p3 = Pattern.compile(printerName, 2);
            Matcher m1 = p1.matcher(sysPrinter);
            Matcher m2 = p2.matcher(sysPrinter);
            Matcher m3 = p3.matcher(sysPrinter);
            if (m1.find()) {
                exact = ps;
                LogIt.log("Printer name match: " + sysPrinter);
                continue;
            }
            if (m2.find()) {
                begins = ps;
                LogIt.log("Printer name beginning match: " + sysPrinter);
                continue;
            }
            if (!m3.find()) continue;
            partial = ps;
            LogIt.log("Printer name partial match: " + sysPrinter);
        }
        if (exact != null) {
            LogIt.log("Using best match: " + exact.getName());
            return exact;
        }
        if (begins != null) {
            LogIt.log("Using best match: " + begins.getName());
            return begins;
        }
        if (partial != null) {
            LogIt.log("Using best match: " + partial.getName());
            return partial;
        }
        LogIt.log(Level.WARNING, "Printer not found: " + printerName);
        return null;
    }

    public static PrintService[] getPrinterList() {
        return PrintServiceMatcher.getPrinterArray(false);
    }

    public static PrintService[] getPrinterArray(boolean forceSearch) {
        if (forceSearch || printers == null || printers.length == 0) {
            printerListing = "";
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < services.length; ++i) {
                PrintServiceAttributeSet psa = services[i].getAttributes();
                printerListing = printerListing + psa.get(PrinterName.class);
                if (i == services.length - 1) continue;
                printerListing = printerListing + ",";
            }
            printers = services;
        }
        return printers;
    }

    public static String getPrinterListing() {
        return printerListing;
    }
}

