/*
 * Decompiled with CFR 0.152.
 */
package javastat.eda;

import java.util.Arrays;

public class QuantitativeDataAnalysis {
    public double[] fiveNumberSummary;
    public double[][] frequencyTable;
    public int nClass;
    public double[] data;
    public double classWidth;
    private int counts;
    private int startIndex;
    private double[] copy;

    public QuantitativeDataAnalysis() {
    }

    public QuantitativeDataAnalysis(int nClass, double[] data) {
        this.nClass = nClass;
        this.data = data;
        this.fiveNumberSummary = this.fiveNumberSummary(data);
        this.frequencyTable = this.frequencyTable(nClass, data);
    }

    public QuantitativeDataAnalysis(double[] data) {
        this(4, data);
    }

    public double[] fiveNumberSummary(double[] data) {
        this.data = data;
        this.fiveNumberSummary = new double[5];
        this.copy = (double[])data.clone();
        Arrays.sort(this.copy);
        this.fiveNumberSummary[0] = this.copy[0];
        this.fiveNumberSummary[4] = this.copy[this.copy.length - 1];
        this.fiveNumberSummary[1] = data.length == data.length / 4 * 4 ? (this.copy[data.length / 4] + this.copy[data.length / 4 - 1]) / 2.0 : this.copy[data.length / 4];
        this.fiveNumberSummary[2] = data.length % 2 == 0 ? (this.copy[data.length / 2] + this.copy[data.length / 2 - 1]) / 2.0 : this.copy[data.length / 2];
        this.fiveNumberSummary[3] = data.length == data.length * 3 / 4 * 4 / 3 ? (this.copy[data.length * 3 / 4] + this.copy[data.length * 3 / 4 - 1]) / 2.0 : this.copy[data.length * 3 / 4];
        return this.fiveNumberSummary;
    }

    public double[][] frequencyTable(int nClass, double[] data) {
        if (nClass <= 0) {
            throw new IllegalArgumentException("The number of classes should be greater thant 0.");
        }
        this.nClass = nClass;
        this.data = data;
        this.copy = (double[])data.clone();
        this.frequencyTable = new double[2][nClass];
        this.startIndex = 0;
        Arrays.sort(this.copy);
        this.classWidth = Math.ceil((Math.ceil(this.copy[this.copy.length - 1]) - Math.floor(this.copy[0])) / (double)nClass);
        int i = 0;
        while (i < nClass) {
            this.frequencyTable[0][i] = Math.floor(this.copy[0]) + this.classWidth * (double)(i + 1);
            this.counts = 0;
            while (this.startIndex < this.copy.length && this.copy[this.startIndex] <= this.frequencyTable[0][i]) {
                ++this.startIndex;
                ++this.counts;
            }
            this.frequencyTable[1][i] = this.counts;
            ++i;
        }
        return this.frequencyTable;
    }
}

