/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference;

import JSci.maths.statistics.ChiSqrDistribution;
import javastat.inference.MultiSampsInterface;
import javastat.util.BasicStatistics;
import javastat.util.DataManager;

public class ChisqTest
implements MultiSampsInterface {
    public double testStatistic;
    public double degreeFreedom;
    public double pValue;
    public double[][] table;
    private double sampleSize;
    private double ei;
    private double[] rowMean;
    private double[] columnMean;
    private BasicStatistics basicStatistics;

    public ChisqTest() {
    }

    public ChisqTest(double[][] table) {
        this.table = table;
        this.degreeFreedom = this.degreeFreedom(table);
        this.testStatistic = this.testStatistic(table);
        this.pValue = this.pValue(table);
    }

    public double degreeFreedom(double[][] table) {
        this.table = table;
        this.degreeFreedom = (table.length - 1) * (table[0].length - 1);
        return this.degreeFreedom;
    }

    public double testStatistic(double[][] table) {
        this.table = table;
        new DataManager().checkPositiveRangeDimension(table);
        this.testStatistic = 0.0;
        this.basicStatistics = new BasicStatistics();
        this.rowMean = this.basicStatistics.meanVector(table);
        this.columnMean = this.basicStatistics.columnMeanVector(table);
        this.sampleSize = this.basicStatistics.sum(table);
        int i = 0;
        while (i < table[0].length) {
            int k = 0;
            while (k < table.length) {
                this.ei = (double)(table.length * table[0].length) * this.rowMean[k] * this.columnMean[i] / this.sampleSize;
                this.testStatistic += Math.pow(table[k][i] - this.ei, 2.0) / this.ei;
                ++k;
            }
            ++i;
        }
        return this.testStatistic;
    }

    public double pValue(double[][] table) {
        this.table = table;
        this.testStatistic = this.testStatistic(table);
        this.pValue = 1.0 - new ChiSqrDistribution((double)((table.length - 1) * (table[0].length - 1))).cumulative(this.testStatistic);
        return this.pValue;
    }
}

