/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference;

import JSci.maths.statistics.FDistribution;
import javastat.inference.MultiSampsInterface;
import javastat.util.BasicStatistics;
import javastat.util.DataManager;

public class OneWayANOVA
implements MultiSampsInterface {
    public double testStatistic;
    public double pValue;
    public double ssWithin;
    public double ssBetween;
    public double[] degreeFreedom;
    public double[][] data;
    private double sampleSize;
    private double[] meanVector;
    private double variance;
    private double dataSum;
    private BasicStatistics basicStatistics;

    public OneWayANOVA() {
    }

    public OneWayANOVA(double[][] data) {
        this.data = data;
        this.degreeFreedom = this.degreeFreedom(data);
        this.testStatistic = this.testStatistic(data);
        this.pValue = this.pValue(data);
    }

    public double[] degreeFreedom(double[][] data) {
        this.data = data;
        this.degreeFreedom = new double[2];
        this.sampleSize = new DataManager().sampleSize(data);
        this.degreeFreedom[0] = (double)data.length - 1.0;
        this.degreeFreedom[1] = this.sampleSize - (double)data.length;
        return this.degreeFreedom;
    }

    public double testStatistic(double[][] data) {
        this.data = data;
        this.basicStatistics = new BasicStatistics();
        this.meanVector = this.basicStatistics.meanVector(data);
        this.sampleSize = new DataManager().sampleSize(data);
        this.dataSum = 0.0;
        this.ssWithin = 0.0;
        this.ssBetween = 0.0;
        int j = 0;
        while (j < data.length) {
            this.ssBetween += (double)data[j].length * Math.pow(this.meanVector[j], 2.0);
            this.variance = this.basicStatistics.variance(data[j]);
            this.ssWithin += (double)(data[j].length - 1) * this.variance;
            this.dataSum += this.meanVector[j] * (double)data[j].length;
            ++j;
        }
        this.ssBetween -= Math.pow(this.dataSum, 2.0) / this.sampleSize;
        this.testStatistic = this.ssBetween * (this.sampleSize - (double)data.length) / (this.ssWithin * ((double)data.length - 1.0));
        return this.testStatistic;
    }

    public double pValue(double[][] data) {
        this.testStatistic = this.testStatistic(data);
        this.sampleSize = new DataManager().sampleSize(data);
        this.pValue = 1.0 - new FDistribution((double)data.length - 1.0, this.sampleSize - (double)data.length).cumulative(this.testStatistic);
        return this.pValue;
    }
}

