/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference.nonparametric;

import JSci.maths.statistics.NormalDistribution;
import javastat.inference.TwoSampMediansInterface;
import javastat.util.BasicStatistics;
import javastat.util.DataManager;

public class RankSumTest
implements TwoSampMediansInterface {
    public double alpha;
    public double testStatistic;
    public double wAlpha;
    public double pValue;
    public String side;
    public double[] data1;
    public double[] data2;
    private double[] data;
    private double rank;
    private double zStatistic;
    private double tieNumber;
    private double rankSumMean;
    private double rankSumVariance;
    private int tableIndex1;
    private boolean tableIndex2;
    private int data2Index;
    private int tableIndex3;
    private BasicStatistics basicStatistics;
    private NormalDistribution normalDistribution;

    public RankSumTest() {
    }

    public RankSumTest(double alpha, String side, double[] data1, double[] data2) {
        this.alpha = alpha;
        this.side = side;
        this.data1 = data1;
        this.data2 = data2;
        this.testStatistic = this.testStatistic(data1, data2);
        this.wAlpha = this.wAlpha(alpha, data1, data2);
        this.pValue = this.pValue(side, data1, data2);
    }

    public RankSumTest(String side, double[] data1, double[] data2) {
        this(0.05, side, data1, data2);
    }

    public RankSumTest(double[] data1, double[] data2) {
        this(0.05, "equal", data1, data2);
    }

    public double testStatistic(double[] data1, double[] data2) {
        if (data1.length > data2.length) {
            return this.testStatistic(data2, data1);
        }
        this.testStatistic = 0.0;
        this.data = new DataManager().dataMerge(data1, data2);
        if (this.data.length < 3) {
            throw new IllegalArgumentException("The length of the input data should be larger than 2.");
        }
        int i = 0;
        while (i < data1.length) {
            this.tieNumber = 1.0;
            this.rank = 1.0;
            int k = 0;
            while (k < this.data.length) {
                if (k != i) {
                    if (this.data[i] == this.data[k]) {
                        this.tieNumber += 1.0;
                    }
                    if (this.data[i] > this.data[k]) {
                        this.rank += 1.0;
                    }
                }
                ++k;
            }
            if (this.tieNumber > 1.0) {
                this.rank += this.tieNumber * (this.tieNumber - 1.0) / (2.0 * this.tieNumber);
            }
            this.testStatistic += this.rank;
            ++i;
        }
        return this.testStatistic;
    }

    /*
     * Unable to fully structure code
     */
    public double wAlpha(double alpha, double[] data1, double[] data2) {
        block3: {
            if (data1.length > data2.length) {
                return this.wAlpha(alpha, data2, data1);
            }
            this.alpha = alpha;
            this.data1 = data1;
            this.data2 = data2;
            this.tableIndex1 = 0;
            this.data2Index = data2.length - data1.length;
            if (data1.length <= 2) {
                this.data2Index = data2.length - 3;
            }
            if ((data1.length > 4 || data2.length > 20) && (data1.length > 10 || data2.length > 10)) break block3;
            if (!(alpha > BasicStatistics.rankSumTable[data1.length - 1][this.data2Index][0])) ** GOTO lbl14
            throw new IllegalArgumentException("The input level of significance should be less than " + BasicStatistics.rankSumTable[data1.length][this.data2Index][0]);
lbl-1000:
            // 1 sources

            {
                ++this.tableIndex1;
lbl14:
                // 2 sources

                ** while (alpha <= BasicStatistics.rankSumTable[data1.length - 1][this.data2Index][this.tableIndex1])
            }
lbl15:
            // 1 sources

            return this.tableIndex1 + BasicStatistics.rankSumIndex[data1.length - 1][this.data2Index] - 1;
        }
        return NaN;
    }

    public double pValue(String side, double[] data1, double[] data2) {
        if (data1.length > data2.length) {
            return this.pValue(side, data2, data1);
        }
        this.side = side;
        this.data1 = data1;
        this.data2 = data2;
        this.testStatistic = this.testStatistic(data1, data2);
        this.tableIndex2 = false;
        this.data2Index = data2.length - data1.length;
        if (data1.length <= 2) {
            this.data2Index = data2.length - 3;
        }
        if (data1.length <= 4 && data2.length <= 20 || data1.length <= 10 && data2.length <= 10) {
            this.tableIndex2 = true;
        }
        if (data1.length <= 10 && this.data2Index >= 0 && this.tableIndex2) {
            this.tableIndex3 = (int)this.testStatistic - BasicStatistics.rankSumIndex[data1.length - 1][this.data2Index];
            if (side.equalsIgnoreCase("greater")) {
                if (this.tableIndex3 < 0) {
                    this.tableIndex3 = data1.length * (data1.length + data2.length + 1) - (int)this.testStatistic - BasicStatistics.rankSumIndex[data1.length - 1][this.data2Index];
                    this.pValue = 1.0 - BasicStatistics.rankSumTable[data1.length - 1][this.data2Index][this.tableIndex3];
                } else {
                    this.pValue = BasicStatistics.rankSumTable[data1.length - 1][this.data2Index][this.tableIndex3];
                }
            } else if (side.equalsIgnoreCase("less")) {
                if (this.tableIndex3 < 0) {
                    this.tableIndex3 = data1.length * (data1.length + data2.length + 1) - (int)this.testStatistic - BasicStatistics.rankSumIndex[data1.length - 1][this.data2Index];
                    this.pValue = BasicStatistics.rankSumTable[data1.length - 1][this.data2Index][this.tableIndex3];
                } else {
                    this.pValue = 1.0 - BasicStatistics.rankSumTable[data1.length - 1][this.data2Index][this.tableIndex3];
                }
            } else {
                this.tableIndex3 = Math.max((int)this.testStatistic, data1.length * (data1.length + data2.length + 1) - (int)this.testStatistic) - BasicStatistics.rankSumIndex[data1.length - 1][this.data2Index];
                this.pValue = 2.0 * BasicStatistics.rankSumTable[data1.length - 1][this.data2Index][this.tableIndex3];
            }
        } else {
            this.basicStatistics = new BasicStatistics();
            this.rankSumMean = this.basicStatistics.rankSumMean(data1, data2);
            this.rankSumVariance = this.basicStatistics.rankSumVariance(data1, data2);
            this.normalDistribution = new NormalDistribution();
            this.zStatistic = (this.testStatistic - this.rankSumMean) / Math.sqrt(this.rankSumVariance);
            this.pValue = side.equalsIgnoreCase("less") ? this.normalDistribution.cumulative(this.zStatistic) : (side.equalsIgnoreCase("greater") ? 1.0 - this.normalDistribution.cumulative(this.zStatistic) : 2.0 * (1.0 - this.normalDistribution.cumulative(Math.abs(this.zStatistic))));
        }
        return this.pValue;
    }
}

