/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference.nonparametric;

import JSci.maths.statistics.NormalDistribution;
import javastat.inference.OneSampMedianInterface;
import javastat.util.BasicStatistics;
import javastat.util.DataManager;

public class SignRankTest
implements OneSampMedianInterface {
    public double alpha;
    public double testStatistic;
    public double tAlpha;
    public double pValue;
    public double med;
    public String side;
    public double[] data;
    private int zeroNumber;
    private double rank;
    private double zStatistic;
    private double signRankMean;
    private double signRankVariance;
    private double[] tieNumber;
    private int tableIndex;
    private int lengthIndex;
    private DataManager dataManager;
    private BasicStatistics basicStatistics;
    private NormalDistribution normalDistribution;

    public SignRankTest() {
    }

    public SignRankTest(double alpha, double med, String side, double[] data) {
        this.alpha = alpha;
        this.med = med;
        this.side = side;
        this.data = data;
        this.testStatistic = this.testStatistic(med, data);
        this.tAlpha = this.tAlpha(alpha, med, data);
        this.pValue = this.pValue(med, side, data);
    }

    public SignRankTest(double med, String side, double[] data) {
        this(0.05, med, side, data);
    }

    public SignRankTest(double med, double[] data) {
        this(0.05, med, "equal", data);
    }

    public SignRankTest(double[] data) {
        this(0.05, 0.0, "equal", data);
    }

    public double testStatistic(double med, double[] data) {
        this.med = med;
        this.data = data;
        this.dataManager = new DataManager();
        this.zeroNumber = (int)this.dataManager.zeroNumber(med, data);
        if (data.length - this.zeroNumber < 3) {
            throw new IllegalArgumentException("The length of the input data should be larger than 2.");
        }
        this.testStatistic = 0.0;
        this.tieNumber = this.dataManager.tieNumber(med, data);
        int i = 0;
        while (i < data.length) {
            if (data[i] - med > 0.0) {
                this.rank = 1.0;
                int k = 0;
                while (k < data.length) {
                    if (k != i && Math.abs(data[i] - med) > Math.abs(data[k] - med)) {
                        this.rank += 1.0;
                    }
                    ++k;
                }
                this.rank -= (double)this.zeroNumber;
                this.rank += this.tieNumber[i] * (this.tieNumber[i] - 1.0) / (2.0 * this.tieNumber[i]);
                this.testStatistic += this.rank;
            }
            ++i;
        }
        return this.testStatistic;
    }

    /*
     * Unable to fully structure code
     */
    public double tAlpha(double alpha, double med, double[] data) {
        block2: {
            block1: {
                this.alpha = alpha;
                this.med = med;
                this.data = data;
                index = 0;
                this.zeroNumber = (int)new DataManager().zeroNumber(med, data);
                if (data.length - this.zeroNumber <= 30 && data.length - this.zeroNumber >= 3) break block1;
                this.tAlpha = NaN;
                break block2;
            }
            if (!(alpha > BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][0])) ** GOTO lbl13
            throw new IllegalArgumentException("The input level of significance should be less than " + BasicStatistics.signRankTable[data.length - 3][0]);
lbl-1000:
            // 1 sources

            {
                ++index;
lbl13:
                // 2 sources

                ** while (index < BasicStatistics.signRankTable[data.length - this.zeroNumber - 3].length && alpha <= BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][index])
            }
lbl14:
            // 1 sources

            this.tAlpha = index + BasicStatistics.signRankIndex[data.length - this.zeroNumber - 3] - 1;
        }
        return this.tAlpha;
    }

    public double pValue(double med, String side, double[] data) {
        this.med = med;
        this.side = side;
        this.data = data;
        this.zeroNumber = (int)new DataManager().zeroNumber(med, data);
        this.testStatistic = this.testStatistic(med, data);
        if (data.length - this.zeroNumber >= 30) {
            this.basicStatistics = new BasicStatistics();
            this.signRankMean = this.basicStatistics.signRankMean(med, data);
            this.signRankVariance = this.basicStatistics.signRankVariance(med, data);
            this.normalDistribution = new NormalDistribution();
            this.zStatistic = (this.testStatistic - this.signRankMean) / Math.sqrt(this.signRankVariance);
            this.pValue = side.equalsIgnoreCase("less") ? this.normalDistribution.cumulative(this.zStatistic) : (side.equalsIgnoreCase("greater") ? 1.0 - this.normalDistribution.cumulative(this.zStatistic) : 2.0 * (1.0 - this.normalDistribution.cumulative(Math.abs(this.zStatistic))));
        } else {
            this.tableIndex = (int)this.testStatistic - BasicStatistics.signRankIndex[data.length - this.zeroNumber - 3];
            if (side.equalsIgnoreCase("greater")) {
                if (this.tableIndex < 0) {
                    this.tableIndex = (int)((double)((data.length - this.zeroNumber) * (data.length + 1 - this.zeroNumber) / 2) - this.testStatistic) - BasicStatistics.signRankIndex[data.length - this.zeroNumber - 3];
                    if (this.tableIndex < 0) {
                        this.lengthIndex = BasicStatistics.signRankTable[data.length - this.zeroNumber - 3].length - 1;
                        this.pValue = BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][this.lengthIndex];
                    } else {
                        this.pValue = 1.0 - BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][this.tableIndex];
                    }
                } else {
                    this.pValue = BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][this.tableIndex];
                }
            } else if (side.equalsIgnoreCase("less")) {
                if (this.tableIndex < 0) {
                    this.tableIndex = (int)((double)((data.length - this.zeroNumber) * (data.length + 1 - this.zeroNumber) / 2) - this.testStatistic) - BasicStatistics.signRankIndex[data.length - this.zeroNumber - 3];
                    if (this.tableIndex < 0) {
                        this.lengthIndex = BasicStatistics.signRankTable[data.length - this.zeroNumber - 3].length - 1;
                        this.pValue = BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][this.lengthIndex];
                    } else {
                        this.pValue = BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][this.tableIndex];
                    }
                } else {
                    this.pValue = 1.0 - BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][this.tableIndex];
                }
            } else {
                this.tableIndex = (int)Math.max(this.testStatistic, (double)((data.length - this.zeroNumber) * (data.length + 1 - this.zeroNumber) / 2) - this.testStatistic) - BasicStatistics.signRankIndex[data.length - this.zeroNumber - 3];
                if (this.tableIndex < 0) {
                    this.lengthIndex = BasicStatistics.signRankTable[data.length - this.zeroNumber - 3].length - 1;
                    this.pValue = 2.0 * BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][this.lengthIndex];
                } else {
                    this.pValue = 2.0 * BasicStatistics.signRankTable[data.length - this.zeroNumber - 3][this.tableIndex];
                }
            }
        }
        return this.pValue;
    }
}

