/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference.onesample;

import JSci.maths.statistics.NormalDistribution;
import javastat.inference.OneSampMeanInterface;
import javastat.util.BasicStatistics;

public class OneSampMeanZTest
implements OneSampMeanInterface {
    public double alpha;
    public double mean;
    public double meanSE;
    public double testStatistic;
    public double pValue;
    public double[] confidenceInterval = new double[2];
    public double u0;
    public String side;
    public double[] data;
    private BasicStatistics basicStatistics;
    private NormalDistribution normalDistribution;
    private double zAlpha;

    public OneSampMeanZTest() {
    }

    public OneSampMeanZTest(double alpha, double u0, String side, double[] data) {
        this.alpha = alpha;
        this.u0 = u0;
        this.side = side;
        this.data = data;
        this.confidenceInterval = this.confidenceInterval(alpha, data);
        this.testStatistic = this.testStatistic(u0, data);
        this.pValue = this.pValue(u0, side, data);
    }

    public OneSampMeanZTest(double u0, String side, double[] data) {
        this(0.05, u0, side, data);
    }

    public OneSampMeanZTest(double u0, double[] data) {
        this(0.05, u0, "equal", data);
    }

    public OneSampMeanZTest(double[] data) {
        this(0.05, 0.0, "equal", data);
    }

    public double[] confidenceInterval(double alpha, double[] data) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The level of significance should be (strictly) positive and not greater than 1.");
        }
        this.alpha = alpha;
        this.data = data;
        this.basicStatistics = new BasicStatistics();
        this.mean = this.basicStatistics.mean(data);
        this.meanSE = this.basicStatistics.meanSE(data);
        this.zAlpha = new NormalDistribution().inverse(1.0 - alpha / 2.0);
        this.confidenceInterval[0] = this.mean - this.zAlpha * this.meanSE;
        this.confidenceInterval[1] = this.mean + this.zAlpha * this.meanSE;
        return this.confidenceInterval;
    }

    public double testStatistic(double u0, double[] data) {
        this.u0 = u0;
        this.data = data;
        this.basicStatistics = new BasicStatistics();
        this.mean = this.basicStatistics.mean(data);
        this.meanSE = this.basicStatistics.meanSE(data);
        this.testStatistic = (this.mean - u0) / this.meanSE;
        return this.testStatistic;
    }

    public double pValue(double u0, String side, double[] data) {
        this.u0 = u0;
        this.side = side;
        this.data = data;
        this.testStatistic = this.testStatistic(u0, data);
        this.normalDistribution = new NormalDistribution();
        this.pValue = side.equalsIgnoreCase("greater") ? 1.0 - this.normalDistribution.cumulative(this.testStatistic) : (side.equalsIgnoreCase("less") ? this.normalDistribution.cumulative(this.testStatistic) : 2.0 * (1.0 - this.normalDistribution.cumulative(Math.abs(this.testStatistic))));
        return this.pValue;
    }
}

