/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference.onesample;

import JSci.maths.statistics.NormalDistribution;
import javastat.inference.OneSampPropInterface;
import javastat.util.BasicStatistics;

public class OneSampProp
implements OneSampPropInterface {
    public double alpha;
    public double proportion;
    public double proportionSE;
    public double proportionSEH0;
    public double testStatistic;
    public double pValue;
    public double[] confidenceInterval = new double[2];
    public double p0;
    public String side;
    public double count;
    public double sampleSize;
    private BasicStatistics basicStatistics;
    private NormalDistribution normalDistribution;
    private double zAlpha;

    public OneSampProp() {
    }

    public OneSampProp(double alpha, double p0, String side, double count, double sampleSize) {
        this.alpha = alpha;
        this.p0 = p0;
        this.side = side;
        this.count = count;
        this.sampleSize = sampleSize;
        this.confidenceInterval = this.confidenceInterval(alpha, count, sampleSize);
        this.testStatistic = this.testStatistic(p0, count, sampleSize);
        this.pValue = this.pValue(p0, side, count, sampleSize);
    }

    public OneSampProp(double p0, String side, double count, double sampleSize) {
        this(0.05, p0, side, count, sampleSize);
    }

    public OneSampProp(double p0, double count, double sampleSize) {
        this(0.05, p0, "equal", count, sampleSize);
    }

    public OneSampProp(double count, double sampleSize) {
        this(0.05, 0.5, "equal", count, sampleSize);
    }

    public double[] confidenceInterval(double alpha, double count, double sampleSize) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The level of significance should be (strictly) positive and not greater than 1.");
        }
        this.alpha = alpha;
        this.count = count;
        this.sampleSize = sampleSize;
        this.basicStatistics = new BasicStatistics();
        this.proportion = this.basicStatistics.proportion(count, sampleSize);
        this.proportionSE = this.basicStatistics.proportionSE(count, sampleSize);
        this.zAlpha = new NormalDistribution().inverse(1.0 - alpha / 2.0);
        this.confidenceInterval[0] = this.proportion - this.zAlpha * this.proportionSE;
        this.confidenceInterval[1] = this.proportion + this.zAlpha * this.proportionSE;
        return this.confidenceInterval;
    }

    public double testStatistic(double p0, double count, double sampleSize) {
        if (p0 <= 0.0) {
            throw new IllegalArgumentException("The proportion under test should be (strictly) positive.");
        }
        this.p0 = p0;
        this.count = count;
        this.sampleSize = sampleSize;
        this.proportion = new BasicStatistics().proportion(count, sampleSize);
        this.proportionSEH0 = Math.sqrt(p0 * (1.0 - p0) / sampleSize);
        this.testStatistic = (this.proportion - p0) / this.proportionSEH0;
        return this.testStatistic;
    }

    public double pValue(double p0, String side, double count, double sampleSize) {
        this.p0 = p0;
        this.side = side;
        this.count = count;
        this.sampleSize = sampleSize;
        this.testStatistic = this.testStatistic(p0, count, sampleSize);
        this.normalDistribution = new NormalDistribution();
        this.pValue = side.equalsIgnoreCase("greater") ? 1.0 - this.normalDistribution.cumulative(this.testStatistic) : (side.equalsIgnoreCase("less") ? this.normalDistribution.cumulative(this.testStatistic) : 2.0 * (1.0 - this.normalDistribution.cumulative(Math.abs(this.testStatistic))));
        return this.pValue;
    }
}

