/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference.twosamples;

import JSci.maths.statistics.TDistribution;
import javastat.inference.TwoSampMeansInterface;
import javastat.util.BasicStatistics;

public class TwoSampMeansTTest
implements TwoSampMeansInterface {
    public double alpha;
    public double meanDifference;
    public double meanDifferenceSE;
    public double testStatistic;
    public double degreeFreedom;
    public double pValue;
    public double[] confidenceInterval = new double[2];
    public double u12;
    public String side;
    public double[] data1;
    public double[] data2;
    private BasicStatistics basicStatistics;
    private TDistribution tDistribution;
    private double tAlpha;

    public TwoSampMeansTTest() {
    }

    public TwoSampMeansTTest(double alpha, double u12, String side, double[] data1, double[] data2) {
        this.alpha = alpha;
        this.u12 = u12;
        this.side = side;
        this.data1 = data1;
        this.data2 = data2;
        this.confidenceInterval = this.confidenceInterval(alpha, data1, data2);
        this.degreeFreedom = this.df(data1, data2);
        this.testStatistic = this.testStatistic(u12, data1, data2);
        this.pValue = this.pValue(u12, side, data1, data2);
    }

    public TwoSampMeansTTest(double u12, String side, double[] data1, double[] data2) {
        this(0.05, u12, side, data1, data2);
    }

    public TwoSampMeansTTest(double u12, double[] data1, double[] data2) {
        this(0.05, u12, "equal", data1, data2);
    }

    public TwoSampMeansTTest(double[] data1, double[] data2) {
        this(0.05, 0.0, "equal", data1, data2);
    }

    public double[] confidenceInterval(double alpha, double[] data1, double[] data2) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The level of significance should be (strictly) positive and not greater than 1.");
        }
        if (data1.length == 0 || data2.length == 0) {
            throw new IllegalArgumentException("The length of the input data should not be 0.");
        }
        this.alpha = alpha;
        this.data1 = data1;
        this.data2 = data2;
        this.basicStatistics = new BasicStatistics();
        this.meanDifference = this.basicStatistics.meanDifference(data1, data2);
        this.meanDifferenceSE = this.basicStatistics.meanDifferenceSE(data1, data2, "T Test");
        this.tAlpha = new TDistribution(data1.length + data2.length - 2).inverse(1.0 - alpha / 2.0);
        this.confidenceInterval[0] = this.meanDifference - this.tAlpha * this.meanDifferenceSE;
        this.confidenceInterval[1] = this.meanDifference + this.tAlpha * this.meanDifferenceSE;
        return this.confidenceInterval;
    }

    public double df(double[] data1, double[] data2) {
        if (data1.length == 0 || data2.length == 0) {
            throw new IllegalArgumentException("The length of the input data should not be 0.");
        }
        this.data1 = data1;
        this.data2 = data2;
        this.degreeFreedom = data1.length + data2.length - 2;
        return this.degreeFreedom;
    }

    public double testStatistic(double u12, double[] data1, double[] data2) {
        this.u12 = u12;
        this.data1 = data1;
        this.data2 = data2;
        this.basicStatistics = new BasicStatistics();
        this.meanDifference = this.basicStatistics.meanDifference(data1, data2);
        this.meanDifferenceSE = this.basicStatistics.meanDifferenceSE(data1, data2, "T Test");
        this.testStatistic = (this.meanDifference - u12) / this.meanDifferenceSE;
        return this.testStatistic;
    }

    public double pValue(double u12, String side, double[] data1, double[] data2) {
        this.u12 = u12;
        this.side = side;
        this.data1 = data1;
        this.data2 = data2;
        this.testStatistic = this.testStatistic(u12, data1, data2);
        this.degreeFreedom = this.df(data1, data2);
        this.tDistribution = new TDistribution(data1.length + data2.length - 2);
        this.pValue = side.equalsIgnoreCase("less") ? this.tDistribution.cumulative(this.testStatistic) : (side.equalsIgnoreCase("greater") ? 1.0 - this.tDistribution.cumulative(this.testStatistic) : 2.0 * (1.0 - this.tDistribution.cumulative(Math.abs(this.testStatistic))));
        return this.pValue;
    }
}

