/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference.twosamples;

import JSci.maths.statistics.NormalDistribution;
import javastat.inference.TwoSampMeansInterface;
import javastat.util.BasicStatistics;

public class TwoSampMeansZTest
implements TwoSampMeansInterface {
    public double alpha;
    public double meanDifference;
    public double meanDifferenceSE;
    public double testStatistic;
    public double pValue;
    public double[] confidenceInterval = new double[2];
    public double u12;
    public String side;
    public double[] data1;
    public double[] data2;
    private BasicStatistics basicStatistics;
    private NormalDistribution normalDistribution;
    private double zAlpha;

    public TwoSampMeansZTest() {
    }

    public TwoSampMeansZTest(double alpha, double u12, String side, double[] data1, double[] data2) {
        this.alpha = alpha;
        this.u12 = u12;
        this.side = side;
        this.data1 = data1;
        this.data2 = data2;
        this.confidenceInterval = this.confidenceInterval(alpha, data1, data2);
        this.testStatistic = this.testStatistic(u12, data1, data2);
        this.pValue = this.pValue(u12, side, data1, data2);
    }

    public TwoSampMeansZTest(double u12, String side, double[] data1, double[] data2) {
        this(0.05, u12, side, data1, data2);
    }

    public TwoSampMeansZTest(double u12, double[] data1, double[] data2) {
        this(0.05, u12, "equal", data1, data2);
    }

    public TwoSampMeansZTest(double[] data1, double[] data2) {
        this(0.05, 0.0, "equal", data1, data2);
    }

    public double[] confidenceInterval(double alpha, double[] data1, double[] data2) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The level of significance should be (strictly) positive and not greater than 1.");
        }
        this.alpha = alpha;
        this.data1 = data1;
        this.data2 = data2;
        this.basicStatistics = new BasicStatistics();
        this.meanDifference = this.basicStatistics.meanDifference(data1, data2);
        this.meanDifferenceSE = this.basicStatistics.meanDifferenceSE(data1, data2, "Z Test");
        this.zAlpha = new NormalDistribution().inverse(1.0 - alpha / 2.0);
        this.confidenceInterval[0] = this.meanDifference - this.zAlpha * this.meanDifferenceSE;
        this.confidenceInterval[1] = this.meanDifference + this.zAlpha * this.meanDifferenceSE;
        return this.confidenceInterval;
    }

    public double testStatistic(double u12, double[] data1, double[] data2) {
        this.u12 = u12;
        this.data1 = data1;
        this.data2 = data2;
        this.basicStatistics = new BasicStatistics();
        this.meanDifference = this.basicStatistics.meanDifference(data1, data2);
        this.meanDifferenceSE = this.basicStatistics.meanDifferenceSE(data1, data2, "Z Test");
        this.testStatistic = (this.meanDifference - u12) / this.meanDifferenceSE;
        return this.testStatistic;
    }

    public double pValue(double u12, String side, double[] data1, double[] data2) {
        this.u12 = u12;
        this.side = side;
        this.data1 = data1;
        this.data2 = data2;
        this.testStatistic = this.testStatistic(u12, data1, data2);
        this.normalDistribution = new NormalDistribution();
        this.pValue = side.equalsIgnoreCase("less") ? this.normalDistribution.cumulative(this.testStatistic) : (side.equalsIgnoreCase("greater") ? 1.0 - this.normalDistribution.cumulative(this.testStatistic) : 2.0 * (1.0 - this.normalDistribution.cumulative(Math.abs(this.testStatistic))));
        return this.pValue;
    }
}

