/*
 * Decompiled with CFR 0.152.
 */
package javastat.inference.twosamples;

import JSci.maths.statistics.NormalDistribution;
import javastat.inference.TwoSampPropsInterface;
import javastat.util.BasicStatistics;

public class TwoSampProps
implements TwoSampPropsInterface {
    public double alpha;
    public double proportionH0;
    public double proportionDifference;
    public double proportionDifferenceSE;
    public double proportionDifferenceSEH0;
    public double testStatistic;
    public double pValue;
    public double[] confidenceInterval = new double[2];
    public double p12;
    public String side;
    public double count1;
    public double sampleSize1;
    public double count2;
    public double sampleSize2;
    private BasicStatistics basicStatistics;
    private NormalDistribution normalDistribution;
    private double zAlpha;

    public TwoSampProps() {
    }

    public TwoSampProps(double alpha, double p12, String side, double count1, double sampleSize1, double count2, double sampleSize2) {
        this.alpha = alpha;
        this.p12 = p12;
        this.side = side;
        this.count1 = count1;
        this.sampleSize1 = sampleSize1;
        this.count2 = count2;
        this.sampleSize2 = sampleSize2;
        this.confidenceInterval = this.confidenceInterval(alpha, count1, sampleSize1, count2, sampleSize2);
        this.testStatistic = this.testStatistic(p12, count1, sampleSize1, count2, sampleSize2);
        this.pValue = this.pValue(p12, side, count1, sampleSize1, count2, sampleSize2);
    }

    public TwoSampProps(double p12, String side, double count1, double sampleSize1, double count2, double sampleSize2) {
        this(0.05, p12, side, count1, sampleSize1, count2, sampleSize2);
    }

    public TwoSampProps(double p12, double count1, double sampleSize1, double count2, double sampleSize2) {
        this(0.05, p12, "equal", count1, sampleSize1, count2, sampleSize2);
    }

    public TwoSampProps(double count1, double sampleSize1, double count2, double sampleSize2) {
        this(0.05, 0.0, "equal", count1, sampleSize1, count2, sampleSize2);
    }

    public double[] confidenceInterval(double alpha, double count1, double sampleSize1, double count2, double sampleSize2) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The level of significance should be (strictly) positive and not greater than 1.");
        }
        this.alpha = alpha;
        this.count1 = count1;
        this.sampleSize1 = sampleSize1;
        this.count2 = count2;
        this.sampleSize2 = sampleSize2;
        this.basicStatistics = new BasicStatistics();
        this.proportionDifference = this.basicStatistics.proportionDifference(count1, sampleSize1, count2, sampleSize2);
        this.proportionDifferenceSE = this.basicStatistics.proportionDifferenceSE(count1, sampleSize1, count2, sampleSize2);
        this.zAlpha = new NormalDistribution().inverse(1.0 - alpha / 2.0);
        this.confidenceInterval[0] = this.proportionDifference - this.zAlpha * this.proportionDifferenceSE;
        this.confidenceInterval[1] = this.proportionDifference + this.zAlpha * this.proportionDifferenceSE;
        return this.confidenceInterval;
    }

    public double testStatistic(double p12, double count1, double sampleSize1, double count2, double sampleSize2) {
        if (p12 < -1.0 || p12 > 1.0) {
            throw new IllegalArgumentException("The absolute value of the difference under test should be not greater than 1.");
        }
        this.p12 = p12;
        this.count1 = count1;
        this.sampleSize1 = sampleSize1;
        this.count2 = count2;
        this.sampleSize2 = sampleSize2;
        this.basicStatistics = new BasicStatistics();
        this.proportionDifference = this.basicStatistics.proportionDifference(count1, sampleSize1, count2, sampleSize2);
        if (p12 == 0.0) {
            this.proportionH0 = (count1 + count2) / (sampleSize1 + sampleSize2);
            this.proportionDifferenceSEH0 = Math.sqrt(this.proportionH0 * (1.0 - this.proportionH0) * (1.0 / sampleSize1 + 1.0 / sampleSize2));
        } else {
            this.proportionDifferenceSEH0 = this.basicStatistics.proportionDifferenceSE(count1, sampleSize1, count2, sampleSize2);
        }
        this.testStatistic = (this.proportionDifference - p12) / this.proportionDifferenceSEH0;
        return this.testStatistic;
    }

    public double pValue(double p12, String side, double count1, double sampleSize1, double count2, double sampleSize2) {
        this.p12 = p12;
        this.side = side;
        this.count1 = count1;
        this.sampleSize1 = sampleSize1;
        this.count2 = count2;
        this.sampleSize2 = sampleSize2;
        this.testStatistic = this.testStatistic(p12, count1, sampleSize1, count2, sampleSize2);
        this.normalDistribution = new NormalDistribution();
        this.pValue = side.equalsIgnoreCase("less") ? this.normalDistribution.cumulative(this.testStatistic) : (side.equalsIgnoreCase("greater") ? 1.0 - this.normalDistribution.cumulative(this.testStatistic) : 2.0 * (1.0 - this.normalDistribution.cumulative(Math.abs(this.testStatistic))));
        return this.pValue;
    }
}

