/*
 * Decompiled with CFR 0.152.
 */
package javastat.multivariate;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import javastat.util.BasicStatistics;
import javastat.util.DataManager;

public class DiscriminantAnalysis {
    public int[] predictedGroup;
    public double[][] linearDiscriminants;
    public double[] group;
    public double[][] covariate;
    public double[][] newCovariate;
    public boolean predictionInd;
    private int predictedGroupIndex;
    private int covariateIndex;
    private int eigenValueInd;
    private int[] groupIndex;
    private double minimumDistance;
    private double[] overallMean;
    private double[] eigenValues;
    private double[] spoolInverseEigenValues;
    double[][] covariateBuffer;
    private double[][] meanVector;
    private double[][] InverseOrderDiscriminants;
    private double[][] eigenVectors;
    private double[][] spoolInverseSQREigenValues;
    private Matrix meanMatrix1;
    private Matrix meanMatrix2;
    private Matrix meanDifferenceMatrix;
    private Matrix SSBMatrix;
    private Matrix overallMeanMatrix;
    private Matrix spoolMatrix;
    private Matrix spoolInverseMatrix;
    private Matrix discriminantMatrix;
    private Matrix predictionMatrix;
    private Matrix predictionSubMatrix;
    private Matrix meanPredictionMatrix;
    private Matrix spoolInverseEigenVectorMatrix;
    private Matrix spoolInverseSQRMatrix;
    private Matrix differenceMatrix;
    private Matrix differenceSquareMatrix;
    private EigenvalueDecomposition eigenDecomposition;
    private EigenvalueDecomposition spoolInverseEigenDecomposition;
    private BasicStatistics basicStatistics;
    private DataManager dataManager;

    public DiscriminantAnalysis() {
    }

    public DiscriminantAnalysis(double[] group, double[][] covariate, double[][] newCovariate) {
        this.group = group;
        this.covariate = covariate;
        this.newCovariate = newCovariate;
        this.predictionInd = true;
        this.linearDiscriminants = this.linearDiscriminants(group, covariate, newCovariate);
    }

    public DiscriminantAnalysis(double[] groups, double[][] covariate) {
        this.group = this.group;
        this.covariate = covariate;
        this.predictionInd = false;
        this.linearDiscriminants = this.linearDiscriminants(groups, covariate);
    }

    public double[][] linearDiscriminants(double[] groups, double[][] covariate) {
        this.group = this.group;
        this.covariate = covariate;
        this.predictionInd = false;
        this.linearDiscriminants = this.linearDiscriminants(groups, covariate, this.newCovariate);
        return this.linearDiscriminants;
    }

    public double[][] linearDiscriminants(double[] group, double[][] covariate, double[][] newCovariate) {
        this.group = group;
        this.covariate = covariate;
        this.basicStatistics = new BasicStatistics();
        this.dataManager = new DataManager();
        this.predictionInd = true;
        if (newCovariate == null) {
            this.predictionInd = false;
        } else {
            this.dataManager.checkDimension(newCovariate);
            this.predictedGroup = new int[newCovariate[0].length];
            this.newCovariate = newCovariate;
        }
        this.dataManager.dataSort(group, covariate);
        this.groupIndex = this.dataManager.groupIndex(group);
        this.covariateIndex = 0;
        this.overallMean = this.basicStatistics.meanVector(covariate);
        this.overallMeanMatrix = new Matrix(this.overallMean, this.overallMean.length);
        this.spoolMatrix = new Matrix(covariate.length, covariate.length, 0.0);
        this.SSBMatrix = new Matrix(covariate.length, covariate.length, 0.0);
        this.meanVector = new double[this.groupIndex.length][covariate.length];
        int j = 0;
        while (j < this.groupIndex.length) {
            this.covariateBuffer = new double[covariate.length][this.groupIndex[j]];
            int l = 0;
            while (l < this.groupIndex[j]) {
                int k = 0;
                while (k < covariate.length) {
                    this.covariateBuffer[k][l] = covariate[k][this.covariateIndex + l];
                    ++k;
                }
                ++l;
            }
            this.covariateIndex += this.groupIndex[j];
            this.meanVector[j] = this.basicStatistics.meanVector(this.covariateBuffer);
            this.meanDifferenceMatrix = new Matrix(this.meanVector[j], this.meanVector[j].length).minus(this.overallMeanMatrix);
            this.SSBMatrix.plusEquals(this.meanDifferenceMatrix.times(this.meanDifferenceMatrix.transpose()).timesEquals((double)this.groupIndex[j]));
            this.spoolMatrix.plusEquals(new Matrix(this.basicStatistics.covarianceMatrix(this.covariateBuffer)).timesEquals((double)(this.groupIndex[j] - 1)));
            ++j;
        }
        this.spoolInverseMatrix = this.spoolMatrix.inverse();
        if (this.groupIndex.length == 2) {
            this.meanMatrix1 = new Matrix(this.meanVector[0], this.meanVector[0].length);
            this.meanMatrix2 = new Matrix(this.meanVector[1], this.meanVector[1].length);
            this.discriminantMatrix = this.spoolInverseMatrix.times(this.meanMatrix1.minus(this.meanMatrix2));
            this.discriminantMatrix.timesEquals((double)(group.length - this.groupIndex.length));
            if (this.predictionInd) {
                this.predictionMatrix = this.discriminantMatrix.transpose().times(new Matrix(newCovariate));
                this.meanPredictionMatrix = this.discriminantMatrix.transpose().times(this.meanMatrix1.plusEquals(this.meanMatrix2).timesEquals(0.5));
                int l = 0;
                while (l < newCovariate[0].length) {
                    this.predictedGroup[l] = this.predictionMatrix.get(0, l) >= this.meanPredictionMatrix.get(0, 0) ? 1 : 2;
                    ++l;
                }
            }
        } else {
            this.eigenDecomposition = new EigenvalueDecomposition(this.spoolInverseMatrix.times(this.SSBMatrix));
            this.eigenValues = this.dataManager.abs(this.eigenDecomposition.getRealEigenvalues());
            this.eigenVectors = this.eigenDecomposition.getV().getArray();
            this.dataManager.dataSort(this.eigenValues, this.eigenVectors);
            this.eigenValueInd = 0;
            int i = 0;
            while (i < this.eigenValues.length) {
                if (this.eigenValues[i] < Math.pow(10.0, -7.0) || this.eigenValues[i] / this.basicStatistics.sum(this.eigenValues) < Math.pow(10.0, -3.0)) {
                    ++this.eigenValueInd;
                }
                ++i;
            }
            this.spoolInverseMatrix.timesEquals((double)(group.length - this.groupIndex.length));
            this.spoolInverseEigenDecomposition = new EigenvalueDecomposition(this.spoolInverseMatrix);
            this.spoolInverseEigenValues = this.spoolInverseEigenDecomposition.getRealEigenvalues();
            this.spoolInverseSQREigenValues = this.dataManager.zeroArray(this.spoolInverseEigenValues.length, this.spoolInverseEigenValues.length);
            i = 0;
            while (i < this.spoolInverseEigenValues.length) {
                this.spoolInverseSQREigenValues[i][i] = Math.sqrt(this.spoolInverseEigenValues[i]);
                ++i;
            }
            this.spoolInverseEigenVectorMatrix = this.spoolInverseEigenDecomposition.getV().transpose();
            this.spoolInverseSQRMatrix = this.spoolInverseEigenDecomposition.getV().times(new Matrix(this.spoolInverseSQREigenValues)).times(this.spoolInverseEigenVectorMatrix);
            this.discriminantMatrix = this.spoolInverseSQRMatrix.times(new Matrix(this.eigenVectors).getMatrix(0, this.eigenValues.length - 1, this.eigenValueInd, this.eigenValues.length - 1));
            if (this.predictionInd) {
                this.predictionMatrix = this.discriminantMatrix.transpose().times(new Matrix(newCovariate));
                this.meanPredictionMatrix = this.discriminantMatrix.transpose().times(new Matrix(this.meanVector).transpose());
                int s = 0;
                while (s < newCovariate[0].length) {
                    this.predictionSubMatrix = this.predictionMatrix.getMatrix(0, this.eigenValues.length - 1 - this.eigenValueInd, s, s);
                    this.differenceMatrix = this.predictionSubMatrix.minus(this.meanPredictionMatrix.getMatrix(0, this.eigenValues.length - 1 - this.eigenValueInd, 0, 0));
                    this.minimumDistance = this.differenceMatrix.transpose().times(this.differenceMatrix).get(0, 0);
                    this.predictedGroupIndex = 1;
                    int m = 1;
                    while (m < this.eigenValues.length - 1) {
                        this.differenceMatrix = this.predictionSubMatrix.minus(this.meanPredictionMatrix.getMatrix(0, this.eigenValues.length - 1 - this.eigenValueInd, m, m));
                        this.differenceSquareMatrix = this.differenceMatrix.transpose().times(this.differenceMatrix);
                        if (this.differenceSquareMatrix.get(0, 0) < this.minimumDistance) {
                            this.predictedGroupIndex = m + 1;
                            this.minimumDistance = this.differenceSquareMatrix.get(0, 0);
                        }
                        ++m;
                    }
                    this.predictedGroup[s] = this.predictedGroupIndex;
                    ++s;
                }
            }
        }
        this.InverseOrderDiscriminants = this.discriminantMatrix.transpose().getArray();
        this.linearDiscriminants = new double[this.InverseOrderDiscriminants.length][];
        int m = 0;
        while (m < this.InverseOrderDiscriminants.length) {
            this.linearDiscriminants[m] = this.InverseOrderDiscriminants[this.InverseOrderDiscriminants.length - 1 - m];
            ++m;
        }
        return this.linearDiscriminants;
    }

    public int[] predictedGroup(double[] groups, double[][] covariate, double[][] newCovariate) {
        this.group = this.group;
        this.covariate = covariate;
        this.newCovariate = newCovariate;
        this.predictionInd = true;
        this.linearDiscriminants(this.group, covariate, newCovariate);
        return this.predictedGroup;
    }
}

