/*
 * Decompiled with CFR 0.152.
 */
package javastat.multivariate;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import javastat.util.BasicStatistics;
import javastat.util.DataManager;

public class PCA {
    public double level;
    public double[][] principalComponents;
    public double[] variance;
    public String covChoice;
    public double[][] data;
    private double[][] covariance;
    private Matrix covarianceMatrix;
    private BasicStatistics basicStatistics;
    private DataManager dataManager;

    public PCA() {
        this(1.0);
    }

    public PCA(double level) {
        if (level <= 0.0 || level > 1.0) {
            throw new IllegalArgumentException("The selection criterion should be (strictly) positive and not greater than 1.");
        }
        this.level = level;
    }

    public PCA(double level, String covChoice, double[][] data) {
        if (level <= 0.0 || level > 1.0) {
            throw new IllegalArgumentException("The selection criterion should be (strictly) positive and not greater than 1.");
        }
        this.level = level;
        this.covChoice = covChoice;
        this.data = data;
        this.principalComponents = this.principalComponents(covChoice, data);
    }

    public PCA(String covChoice, double[][] data) {
        this(0.9, covChoice, data);
    }

    public PCA(double level, double[][] data) {
        this(level, "correlation", data);
    }

    public PCA(double[][] data) {
        this(0.9, "correlation", data);
    }

    public double[][] principalComponents(String covChoice, double[][] data) {
        this.covChoice = covChoice;
        this.data = data;
        this.dataManager = new DataManager();
        this.dataManager.checkDimension(data);
        this.basicStatistics = new BasicStatistics();
        this.covariance = covChoice.equalsIgnoreCase("covariance") ? this.basicStatistics.covarianceMatrix(data) : this.basicStatistics.correlationMatrix(data);
        this.covarianceMatrix = new Matrix(this.covariance);
        EigenvalueDecomposition eigenCovMatrix = new EigenvalueDecomposition(this.covarianceMatrix);
        double[] eigenvalueCovMatrix = eigenCovMatrix.getRealEigenvalues();
        double[][] eigenvectorCov = eigenCovMatrix.getV().getArray();
        this.dataManager.dataSort(eigenvalueCovMatrix, eigenvectorCov);
        int indices = this.basicStatistics.pcaNumber(eigenvalueCovMatrix, this.level);
        this.principalComponents = new double[data.length - indices][data.length];
        this.variance = new double[data.length - indices];
        int i = data.length - 1;
        while (i >= indices) {
            this.variance[data.length - 1 - i] = eigenvalueCovMatrix[i];
            int k = 0;
            while (k < data.length) {
                this.principalComponents[data.length - 1 - i][k] = eigenvectorCov[k][i];
                ++k;
            }
            --i;
        }
        return this.principalComponents;
    }

    public double[] variance(String covChoice, double[][] data) {
        this.covChoice = covChoice;
        this.data = data;
        this.principalComponents = this.principalComponents(covChoice, data);
        return this.variance;
    }
}

