/*
 * Decompiled with CFR 0.152.
 */
package javastat.regression.lm;

import JSci.maths.statistics.FDistribution;
import JSci.maths.statistics.NormalDistribution;
import JSci.maths.statistics.TDistribution;
import Jama.Matrix;
import javastat.regression.RegressionInterface;
import javastat.util.BasicStatistics;
import javastat.util.DataManager;

public class LinearRegression
implements RegressionInterface {
    public double alpha;
    public double[] coefficients;
    public double[][] variance;
    public double[] fittedValues;
    public double[] residuals;
    public double[] testStatistic;
    public double[][] confidenceInterval;
    public double[] pValue;
    public double SSR;
    public double SSE;
    public double SST;
    public double MSE;
    public double[] degreeFreedom;
    public double rSquare;
    public double testFStatistic;
    public double fPValue;
    public double[] response;
    public double[][] covariate;
    private double zAlpha;
    private double[][] covariateWithIntercept;
    private Matrix responseMatrix;
    private Matrix covariateMatrix;
    private Matrix coefficientMatrix;
    private Matrix fittedMatrix;
    private Matrix residualMatrix;
    private Matrix varianceMatrix;
    private Matrix SSTMatrix;
    private Matrix SSRMatrix;
    private Matrix SSEMatrix;
    private BasicStatistics basicStatistics;

    public LinearRegression() {
    }

    public LinearRegression(double alpha, double[] response, double[][] covariate) {
        this.alpha = alpha;
        this.response = response;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(response, covariate);
        this.confidenceInterval = this.confidenceInterval(alpha, response, covariate);
    }

    public LinearRegression(double[] response, double[][] covariate) {
        this(0.05, response, covariate);
    }

    public double[] coefficients(double[] response, double[][] covariate) {
        this.response = response;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(response, covariate);
        return this.coefficients;
    }

    public double[] testStatistic(double[] response, double[][] covariate) {
        this.response = response;
        this.covariate = covariate;
        new DataManager().checkDimension(covariate);
        this.testStatistic = new double[covariate.length + 1];
        this.pValue = new double[covariate.length + 1];
        this.degreeFreedom = new double[3];
        this.basicStatistics = new BasicStatistics();
        this.responseMatrix = new Matrix(response, response.length);
        this.covariateWithIntercept = new double[covariate.length + 1][response.length];
        int i = 0;
        while (i < response.length) {
            this.covariateWithIntercept[0][i] = 1.0;
            ++i;
        }
        int j = 1;
        while (j < covariate.length + 1) {
            this.covariateWithIntercept[j] = covariate[j - 1];
            ++j;
        }
        this.covariateMatrix = new Matrix(this.covariateWithIntercept);
        this.coefficientMatrix = this.covariateMatrix.times(this.covariateMatrix.transpose()).inverse().times(this.covariateMatrix.times(this.responseMatrix));
        this.fittedMatrix = this.covariateMatrix.transpose().times(this.coefficientMatrix);
        this.residualMatrix = this.responseMatrix.minus(this.fittedMatrix);
        this.SSRMatrix = this.coefficientMatrix.transpose().times(this.covariateMatrix.times(this.responseMatrix));
        this.SSTMatrix = this.responseMatrix.transpose().times(this.responseMatrix);
        this.SSEMatrix = this.SSTMatrix.minus(this.SSRMatrix);
        this.coefficients = this.coefficientMatrix.getColumnPackedCopy();
        this.fittedValues = this.fittedMatrix.getColumnPackedCopy();
        this.residuals = this.residualMatrix.getColumnPackedCopy();
        this.SSE = this.SSEMatrix.get(0, 0);
        this.SST = this.SSTMatrix.get(0, 0) - (double)response.length * Math.pow(this.basicStatistics.mean(response), 2.0);
        this.SSR = this.SSRMatrix.get(0, 0) - (double)response.length * Math.pow(this.basicStatistics.mean(response), 2.0);
        this.degreeFreedom[0] = covariate.length;
        this.degreeFreedom[1] = response.length - covariate.length - 1;
        this.degreeFreedom[2] = (double)response.length - 1.0;
        this.MSE = this.SSE / this.degreeFreedom[1];
        this.varianceMatrix = this.covariateMatrix.times(this.covariateMatrix.transpose()).inverse().times(this.MSE);
        this.variance = this.varianceMatrix.getArray();
        this.rSquare = this.SSR / this.SST;
        j = 0;
        while (j < covariate.length + 1) {
            this.testStatistic[j] = this.coefficients[j] / Math.sqrt(this.variance[j][j]);
            this.pValue[j] = 2.0 * (1.0 - new TDistribution(response.length - covariate.length - 1).cumulative(Math.abs(this.testStatistic[j])));
            ++j;
        }
        this.testFStatistic = this.SSR / (this.degreeFreedom[0] * this.MSE);
        this.fPValue = 1.0 - new FDistribution(this.degreeFreedom[0], this.degreeFreedom[1]).cumulative(this.testFStatistic);
        return this.testStatistic;
    }

    public double[][] confidenceInterval(double alpha, double[] response, double[][] covariate) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The level of significance should be (strictly) positive and not greater than 1.");
        }
        this.alpha = alpha;
        this.response = response;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(response, covariate);
        this.zAlpha = new NormalDistribution().inverse(1.0 - alpha / 2.0);
        this.confidenceInterval = new double[this.testStatistic.length][2];
        int i = 0;
        while (i < this.testStatistic.length) {
            this.confidenceInterval[i][0] = this.coefficients[i] - this.zAlpha * Math.sqrt(this.variance[i][i]);
            this.confidenceInterval[i][1] = this.coefficients[i] + this.zAlpha * Math.sqrt(this.variance[i][i]);
            ++i;
        }
        return this.confidenceInterval;
    }

    public double testFStatistic(double[] response, double[][] covariate) {
        this.response = response;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(response, covariate);
        return this.testFStatistic;
    }

    public double[] pValue(double[] response, double[][] covariate) {
        this.response = response;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(response, covariate);
        return this.pValue;
    }

    public double fPValue(double[] response, double[][] covariate) {
        this.response = response;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(response, covariate);
        return this.fPValue;
    }
}

