/*
 * Decompiled with CFR 0.152.
 */
package javastat.survival;

import JSci.maths.statistics.NormalDistribution;
import javastat.survival.SurvivalEstimateInterface;
import javastat.survival.regression.CoxRegression;
import javastat.util.DataManager;

public class KaplanMeierEstimate
implements SurvivalEstimateInterface {
    public double alpha;
    public double[] estimate;
    public double[] variance;
    public double[][] confidenceInterval;
    public double[] coefficients;
    public CoxRegression coxRegression;
    public double[] time;
    public double[] censor;
    public double[][] covariate;
    public boolean pHInd;
    private double zAlpha;
    private double riskFactor;
    private double[] riskFactorVector;
    private double[][] survivalIndex;

    public KaplanMeierEstimate() {
    }

    public KaplanMeierEstimate(double alpha, double[] time, double[] censor) {
        this.alpha = alpha;
        this.time = time;
        this.censor = censor;
        this.pHInd = false;
        this.estimate = this.estimate(time, censor);
        this.confidenceInterval = this.confidenceInterval(alpha, time, censor);
        this.coefficients = null;
    }

    public KaplanMeierEstimate(double[] time, double[] censor) {
        this(0.05, time, censor);
    }

    public KaplanMeierEstimate(double[] time, double[] censor, double[][] covariate) {
        this.time = time;
        this.censor = censor;
        this.covariate = covariate;
        this.pHInd = true;
        this.estimate = this.estimate(time, censor, covariate);
    }

    public double[] estimate(double[] time, double[] censor) {
        this.time = time;
        this.censor = censor;
        this.pHInd = false;
        this.survivalIndex = new DataManager().survivalIndex(time, censor);
        this.estimate = new double[time.length];
        this.variance = new double[time.length];
        int i = 0;
        while (i < time.length) {
            this.estimate[i] = 1.0;
            this.variance[i] = 0.0;
            int k = 0;
            while (k < time.length) {
                if (time[k] <= time[i]) {
                    int n = i;
                    this.estimate[n] = this.estimate[n] * (1.0 - this.survivalIndex[1][k] / this.survivalIndex[0][k]);
                    int n2 = i;
                    this.variance[n2] = this.variance[n2] + this.survivalIndex[1][k] / (this.survivalIndex[0][k] * (this.survivalIndex[0][k] - this.survivalIndex[1][k]));
                }
                ++k;
            }
            int n = i;
            this.variance[n] = this.variance[n] * Math.pow(this.estimate[i], 2.0);
            ++i;
        }
        return this.estimate;
    }

    public double[] estimate(double[] time, double[] censor, double[][] covariate) {
        int k;
        this.time = time;
        this.censor = censor;
        this.covariate = covariate;
        this.pHInd = true;
        this.coxRegression = new CoxRegression();
        this.coefficients = this.coxRegression.coefficients(time, censor, covariate);
        this.survivalIndex = new DataManager().survivalIndex(time, censor);
        this.riskFactorVector = new double[time.length];
        this.estimate = new double[time.length];
        int i = 0;
        while (i < time.length) {
            if ((int)censor[i] == 0) {
                this.riskFactorVector[i] = 1.0;
            } else {
                this.riskFactorVector[i] = 0.0;
                k = 0;
                while (k < time.length) {
                    if (time[k] >= time[i]) {
                        this.riskFactor = 1.0;
                        int l = 0;
                        while (l < this.coefficients.length) {
                            this.riskFactor *= Math.exp(this.coefficients[l] * covariate[l][k]);
                            ++l;
                        }
                        int n = i;
                        this.riskFactorVector[n] = this.riskFactorVector[n] + this.riskFactor;
                    }
                    ++k;
                }
            }
            ++i;
        }
        i = 0;
        while (i < time.length) {
            this.estimate[i] = 1.0;
            k = 0;
            while (k < time.length) {
                if (time[k] <= time[i]) {
                    int n = i;
                    this.estimate[n] = this.estimate[n] * (1.0 - this.survivalIndex[1][k] / this.riskFactorVector[k]);
                }
                ++k;
            }
            ++i;
        }
        return this.estimate;
    }

    public double[][] confidenceInterval(double alpha, double[] time, double[] censor) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The level of significance should be (strictly) positive and not greater than 1.");
        }
        this.alpha = alpha;
        this.time = time;
        this.censor = censor;
        this.pHInd = false;
        this.estimate = this.estimate(time, censor);
        this.zAlpha = new NormalDistribution().inverse(1.0 - alpha / 2.0);
        this.confidenceInterval = new double[time.length][2];
        int i = 0;
        while (i < time.length) {
            this.confidenceInterval[i][0] = this.estimate[i] - this.zAlpha * Math.sqrt(this.variance[i]);
            this.confidenceInterval[i][1] = this.estimate[i] + this.zAlpha * Math.sqrt(this.variance[i]);
            if (this.confidenceInterval[i][0] < 0.0) {
                this.confidenceInterval[i][0] = 0.0;
            }
            if (this.confidenceInterval[i][1] > 1.0) {
                this.confidenceInterval[i][1] = 1.0;
            }
            ++i;
        }
        return this.confidenceInterval;
    }

    public double[] variance(double[] time, double[] censor) {
        this.time = time;
        this.censor = censor;
        this.pHInd = false;
        this.estimate(time, censor);
        return this.variance;
    }
}

