/*
 * Decompiled with CFR 0.152.
 */
package javastat.survival.inference;

import JSci.maths.statistics.NormalDistribution;
import javastat.survival.SurvivalTwoSampTestsInterface;
import javastat.util.DataManager;

public class WilcoxonTest
implements SurvivalTwoSampTestsInterface {
    public double testStatistic;
    public double variance;
    public double pValue;
    public double[] time1;
    public double[] censor1;
    public double[] time2;
    public double[] censor2;
    private double ni;
    private double di;
    private double n1i;
    private double d1i;
    private double n2i;
    private double d2i;
    private double[][] survivalIndex1;
    private double[][] survivalIndex2;
    private DataManager dataManager;

    public WilcoxonTest() {
    }

    public WilcoxonTest(double[] time1, double[] censor1, double[] time2, double[] censor2) {
        this.time1 = time1;
        this.censor1 = censor1;
        this.time2 = time2;
        this.censor2 = censor2;
        this.testStatistic = this.testStatistic(time1, censor1, time2, censor2);
    }

    public double testStatistic(double[] time1, double[] censor1, double[] time2, double[] censor2) {
        this.time1 = time1;
        this.censor1 = censor1;
        this.time2 = time2;
        this.censor2 = censor2;
        this.dataManager = new DataManager();
        this.dataManager.checkPositiveRange(time1, "time1");
        this.dataManager.checkPositiveRange(time2, "time1");
        if (time1.length != censor1.length) {
            throw new IllegalArgumentException("The time vector and the censor vector in group 1 must have the same length.");
        }
        if (time2.length != censor2.length) {
            throw new IllegalArgumentException("The time vector and the censor vector in group 2 must have the same length.");
        }
        this.survivalIndex1 = this.dataManager.survivalIndex(time1, censor1);
        this.survivalIndex2 = this.dataManager.survivalIndex(time2, censor2);
        this.testStatistic = 0.0;
        this.variance = 0.0;
        int i = 0;
        while (i < time1.length + time2.length - 1) {
            int k;
            if (i >= time1.length) {
                if ((int)censor2[i - time1.length] == 1) {
                    this.n1i = 0.0;
                    this.d1i = 0.0;
                    k = 0;
                    while (k < time1.length) {
                        if (time1[k] > time2[i - time1.length]) {
                            this.n1i += 1.0;
                        }
                        if (time1[k] == time2[i - time1.length]) {
                            this.n1i += 1.0;
                            if ((int)censor1[k] == 1) {
                                this.d1i += 1.0;
                            }
                        }
                        ++k;
                    }
                    this.di = this.d1i + this.survivalIndex2[1][i - time1.length];
                    this.ni = this.n1i + this.survivalIndex2[0][i - time1.length];
                    this.testStatistic += this.ni * (this.d1i - this.n1i * this.di / this.ni);
                    this.variance += Math.pow(this.ni, 2.0) * (this.n1i * this.survivalIndex2[0][i - time1.length] * this.di * (this.ni - this.di) / (Math.pow(this.ni, 2.0) * (this.ni - 1.0)));
                }
            } else if ((int)censor1[i] == 1) {
                this.n2i = 0.0;
                this.d2i = 0.0;
                k = 0;
                while (k < time2.length) {
                    if (time2[k] > time1[i]) {
                        this.n2i += 1.0;
                    }
                    if (time2[k] == time1[i]) {
                        this.n2i += 1.0;
                        if ((int)censor2[k] == 1) {
                            this.d2i += 1.0;
                        }
                    }
                    ++k;
                }
                this.di = this.d2i + this.survivalIndex1[1][i];
                this.ni = this.n2i + this.survivalIndex1[0][i];
                this.testStatistic += this.ni * (this.survivalIndex1[1][i] - this.survivalIndex1[0][i] * this.di / this.ni);
                this.variance += Math.pow(this.ni, 2.0) * (this.n2i * this.survivalIndex1[0][i] * this.di * (this.ni - this.di) / (Math.pow(this.ni, 2.0) * (this.ni - 1.0)));
            }
            ++i;
        }
        this.pValue = 2.0 * (1.0 - new NormalDistribution().cumulative(Math.abs(this.testStatistic / Math.pow(this.variance, 0.5))));
        return this.testStatistic;
    }

    public double pValue(double[] time1, double[] censor1, double[] time2, double[] censor2) {
        this.time1 = time1;
        this.censor1 = censor1;
        this.time2 = time2;
        this.censor2 = censor2;
        this.testStatistic(time1, censor1, time2, censor2);
        return this.pValue;
    }
}

