/*
 * Decompiled with CFR 0.152.
 */
package javastat.survival.regression;

import JSci.maths.statistics.NormalDistribution;
import Jama.Matrix;
import javastat.survival.SurvivalRegressionInterface;
import javastat.util.DataManager;

public class CoxRegression
implements SurvivalRegressionInterface {
    public double alpha;
    public double[] coefficients;
    public double[][] variance;
    public double[] testStatistic;
    public double[] pValue;
    public double[][] confidenceInterval;
    public double[] time;
    public double[] censor;
    public double[][] covariate;
    private double zAlpha;
    private double numerator;
    private double denumerator;
    private double error1;
    private double error2;
    private double[] riskFactor;
    private double[][] expectedCovariate;
    private double[] score;
    private double[][] information;
    private Matrix scoreMatrix;
    private Matrix informationMatrix;
    private Matrix coefficientMatrix;
    private Matrix errorMatrix;
    private DataManager dataManager;
    private NormalDistribution normalDistribution;

    public CoxRegression() {
    }

    public CoxRegression(double alpha, double[] time, double[] censor, double[][] covariate) {
        this.alpha = alpha;
        this.time = time;
        this.censor = censor;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(time, censor, covariate);
        this.confidenceInterval = this.confidenceInterval(alpha, time, censor, covariate);
    }

    public CoxRegression(double[] time, double[] censor, double[][] covariate) {
        this(0.05, time, censor, covariate);
    }

    public double[] coefficients(double[] time, double[] censor, double[][] covariate) {
        this.time = time;
        this.censor = censor;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(time, censor, covariate);
        return this.coefficients;
    }

    public double[] testStatistic(double[] time, double[] censor, double[][] covariate) {
        this.time = time;
        this.censor = censor;
        this.covariate = covariate;
        this.denumerator = 0.0;
        this.numerator = 0.0;
        this.error1 = 1.0;
        this.error2 = 1.0;
        this.pValue = new double[covariate.length];
        this.testStatistic = new double[covariate.length];
        this.riskFactor = new double[time.length];
        this.expectedCovariate = new double[covariate.length][time.length];
        this.score = new double[covariate.length];
        this.coefficients = new double[covariate.length];
        this.information = new double[covariate.length][covariate.length];
        this.normalDistribution = new NormalDistribution();
        this.dataManager = new DataManager();
        this.dataManager.checkDimension(covariate);
        this.dataManager.checkPositiveRange(time, "time");
        this.dataManager.checkCensor(censor);
        if (time.length != covariate[0].length || time.length != censor.length) {
            throw new IllegalArgumentException("The time vector, censor vector, and rows of the covariate matrix must have the same length.");
        }
        this.coefficientMatrix = new Matrix(covariate.length, 1, 0.1);
        this.coefficients = this.coefficientMatrix.getColumnPackedCopy();
        while (this.error1 > 1.0E-5 || this.error2 > 1.0E-5) {
            int s;
            int i = 0;
            while (i < time.length) {
                this.riskFactor[i] = 1.0;
                s = 0;
                while (s < covariate.length) {
                    int n = i;
                    this.riskFactor[n] = this.riskFactor[n] * Math.exp(this.coefficients[s] * covariate[s][i]);
                    ++s;
                }
                ++i;
            }
            int j = 0;
            while (j < covariate.length) {
                this.score[j] = 0.0;
                int i2 = 0;
                while (i2 < time.length) {
                    int k = 0;
                    while (k < time.length) {
                        if (time[k] >= time[i2]) {
                            this.denumerator += this.riskFactor[k];
                            this.numerator += covariate[j][k] * this.riskFactor[k];
                        }
                        ++k;
                    }
                    this.expectedCovariate[j][i2] = this.numerator / this.denumerator;
                    int n = j;
                    this.score[n] = this.score[n] + censor[i2] * (covariate[j][i2] - this.expectedCovariate[j][i2]);
                    this.numerator = 0.0;
                    this.denumerator = 0.0;
                    ++i2;
                }
                ++j;
            }
            int r = 0;
            while (r < covariate.length) {
                s = 0;
                while (s < covariate.length) {
                    this.information[r][s] = 0.0;
                    int i3 = 0;
                    while (i3 < time.length) {
                        int k = 0;
                        while (k < time.length) {
                            if (time[k] >= time[i3]) {
                                this.denumerator += this.riskFactor[k];
                                this.numerator += covariate[r][k] * covariate[s][k] * this.riskFactor[k];
                            }
                            ++k;
                        }
                        double[] dArray = this.information[r];
                        int n = s;
                        dArray[n] = dArray[n] + censor[i3] * (this.expectedCovariate[r][i3] * this.expectedCovariate[s][i3] - this.numerator / this.denumerator);
                        this.numerator = 0.0;
                        this.denumerator = 0.0;
                        ++i3;
                    }
                    ++s;
                }
                ++r;
            }
            this.informationMatrix = new Matrix(this.information);
            this.scoreMatrix = new Matrix(this.score, covariate.length);
            this.errorMatrix = this.informationMatrix.inverse().times(this.scoreMatrix);
            this.coefficientMatrix.minusEquals(this.errorMatrix);
            this.coefficients = this.coefficientMatrix.getColumnPackedCopy();
            this.error1 = Math.sqrt(this.errorMatrix.normF());
            this.error2 = Math.sqrt(this.scoreMatrix.normF());
        }
        this.informationMatrix = new Matrix(this.information);
        this.variance = this.informationMatrix.inverse().times(-1.0).getArray();
        int s = 0;
        while (s < covariate.length) {
            this.testStatistic[s] = this.coefficients[s] / Math.sqrt(this.variance[s][s]);
            ++s;
        }
        s = 0;
        while (s < this.testStatistic.length) {
            this.pValue[s] = 2.0 * (1.0 - this.normalDistribution.cumulative(Math.abs(this.testStatistic[s])));
            ++s;
        }
        return this.testStatistic;
    }

    public double[][] confidenceInterval(double alpha, double[] time, double[] censor, double[][] covariate) {
        if (alpha <= 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The level of significance should be (strictly) positive and not greater than 1.");
        }
        this.alpha = alpha;
        this.time = time;
        this.censor = censor;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(time, censor, covariate);
        this.zAlpha = new NormalDistribution().inverse(1.0 - alpha / 2.0);
        this.confidenceInterval = new double[this.testStatistic.length][2];
        int i = 0;
        while (i < this.testStatistic.length) {
            this.confidenceInterval[i][0] = this.coefficients[i] - this.zAlpha * Math.sqrt(this.variance[i][i]);
            this.confidenceInterval[i][1] = this.coefficients[i] + this.zAlpha * Math.sqrt(this.variance[i][i]);
            ++i;
        }
        return this.confidenceInterval;
    }

    public double[] pValue(double[] time, double[] censor, double[][] covariate) {
        this.time = time;
        this.censor = censor;
        this.covariate = covariate;
        this.testStatistic = this.testStatistic(time, censor, covariate);
        return this.pValue;
    }
}

