/*
 * Decompiled with CFR 0.152.
 */
package javastat.util;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javastat.util.FunctionType;
import javastat.util.OperationType;

public class DataManager {
    public double[] abs(double[] data) {
        double[] absData = new double[data.length];
        int i = 0;
        while (i < data.length) {
            absData[i] = Math.abs(data[i]);
            ++i;
        }
        return absData;
    }

    public double[][] abs(double[][] data) {
        double[][] absData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            absData[i] = new double[data[i].length];
            absData[i] = this.abs(data[i]);
            ++i;
        }
        return absData;
    }

    public double roundDigits(double a, double d) {
        return (double)Math.round(a * Math.pow(10.0, d)) / Math.pow(10.0, d);
    }

    public double[] stringToDouble(String[] stringArray) {
        double[] doubleArray = new double[stringArray.length];
        int i = 0;
        while (i <= stringArray.length - 1) {
            doubleArray[i] = Double.parseDouble(stringArray[i]);
            ++i;
        }
        return doubleArray;
    }

    public int[] stringToInteger(String[] stringArray) {
        int[] intArray = new int[stringArray.length];
        int i = 0;
        while (i <= stringArray.length - 1) {
            intArray[i] = Integer.parseInt(stringArray[i]);
            ++i;
        }
        return intArray;
    }

    public String[][] doubleToString(double[][] doubleArray) {
        String[][] stringArray = new String[doubleArray.length][];
        int i = 0;
        while (i < doubleArray.length) {
            stringArray[i] = new String[doubleArray[i].length];
            int j = 0;
            while (j < doubleArray[i].length) {
                stringArray[i][j] = Double.toString(doubleArray[i][j]);
                ++j;
            }
            ++i;
        }
        return stringArray;
    }

    public String[] doubleToString(double[] doubleArray) {
        return this.doubleToString(new double[][]{doubleArray})[0];
    }

    public double numberOfClass(String[] str, String criterion) {
        double counts = 0.0;
        int i = 0;
        while (i < str.length) {
            if (str[i].equalsIgnoreCase(criterion)) {
                counts += 1.0;
            }
            ++i;
        }
        return counts;
    }

    public double[][] contingencyTable(String[] colVar, String[] rowVar) {
        int[] colVarHcode = new int[colVar.length];
        int[] rowVarHcode = new int[colVar.length];
        int[] colVarHcodeClone = new int[colVar.length];
        int[] rowVarHcodeClone = new int[colVar.length];
        double[] totalHcode = new double[rowVar.length];
        int ind2 = 0;
        int i = 0;
        while (i < colVar.length) {
            colVarHcode[i] = colVar[i].toLowerCase().hashCode();
            rowVarHcode[i] = rowVar[i].toLowerCase().hashCode();
            colVarHcodeClone[i] = colVar[i].toLowerCase().hashCode();
            rowVarHcodeClone[i] = rowVar[i].toLowerCase().hashCode();
            totalHcode[i] = (double)rowVar[i].toLowerCase().hashCode() + 1.0 / (double)colVarHcode[i];
            ++i;
        }
        Arrays.sort(colVarHcode);
        Arrays.sort(rowVarHcode);
        int[] uniColHcode = this.unique(colVarHcode);
        int[] uniRowHcode = this.unique(rowVarHcode);
        int nc = uniColHcode.length;
        int nr = uniRowHcode.length;
        Arrays.sort(totalHcode);
        int[] totalIndex = this.groupIndex(totalHcode);
        double[][] table = new double[nr][nc];
        int j = 0;
        while (j < nr) {
            int k = 0;
            while (k < nc) {
                int ind1 = 0;
                boolean zeroind = true;
                while (ind1 < colVar.length && zeroind) {
                    if (uniColHcode[k] == colVarHcodeClone[ind1] && uniRowHcode[j] == rowVarHcodeClone[ind1]) {
                        zeroind = false;
                    }
                    ++ind1;
                }
                if (zeroind) {
                    table[j][k] = 0.0;
                } else {
                    table[j][k] = totalIndex[ind2];
                    ++ind2;
                }
                ++k;
            }
            ++j;
        }
        return table;
    }

    public int[] orderIndex(double[] data) {
        int[] index = new int[data.length];
        double[] buffer = (double[])data.clone();
        Arrays.sort(buffer);
        int i = 0;
        while (i < data.length) {
            boolean ind = true;
            int j = 0;
            if (i > 0 && buffer[i] == buffer[i - 1]) {
                j = index[i - 1] + 1;
            }
            while (ind && j < data.length) {
                if (buffer[i] == data[j]) {
                    ind = false;
                    index[i] = j;
                }
                ++j;
            }
            ++i;
        }
        return index;
    }

    public int[] unique(int[] orderVar) {
        int[] oriVar = new int[orderVar.length];
        int j = 1;
        int index = 0;
        while (j < orderVar.length) {
            int number = 1;
            while (orderVar[j - 1] == orderVar[j]) {
                ++number;
                if (++j == orderVar.length) break;
            }
            oriVar[index] = orderVar[j - 1];
            ++j;
            ++index;
        }
        int[] uniqueVar = new int[index];
        int i = 0;
        while (i < index) {
            uniqueVar[i] = oriVar[i];
            ++i;
        }
        return uniqueVar;
    }

    public double[] zeroArray(int arrayDim) {
        double[] data = new double[arrayDim];
        int i = 0;
        while (i < arrayDim) {
            data[i] = 0.0;
            ++i;
        }
        return data;
    }

    public double[][] zeroArray(int arrayDim1, int arrayDim2) {
        double[][] data = new double[arrayDim1][arrayDim2];
        int i = 0;
        while (i < arrayDim1) {
            int j = 0;
            while (j < arrayDim2) {
                data[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        return data;
    }

    public double[] matchedDataDifference(double[] data1, double[] data2) {
        if (data1.length != data2.length) {
            throw new IllegalArgumentException("The sample sizes of the two data sets must agree.");
        }
        double[] mData = new double[data1.length];
        int i = 0;
        while (i < data1.length) {
            mData[i] = data1[i] - data2[i];
            ++i;
        }
        return mData;
    }

    public double zeroNumber(double med, double[] data) {
        double zn = 0.0;
        int i = 0;
        while (i < data.length) {
            if (data[i] - med == 0.0) {
                zn += 1.0;
            }
            ++i;
        }
        return zn;
    }

    public double[] nonZeroData(double med, double[] data) {
        int zn = (int)this.zeroNumber(med, data);
        double[] nonzeroData = new double[data.length - zn];
        int ind = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] - med != 0.0) {
                nonzeroData[ind] = data[i];
                ++ind;
            }
            ++i;
        }
        return nonzeroData;
    }

    public double[] tieNumber(double[] data) {
        double[] tn = new double[data.length];
        int i = 0;
        while (i < data.length) {
            tn[i] = 0.0;
            int k = 0;
            while (k < data.length) {
                if (data[i] == data[k]) {
                    int n = i;
                    tn[n] = tn[n] + 1.0;
                }
                ++k;
            }
            ++i;
        }
        return tn;
    }

    public double[] tieNumber(double med, double[] data) {
        double[] tn = new double[data.length];
        int i = 0;
        while (i < data.length) {
            tn[i] = 0.0;
            int k = 0;
            while (k < data.length) {
                if (Math.abs(data[i] - med) == Math.abs(data[k] - med)) {
                    int n = i;
                    tn[n] = tn[n] + 1.0;
                }
                ++k;
            }
            ++i;
        }
        return tn;
    }

    public void dataSort(double[] groups) {
        int i = 1;
        while (i < groups.length) {
            int j = i;
            while (groups[j] < groups[j - 1]) {
                double buffer = groups[j];
                groups[j] = groups[j - 1];
                groups[j - 1] = buffer;
                if (--j == 0) break;
            }
            ++i;
        }
    }

    public void dataSort(double[] groups, double[][] covariate) {
        this.checkDimension(covariate);
        if (groups.length != covariate[0].length) {
            throw new IllegalArgumentException("The group vector and rows of the covariate matrix must have the same length.");
        }
        int i = 1;
        while (i < groups.length) {
            int j = i;
            while (groups[j] < groups[j - 1]) {
                double buffer = groups[j];
                groups[j] = groups[j - 1];
                groups[j - 1] = buffer;
                int k = 0;
                while (k < covariate.length) {
                    buffer = covariate[k][j];
                    covariate[k][j] = covariate[k][j - 1];
                    covariate[k][j - 1] = buffer;
                    ++k;
                }
                if (--j == 0) break;
            }
            ++i;
        }
    }

    public double[] dataMerge(double[] data1, double[] data2) {
        double[] data = new double[data1.length + data2.length];
        int s = 0;
        while (s < data1.length) {
            data[s] = data1[s];
            ++s;
        }
        int m = data1.length;
        while (m < data.length) {
            data[m] = data2[m - data1.length];
            ++m;
        }
        return data;
    }

    public double sampleSize(double[][] data) {
        double samSize = 0.0;
        int j = 0;
        while (j < data.length) {
            samSize += (double)data[j].length;
            ++j;
        }
        return samSize;
    }

    public int[] groupIndex(double[] orderGroups) {
        int[] oriIndex = new int[orderGroups.length];
        int j = 1;
        int index = 0;
        while (j < orderGroups.length) {
            int number = 1;
            while (orderGroups[j - 1] == orderGroups[j]) {
                ++number;
                if (++j == orderGroups.length) break;
            }
            oriIndex[index] = number;
            ++j;
            ++index;
        }
        int[] gindex = new int[index];
        int i = 0;
        while (i < index) {
            gindex[i] = oriIndex[i];
            ++i;
        }
        return gindex;
    }

    public double[][] survivalIndex(double[] time, double[] censor) {
        this.checkPositiveRange(time, "time");
        this.checkCensor(censor);
        if (time.length != censor.length) {
            throw new IllegalArgumentException("The time vector and censor vector must have the same length.");
        }
        double[][] index = this.zeroArray(2, time.length);
        int i = 0;
        while (i < time.length) {
            int k = 0;
            while (k < time.length) {
                if (time[k] > time[i]) {
                    double[] dArray = index[0];
                    int n = i;
                    dArray[n] = dArray[n] + 1.0;
                }
                if (time[k] == time[i]) {
                    double[] dArray = index[0];
                    int n = i;
                    dArray[n] = dArray[n] + 1.0;
                    if ((int)censor[i] == 1) {
                        double[] dArray2 = index[1];
                        int n2 = i;
                        dArray2[n2] = dArray2[n2] + 1.0;
                    }
                }
                ++k;
            }
            ++i;
        }
        return index;
    }

    public final void checkPositiveRangeDimension(double[][] table) {
        int i = 0;
        while (i < table.length) {
            if (table[i].length != table[0].length) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            int j = 0;
            while (j < table[i].length) {
                if (table[i][j] < 0.0) {
                    throw new IllegalArgumentException("The elements of the table should be positive.");
                }
                ++j;
            }
            ++i;
        }
    }

    public final void checkPositiveRange(double[] vector, String s) {
        int i = 0;
        while (i < vector.length) {
            if (vector[i] < 0.0) {
                throw new IllegalArgumentException("The elements of the " + s + " vector should be positive.");
            }
            ++i;
        }
    }

    public final void checkCensor(double[] censor) {
        int i = 0;
        while (i < censor.length) {
            if ((int)censor[i] != 0 && (int)censor[i] != 1) {
                throw new IllegalArgumentException("The elements of the censor vector should be either 1 or 0.");
            }
            ++i;
        }
    }

    public final void checkDimension(double[][] covariate) {
        int i = 1;
        while (i < covariate.length) {
            if (covariate[i].length != covariate[0].length) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++i;
        }
    }

    public void scanFileToMatrix(String fileName, double[][] matrix, int nc) {
        try {
            File file = new File(fileName);
            int size = (int)file.length();
            int readind = 0;
            int ind1 = 0;
            int ind2 = 0;
            FileReader in = new FileReader(file);
            char[] data = new char[size];
            while (in.ready()) {
                readind += in.read(data, readind, size - readind);
            }
            in.close();
            String s1 = new String(data, 0, readind);
            StringTokenizer st = new StringTokenizer(s1, "\n\r\t, :;");
            double[][] m = new double[nc][st.countTokens() / nc];
            while (st.hasMoreTokens()) {
                if (ind2 == nc) {
                    ind2 = 0;
                    ++ind1;
                }
                m[ind2++][ind1] = Double.parseDouble(st.nextToken());
            }
            int j = 0;
            while (j < nc) {
                matrix[j] = m[j];
                ++j;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double[][] getDataRange(int fromRowIndex, int toRowIndex, int fromColumnIndex, int toColumnIndex, double[][] data) {
        double[][] copy = new double[toRowIndex - fromRowIndex + 1][toColumnIndex - fromColumnIndex + 1];
        int i = fromRowIndex;
        while (i <= toRowIndex) {
            int j = fromColumnIndex;
            while (j <= toColumnIndex) {
                copy[i][j] = data[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public double[] copyData(double[] data) {
        double[] copy = new double[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public double[][] pow(double[][] data, double[][] power) {
        double[][] dataPower = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            dataPower[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                dataPower[i][j] = Math.pow(data[i][j], power[i][j]);
                ++j;
            }
            ++i;
        }
        return dataPower;
    }

    public double[][] pow(double[][] data, double power) {
        double[][] dataPower = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            dataPower[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                dataPower[i][j] = Math.pow(data[i][j], power);
                ++j;
            }
            ++i;
        }
        return dataPower;
    }

    public double[] pow(double[] data, double[] power) {
        return this.pow((double[][])new double[][]{data}, new double[][]{power})[0];
    }

    public double[] pow(double[] data, double power) {
        return this.pow((double[][])new double[][]{data}, power)[0];
    }

    public double[][] sqrt(double[][] data) {
        return this.pow(data, 0.5);
    }

    public double[] sqrt(double[] data) {
        return this.pow(data, 0.5);
    }

    public double[][] square(double[][] data) {
        return this.pow(data, 2.0);
    }

    public double[] square(double[] data) {
        return this.pow(data, 2.0);
    }

    public double[][] cube(double[][] data) {
        return this.pow(data, 3.0);
    }

    public double[] cube(double[] data) {
        return this.pow(data, 3.0);
    }

    public double[][] reciprocal(double[][] data) {
        return this.pow(data, -1.0);
    }

    public double[] reciprocal(double[] data) {
        return this.pow(data, -1.0);
    }

    public double[][] cbrt(double[][] data) {
        return this.pow(data, 0.3333333333333333);
    }

    public double[] cbrt(double[] data) {
        return this.pow(data, 0.3333333333333333);
    }

    public double[][] sin(double[][] data) {
        double[][] sinData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            sinData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                sinData[i][j] = Math.sin(data[i][j]);
                ++j;
            }
            ++i;
        }
        return sinData;
    }

    public double[] sin(double[] data) {
        return this.sin(new double[][]{data})[0];
    }

    public double[][] cos(double[][] data) {
        double[][] cosData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            cosData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                cosData[i][j] = Math.cos(data[i][j]);
                ++j;
            }
            ++i;
        }
        return cosData;
    }

    public double[] cos(double[] data) {
        return this.cos(new double[][]{data})[0];
    }

    public double[][] tan(double[][] data) {
        double[][] tanData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            tanData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                tanData[i][j] = Math.tan(data[i][j]);
                ++j;
            }
            ++i;
        }
        return tanData;
    }

    public double[] tan(double[] data) {
        return this.tan(new double[][]{data})[0];
    }

    public double[][] trigonoFunction(double[][] data, FunctionType option) {
        double[][] trigonoData;
        switch (option) {
            case SIN: {
                trigonoData = this.sin(data);
                break;
            }
            case COS: {
                trigonoData = this.cos(data);
                break;
            }
            case TAN: {
                trigonoData = this.tan(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("The input function type does not exist.");
            }
        }
        return trigonoData;
    }

    public double[] trigonoFunction(double[] data, FunctionType option) {
        return this.trigonoFunction((double[][])new double[][]{data}, option)[0];
    }

    public double[][] trigonoFunction(double[][] data, String option) {
        return this.trigonoFunction(data, FunctionType.valueOf(option.toUpperCase()));
    }

    public double[] trigonoFunction(double[] data, String option) {
        return this.trigonoFunction(data, FunctionType.valueOf(option.toUpperCase()));
    }

    public double[][] asin(double[][] data) {
        double[][] asinData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            asinData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                asinData[i][j] = Math.asin(data[i][j]);
                ++j;
            }
            ++i;
        }
        return asinData;
    }

    public double[] asin(double[] data) {
        return this.asin(new double[][]{data})[0];
    }

    public double[][] acos(double[][] data) {
        double[][] acosData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            acosData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                acosData[i][j] = Math.acos(data[i][j]);
                ++j;
            }
            ++i;
        }
        return acosData;
    }

    public double[] acos(double[] data) {
        return this.acos(new double[][]{data})[0];
    }

    public double[][] atan(double[][] data) {
        double[][] atanData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            atanData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                atanData[i][j] = Math.atan(data[i][j]);
                ++j;
            }
            ++i;
        }
        return atanData;
    }

    public double[] atan(double[] data) {
        return this.atan(new double[][]{data})[0];
    }

    public double[][] arcFunction(double[][] data, FunctionType option) {
        double[][] arcData;
        switch (option) {
            case ASIN: {
                arcData = this.asin(data);
                break;
            }
            case ACOS: {
                arcData = this.acos(data);
                break;
            }
            case ATAN: {
                arcData = this.atan(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("The input function type does not exist.");
            }
        }
        return arcData;
    }

    public double[] arcFunction(double[] data, FunctionType option) {
        return this.arcFunction((double[][])new double[][]{data}, option)[0];
    }

    public double[][] arcFunction(double[][] data, String option) {
        return this.arcFunction(data, FunctionType.valueOf(option.toUpperCase()));
    }

    public double[] arcFunction(double[] data, String option) {
        return this.arcFunction(data, FunctionType.valueOf(option.toUpperCase()));
    }

    public double[][] sinh(double[][] data) {
        double[][] sinhData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            sinhData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                sinhData[i][j] = Math.sinh(data[i][j]);
                ++j;
            }
            ++i;
        }
        return sinhData;
    }

    public double[] sinh(double[] data) {
        return this.sinh(new double[][]{data})[0];
    }

    public double[][] cosh(double[][] data) {
        double[][] coshData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            coshData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                coshData[i][j] = Math.cosh(data[i][j]);
                ++j;
            }
            ++i;
        }
        return coshData;
    }

    public double[] cosh(double[] data) {
        return this.cosh(new double[][]{data})[0];
    }

    public double[][] tanh(double[][] data) {
        double[][] tanhData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            tanhData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                tanhData[i][j] = Math.tanh(data[i][j]);
                ++j;
            }
            ++i;
        }
        return tanhData;
    }

    public double[] tanh(double[] data) {
        return this.tanh(new double[][]{data})[0];
    }

    public double[][] asinh(double[][] data) {
        double[][] asinhData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            asinhData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                asinhData[i][j] = Math.log(data[i][j] + Math.sqrt(data[i][j] * data[i][j] + 1.0));
                ++j;
            }
            ++i;
        }
        return asinhData;
    }

    public double[] asinh(double[] data) {
        return this.asinh(new double[][]{data})[0];
    }

    public double[][] acosh(double[][] data) {
        double[][] acoshData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            acoshData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                acoshData[i][j] = Math.log(data[i][j] + Math.sqrt(data[i][j] * data[i][j] - 1.0));
                ++j;
            }
            ++i;
        }
        return acoshData;
    }

    public double[] acosh(double[] data) {
        return this.acosh(new double[][]{data})[0];
    }

    public double[][] atanh(double[][] data) {
        double[][] atanhData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            atanhData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                atanhData[i][j] = 0.5 * Math.log((1.0 + data[i][j]) / (1.0 - data[i][j]));
                ++j;
            }
            ++i;
        }
        return atanhData;
    }

    public double[] atanh(double[] data) {
        return this.atanh(new double[][]{data})[0];
    }

    public double[][] hyperbolicFunction(double[][] data, FunctionType option) {
        double[][] hyperbolicData;
        switch (option) {
            case SINH: {
                hyperbolicData = this.sinh(data);
                break;
            }
            case COSH: {
                hyperbolicData = this.cosh(data);
                break;
            }
            case TANH: {
                hyperbolicData = this.tanh(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("The input function type does not exist.");
            }
        }
        return hyperbolicData;
    }

    public double[] hyperbolicFunction(double[] data, FunctionType option) {
        return this.hyperbolicFunction((double[][])new double[][]{data}, option)[0];
    }

    public double[][] hyperbolicFunction(double[][] data, String option) {
        return this.hyperbolicFunction(data, FunctionType.valueOf(option.toUpperCase()));
    }

    public double[] hyperbolicFunction(double[] data, String option) {
        return this.hyperbolicFunction(data, FunctionType.valueOf(option.toUpperCase()));
    }

    public double[][] inverseHyperbolicFunction(double[][] data, FunctionType option) {
        double[][] inverseHyperbolicData;
        switch (option) {
            case ASINH: {
                inverseHyperbolicData = this.asinh(data);
                break;
            }
            case ACOSH: {
                inverseHyperbolicData = this.acosh(data);
                break;
            }
            case ATANH: {
                inverseHyperbolicData = this.atanh(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("The input function type does not exist.");
            }
        }
        return inverseHyperbolicData;
    }

    public double[] inverseHyperbolicFunction(double[] data, FunctionType option) {
        return this.inverseHyperbolicFunction((double[][])new double[][]{data}, option)[0];
    }

    public double[][] inverseHyperbolicFunction(double[][] data, String option) {
        return this.inverseHyperbolicFunction(data, FunctionType.valueOf(option.toUpperCase()));
    }

    public double[] inverseHyperbolicFunction(double[] data, String option) {
        return this.inverseHyperbolicFunction(data, FunctionType.valueOf("option"));
    }

    public double[][] log(double[][] data, double[][] base) {
        double[][] logData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            logData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                logData[i][j] = Math.log(data[i][j]) / Math.log(base[i][j]);
                ++j;
            }
            ++i;
        }
        return logData;
    }

    public double[] log(double[] data, double[] base) {
        return this.log((double[][])new double[][]{data}, new double[][]{base})[0];
    }

    public double[][] log(double[][] data, double base) {
        double[][] logData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            logData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                logData[i][j] = Math.log(data[i][j]) / Math.log(base);
                ++j;
            }
            ++i;
        }
        return logData;
    }

    public double[] log(double[] data, double base) {
        return this.log((double[][])new double[][]{data}, base)[0];
    }

    public double[][] log(double[][] data) {
        return this.log(data, Math.E);
    }

    public double[] log(double[] data) {
        return this.log(new double[][]{data})[0];
    }

    public double[][] log10(double[][] data) {
        return this.log(data, 10.0);
    }

    public double[] log10(double[] data) {
        return this.log10(new double[][]{data})[0];
    }

    public double[][] exp(double[][] data) {
        double[][] expData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            expData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                expData[i][j] = Math.exp(data[i][j]);
                ++j;
            }
            ++i;
        }
        return expData;
    }

    public double[] exp(double[] data) {
        return this.exp(new double[][]{data})[0];
    }

    public double[][] toRadians(double[][] data) {
        double[][] radiansData = new double[data.length][];
        int i = 0;
        while (i < data.length) {
            radiansData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                radiansData[i][j] = Math.toRadians(data[i][j]);
                ++j;
            }
            ++i;
        }
        return radiansData;
    }

    public double[] toRadians(double[] data) {
        return this.toRadians(new double[][]{data})[0];
    }

    public double[][] cummax(double[][] data) {
        double[][] cumData = new double[data.length][];
        double maxValue = data[0][0];
        int i = 0;
        while (i < data.length) {
            cumData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                if (data[i][j] <= maxValue) {
                    cumData[i][j] = maxValue;
                } else {
                    cumData[i][j] = data[i][j];
                    maxValue = data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return cumData;
    }

    public double[] cummax(double[] data) {
        return this.cummax(new double[][]{data})[0];
    }

    public double[][] cummin(double[][] data) {
        double[][] cumData = new double[data.length][];
        double minValue = data[0][0];
        int i = 0;
        while (i < data.length) {
            cumData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                if (data[i][j] >= minValue) {
                    cumData[i][j] = minValue;
                } else {
                    cumData[i][j] = data[i][j];
                    minValue = data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return cumData;
    }

    public double[] cummin(double[] data) {
        return this.cummin(new double[][]{data})[0];
    }

    public double[][] cumsum(double[][] data) {
        double[][] cumData = new double[data.length][];
        double total = 0.0;
        int i = 0;
        while (i < data.length) {
            cumData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                cumData[i][j] = total += data[i][j];
                ++j;
            }
            ++i;
        }
        return cumData;
    }

    public double[] cumsum(double[] data) {
        return this.cumsum(new double[][]{data})[0];
    }

    public double[][] cumprod(double[][] data) {
        double[][] cumData = new double[data.length][];
        double total = 1.0;
        int i = 0;
        while (i < data.length) {
            cumData[i] = new double[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                cumData[i][j] = total *= data[i][j];
                ++j;
            }
            ++i;
        }
        return cumData;
    }

    public double[] cumprod(double[] data) {
        return this.cumprod(new double[][]{data})[0];
    }

    public double[][] cumFunction(double[][] data, FunctionType option) {
        double[][] cumData;
        switch (option) {
            case CUMMIN: {
                cumData = this.cummin(data);
                break;
            }
            case CUMMAX: {
                cumData = this.cummax(data);
                break;
            }
            case CUMSUM: {
                cumData = this.cumsum(data);
                break;
            }
            case CUMPROD: {
                cumData = this.cumprod(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("The input function type does not exist.");
            }
        }
        return cumData;
    }

    public double[] cumFunction(double[] data, FunctionType option) {
        return this.cumFunction((double[][])new double[][]{data}, option)[0];
    }

    public double[][] cumFunction(double[][] data, String option) {
        return this.cumFunction(data, FunctionType.valueOf(option.toUpperCase()));
    }

    public double[] cumFunction(double[] data, String option) {
        return this.cumFunction(data, FunctionType.valueOf("option"));
    }

    public double[][] sort(double[][] data) {
        double[] oneDData = this.twoDToOneD(data);
        double[][] sortedData = new double[data.length][];
        int len = 0;
        Arrays.sort(oneDData);
        int i = 0;
        while (i < data.length) {
            sortedData[i] = new double[data[i].length];
            len += data[i].length;
            int j = 0;
            while (j < data[i].length) {
                sortedData[i][j] = oneDData[len - data[i].length + j];
                ++j;
            }
            ++i;
        }
        return sortedData;
    }

    public double[] sort(double[] data) {
        return this.sort(new double[][]{data})[0];
    }

    public double[] twoDToOneD(double[][] data) {
        double[] oneDData = new double[this.length(data)];
        int len = 0;
        int i = 0;
        while (i < data.length) {
            len += data[i].length;
            int j = data[i].length;
            while (j > 0) {
                oneDData[len - j] = data[i][data[i].length - j];
                --j;
            }
            ++i;
        }
        return oneDData;
    }

    public int length(double[][] data) {
        int len = 0;
        int i = 0;
        while (i < data.length) {
            len += data[i].length;
            ++i;
        }
        return len;
    }

    public double[][] add(double[][] data1, double[][] data2) {
        double[][] addedData = new double[data1.length][];
        int i = 0;
        while (i < data1.length) {
            addedData[i] = new double[data1[i].length];
            int j = 0;
            while (j < data1[i].length) {
                addedData[i][j] = data1[i][j] + data2[i][j];
                ++j;
            }
            ++i;
        }
        return addedData;
    }

    public double[] add(double[] data1, double[] data2) {
        return this.add(new double[][]{data1}, new double[][]{data2})[0];
    }

    public double[][] minus(double[][] data1, double[][] data2) {
        double[][] substractedData = new double[data1.length][];
        int i = 0;
        while (i < data1.length) {
            substractedData[i] = new double[data1[i].length];
            int j = 0;
            while (j < data1[i].length) {
                substractedData[i][j] = data1[i][j] - data2[i][j];
                ++j;
            }
            ++i;
        }
        return substractedData;
    }

    public double[] minus(double[] data1, double[] data2) {
        return this.minus(new double[][]{data1}, new double[][]{data2})[0];
    }

    public double[][] prod(double[][] data1, double[][] data2) {
        double[][] multipliedData = new double[data1.length][];
        int i = 0;
        while (i < data1.length) {
            multipliedData[i] = new double[data1[i].length];
            int j = 0;
            while (j < data1[i].length) {
                multipliedData[i][j] = data1[i][j] * data2[i][j];
                ++j;
            }
            ++i;
        }
        return multipliedData;
    }

    public double[] prod(double[] data1, double[] data2) {
        return this.prod(new double[][]{data1}, new double[][]{data2})[0];
    }

    public double[][] divide(double[][] data1, double[][] data2) {
        double[][] dividedData = new double[data1.length][];
        int i = 0;
        while (i < data1.length) {
            dividedData[i] = new double[data1[i].length];
            int j = 0;
            while (j < data1[i].length) {
                dividedData[i][j] = data1[i][j] / data2[i][j];
                ++j;
            }
            ++i;
        }
        return dividedData;
    }

    public double[] divide(double[] data1, double[] data2) {
        return this.divide(new double[][]{data1}, new double[][]{data2})[0];
    }

    public double[][] multiply(double[][] matrix1, double[][] matrix2) {
        return new Matrix(matrix1).times(new Matrix(matrix2)).getArray();
    }

    public double[] multiply(double[] matrix1, double[] matrix2) {
        return this.multiply(new double[][]{matrix1}, new double[][]{matrix2})[0];
    }

    public double[][] inverse(double[][] matrix) {
        return new Matrix(matrix).inverse().getArray();
    }

    public double[][] transpose(double[][] matrix) {
        return new Matrix(matrix).transpose().getArray();
    }

    public double[] transpose(double[] matrix) {
        return this.transpose(new double[][]{matrix})[0];
    }

    public Hashtable eigenAnalysis(double[][] matrix) {
        Hashtable<String, Object> eigenTable = new Hashtable<String, Object>();
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(new Matrix(matrix));
        eigenTable.put("Eigenvalues", eigenvalueDecomposition.getRealEigenvalues());
        eigenTable.put("Eigenvectors", eigenvalueDecomposition.getV().getArray());
        return eigenTable;
    }

    public Vector eigen(double[][] matrix) {
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(new Matrix(matrix));
        Vector<Object> eigenTable = new Vector<Object>();
        eigenTable.add(eigenvalueDecomposition.getRealEigenvalues());
        eigenTable.add(eigenvalueDecomposition.getV().getArray());
        return eigenTable;
    }

    public double[] eigenvalue(double[][] matrix) {
        return (double[])this.eigenAnalysis(matrix).get("Eigenvalues");
    }

    public double[][] eigenvectors(double[][] matrix) {
        return (double[][])this.eigenAnalysis(matrix).get("Eigenvectors");
    }

    public double det(double[][] matrix) {
        return new Matrix(matrix).det();
    }

    public double[][] determinant(double[][] matrix) {
        return new double[][]{{this.det(matrix)}};
    }

    public double[][] dataManipulation(double[][] data, FunctionType option) {
        double[][] transformedData;
        switch (option) {
            case RECIPROCAL: {
                transformedData = this.reciprocal(data);
                break;
            }
            case SQUARE: {
                transformedData = this.square(data);
                break;
            }
            case CUBE: {
                transformedData = this.cube(data);
                break;
            }
            case SQRT: {
                transformedData = this.sqrt(data);
                break;
            }
            case CBRT: {
                transformedData = this.cbrt(data);
                break;
            }
            case ABS: {
                transformedData = this.abs(data);
                break;
            }
            case ACOS: {
                transformedData = this.acos(data);
                break;
            }
            case ASIN: {
                transformedData = this.asin(data);
                break;
            }
            case ATAN: {
                transformedData = this.atan(data);
                break;
            }
            case ACOSH: {
                transformedData = this.acosh(data);
                break;
            }
            case ASINH: {
                transformedData = this.asinh(data);
                break;
            }
            case ATANH: {
                transformedData = this.atanh(data);
                break;
            }
            case COS: {
                transformedData = this.cos(data);
                break;
            }
            case COSH: {
                transformedData = this.cosh(data);
                break;
            }
            case CUMMAX: {
                transformedData = this.cummax(data);
                break;
            }
            case CUMMIN: {
                transformedData = this.cummin(data);
                break;
            }
            case CUMPROD: {
                transformedData = this.cumprod(data);
                break;
            }
            case CUMSUM: {
                transformedData = this.cumsum(data);
                break;
            }
            case EXP: {
                transformedData = this.exp(data);
                break;
            }
            case INVERSE: {
                transformedData = this.inverse(data);
                break;
            }
            case TRANSPOSE: {
                transformedData = this.transpose(data);
                break;
            }
            case EIGEN: {
                Vector eigenTable = this.eigen(data);
                transformedData = new double[data.length + 1][];
                transformedData[0] = (double[])eigenTable.get(0);
                int i = 0;
                while (i < data.length) {
                    transformedData[i + 1] = ((double[][])eigenTable.get(1))[i];
                    ++i;
                }
                break;
            }
            case DET: {
                transformedData = this.determinant(data);
                break;
            }
            case LOG: {
                transformedData = this.log(data);
                break;
            }
            case LOG10: {
                transformedData = this.log10(data);
                break;
            }
            case SIN: {
                transformedData = this.sin(data);
                break;
            }
            case SINH: {
                transformedData = this.sinh(data);
                break;
            }
            case SORT: {
                transformedData = this.sort(data);
                break;
            }
            case TAN: {
                transformedData = this.tan(data);
                break;
            }
            case TANH: {
                transformedData = this.tanh(data);
                break;
            }
            case TORADIANS: {
                transformedData = this.toRadians(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("The input function type does not exist.");
            }
        }
        return transformedData;
    }

    public double[][] dataManipulation(double[][] data, String option) {
        return this.dataManipulation(data, FunctionType.valueOf(option));
    }

    public double[][] dataManipulation(double[][] data1, double[][] data2, OperationType option) {
        double[][] operationData;
        switch (option) {
            case ADD: {
                operationData = this.add(data1, data2);
                break;
            }
            case MINUS: {
                operationData = this.minus(data1, data2);
                break;
            }
            case PROD: {
                operationData = this.prod(data1, data2);
                break;
            }
            case DIVIDE: {
                operationData = this.divide(data1, data2);
                break;
            }
            case POW: {
                operationData = this.pow(data1, data2);
                break;
            }
            case MULTIPLY: {
                operationData = this.multiply(data1, data2);
                break;
            }
            default: {
                throw new IllegalArgumentException("The input function type does not exist.");
            }
        }
        return operationData;
    }

    public double[][] dataManipulation(double[][] data1, double[][] data2, String option) {
        return this.dataManipulation(data1, data2, OperationType.valueOf(option));
    }

    public FunctionType combotextToFunctionType(String combotext) {
        if (combotext.equalsIgnoreCase("reciprocal (1/x)")) {
            return FunctionType.RECIPROCAL;
        }
        if (combotext.equalsIgnoreCase("square (x^2)")) {
            return FunctionType.SQUARE;
        }
        if (combotext.equalsIgnoreCase("cubic (x^3)")) {
            return FunctionType.CUBE;
        }
        if (combotext.equalsIgnoreCase("absolute value")) {
            return FunctionType.ABS;
        }
        if (combotext.equalsIgnoreCase("arc cosine")) {
            return FunctionType.ACOS;
        }
        if (combotext.equalsIgnoreCase("arc sine")) {
            return FunctionType.ASIN;
        }
        if (combotext.equalsIgnoreCase("arc tangent")) {
            return FunctionType.ATAN;
        }
        if (combotext.equalsIgnoreCase("inverse hyperbolic cosine")) {
            return FunctionType.ACOSH;
        }
        if (combotext.equalsIgnoreCase("inverse hyperbolic sine")) {
            return FunctionType.ASINH;
        }
        if (combotext.equalsIgnoreCase("inverse hyperbolic tangent")) {
            return FunctionType.ATANH;
        }
        if (combotext.equalsIgnoreCase("cubic root")) {
            return FunctionType.CBRT;
        }
        if (combotext.equalsIgnoreCase("cosine")) {
            return FunctionType.COS;
        }
        if (combotext.equalsIgnoreCase("sine")) {
            return FunctionType.SIN;
        }
        if (combotext.equalsIgnoreCase("hyperbolic cosine")) {
            return FunctionType.COSH;
        }
        if (combotext.equalsIgnoreCase("cumulative maxima")) {
            return FunctionType.CUMMAX;
        }
        if (combotext.equalsIgnoreCase("cumulative minima")) {
            return FunctionType.CUMMIN;
        }
        if (combotext.equalsIgnoreCase("cumulative product")) {
            return FunctionType.CUMPROD;
        }
        if (combotext.equalsIgnoreCase("cumulative sum")) {
            return FunctionType.CUMSUM;
        }
        if (combotext.equalsIgnoreCase("exponential")) {
            return FunctionType.EXP;
        }
        if (combotext.equalsIgnoreCase("natural logarithm (base e)")) {
            return FunctionType.LOG;
        }
        if (combotext.equalsIgnoreCase("base 10 logarithm")) {
            return FunctionType.LOG10;
        }
        if (combotext.equalsIgnoreCase("inverse matrix")) {
            return FunctionType.INVERSE;
        }
        if (combotext.equalsIgnoreCase("inverse matrix")) {
            return FunctionType.INVERSE;
        }
        if (combotext.equalsIgnoreCase("matrix transpose")) {
            return FunctionType.TRANSPOSE;
        }
        if (combotext.equalsIgnoreCase("eigen analysis")) {
            return FunctionType.EIGEN;
        }
        if (combotext.equalsIgnoreCase("matrix determinant")) {
            return FunctionType.DET;
        }
        if (combotext.equalsIgnoreCase("hyperbolic sine")) {
            return FunctionType.SINH;
        }
        if (combotext.equalsIgnoreCase("sort")) {
            return FunctionType.SORT;
        }
        if (combotext.equalsIgnoreCase("square root")) {
            return FunctionType.SQRT;
        }
        if (combotext.equalsIgnoreCase("tangent")) {
            return FunctionType.TAN;
        }
        if (combotext.equalsIgnoreCase("hyperbolic tangent")) {
            return FunctionType.TANH;
        }
        return FunctionType.TORADIANS;
    }

    public OperationType combotextToOperationType(String combotext) {
        if (combotext.equalsIgnoreCase("+")) {
            return OperationType.ADD;
        }
        if (combotext.equalsIgnoreCase("-")) {
            return OperationType.MINUS;
        }
        if (combotext.equalsIgnoreCase("*")) {
            return OperationType.PROD;
        }
        if (combotext.equalsIgnoreCase("/")) {
            return OperationType.DIVIDE;
        }
        if (combotext.equalsIgnoreCase("^")) {
            return OperationType.POW;
        }
        return OperationType.MULTIPLY;
    }
}

