/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib;

import de.laures.cewolf.ChartValidationException;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.DatasetProducer;
import de.laures.cewolf.taglib.AttributeValidationException;
import de.laures.cewolf.taglib.DataAware;
import de.laures.cewolf.taglib.DataContainer;
import de.laures.cewolf.taglib.IncompatibleDatasetException;
import de.laures.cewolf.taglib.PlotConstants;
import de.laures.cewolf.taglib.PlotTypes;
import de.laures.cewolf.taglib.TaglibConstants;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;

public class PlotDefinition
implements DataAware,
Serializable,
TaglibConstants,
PlotConstants {
    private transient Log log = LogFactory.getLog(this.getClass());
    private String type;
    private String xAxisLabel;
    private String yAxisLabel;
    private DataContainer dataAware = new DataContainer();
    private transient Plot plot;
    private transient DrawingSupplier drawingSupplier = null;
    static /* synthetic */ Class class$org$jfree$data$xy$XYDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$IntervalXYDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$OHLCDataset;
    static /* synthetic */ Class class$org$jfree$data$category$CategoryDataset;

    public Plot getPlot(int chartType) throws DatasetProduceException, ChartValidationException {
        block9: {
            AbstractRenderer rend;
            Dataset data;
            int rendererIndex;
            block10: {
                this.log.debug((Object)("Plot.getPlot: chartType: " + chartType));
                if (this.plot != null) break block9;
                rendererIndex = PlotTypes.getRendererIndex(this.type);
                data = (Dataset)this.getDataset();
                this.log.debug((Object)("Plot.getPlot: data name: " + data.getClass().getName()));
                rend = PlotTypes.getRenderer(rendererIndex);
                this.log.debug((Object)("Plot.getPlot: rendererIndex: " + rendererIndex));
                if (chartType != 21 && chartType != 23) break block10;
                switch (rendererIndex) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        this.check(data, class$org$jfree$data$xy$XYDataset == null ? (class$org$jfree$data$xy$XYDataset = PlotDefinition.class$("org.jfree.data.xy.XYDataset")) : class$org$jfree$data$xy$XYDataset, rendererIndex);
                        this.plot = new XYPlot((XYDataset)data, null, null, (XYItemRenderer)rend);
                        break block9;
                    }
                    case 4: {
                        this.check(data, class$org$jfree$data$xy$IntervalXYDataset == null ? (class$org$jfree$data$xy$IntervalXYDataset = PlotDefinition.class$("org.jfree.data.xy.IntervalXYDataset")) : class$org$jfree$data$xy$IntervalXYDataset, rendererIndex);
                        this.plot = new XYPlot((XYDataset)((IntervalXYDataset)data), null, null, (XYItemRenderer)rend);
                        break block9;
                    }
                    case 6: 
                    case 7: {
                        this.check(data, class$org$jfree$data$xy$OHLCDataset == null ? (class$org$jfree$data$xy$OHLCDataset = PlotDefinition.class$("org.jfree.data.xy.OHLCDataset")) : class$org$jfree$data$xy$OHLCDataset, rendererIndex);
                        this.plot = new XYPlot((XYDataset)((OHLCDataset)data), null, null, (XYItemRenderer)rend);
                        break block9;
                    }
                    default: {
                        throw new AttributeValidationException(chartType + ".type", this.type);
                    }
                }
            }
            if (chartType == 22) {
                switch (rendererIndex) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: {
                        this.check(data, class$org$jfree$data$category$CategoryDataset == null ? (class$org$jfree$data$category$CategoryDataset = PlotDefinition.class$("org.jfree.data.category.CategoryDataset")) : class$org$jfree$data$category$CategoryDataset, rendererIndex);
                        this.plot = new CategoryPlot((CategoryDataset)data, null, null, (CategoryItemRenderer)rend);
                        break;
                    }
                    default: {
                        throw new AttributeValidationException(chartType + ".type", this.type);
                    }
                }
            }
        }
        this.plot.setDrawingSupplier(this.drawingSupplier);
        return this.plot;
    }

    public Object getDataset() throws DatasetProduceException {
        return this.dataAware.getDataset();
    }

    public String getXaxislabel() {
        return this.xAxisLabel;
    }

    public String getYaxislabel() {
        return this.yAxisLabel;
    }

    public void setXaxislabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public void setYaxislabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void check(Dataset data, Class clazz, int plotType) throws IncompatibleDatasetException {
        if (!clazz.isInstance(data)) {
            throw new IncompatibleDatasetException("Plots of type " + PlotTypes.typeNames[plotType] + " need a dataset of type " + clazz.getName());
        }
    }

    public void setDataProductionConfig(DatasetProducer dsp, Map params, boolean useCache) {
        this.log.debug((Object)("setDataProductionConfig(" + dsp + ", " + params));
        this.dataAware.setDataProductionConfig(dsp, params, useCache);
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        this.drawingSupplier = drawingSupplier;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

