/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.taglib.tags;

import de.laures.cewolf.CewolfException;
import de.laures.cewolf.ChartHolder;
import de.laures.cewolf.Configuration;
import de.laures.cewolf.Storage;
import de.laures.cewolf.WebConstants;
import de.laures.cewolf.taglib.ChartImageDefinition;
import de.laures.cewolf.taglib.TaglibConstants;
import de.laures.cewolf.taglib.html.HTMLImgTag;
import de.laures.cewolf.taglib.tags.CewolfRootTag;
import de.laures.cewolf.taglib.tags.Mapped;
import de.laures.cewolf.taglib.util.MIMEExtensionHelper;
import de.laures.cewolf.taglib.util.PageUtils;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.TagSupport;

public class ChartImgTag
extends HTMLImgTag
implements CewolfRootTag,
Mapped,
TaglibConstants,
WebConstants {
    private static final String DEFAULT_MIME_TYPE = "image/png";
    private static final String TAG_NAME_SVG = "EMBED";
    private static final int DEFAULT_TIMEOUT = 300;
    private String chartId = null;
    private String renderer;
    private String mimeType = "image/png";
    private int timeout = 300;
    protected String sessionKey = null;
    private ChartImageDefinition chartImageDefinition;

    public int doStartTag() throws JspException {
        ChartHolder chartHolder = PageUtils.getChartHolder(this.chartId, ((TagSupport)this).pageContext);
        this.chartImageDefinition = new ChartImageDefinition(chartHolder, this.width, this.height, 0, this.mimeType, this.timeout);
        Storage storage = Configuration.getInstance(((TagSupport)this).pageContext.getServletContext()).getStorage();
        try {
            this.sessionKey = storage.storeChartImage(this.chartImageDefinition, ((TagSupport)this).pageContext);
        }
        catch (CewolfException cwex) {
            throw new JspException(cwex.getMessage());
        }
        return 6;
    }

    public int doAfterBody() throws JspException {
        try {
            JspWriter writer;
            BodyContent body = this.getBodyContent();
            if (body != null && (writer = this.getPreviousOut()) != null) {
                body.writeOut((Writer)writer);
            }
        }
        catch (IOException ioex) {
            this.log.error((Object)ioex);
            throw new JspException(ioex.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        super.doStartTag();
        StringBuffer buffer = new StringBuffer(" src=\"");
        buffer.append(this.getImgURL());
        buffer.append("\"");
        try {
            ((TagSupport)this).pageContext.getOut().write(buffer.toString());
        }
        catch (IOException ioex) {
            this.reset();
            this.log.error((Object)ioex);
            throw new JspException(ioex.getMessage());
        }
        return super.doEndTag();
    }

    public static String fixAbsolutURL(String url, HttpServletRequest request) {
        if (url.startsWith("/")) {
            String context = request.getContextPath();
            url = context + url;
        }
        return url;
    }

    public static String fixAbsolutURL(String url, PageContext pageContext) {
        return ChartImgTag.fixAbsolutURL(url, (HttpServletRequest)pageContext.getRequest());
    }

    public static String buildImgURL(String renderer, PageContext pageContext, String sessionKey, int width, int height, String mimeType, boolean forceSessionId, boolean removeAfterRender) {
        renderer = ChartImgTag.fixAbsolutURL(renderer, pageContext);
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        StringBuffer url = new StringBuffer(response.encodeURL(renderer));
        if (url.toString().indexOf("jsessionid") == -1 && forceSessionId) {
            String sessionId = pageContext.getSession().getId();
            url.append(";jsessionid=" + sessionId);
        }
        url.append("?img=" + sessionKey);
        url.append("&amp;width=" + width);
        url.append("&amp;height=" + height);
        if (removeAfterRender) {
            url.append("&amp;removeAfterRendering=true");
        }
        url.append("&amp;iehack=" + MIMEExtensionHelper.getExtensionForMimeType(mimeType));
        return url.toString();
    }

    protected String getImgURL() {
        return ChartImgTag.buildImgURL(this.renderer, ((TagSupport)this).pageContext, this.sessionKey, this.width, this.height, this.mimeType, this.forceSessionId, this.removeAfterRender);
    }

    public Object getRenderingInfo() throws CewolfException {
        return this.chartImageDefinition.getRenderingInfo();
    }

    protected String getMimeType() {
        return this.mimeType;
    }

    protected void reset() {
        this.mimeType = DEFAULT_MIME_TYPE;
        int lHeight = this.height;
        int lWidth = this.width;
        int lTimeout = this.timeout;
        super.reset();
        this.height = lHeight;
        this.width = lWidth;
        this.timeout = lTimeout;
    }

    public void enableMapping() {
        this.setUsemap("#" + this.chartId);
    }

    public String getChartId() {
        return this.getChartid();
    }

    public void setChartid(String id) {
        this.chartId = id;
    }

    public String getChartid() {
        return this.chartId;
    }

    public void setRenderer(String renderer) {
        this.renderer = renderer;
    }

    protected String getRenderer() {
        return this.renderer;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setMime(String mimeType) {
        this.mimeType = mimeType;
    }

    protected String getTagName() {
        if ("image/svg+xml".equals(this.mimeType)) {
            return TAG_NAME_SVG;
        }
        return super.getTagName();
    }

    public void writeAttributes(Writer wr) {
        super.writeAttributes(wr);
        if ("image/svg+xml".equals(this.mimeType)) {
            try {
                this.appendAttributeDeclaration(wr, "http://www.adobe.com/svg/viewer/install/", "PLUGINSPAGE");
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

