<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://jakarta.apache.org/struts/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="http://jakarta.apache.org/struts/tags/struts-html" prefix="html" %>
<%@ taglib uri="http://sslext.sf.net/tags/sslext" prefix="ssl" %>
<%@ taglib uri="http://devel.cyclos.org/tlibs/cyclos-core" prefix="cyclos" %>
<%@ taglib uri="http://www.servletsuite.com/servlets/toggletag" prefix="t" %> 

<cyclos:script src="/pages/accounts/external/listExternalTransferTypes.js" />
<script>
var removeConfirmation = "<cyclos:escapeJS><bean:message key='externalTransferType.removeConfirmation'/></cyclos:escapeJS>";
var externalAccountId = ${externalAccount.id};
</script>

<table class="defaultTableContent" cellspacing="0" cellpadding="0">
    <tr>
        <td class="tdHeaderTable"><bean:message key='externalTransferType.title.list'/></td>
        <cyclos:help page="bookkeeping#external_transfer_type_list"/>
    </tr>
    <tr>
        <td colspan="2" align="left" class="tdContentTableLists">
            <table class="defaultTable">
                <tr> 
                    <th class="tdHeaderContents" width="50%"><bean:message key='externalTransferType.name'/></th>
                    <th class="tdHeaderContents" width="40%"><bean:message key='externalTransferType.action'/></th>                    
                    <th class="tdHeaderContents" width="10%">&nbsp;</th>
                </tr>                
				<c:forEach var="externalTransferType" items="${externalTransferTypes}">
	                <tr class="<t:toggle>ClassColor1|ClassColor2</t:toggle>">
	                    <td align="left">${externalTransferType.name}</td>
	                    <td align="left"><bean:message key='externalTransferType.action.${externalTransferType.action}'/></td>	                    
	                    <td align="center">
	                       	<c:choose><c:when test="${editable}">
	                    		<img externalTransferTypeId="${externalTransferType.id}" src="<c:url value="/pages/images/edit.gif" />" class="edit details typeDetails" />
	                    		<img externalTransferTypeId="${externalTransferType.id}" src="<c:url value="/pages/images/delete.gif" />" class="remove typeRemove" />
		                    </c:when><c:otherwise>
		                    	<img externalTransferTypeId="${externalTransferType.id}" src="<c:url value="/pages/images/view.gif" />" class="view details typeDetails" />
		                    </c:otherwise></c:choose>		                    	
						</td>
					</tr>
				</c:forEach>                
            </table>
        </td>
    </tr>
</table>
<c:if test="${editable}">

	<table class="defaultTableContentHidden" cellpadding="0" cellspacing="0">
		<tr>
			<td align="right">
				<span class="label"><bean:message key='externalTransferType.action.new'/></span>
				<input class="button" type="button" id="newButton" value="<bean:message key='global.submit'/>">
			</td>
		</tr>
	</table>
</c:if>