<div style="page-break-after: always;">
口座と取引に関連するすべての設定は、口座管理機能で行えます。
取引タイプ詳細
<i>見つけ方</i><br>
口座管理は「メニュー: 口座 &gt; 口座の管理」からアクセスできます。
<hr>


<A NAME="currencies"></A>
<h2>通貨</h2>
新しい通貨を作成して口座をその通貨に関連づけることができます。グループごとに標準の通貨を設定できます。

<i>見つけ方</i><br>
通貨は「メニュー: 通貨の管理」からアクセスできます。
<hr class="help">


<A NAME="currency_search"></A>
<h3>通貨</h3>
通貨リストページは、システム内に設定された通貨のリストを表示します。通貨は口座タイプに結びつけることができます。新しい通貨を追加するには、右下の「新しい通貨」をクリックしてください。<br>
通貨を消去または編集するには、リスト内のアイコンをクリックしなければなりません。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">通貨を修正するには、このアイコンをクリックしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">通貨を消去したいならば、このアイコンをクリックしてください。
</ul>
<hr class="help">


<A NAME="currency_details"></A>
<h3>通貨を修正する/新しい通貨を挿入する</h3>
通貨修正ページでは、通貨を定義できます。以下のフィールドを利用可能です:
<ul>
	<li><b>名称:</b> 内部名(どこにも表示されません)
	<li><b>シンボル:</b> ページ内に表示されます。たとえば、広告の価格フィールド内の通貨の後です。
	<li><b>パターン:</b> ここでは通貨の名称/シンボルとそれが表示される場所を設定できます。それは金額の前か後に記すことができます。金額の前にシンボルを表示する通貨(ドルのように)もあれば、金額の後にシンボルを表示する通貨もあります。通貨パターンはリストやメッセージに表示されます。<br>
シンボルは必ずしもブラウザによってサポートされていません。ユーロのシンボルがその例です。その場合、Unicodeのシンボルを使う必要があるかもしれません(例. &amp;euro;)。
	<li><b>説明:</b> 内部情報のためのものです(どこにも表示されません)。
</ul>
<hr class="help">
</span>


<hr>


<span class="admin broker"> <a name="accounts"></a>
<h2>口座</h2>
Cyclosにおける口座は、「システム」または「メンバー」のいずれかのタイプになります。
どちらのタイプも1つの通貨に関連しており、他の口座との間で移転できるユニットを含みます(これらの口座間の取引タイプが存在する場合)。<br>
メンバー口座と異なり、システム口座には関連づけられた所有者がいません。権限を持つ管理者はシステム口座から別のシステム口座やメンバー口座への支払いを行えます。<br>
メンバーはゼロ、1つ､または複数の関連するメンバー口座を持つことができ､彼自身の複数の口座の間や､他のメンバー口座やシステム口座に対して支払いを行えます。「メンバー」タイプの新しい口座が作成された場合、その口座にはまだ関連するメンバーがいません。メンバーが実際に口座タイプを使えるようにするには、以下のステップを行わなければなりません。
<ol>
	<li><b>口座をグループに割り当てる:</b> 口座をメンバーグループに割り当てることにより、そのグループのメンバーがその口座にアクセスできるようになります。これは<a href="${pagePrefix}groups#manage_groups"><u>グループ設定</u></a>から行えます。
	<li><b>取引タイプ:</b> メンバーがこの口座から支払いをしたり、この口座で支払いを受け取ったりすることを可能にするには、
「<a href="#transaction_types"><u>取引タイプ</u></a>」を作成して関連づける必要があります。これは口座タイプ設定のためのウィンドウと同じページにある取引タイプウィンドウで行えます。
	<li><b>権限:</b> もちろん、<a href="${pagePrefix}groups#manage_groups"><u>権限</u></a>を設定することも必要です。
</ol>

取引タイプのほかにも、ローン、取引手数料、口座手数料、支払いフィルタのように
多くのものが口座に直接関連づけられています。<br><br>Cyclosには<a href="#standard_accounts"><u>標準口座</u></a>のセットを含むデータベースが備わっています。それは大多数のユーザー/システムに適合するでしょう。<br><br><i>見つけ方</i><br>
口座は「メニュー: 口座 &gt; 口座の管理」から管理(作成、消去等)できます。<br>
システム口座は「メニュー: 口座 &gt; システム口座」で見られます。
<hr>


<a name="standard_accounts"></a>
<h3>標準の口座タイプ</h3>
一から完全に新しい口座構造を作成することも可能ですが、私たちは、大多数の補完通貨システムにとって標準的な口座を備えたデータベースを用意しました。標準のデータベースは、いつでも追加的な口座や取引タイプで拡張できます。<br><br>

私たちはメンバー口座と様々なシステム口座を作りました。
<a href="#account_fees"><u>口座手数料</u></a> 
(自動、手動、流動性税=「デマレージ」)と
<a href="#transaction_fees"><u>取引手数料</u></a>
は標準では無効ですが、標準値を変更してそれらを有効にするのは簡単です。
<br><br>データベースは以下の標準のシステム口座を備えています:
<ul>
	<li><b>ローン(デビット)口座:</b> デビット口座またはローン口座は、ローンや初期クレジット(ローンまたはギフト)のためにのみ使われます。それは主要なシステム口座であり、明瞭さのためにローン口座と呼ばれます(時折、この種の口座は「フロート口座」または「デビット口座」と呼ばれます)。デビット口座をマイナスの制限がない唯一の口座とするのが一般的です。この口座はユニットの作成のために必要です。ユニットが作成されると、ローン口座はマイナスになり、受取人(たいていはメンバー口座)は同じ額のユニットだけプラスになります。<br>
ローン口座の管理はしたがって非常に重大です。おそらく、LETSの種類のシステムにとってはさほどでもないですが、バーター(ビジネス)ソフトウェアや貨幣で裏付けられたシステムにとって、これは非常に堅牢で制御されていなければなりません。<br>
	<br>
	<li><b>コミュニティ口座:</b> コミュニティ口座は、コミュニティによって所有されている口座であり、
税(設定による)やメンバー寄付支払いの受け取りが可能です。管理者はコミュニティ口座からメンバー口座への(たとえば、メンバーによって行われたコミュニティの仕事のための)支払いを行えます。メンバー口座と同じように、コミュニティ口座はクレジット下限を下回ることができません。<br>
	<br>
	<li><b>バウチャー口座:</b> バウチャー口座は、バウチャー(物理的ユニット)として循環していた(デジタル)ユニットを含む口座です。メンバーがバウチャーを購入したい場合、メンバーはバウチャー口座に支払う必要があります。組織は支払いを確認してバウチャーを手渡すことができます。メンバーがバウチャーをユニットへと現金化したい場合、メンバーはバウチャーを組織に手渡す必要があり、
管理者はバウチャー口座からメンバー口座へと支払いを行わなければなりません。<br>
ユニットが(部分的に)伝統的な貨幣で裏付けられているシステムでは、バウチャーを伝統的貨幣と交換で販売できます。この場合、システムのメンバーになる必要はありません。あなたは一種の「ボーナスクーポン」としてバウチャーを購入するだけです。この場合、管理者はローン口座からバウチャー口座への支払いを行わなければなりません。<br>
	<br>
	<li><b>オーガニゼーション口座:</b> オーガニゼーション口座は、組織のための追加的な口座として機能します。必要ならば、その機能によって名称を変更できます(たとえば、ソーシャル口座や投資基金など)。
</ul>
<hr class="help">


<A NAME="account_search"></A>
<h3>口座リスト</h3>
口座タイプリストページは、口座とそのタイプのリストを含む概要を表示します。(したがって、時折これを口座タイプと呼びます。)
<br><br>新しいメンバー口座またはシステム口座を作成するには、
そのウィンドウの下の「新しい口座タイプを挿入する」というラベルの「送信」ボタンをクリックしなければなりません。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">口座を修正するにはこのアイコンをくりっくしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">口座を消去するにはこのアイコンをクリックしてください。(口座の消去は、その口座のための取引がシステム内に存在しない場合にのみ行えます。)
</ul>
<hr class="help">


<A NAME="account_details"></A>
<h3>口座タイプを修正する/新しい口座</h3>
口座詳細ウィンドウでは、新しいメンバー口座を作成または修正できます。<br>
新しい口座を作成する場合、システム口座にするかメンバー口座にするかを指定できます。以下のオプションが利用可能です:
<UL>
	<li><b>名称:</b> 口座の名称。これは<a href="#account_search"><u>口座リストの管理</u></a>に表示され、
(システム口座の場合は)<a href="${pagePrefix}payments#account_overview"><u>システム口座概要リスト</u></a>に表示されます。
	<li><b>説明:</b> 口座の説明(管理者だけが読めます)。
	<li><b>通貨:</b> ここではこの口座のための<a href="#currencies"><u>通貨</u></a>を設定します。
	<li><b>制限タイプ(システム口座のみ):</b> 口座は無制限にすることができます。
それは無制限にマイナスになり得るということを意味します(これはたいてい「デビット」、「フロート」、または「ローン」口座です。)<br>
口座が制限されている場合、クレジット上限とクレジット下限を指定できます。制限タイプは口座作成時にのみ指定できます(後から変更することはできません)。
</UL>
注:多くの口座設定はグループ固有のものです(たとえば、クレジット制限がそうです)。これらの設定は<a href="${pagePrefix}groups#manage_groups"><u>ユーザーグループ設定</u></a>で修正できます。
<hr>


<A NAME="transaction_types"></A>
<h2>取引タイプ</h2>
各支払い(取引とも呼ばれます)には「取引タイプ」があります。取引タイプは、支払いの移転元口座タイプと移転先口座タイプを定義します。口座タイプに関連づけられた取引タイプがない場合、支払いを行うことはできません。取引タイプは移転元口座(=支払人の口座)に関連づけられていなければなりません。<i>見つけ方</i><br>
取引タイプは口座管理ウィンドウで定義、修正できます。
「メニュー: 口座 &gt; 口座の管理」とたどるとそのウィンドウに行けます。
口座タイプを修正するには編集アイコンをクリックしてください。次の画面には、関連づけられた取引タイプの概要を示す専用のウィンドウがあります。
<hr class="help">


<A NAME="transaction_type_search"></A>
<h3>取引タイプリスト</h3>
取引タイプウィンドウは、選択された口座に関連する取引タイプのリストを表示します。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">取引タイプを修正するにはこのアイコンをクリックしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">取引タイプを消去したい場合は、このアイコンをクリックしてください。
</ul>
新しい取引タイプを挿入するには、下の「新しい取引タイプを挿入する」ボタンを使ってください。<br><br>注1: 取引タイプの権限はグループごとに定義されており、「メニュー: ユーザー &amp; グループ &gt; 権限グループ &gt; グループ権限を編集する」で設定できます。
<br><br>注2:選択された口座がメンバー口座の場合、具体的な口座設定(クレジット制限など)はグループごとに定められます。これらは「ユーザー &amp; グループ - 権限グループ」セクション(編集アイコン - 口座の選択でも修正できます。
<hr class='help'>


<A NAME="transaction_type_details"></A>
<h3>取引タイプを修正/挿入する</h3>
このウィンドウで具体的な取引タイプの属性を設定できます。取引タイプには以下のフィールドがあります(タイプと設定によっては見えないフィールドもあるかもしれません):
<ul>
	<li><b>名称:</b> 取引タイプの名称。<br>
	<br>
	<li><b>説明:</b> 取引タイプの内的説明です。この説明は、顧客が画面上で見る取引詳細の中に現れるかもしれません。<br>
	注: ローン返済と定期的な手数料の場合、特定のコードを使ってこの説明の中に具体的なデータを含めることができます。「プレースホルダ」を使うことができ、それらは最終的な取引説明の中では対応する値によって置き換えられます。<a href="#placeholders">
概要については<u>ここをクリック</u></a>してください。<br>
	<br>
	<li><b>確認メッセージ:</b> 
このメッセージは確認ポップウィンドウの取引情報の下に表示されます。この方法により、特定の支払いタイプのためのメッセージを設定することが可能です。<br>
	<br>
	<li><b>移転元:</b> 支払人の口座タイプ。<br>
	<br>
	<li><b>移転先:</b> 受取人の口座タイプ。<br>
	<br>
	<li><b>固定された移転先メンバー:</b> この取引タイプの宛先を常に同じメンバーにしたいならば、ここでメンバーを選んでください。これは稀な場合であることに注意してください。たいてい、これが使われるのは、ルールおよび/またはカスタム支払いフィールドをメンバーグループではなく特定のメンバーに結びつけたい場合です。<br>
	複数の(メンバーからメンバーへの)支払いタイプがある場合、あなたは優先順位オプション(以下で説明)を使って支払いを隠せます。宛先メンバーが固定されている場合、優先順位設定を空欄のままにすることにより、通常のメンバー間支払いを隠せます。
	<br>
	<br>
	<li><b>利用可能性:</b> (メンバー口座間の支払い専用 - あなたのメンバーがこの通貨で1つの口座しか持たない場合、このオプションは見えません。そのような場合、「有効」チェックボックス(次の項目)が表示されます。)
利用可能性は支払いがどこから行われうるかを定めます。
	<ul>
		<li><b>無効:</b> 支払いは非アクティブであり、もう表示されません。
		<li><b>他者への支払い:</b> これは最も一般的な支払いタイプです。このオプションが選択されると、メンバーはこの取引タイプを使って、別のメンバーまたはシステム口座への支払いを行えます。
		<li><b>自己支払い:</b> 複数のメンバー口座タイプ(たとえば、当座預金口座と預金口座)が存在する場合、メンバーがそれらの口座間で支払いを行えるように取引タイプを作成できます。自己支払いの場合、おそらく、あるメンバーの当座預金口座から別のメンバーの預金口座への支払いは許したくないでしょう。これは直接支払いチェックボックスの選択を外すことによって行えます。
	</ul>
	注!:口座手数料や取引手数料のように自動的に生成される取引タイプは、たとえこの概要でどのオプションもチェックされず、そのメンバーグループに対してどの権限も設定されていなくても、常に賦課されます。これは次の項目である「有効」チェックボックスについても同じです。 <br>
	<br>
	<li><b>有効:</b> この取引タイプで支払いを行うことができ、その支払いタイプは支払いウィンドウと取引概要の中で見えます。この項目は前の項目と相互に排他的であることに注意してください:
	「利用可能性」が表示されている場合、「有効」は表示されず、逆もまた同様です。<br>
	<br>
	<li><b>チャネル:</b> この項目によってこのタイプが使われる<a href="${pagePrefix}settings#channels"><u>チャネル</u></a>を定められます。標準のチャネルは「メインWebアクセス」ですが、他のチャネル(携帯電話のような)も利用可能です。 phone) are available to.<br>
	<br>
	<li><b>優先:</b> 優先オプションが選択されている場合、その取引タイプが他の取引タイプよりも優先されます。支払いが複数の取引タイプを表示する場合、優先設定を持つ取引タイプのみが表示されます。しかし、どの支払いも優先に設定されていない場合、すべてが表示されます。<br>
優先設定は、様々なグループが一部の状況下でのみ他のグループと取引を許される比較的複雑なシステムでのみ使われます。<br>
グループと取引タイプを使えば、様々なコミュニティが独立に取引するが、同じシステム内で相互にも取引できるシステムを築くことが可能です。<br>
この設定は、上で説明された「固定されたメンバー」オプションと組み合わせても使えます。 <br><br>
	<li><b>日ごとの最大額:</b> これはこの取引タイプでメンバーごとに日ごとに支払える最大額です。　たとえば、これは携帯電話で行われる支払いを制限するために使えます。<br>
	<br>
	<li><b>Javaクラスを実行する:</b> 設定によって行うことができない特定の振る舞いや機能が必要な場合は、自分でJavaクラスを作成できます。そのクラスはこの取引タイプの支払いが処理される度に発動されます。<br><br>
	<b>注1:</b>  
	そのクラスは「処理済み」の支払いに対してのみ発動されます。つまり、その支払いが将来の日付にスケジュールされているか、認可待ちで保留中の場合、それは発動されません。(しかし、スケジュールされた支払いまたは認可された支払いが最終的に処理されると、そのクラスが発動されます。)<br><br>
	<b>注2:</b>
	そのクラスがサーバークラスパス、たとえばWEB-INF/lib上で利用可能であることを確認してください。
	<br><br>
	<b>注3:</b> すべての支払いタイプに関してクラスを発動することも可能です。これは<a href="${pagePrefix}settings#local"><u>ローカル設定</u></a> - その他 - 処理された支払いのためのJavaクラスで設定できます。
	<br>
	<br>
	<li><b>認可を必要とする:</b> 選択されると、初回時に保存する時にこのウィンドウの下に追加的な認可ウィンドウが現れます。<a href="${pagePrefix}payments#authorized"><u>認可された支払い</u></a>についての詳細な情報は、
<a href="#authorized_payment_levels"><u>そのウィンドウ</u></a>のヘルプの中で見つけられます。<br>
	認可オプションの選択を解除すると、新しい支払いのためのあらゆる認可レベルがキャンセルされます。 <br>
	<br>
	<li><b>スケジュールされた支払い(割賦金)を許可する:</b> このオプションが選択されると、
このタイプの取引を<a href="${pagePrefix}payments#scheduled"><u>スケジュール</u></a>することができます。この取引タイプを持つどのメンバーや管理者も自動的にスケジュールオプションを使えるようになるというわけではありません。さらにグループごとに権限(スケジュールされた支払いを見る/許可する)を設定する必要があります。詳しくは、マニュアル - 支払い - スケジュールされた支払いを参照してください。
	<ul>
		<li><b>スケジュールされた支払いの全額を留保する:</b> 
このオプションが選択されると、メンバーはすべての割賦金の全額が残高上で利用可能な場合にのみ支払いをスケジュールできます。全額が留保され支出できません。<br>
取引システム内のメンバー間の一般的な支払いについては、この設定はおそらく使われません。消費者からビジネスへの支払い、たとえば、POS (point os sale)での支払いについては、この設定はより一般的でしょう。
		<li><b>支払人にスケジュールされた支払いのキャンセルを許可する:</b> 
このオプションが選択された場合、支払人はスケジュールされた支払いをキャンセルできます。この設定とは別に、支払人のグループが、スケジュールされた支払いをキャンセルする権限を持つ必要がああります。
		<li><b>支払人にスケジュールされた支払いのブロックを許可する:</b> 
このオプションが選択された場合、支払人はスケジュールされた支払いをブロックできます。	この設定とは別に、支払人のグループがスケジュールされた支払いをブロックする権限を持つ必要があります。
		<li><b>宛先へのスケジュールされた支払いを表示する:</b> 
スケジュールされた支払いは支払人によって開始されます。受取人にとっては、どの単一の割賦金も分離された支払いとして現れます。受取人は割賦金が支払いのグループの一部であると気づいていません。<br>
受取人に将来の(これからやって来る)スケジュールされた支払いを見せたい場合は、このオプションをチェックする必要があります。<br>
		この設定はPOS (point of sale)での支払いのように消費者からビジネスへの場合により一般的です。<br>
		承諾された請求書の結果であるスケジュールされた支払いは、常に受取人(請求書の送信者)に表示されることに注意してください。
	</ul>
	<br>
	<li><b>調停可能:</b> このオプションがチェックされた場合、この取引タイプは調停機能の一部となります。詳しくは、簿記/調停機能の<a href="${pagePrefix}bookkeeping"><u>ヘルプファイル</u></a>を参照してください。. <br>
	<br>
	<li><b>ローンである:</b> (システムからメンバーへの支払いについてのみ利用可能)
	取引タイプがローンの場合、このチェックボックスをチェックしてください。このボックスをチェックすると、ローン設定が現れます。
詳しくは、<a href="${pagePrefix}loans#make_loan_type"><u>ここをクリック</u></a>してください。 <br>
	<br>
	<li><b>取引に関するフィードバックを要求する:</b> 
このオプションはメンバーからメンバーへの支払いについてのみ利用可能です。このオプションがチェックされた場合、メンバーはこのタイプの実行された取引に対してフィードバックを設定できます。フィードバックについて詳しくは、<a href="${pagePrefix}transaction_feedback">ヘルプページ</a>を参照してください。<br>
	以下の要素は、「フィードバックを要求する」チェックボックスがチェックされた場合にのみ見えます:
	<ul>
		<li><b>最長フィードバック期間:</b> 支払いが行われた時、支払人(=購入者)はフィードバックを設定できる最長期間を持ちます。この期間はこの設定で指定できます。
		<li><b>最長フィードバック返信コメント期間:</b> フィードバックの受取人(販売者)がフィードバックに返信できます。この最長期間はこの設定で指定できます。
		<li><b>期限切れ時のフィードバックレベル:</b> フィードバックが期限切れになると、標準のフィードバックが作成されます。この設定で標準のレベルを指定できます(これは典型的には「中立的」のようなものです)。
		<li><b>期限切れ時のフィードバックコメント:</b> フィードバックが期限切れになると、標準のフィードバックが作成されます。この設定で標準のコメントを指定できます(これは典型的には「追加のフィードバックなし」のようなものです)。
	</ul>
</ul>
<hr class="help">


<a name="placeholders"></a>
<h3>説明フィールドのためのプレースホルダ</h3>
ローン返済と定期的な手数料の場合、特定のコードを使って<a href="#transaction_types"><u>取引タイプ</u></a>の説明の中に具体的なデータを含めることができます。「プレースホルダ」を使えます - それらは最終的な取引説明の中では対応する値によって置き換えられます。<br><br><b>ローン返済:</b>
<ul>
	<li><b>#loanAmount#:</b> 元のローン額。
	<li><b>#loanTotalAmount#:</b> ローン額プラス費用(利子、ローン許可手数料)。
	<li><b>#parcelAmount#:</b> ローン構成要素の額、特定のローン期間における額。ローンは一定数の返済構成要素へと分割されます。
	<li><b>#parcelNumber#:</b> ローン構成要素の数。ローンは一定数の返済、「構成要素」へと分割されます。
	これらの構成要素の各々がそれ自体の数を持ちえます。
</ul>
ローンについて詳しくは、<a href="${pagePrefix}loans"><u>ローンヘルプ</u></a>を見てください。
<br><br><b><a href="#account_fees"><u>定期的手数料</u></a></b>
<ul>
	<li><b>#begin_date#:</b> 開始日時(<a href="#account_fees"><u>流動性税</u></a>の場合のみ)
	<li><b>#end_date#:</b> 終了日時(流動性税の場合のみ)
	<li><b>#tax#:</b> = 額
	<li><b>#freebase#:</b> フリーベース、支払われるべき税がない基本額です(流動性税の場合のみ)
	<li><b>#volume#:</b> = 合計取引量(流動性税の場合のみ)
	<li><b>#result#:</b> = 結果
</ul>
<br><br><b><a href="#transaction_fees"><u>取引手数料</u></a></b>
これらは手数料それ自体の説明ではなく、手数料の取引タイプの説明に入力されるべきであことに注意してください。
<ul>
	<li><b>額</b>:手数料の値。パーセンテージ手数料の場合、パーセンテージ(%記号を含む)、あるいは固定的な手数料の場合、金額。
	<li><b>#fee_amount#</b>: 上に同じ。
	<li><b>#member#</b>: 支払いをするメンバー。
	<li><b>#transfer#</b>: この手数料を発動した元の移転の合計額。
	<li><b>#original_amount#</b>: 上に同じ。
	<li><b>#amount#</b>: この手数料に関して支払われる額のローカライズされた表現。固定された手数料の場合、これは#fee#と同じですが、パーセンテージ手数料の場合、これは取引額の#fee#倍です。

</ul>
<hr class="help">


<br><br><A NAME="payment_fields_list"></A>
<h3>カスタム支払いフィールド</h3>
メンバープロフィールや広告にカスタムフィールドを設定できるように、取引(支払い)タイプにカスタムフィールドを追加することが可能です。支払いフィールドは、現在の取引タイプ(あなたが現在編集しているもの)についてのみ見えます。<br>
あなたはカスタム支払いフィールドのタイプを作成できます:
<ul>
	<li><b>新しいカスタムフィールドを挿入する:</b> このオプションにより、(たとえば)メンバープロフィールに課すタームフィールドを設定するのと同じように、支払いタイプにカスタムフィールドを設定できます。
	<li><b>既存のカスタムフィールドをリンクする:</b> このオプションにより、既存の支払いフィールドにリンクできます。これに関する詳細な情報は、カスタム支払いフィールド詳細リンクで見つけられます。
</ul>
<hr class="help">


<br><br><A NAME="payment_fields_link"></A>
<h3>カスタム支払いフィールドをリンクする</h3>
より複雑なシステムでは、取引が「転送される」のが一般的です。これは通常、100%を賦課し第3者の宛先口座を持つ取引手数料を使うことによって行われます。この場合、両方の支払いのために同一のカスタムフィールドを使いたいかもしれません。これを行うことにより、元の取引タイプにカスタム支払いフィールドを作り、(オプション「既存のカスタムフィールドをリンクする」を使うことにより)
第2の(生成された)取引タイプにカスタム支払いフィールドへのリンクを作成できます。
</ul>
<hr>


<br><br><A NAME="authorized_payment_levels"></A>
<h3>認可レベル</h3>
この機能によって、<a href="${pagePrefix}payments#authorized"><u>
認可</u></a>を必要とする支払いタイプのために、複数の認可レベルを定義できます。
<br><br>様々なレベルの認可が可能であり、支払いタイプごとに複数の認可レベルが存在できます。これは様々な人物がそれを(おそらくは)異なる基準で認可する必要があることを意味します。メンバーと認可者(仲介人または管理者)の両方が、認可を必要とする保留中の支払いのリストにアクセスできます。<br><br>このウィンドウはその取引タイプのためのすべての認可レベルを表示します。利用可能なものがない場合、「新しい認可された支払いレベル」をクリックしなければなりません。なぜなら、各々の認可された支払いタイプのために少なくとも1つの認可レベルを定義しなければならないからです。新しいレベルを追加するとリスト内に表示されます。<br>
レベルがすでに定義されている場合、以下のオプションがあります:
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">認可された支払いレベルを修正するには、このアイコンをクリックしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16"> 認可された支払いレベルを消去したいならば、このアイコンをクリックしてください。
</ul>
<br><br>取引タイプで認可オプションの選択を外すと、取引タイプのためのすべての認可が無効になります。認可レベルは消えますが、履歴内に残ります。認可チェックボックスが取引タイプ設定で再びチェックされると、認可レベルが再び現れます。<br><br>認可支払いが他の支払い(たとえば、ローン返済、税，手数料などのあるローン)を生成する場合、支払いのグループ全体は全体として認可できます(そして、合計額が認可されるまでブロック/留保されます)。
<hr class="help">


<A NAME="edit_authorization_level"></A>
<h3>認可レベルを編集する</h3>
このウィンドウでは、<a href="#authorized_payment_levels"><u>認可のレベル</u></a>を定義できます。最大で5つの認可レベルを定義できます。各レベルが認可「タイプ」を持ち得ます。どの認可が利用可能かは認可レベルに依存します。
<ul>
	<li><b>受取人:</b> 認可タイプが「受取人」の場合、支払いを受け取る(宛先)メンバーはまず支払いを認可しなければなりません。受取人が支払いを認可すると(保留中の認可された支払いのリストから「承認」をクリックすることにより)、その額は移転されて状態は「保留中」から「認可済み」に移行します。<br>
この認可タイプは非常に稀です。<a href="${pagePrefix}invoices">請求書</a>がシステム内で使われている場合、このオプションを使わないことを提案します。請求書が類似の機能を提供します。
	<li><b>支払人:</b> このオプションは、「受取人」認可タイプに第1のレベルオプションがある場合にのみ利用可能です。<br>
	それは「受取人」認可タイプの後に追加的な(オプションの)認可レベルを設けます。このタイプが設定されている場合、支払いは受取人が認可した後に保留中状態にとどまります。ここで支払人(取引開始者)は支払いを承諾しなければなりません。完了すると、その額が移転されます。
	<li><b>仲介人/管理者:</b> この認可レベルは、受取人タイプのレベルの後の第1レベルまたは第2レベルのいずれかとして設定されます。つまり、支払いを行ったメンバーの<a href="${pagePrefix}brokering"><u>仲介人</u></a>は支払いを認可する必要があり、オプションによっては管理者も認可する必要があります。<br>
	仲介者に加えてその支払いを認可できる管理者グループを選択できます。誰が認可できるかについては優先順位はありません。
	仲介人または管理者のいずれかが認可できます。
	<li><b>管理者:</b> この認可タイプは仲介人/管理者の後の第1レベル、第2レベル、支払人や他の管理者のみのタイプの後の第3レベルとして利用可能です。<br>
	つまり、様々なレベルの管理者認可レベルタイプを異なる額やグループとつなげることができます。支払いを認可できる管理者グループを選択する必要があります。
</ul>
各々の認可タイプや認可レベルについて額を指定する必要があります。その支払いが常に認可されるようにしたい場合、金額フィールドにゼロを入力できます。金額、たとえば1000を入力すると、メンバーが24時間に1000以上を支払った場合、超過する支払いは認可される必要があることを意味します。<br>
認可レベルの額は、その親レベルかそれ以上のレベルと同じ額にすることができます。
<hr>


<A NAME="payment_filters"></A>
<h2>支払いフィルタ</h2>
移転タイプを「支払いフィルタ」へとまとめることが可能です。
これらのフィルタによって、特定の関連した取引タイプを便利にグループ化することが可能です。たとえば、取引概要ウィンドウや統計のために使います。例:様々な種類の寄付と他の特定のコミュニティ支払いを「コミュニティ支払い」という名前の1つのフィルタへとグループ化できます。支払いフィルタはカスタマイズされたレポートを作成するために使えます。管理者にとって、支払いフィルタは支払いを取得して具体的なレポートを得るための優れたツールになります。「メニュー: 口座 &gt; 口座の管理」で口座タイプを選び、編集<img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;アイコンをクリックしてください。
他のウィンドウに加えて、関連する支払いフィルタが書かれた特別なウィンドウがあります。
<hr class="help">


<A NAME="payment_filter_search"></A>
<h3>支払いフィルタリスト</h3>
このウィンドウは口座に関連する<a href="#payment_filters"><u>支払いフィルタ</u></a>のリストを表示します。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16"> 支払いフィルタを修正するには、このアイコンをクリックしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">支払いフィルタを消去したい場合は、このアイコンをクリックしてください。
</ul>
新しいフィルタを作成したいならば、そのウィンドウの下にある「新しい支払いフィルタを挿入する」というラベルのついた「送信」ボタンをクリックしなければなりません。
<hr class="help">

<A NAME="payment_filter_details"></A>
<h3>支払いフィルタを修正/挿入する</h3>
ここでは既存の<a href="#payment_filters"><u>支払いフィルタ</u></a>を修正するか、新たに挿入することができます。以下のフィールドを設定できます:
<ul>
	<li><b>フィルタ名</b>: フィルタの名称。
	<li><b>説明</b>:フィルタの説明。
	<li><b>口座履歴に表示する</b>: このボックスがチェックされると、そのフィルタは口座履歴(選択された口座の)に表示されます。
	<li><b>レポート内に表示する</b>: 「レポート内に表示する」チェックボックスにチェックすると、<a href="${pagePrefix}reports"><u>
レポート機能</u></a>はこのフィルタについてのレポートを含みます。それはその支払いフィルタに関連するすべての取引の合計額を表示します。それは<a href="${pagePrefix}statistics"><u>統計モジュール</u></a>でも利用可能です。<br>
	レポート機能のみのために支払いフィルタを作成することもできます。これを行うには、「口座履歴に表示する」チェックボックスの選択を外さなければなりません。
	<li><b>取引タイプ</b>: ここではフィルタ内に含まれる<a href="#transaction_types"><u>取引タイプ</u></a>を選ばなければなりません。
	<li><b>グループ可視性</b>: ここでは支払いフィルタを見ることができるグループを選択できます。この方法で異なるグループに異なるフィルタを作成することが可能です。たとえば、仲介人グループは「委託手数料支払い」フィルタを持つことができます。管理者には通常、もっと具体的な支払いフィルタが必要であり、メンバーグループはたとえば以下のような基本的な支払いフィルタを持ちます:トレード
	取引 - 税 &amp; 手数料。
</ul>
<hr>


<A NAME="transaction_fees"></A>
<h2>取引手数料</h2>
口座手数料とは異なり、取引手数料は手動またはスケジュールで賦課することはできません。それは別の取引が生じた時に自動的に賦課されます。したがって、取引手数料は別の取引の「内部で」設定されます(以下の「見つけ方」を見てください)。<br>
手数料を計算する方法(固定、パーセンテージなど)、誰が賦課されるかを定める方法は様々です。<br>
<br>
手数料の典型的な例は、トレードに対する「通常の」取引手数料です。「トレード」取引が行われる度に、その手数料が(設定されていれば)適用されます。手数料の詳細は元の(発動する)取引を表示します。<br>
1つの取引に複数の手数料を付すことができます。取引手数料には多くの設定オプションがあります。口座手数料には、様々な支払い方向(メンバーからメンバーへ、メンバーからシステムへ、システムからメンバーへ等)があり得ます。誰が賦課され誰が受け取るかを定める様々な方法があります。手数料を適用する多くの方法があるので、それは必ずしも「手数料」ではありません。たとえば、手数料を使って、支払いを他の口座に(パーセンテージオプションを使って)「転送」したり「分配」したりすることが可能です。<i>見つけ方</i><br>
取引手数料は常に<a href="#transaction_types"><u>取引タイプ</u></a>に「帰属」します。したがって、取引手数料の設定は取引タイプ設定の中にあります。「メニュー: 口座 &gt; 口座の管理」に行き、(編集アイコンから)口座を選んでください。取引タイプウィンドウに行き、(編集アイコンから)取引タイプを選んでください。ここで関連する取引手数料が書かれた特別なウィンドウを見つけられます。
<hr class="help">


<A NAME="transaction_fee_search"></A>
<h3>取引手数料</h3>
このウィンドウは関連する<a href="#transaction_types"><u>取引タイプ</u></a>についての関連する<a href="#transaction_fees"><u>
取引手数料</u></a>のリストを表示します。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">取引手数料を修正するには、このアイコンをクリックしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16"> 取引手数料を消去したい場合は、このアイコンをクリックしてください。
</ul>
新しい取引手数料を作成したい場合は、そのウィンドウの下にある「新しい取引手数料を挿入する」というラベルのついた「送信」ボタンをクリックしなければなりません。
<hr class="help">


<A NAME="transaction_fee_details"></A>
<h3>取引手数料を修正/挿入する</h3>
このウィンドウは既存の<a href="#transaction_fees"><u>
取引手数料</u></a>を修正するか、新しい取引手数料を定義するために使われます。<br>
取引手数料は特定の取引が生じた時に生成されます。しかし、手数料はそれ自体も取引なので、それ自体の取引タイプも必要とします。新しい手数料を設定する前に、まず、その手数料のための新しい<a href="#transaction_types"><u>取引タイプ</u></a>を作成しなければなりません。
<br><br><b>フィールド:</b>

<ul>
	<li><b>取引タイプ</b>: これは取引手数料が発動される際の取引タイプです。トレード取引に対する手数料については、典型的に「トレード」のようなものを選ぶでしょう。<br>
	<li><b>名称</b>: 手数料の名称。<br>
	<li><b>説明</b>:手数料の説明。この説明は、顧客/メンバーが自分の取引詳細の中で見る説明ではないことに注意してください。後者については、この手数料に帰属する取引タイプの説明フィールドを見てください。<br>
	<li><b>有効</b>:チェックすると、その手数料がアクティブになります。チェックしない場合、その手数料は賦課されず、システムはそれが存在しないかのように振る舞います。<br>
	<li><b>賦課対象者</b>: ここでは誰が賦課されるかを定義できます。様々なオプションがあります。 仲介人が設定された場合、その手数料が賦課されるにはそのメンバーに仲介人がいなければならないことに注意してください。<br> 
	<li><b>受け取り予定者</b>: ここではその手数料を誰が受け取るかを定められます。様々なオプションがあります。 仲介人が設定されている場合、手数料が受け取られるにはそのメンバーに仲介人がいなければならないことに注意してください。<br>
	<li><b>任意の口座を許可する</b>: 通常、次の編集欄(「生成される取引タイプ」)では、同一通貨の関連する取引タイプのみが表示されます。このチェックボックスを選択すると、取引手数料を適用する際の通貨に制限はありません。別の通貨のものでさえもすべての取引タイプが表示されます。
	<br>
	<li><b>生成される取引タイプ</b>:ここではどの取引タイプが生成されるか、つまり、その手数料自体の取引タイプを定められます。それに関して(たとえば、口座履歴: 手数料と税において)フィルタできるように、これのための特定の取引タイプを作成するのが一般的です。標準のデータベースには、取引手数料とその取引手数料のための取引タイプが備わっています。トレード取引に対する手数料は、「取引税」のように呼ばれます。<br>
	手数料を作成できるようになるには、先にこの取引タイプを作成しておくことが絶対に必要ですので注意してください(このリストの上の注を見てください)。<br>
	<li><b>賦課タイプ</b>: これは手数料が計算される方法を指定します。 以下のタイプが可能です:
	<ul>
		<li><b>固定値</b>: 手数料は常に同じ値をとります。この値は次の「賦課値」という編集欄で入力できます。
		<li><b>パーセンテージ</b>: 手数料はそれを生成する取引の額のパーセンテージとして賦課されます。次の「賦課値」という編集欄にそのパーセンテージを入力できます。
	</ul>
	<br>
	<li><b>賦課値</b>: ここでは手数料の額(前の編集欄で「固定」を選んだ場合)を記入するか、パーセンテージ(前の編集欄で「パーセンテージ」を選んだ場合)を記入することができます。 
	<li><b>控除</b>: このフィールドは「賦課タイプ」「固定」または「パーセンテージ」の場合にのみ見えます。<br>
	この設定により、取引手数料が元の支払いに対する「追加的な」支払いとして計算されるか、あるいは、元の支払いの合計額から「控除」されるかを定められます。<br>
	これは一例を示して説明できます。100の支払いが行われ、合計額から3の手数料が控除されるように設定された場合、以下の支払いが生成されます:
	<ul>
		<li>主な(手数料を発動する)取引97
		<li>手数料: 3
	</ul>
	上の場合は非常に稀です。通常、手数料は合計額から控除されません。同額で控除されない手数料がある例:
	<ul>
		<li>主な(手数料を発動する)取引 100
		<li>手数料: 3
	</ul>
	<br>
	<li><b>適用可能性の条件</b>: ここではその手数料がどのような条件の下で適用されるかを定められます。その手数料は条件が合致する場合にのみ適用されます。その条件は、組み合わされたものにすることができます。
	<ul>
		<li><b>次の額より大きいか等しい</b>: 手数料はそれを発動する取引の取引額が指定された額よりも大きいか等しい場合にのみ賦課されます。
		<li><b>次の額より小さいか等しい</b>: 手数料はそれを発動する取引の取引額が指定された額よりも小さいか等しいときにのみ賦課されます。
		<li><b>すべてのグループから</b>: すべてのグループが選択された場合、その手数料は、手数料を発動する取引タイプの支払人と考えられる任意のグループのメンバーに適用されます。その手数料を特定のグループにのみ適用したいならば、「すべてのグループから」チェックボックスのチェックを外し、そうすると現れるマルチ選択コンボ内のグループを選択する必要があります。
		<li><b>すべてのグループへ</b>: 前の項目と同じですが、これは手数料を発動する取引タイプの受取人であるメンバーについての項目です。
	</ul>
</ul>
<hr class="help">




<A NAME="account_fees"></A>
<h2>口座手数料</h2>
しばしば「寄付」と呼ばれる「口座手数料」は、定期的にスケジュールされるか、管理者によって手動で実行されます。口座手数料は1つの口座に関連しており、1つまたは複数のメンバーグループについてアクティブ化できます。口座手数料が実行される時、口座手数料設定の中で選択されたすべてのメンバーグループは賦課されます。ただし、「手数料」と聞くとメンバーが支払うかのようですが、口座手数料はシステム口座が支払ってメンバーが手数料を受け取るようにも設定できます。典型的な口座手数料は、メンバーからシステム口座への月ごとの寄付支払いです(しかし、それは正反対の方向にすることもできます)。別の例は一種の「マイナス利子」である「デマレージ」または「流動性税」です。その場合、ユーザーは時間の経過とともに彼らのプラスの残高に対して手数料を支払います。この背景にある考えは、それによって人々は彼らの残高を口座上に取っておくのではなく使うように奨励されるということである。<br><br>
<i>見つけ方</i><br>
口座手数料は口座タイプに関連しているので、それらの設定は口座の管理から行われます: 「メニュー: 口座 &gt; 口座の管理」で口座タイプを選び、編集<img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;アイコンをクリックしてください。
<br><br>口座手数料の管理と概観は、口座概要ページ(「メニュー: 口座 &gt; 口座手数料」)から行われます。そのページではすべての口座手数料とそれらの状態をを概観でき、手動で口座手数料を賦課することもできます。
<hr class="help">


<A NAME="account_fee_overview"></A>
<h3>口座手数料</h3>
口座手数料概要ページは、任意の口座タイプについて有効なすべての<a href="#account_fees"><u>
口座手数料</u></a>を表示します。
<br><br>そのウィンドウはアクティブな(有効な)口座手数料、前回と次回の実行日、それらの状態(「実行中」、「完了」)を表示します。<br><br>口座手数料は自動(スケジュール)または手動のいずれかにすることができます。
手動の口座手数料は「今すぐ実行」リンクがクリックされた時にのみ実行されます。口座手数料の実行が成功すると、前回の実行日が設定され、<a href="#account_fee_history"><u>口座手数料履歴リスト</u></a> (下のウィンドウ)内にエントリが現れます。
<hr class="help">


<a name="account_fee_history"></a>
<h3>口座手数料履歴</h3>
このページは過去に行われたすべての口座手数料の賦課を表示します。
虫眼鏡を選択すると、口座手数料の詳細が開かれます。
<br><br>
「状態」の列が「完了」の文字(青色)を表示する場合、それは口座手数料の実行が成功したことを意味します。「完了」の文字が赤色で表示された場合、それは口座手数料の実行中に問題があったことを意味します。口座手数料の詳細ページに移ると、問題を閲覧して修正できます。 
<hr class="help">


<a name="account_fee_log_details"></a>
<h3>口座手数料の詳細</h3>
このウィンドウは口座手数料の詳細を表示します。ほとんどの詳細は一目瞭然です。口座手数料が「スケジュール」、「期間」タイプの場合、フィールドは賦課される期間(月ごと、週ごと、日ごとのいずれか)の開始日と終了日を表示します。手数料が日ごとにスケジュールされている場合、日付は1つだけ表示されます。<br><br>
「合計徴収額」フィールドは、徴収済みの支払いと承諾された請求書(それは支払いを生成することになります)の合計額を表示します。このため「合計徴収額」の値はメンバーが請求書を承諾するにつれて増加することがあり得ます。もちろん、これは<a href="#account_fee_details"><u>口座手数料設定</u></a>において「請求書を送信する」オプションが有効な場合のみ当てはまります。<br><br>
様々な状態(処理済み、スキップ済みなど)は、<a href="#account_fee_log_member_search"><u>口座手数料(メンバー検索) 
</u></a>セクション(以下を見てください)のヘルプ内で詳細に説明されています。「エラー」フィールドが数字を示す場合、それは手数料の実行中に1人または複数のメンバーが賦課されなかったことを意味します。この場合、このウィンドウ内に「再賦課(失敗したメンバー)」と書かれたボタンが現れます。このボタンを選択すると、すべての失敗したメンバーに賦課し、口座手数料の一貫性を保ちます。エラーの数は再賦課の後にゼロになり、<a href="#account_fee_history">
<u>口座手数料履歴リスト</u></a>に戻ると、「完了」状態は青色に変化している(そしてもう赤色ではない)はずです。


<a name="account_fee_log_member_search"></a>
<h3>メンバー検索(口座手数料)</h3>
口座手数料について、状態、グループ、個々のメンバーによってフィルタすることが可能です。以下の状態が存在します: 
<ul>
	<li><b>エラー</b> この検索フィルタは、エラーのために賦課されなかったすべてのメンバーのリストを表示します。エラーは決して生じるべきものではありません。おそらくそれはCyclos内部に問題があることを意味しており、Cyclosチームに報告する必要があるでしょう。特定の口座手数料を一貫性のない状態のままにせず完結できるように、口座手数料を修復するためのエラー再賦課メカニズムを用意しました。
  
	<li><b>処理済み</b> 処理済みの状態では、すべてのメンバーについて処理が済んでいます。基本的に処理済みの状態は、「エラー」状態を除く他のあらゆる状態(以下で詳しく説明)を含みます。
	<li><b>スキップ済み</b> この状態のメンバーは処理済みですが、賦課された額が最小値(0,01)を下回るため賦課されませんでした。
	<li><b>支払い</b> この検索フィルタはすべての直接賦課されたメンバーを表示します。
	<li><b>請求書</b> この検索フィルタは、請求書を送信されたすべてのメンバーを表示します。つまり、それはすべての「未決済」と「決済済み」の請求書の合計額です。
	<li><b>未決済の請求書</b> この検索フィルタはメンバーに送信されており、まだ承諾(支払い)されていないすべての請求書を表示します。 
	<li><b>承諾された請求書</b>
	この検索フィルタは、メンバーの送信され、承諾(支払い)されたすべての請求書を表示します。
</ul>


<a name="account_fee_log_member_list"></a>
<h3>口座手数料履歴メンバーリスト</h3>
このウィンドウは、上の検索ウィンドウの結果(メンバー)リストを表示します。メンバーを選択すると、メンバープロフィールページに移動します。状態の列は口座手数料の状態を表示します。状態が支払いまたは請求書の場合、それを選択することにより直接開くことができます。


<A NAME="account_fee_list"> </A>
<h3>口座手数料</h3>
このウィンドウは、この口座タイプについてすべての設定された<a href="#account_fees"><u>
口座手数料</u></a>(有効または無効)のリストを表示します。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16"> 口座手数料を修正するには、このアイコンをクリックしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16"> 口座手数料を消去したい場合は、このアイコンをクリックしてください。
</ul>
新しい口座手数料を追加するには、リストの下の「新しい口座手数料を挿入する」をクリックしてください。
<hr class="help">


<A NAME="account_fee_details"></A>
<h3>口座手数料を修正/挿入する</h3>
このウィンドウでは<a href="#account_fees"><u>口座手数料</u></a>(新規または既存の)を設定できます。手数料はそれ自体が取引なので<a href="#transaction_types"><u>取引タイプ</u></a>を必要とします。口座手数料の作成と設定を可能とするには、事前にその取引タイプを作成する必要があります。<br><br>以下の設定オプションが利用可能です</b>
<ul>
	<li><b>口座手数料名</b>:口座手数料の名称。<br>
	<br>
	<li><b>説明</b>:口座手数料の説明。<br>
	<br>
	<li><b>有効</b>:口座手数料はこのボックスが選択された場合にのみ賦課されます。この場合、その手数料がスケジュールされているか手動かは関係ありません:このボックスがチェックされていない場合、賦課は可能になりません。<br><br>
	<li><b>賦課モード</b>:5つの賦課モードが可能です:
	<ul>
		<li><b>固定額</b>:固定額は、寄付(メンバーからシステム口座へ)か、システム口座からメンバーのグループへの1回限りのまたはスケジュールされた支払いになり得ます。
		<li>><b>プラスのボリュームパーセンテージ</b>:プラスのボリュームパーセンテージは、利子が計算されるのと同じ方法で計算されます。実際、支払い方向(以下を見てください)を「メンバーからシステム口座へ」に定めると、それは利子になります。その方向が「メンバーからシステム口座へ」の場合、その手数料は逆の利子(デマレージ)になります。<br>
		デマレージは「定期的」フィールドで選ばれた期間に基づいて計算されます。この期間内の各日の最後に口座残高が取得され、この情報により「平均の」口座残高が計算されます。たとえば、1か月の期間中にあるメンバーが100ユニットを口座上に持っている場合、平均口座残高はちょうど100になります。このメンバー残高に対して賦課される1%のデマレージは1ユニットになります。
		<li><b>マイナスのボリュームパーセンテージ</b>:マイナスのボリュームパーセンテージは同様に機能しますが、マイナスの残高に対してのみ機能します。
		<li><b>プラスの残高パーセンテージ</b>: 残高パーセンテージ手数料は、ボリューム(時間+残高)を計算せず、残高のみを計算します。その手数料が(手動またはスケジュールで)実行されると、その手数料は賦課の時点における残高のみを考慮します。つまり、上の例において、そのメンバーが手数料の実行直前に彼の残高をゼロに下げた場合、彼は全く賦課されないでしょう。 
		<li><b>マイナスの残高パーセンテージ</b>:マイナスの残高パーセンテージは、同様に機能しますが、マイナスの残高に対してのみ機能します。
	</ul>
	<br>
<b>口座手数料の例:</b><br>
以下のように各金額部分について取引を作ります: <br>
ローン額 = 1000、認可手数料 = 30、月利 = 20が10回払い = 10 x 105であるとしましょう。
<br><br>
各支払いは次のように生成されるはずです:<br	>
<ul>
	<li>ベース返済(手数料と利子を除く当初額の返済) 100 
	<li>認可手数料返済 3 
	<li>月利返済 2 
	<li>満期で満期手数料 = 4、満期日を5日過ぎており1%/日の場合: 
	<li>満期手数料返済 4 
	<li>満期の日利返済 5(100の1% * 5日)

</u>	

<br><br>
<b>公式:</b><br>
変数<br>
RA = 受け取ったローン額<br>
IN = 割賦金の分割数<br>
GF = 認可手数料<br>
MI = 月利<br>
EF = 満期手数料<br>
EI = 満期利子<br>
IA = 割賦金の額<br>
D = 遅れた日数<br>
DA = ローン合計支払額<br><br>

認可時: <br>
DA = RA + GF + MI/100 ^ (総日数 / 30) * RA <br>
IA = DA / IN 
<br><br>
公式は以下の通り: 
IA = (RA + GF) * (((1+MI/100) ^ (IN + D/30)) * MI) / (((1+MI/100) ^ IN) - 1) 
DA = IA * IN 
最後の割賦金の額はDA - (IA * (IN-1))であるため、端数の問題はありません。
<br><br>		
	賦課モードは既存の手数料について変更できないことに注意してください。それは新しい口座手数料を設定することによってのみ設定できます。<br>
	<br>
	<li><b>許容範囲</b>:この項目は「賦課モード」で「プラスのボリューム」が選択された場合にのみ見えます。許容範囲の設定は、システム支払い(たとえば、ローン)を受け取り、それを短い期間に費やす(両替するか何かを購入する)メンバーが、この額と期間に対してデマレージを賦課されることを避けるために使えます。たとえば、あるメンバーが100ユニットを受け取り、24時間以内にそれらを費やす場合、
もし許容期間が24時間に設定されてれば、そのメンバーはこの時間/額について賦課されません。もし、同じ場合に、そのメンバーが2日間で100ユニットを費やすならば、彼は2日間(1日ではなく)の全期間について賦課されるでしょう。<br>
	<br>
	<li><b>支払い方向</b>:これは口座手数料の方向を、メンバーからシステムへ、あるいは、その逆に定めます<br>
	<br>
	<li><b>生成される取引タイプ</b>:口座手数料には取引タイプが必要です。取引は選ばれた取引タイプのものになります。<br>
	<br>
	<li><b>額</b>:「賦課モード」で「固定額」を選んだ場合、これは賦課される額になります。そうでない場合は、賦課されるボリュームまたは残高のパーセンテージになります。<br>
	<br>
	<li><b>フリーベース</b>:フリーベースを使えば、一定額を超えるものに対してのみ手数料を適用できます。<br>
ボリュームパーセンテージ口座手数料モードの場合、それは(前に述べた例を使うと)以下のように機能するでしょう。
	<ul>
		<li><b>賦課モード:</b> 「プラスのボリュームパーセンテージ」
		<li><b>額:</b> 1%
		<li><b>フリーベース:</b> 40
		<li><b>メンバーの口座上のボリューム:</b> 月全体で100ユニット
	</ul>
	この場合、フリーベースがなければ(つまり、フリーベースが0ならば)、賦課される手数料は1ユニットになります。フリーベースにしたがって、最初の40は賦課されないため、賦課される手数料は0.60ユニットになります。<br>
	固定額の口座手数料の場合、その口座手数料は、フリーベース額に等しいか、それを下回る残高を持つメンバーに対しては賦課されません。 <br>
	<br>
	<li><b>請求書を送信する</b>:この項目は、支払い方向が「メンバーからシステムへ」のの場合にのみ見えます。<br>
	これは、賦課されたメンバーが、その口座手数料を支払うのに十分なクレジットを持っていない場合に、何が起こるかを決めます。以下のオプションが利用可能です:
	<ul>
		<li><b>メンバーが十分なクレジットを持っていない時のみ:</b> この場合、十分なクレジットを持っていないメンバーのみが請求書を受け取ります。残りのメンバーは賦課されます
		<li><b>決してしない(メンバー口座がマイナスになるかもしれません):</b> この場合、これにより彼らの口座がクレジット制限を下回るとしても、すべてのメンバーが賦課されて皆が支払います。
		<li><b>常に(自動的にメンバーに賦課しない):</b> この場合、その口座手数料は誰にも賦課されず、請求書のみを送信します。これはメンバーがクレジット制限に達しているか否かに関わらず送信されます。
	</ul>
	</ul>
	<br>
	<b>注</b>: 請求書に関連するメンバーからシステムへの支払いのために取引タイプを作成する必要があります。たいてい、この支払いタイプは「寄付」のような名称を持つでしょう。この支払いを可能な(手動の)支払いとしてメンバーや管理者に表示したくない場合は、取引タイプ内の「有効」オプションをチェックしないままにすることができます。メンバーは依然として請求書を承諾できますが、メンバーと管理者にその取引タイプで手動の支払いを行う権限を与えることはできません。 
	<br>
	<br>
	<li><b>実行モード</b>:ここでは、その口座手数料がスケジュールされるか、手動で賦課されるかを定められます。いったん手数料が作成されると、これは変更できませんので注意してください。それは新しい手数料に対してのみ設定できます。<br>
	手動で賦課される場合、管理者は<a href="#account_fee_overview"><u>口座手数料概観ウィンドウ</u></a>から手数料の賦課を開始する必要があります。実行モードが「スケジュール」の場合、それは設定された時間に自動的に賦課されます。その場合、以下の追加的なオプションがあります:
	<ul>
		<li><b>定期的</b>: これはその口座手数料が実行される定期的な間隔です。たとえば、毎月または毎年です。<br>
		例: これが「3ヶ月」に設定された場合、その口座手数料は3ヶ月ごとに実行されます。これが「0」に設定された場合、その口座手数料は一度しか実行されません。
		<li><b>日</b>: その口座手数料が実行される日付または曜日。もちろん、これはあなたが日ごとの基準で期間を選ぶならば見えません。
		
		<li><b>時</b>:口座手数料が実行される時間(1-24)。
	</ul>
	<br>
	<li><b>有効化開始日</b>:このフィールドは、「有効」オプションが選択された手数料についてのみ現れます。スケジュールされた税を設定したいが、最初にやって来るスケジュールされた日付で賦課させたくない場合、ここで将来の日付を定められます。その日付以降、その手数料はスケジューリングに従って賦課されます。<br>
たとえば、毎月1日に実行されるスケジュールされた手数料を追加したが、この手数料を2011年1月1日に開始したいとします(現在が2010年6月であるとしましょう)。あなたは「有効化開始日」の日付を、2010年12月1日と2011年1月1日の間のどこかに設定しなければなりません。<br>「有効化開始日」の日付は、一度しか設定できません。一度使われるとそのオプションは表示されません。もちろん、あなたはいつでも、上の「有効」オプションで手数料を手動で無効化／有効化できます。<br>
	<br>
	<br>
	<li><b>グループ</b>:ここでは、口座手数料を賦課される、または受け取るグループを選択できます。
</ul>
<hr>


<A NAME="credit_limit"></A>
<h3>個人のクレジット制限</h3>
<br><br><i>見つけ方</i><br>
個人のクレジット制限は、<a href="${pagePrefix}profiles#accounts_actions"><u>メンバーのための口座アクション
</u></a>(そのメンバーのプロフィールの下のウィンドウ)からアクセスできます。<br><br>この機能により、そのメンバーについて個別のクレジット制限を設定できます。新しいメンバー口座が作成された時、そのメンバーは
<a href="${pagePrefix}groups#manage_groups"><u>グループ設定</u></a>内で設定される標準のクレジット制限を得ます。<br>
このウィンドウにより、これらのグループクレジット制限を覆すことができます。あなたはすべての口座について、この個別のメンバーのためのクレジット上限とクレジット下限を設定できます。メンバーがクレジット下限に達すると、そのメンバーは支払いを行えなくなります。
<br><br>クレジット上限は、滅多に使われない機能です。メンバーがクレジット上限に達すると、そのメンバーは支払いを受け取れなくなります。支払人は、受取人が支払いを受け取ることを許されていないというメッセージを受け取ります。例外は、メンバーがユニットを受け取るスケジュールされた寄付の場合です。これらの支払いは常に生じます。
<hr class="help">
</span>


</div> <%--  page-break end --%>
<div class='help'>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
</div>