<div style="page-break-after: always;">
<br><br>簿記機能は、銀行口座のような「外部口座」か他の通貨システムからの口座をCyclosシステム内の口座にリンク(ミラー)するために使えます。<br><br>簿記機能によって、外部口座(とその取引)の完全なミラーをCyclos内にローカルに持つことができるので、Cyclos取引をインポートされた取引と管理上「リンク」することが可能です。これは、両方の取引が互いを参照し、追加的な状態を受け取ることを意味します。この状態は、取引概要ウィンドウ内に特定のアイコンとして現れます。状態ごとの取引リストの結果を検索および印刷することも可能です。<br><br>簿記モジュールの典型的な使用法は、内部(Cyclos)ユニットが銀行口座上の伝統的な貨幣で裏付けらたシステムの残高を制御することです。そのような場合、銀行口座内の取引は、Cyclos内の特定のユニット取引と直接的な関係を持っています。たとえば、銀行にある預金(入ってきた支払い)は、Cyclosユニットの「購入」またはCyclos内のローンの返済になり得るシステムからメンバーへの支払いに関連付けられます。
そして、逆に、銀行口座(デビット)からメンバーの銀行口座への支払いは、Cyclos内のメンバーからシステムへの(たとえば、両替の)支払いに関連付けられます。調停機能は、Cyclosユニットの「裏付け」を制御するのに役立ちます。たとえば、内部ユニットが伝統的通貨によって100%裏付けられているシステムの「調停残高」は、1対1になります。<br><br>インポートされた取引に関して、特定のタイプの(Cyclos)取引を自動的に生成することが可能です。たとえば、外部の銀行口座に入ってきた支払いは、Cyclosのシステムからメンバーへの支払いを生成できます。<br>
これは簿記モジュールのインポート設定セクションで詳細に説明されています。<br><br>「裏付け」の制御は、簿記モジュールの使用法の一例にすぎません。そのモジュールは、外部取引がローカシステム内のローカル取引またはローン状態変更を生成する必要があるような他の場合のためにも使えます。
<br><br>
<i>見つけ方</i>
<br>
簿記モジュールは、「メニュー: 簿記」で見つかります(このメニュー項目が現れるようにするには、
管理者グループに対して権限が設定される必要があります)。

<br><br><i>動かし方</i><br>
そのモジュールが見えるようにするには、「外部口座(簿記)」ブロック内で、正しい<a
	href="${pagePrefix}groups#manage_group_permissions_admin_system"><u>管理者権限</u></a>が必要です。
<br><br>Cyclos内に新しい外部取引をインポートするには、その前に以下のステップを行わなければなりません:
<ol>
	<li>これらの取引のために必要な<a
		href="${pagePrefix}account_management#transaction_types"><u>
	取引タイプ</u></a>が存在していることを確認してください。

	<li>「メニュー: 外部口座を管理する &gt; 新しい外部口座」から外部口座を作成してください。
	<li><b>ファイルマッピング:</b> 外部口座を作成したウィンドウの下のウィンドウから、	インポートファイルの定義を作成してください。
	<li><b>フィールドマッピング:</b> このファイル内のすべてのフィールドをどのように扱うべきか、次のウィンドウでCyclosに伝えてください。

	<li><b>支払いタイプマッピング:</b> 支払いタイプを定義するフィールド内の値がどのように支払いタイプにマップされるべきか、Cyclosに伝えてください。これは次のウィンドウで行われます。
</ol>
これらのステップ(1度のみで十分です)を行うと、あなたの銀行口座から受け取った取引ファイルから、新しい外部取引をインポートできるようになります。ファイルから新しい取引をインポートする方法に関して概観を得るには、<a href="#using"><u>ここをクリック</u></a>してください。
<hr>


<A NAME="external_accounts_list"></A>
<h3>外部口座をリスト表示する</h3>
このウィンドウは、すべての外部口座のリストを表示します。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">
	外部口座を修正するには、このアイコンをクリックしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">
	外部口座を消去したい場合は、このアイコンをクリックしてください。
</ul>
下の「新しい外部口座」ボタンから、新しい外部口座を追加できます。

<hr class="help">


<A NAME="new_edit_external_account"></A>
<h3>外部口座を新規作成／編集する</h3>
このページでは、外部口座と内部システムとそれに関連するメンバー口座を定められます。<br>
外部口座内の取引は、たいていユニットの作成(たとえば、ローン)や破棄(たとえば、両替)に関わる取引に関連します。したがって、外部口座に関連したシステム口座は、通常、「無制限」タイプになるでしょう。これに関するさらなる情報は、「口座作成」の
<a href="${pagePrefix}account_management#account_details"><u>
ヘルプファイル</u></a>で見つけられます。 
<hr class="help">


<A NAME="edit_file_mapping"></A>
<h3>ファイルマッピングを編集する</h3>
外部口座のための取引情報をインポートするには、外部口座のフィールドとCyclos内のフィールドの間のマッピングを定める必要があります。外部口座の作成後、初回時に新しいファイルマッピングを作成するように求められます。以下のマッピングが利用可能です。
<ul>
	<li><b>タイプ: </b>CSVまたはカスタム(クラスファイル)<br>
	通常、取引ファイルは、値が区切り文字によって区切られたプレーンテキストを含みます。この場合、<a
		href="${pagePrefix}loans#csv"><u>CSV</u></a>オプションを使えます。<br>
	取引ファイルがもっと複雑なフォーマット、例えばxmlである場合、そのフォーマットを扱えるカスタマイズされたクラスをプログラムすることが可能です。このドキュメントは、技術的な詳細に立ち入るようには意図されていませんが、以下のことを行う必要があります:

	<ol>
		<li>取引ファイルインポート(utilsパッケージ内)のCyclosインタフェースを実装するJavaクラスを作成する
		<li>それをクラスパスとサーバーのWEB-INF/classesの位置に置くか、それがjarにパッケージ化されている場合は共有されたlibディレクトリに置く。
	</ol>
	<li><b>列区切り: </b><br>
	たいてい、そのファイル内で使われる区切り文字はカンマ「,」です。
	<li><b>ヘッダー行: </b><br>
	ヘッダー行(実際の値を含まない)の数。これらの行は無視されます。
	<li><b>数字フォーマット: </b><br>
	これには2つの可能なオプションがあります:
	<ul>
		<li><b>固定された位置:</b> 取引ファイル内の金額のフォーマットが区切りを持たず、区切りが固定されており右から計算される場合もあります。たとえば、小数点位置が2のの50000という額は、500(またはカンマ付きで500,00)になります。<br>
		このオプションを選ぶと、その右にあるフィールドは「小数点位置」と呼ばれ、通常はここに「2」を入力します。
		<li><b>区切り付き:</b> 通常、区切りが使われます。
		あなたはフィールド「小数点区切り」(右にある)内でこれを定められます。これはたいてい点「.」またはカンマです。
	</ul>
	<li><b>マイナス文字: </b><br>
	取引ファイル内の金額フィールドのフォーマットが決してマイナスにならない場合もありますが、マイナスの数字については、区切られた列内に特殊文字があります。
たとえば、「-」やD(デビット)です。たとえば、金額列フィールド|-500,00|は、|D|500,00|と同じになります(ここでは|が列区切りです)。そのような場合、このフィールド内にこの文字を入力します。<br>
	通常、その額は、同じフィールド内にマイナスの文字を持っており、マイナスの列は必要とされません。

	<li><b>文字列引用符: </b><br>
	取引ファイルとCSVファイルは、しばしば、テキストのための(行と列が途切れるのを避けるための)文字列を含みます。ここでは文字列引用符(たいていは")を定められます。
	<li><b>日付フォーマット: </b><br>
	ここでは日付フォーマットを定められます。あなたは、年の代わりにy、月の代わりにM(大文字でなければなりません)、日の代わりにdを使えます。dd/mm/yyまたはyyyy-MM-ddのような任意の値区切りを使えます。
</ul>
「送信」をクリックして、ファイルマッピングを送信してください。
「リセット」ボタンをクリックすると、すべてのファイルマッピングが削除され、新しいものを作成するように促されます。支払いタイプ(下のウィンドウ)は、ファイルマッピングのリセット時に削除されません。
<hr class="help">


<A NAME="file_mapping_fields_list"></A>
<h3>ファイルマッピングフィールド</h3>
一度、ファイルマッピングフォーマットが定められると(下のウィンドウ)、取引ファイルのフィールドをCyclosのフィールドへとマップできます。リスト内のすべての行は、取引ファイル内の1つの行を示し、どのフィールドは1つの列になります。<br><br>初めてこのウィンドウを見ると、リスト内には1つもフィールドがありません。新しいフィールドマッピングを挿入するには、「新しいフィールドマッピングを挿入する」をクリックしてください。取引の書かれたファイル内のすべてのフィールドについて、これを繰り返さなければならないでしょう。<br>
最初のフィールド(順序番号1の)は、取引ファイル内で最初の(左の)列になります。フィールドの順序が列順序に対応していることを確認してください。<br><br>一度リスト内に項目が入ると、いくつかのことを行えます。
<ul>
	<li>「フィールドマッピング順序を変更する」ボタンをクリックすることにより、フィールド順序を変更できます。
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;
	このアイコンをクリックすると、このフィールドのためのエントリーを変更できます。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">&nbsp;
	このアイコンをクリックすると、リストからそのフィールドが消去されます。
</ul>
<hr class="help">


<A NAME="edit_field_mapping"></A>
<h3>フィールドマッピングを新規作成／編集する</h3>
ここでは、フィールドごとにマッピングを定められます。名称を入力できますが、それはそのリスト内にテキストラベルとして表示されるだけです。特に機能はありません。フィールドドロップダウンボックス内では、以下のオプションを選択できます。
<ul>
	<li><b>無視された: </b>
	そのファイルが、Cyclosフィールドにマップされる必要がない追加的な列を含んでいる場合、そのためのマッピングを作成しなければなりませんが、「無視する」オプションを設定できます。
	<li><b>メンバーID: </b>
	このオプションは、Cyclos内で使われる内部ID番号にマップするために使えます。取引ファイルがCyclos内部(メンバー)IDを含むということはなさそうですが、
	完全なオプション一式を提供するために、そのオプションも用意されています。
	<li><b>メンバー名: </b> 取引ファイルが(Cyclos)ユーザー名を指定する場合、このオプションにより列を定められます。
	<li><b>メンバーカスタムフィールド: </b> 取引ファイルがユーザー名を指定しない場合、ユーザーを特定するためにカスタム(プロフィール)フィールドをマップすることが可能です。これは固有のカスタムフィールドでなければなりません。たとえば、財務番号です。
	<li><b>支払いタイプ: </b> 取引をインポートして、取引ファイルから支払いを生成したい場合、支払いタイプを定めなければなりません。たいてい、取引ファイル内の取引は、複数の支払いタイプになります。たとえば、預金、ローン返済などです。支払いのタイプは、別個の列におてコードで指定されます。 このオプションにより、どの列が支払いタイプを表示するかを定めます。支払いタイプとして可能な様々な値は、このウィンドウの下の支払いタイプ機能で定められます。
	<li><b>支払日: </b> このオプションにより、取引の支払い日を含む列を指定できます。
	<li><b>支払額: </b> このオプションにより、取引の支払額を含む列を指定できます。
	<li><b>マイナス額の指標: </b> 支払額がマイナスの額かプラスの額かを示さず、それが別の列で指定されることもありますこのフィールドにより、支払額フィールドがマイナスか否かを定められます。それは記号(たとえば、「-」)や単語(たとえば、「D」または「デビット」)にすることができます。
</ul>
「送信」をクリックして保存してください。<br><br> <b>注:</b> 1つのフィールドを一度しか使えません。つまり、あるフィールドタイプ(たとえば、支払日)を追加すると、それを再び追加することはできません(それはオプションとして表示されません)。例外は「無視された」フィールドです。なぜなら、あなたが無視したい(インポートしたくない)かもしれない様々な列が存在しうるからです。<br> メンバーID、メンバー名、メンバーカスタムフィールドは、すべてそのメンバーを定めるために使われるので、ファイルマッピング内ではそれら3つのフィールドタイプのうち1つのみしか使えません。
<hr class="help">


<a name="set_field_mappings_order"></a>
<h3>フィールドマッピング順序を設定する</h3>
このウィンドウでは、フィールドマッピングの順序を変更できます。 定義したフィールドのためのマッピングは、インポートしたい取引ファイル内のフィールド順序と全く同一である必要があります。<br><br>そのウィンドウは、非常に単純な方法で機能します。 フィールド名をクリックして、マウスで望む場所へとドラッグできます。完了したら、「送信」ボタンをクリックして、結果を保存できます。
<hr class="help">


<A NAME="external_transfer_type_list"></A>
<h3>支払いタイプ(アクションマッピング)</h3>
このウィンドウは、取引ファイルに含められる支払いの可能なタイプのリストを表示します。支払いタイプを追加するためには、その「支払いタイプ」フィールドとのフィールドマッピングが存在しなければなりません。このウィンドウでは、このフィールド内のどのコード値がCyclos内の実際の支払いタイプにマップされるかをCyclosに伝えます。このフィールド内に存在する可能性のあるすべての値をマップしなければなりません。 任意の識別可能な取引タイプにマップされないコードは、「なし」としてマップされます。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16"> 支払いタイプマッピングを修正するには、このアイコンをクリックしてください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16"> 支払いタイプマッピングを消去したい場合は、このアイコンをクリックしてください。
</ul>
支払いタイプマッピングを追加するには、「新しい支払いタイプを挿入する」というラベルの付いた「送信」ボタンをクリックしてください。
<hr class="help">


<A NAME="edit_external_transfer_type"></A>
<h3>移転タイプを挿入/修正する</h3>
このページでは、あなたの銀行からの取引ファイルの支払いタイプフィールド内のコードをどのように解釈すべきかを定められます。ここでは、特定のコードがどの取引タイプにマップされるべきかを定めます。このフィールド内で可能性のあるすべてのコードについて、この手続きを繰り返して下さい。<br> 名称と説明は、内部利用のためのものであり、機能はありません。そのコードは、 <a href="#edit_field_mapping"> <u>支払いタイプフィールドマッピング</u></a>を含むフィールドのあり得る値の1つです。 一例については、下のリストを見て下さい。<br> 以下のアクションが可能です。
<ul>
	<li><b>なし: </b> この場合、特定のコードはいかなるアクションも実行しません。その取引はあなたの外部口座概観に現れ、それゆえ残高は正しいですが、Cyclos内にはいかなる支払いも生成されません。
	<li><b>メンバーへの支払いを生成する: </b> ここでは、一例が役に立ちます。取引ファイル内の支払いタイプ列が様々な可能な値(コード)を持っており、それらのうちの1つが「DEP1」、つまり、その取引が銀行口座における預金であることを示す場合です。この特定の支払いタイプに、システム口座からメンバーへの支払いを自動的に生成させたければ、このオプションが選択されるべきです。
	<li><b>システムへの支払いを生成する: </b> これは稀な場合でしょうが、あらゆる可能なオプションを提供するために用意されています。この場合、外部口座に入ってきた取引が、メンバーからシステムへの支払いがCyclos内に生成されます。<br> 一例は、メンバーがメンバーシップ手数料を国民通貨で期間内に支払ったかどうかを確認するため、国民通貨での簿記をCyclosにインポートしたい場合です。この場合、組織のための口座を国民通貨で作成する必要があり(システムの銀行口座を反映させるため)、加えて、メンバーのための追加的な口座を国民通貨で作成する必要があるでしょう。これにより、これらの作成された口座によって銀行口座取引を反映させ、メンバーがメンバーシップ手数料を支払ったかどうか確認することができます(それに加えて、それに関する統計も行えます)。
	<li><b>ローンを放棄する: </b>
	一部のシステムは、外部で(たとえば、伝統的貨幣で)支払いできる<a href="${pagePrefix}loans"><u>ローン</u></a>をCyclos内に持っています。そのローンが外部で返済された場合、Cyclos内の状態を「返済済み」に変えたくないかもしれません。なぜなら、その状態はCyclos内部の通貨で返済された場合のために使われるからです。そのような場合、新しい状態は「放棄済み」になるでしょう。ローン返済が行われた時、ローン状態はこれらの支払いタイプに従って自動的に変更できます。
	<li><b>調停する: </b> 調停状態は、Cyclos内部の支払いに与えられる状態で、それが「逆」の外部支払いを持ち、管理者によって確認済みであることを示します。それは、1セットのCyclos口座(システムおよびメンバー)の残高と外部口座の残高を制御するために使われます。
</ul>
<hr class="help">


<a name="using"></a>
<h2>外部口座の使用</h2>
あなたは外部取引を外部口座へとインポートして、その後、それらを処理することができます。取引について外部口座を検索することもできます。

<i>見つけ方</i>
<br>
外部口座概観は、「メニュー: 簿記 &gt; 口座概観」から見つけられます。 <br><br><i>動かし方</i><br> 外部ファイルのためのマッピング(ファイルの一番上を見て下さい)を設定すると、あなたの銀行からのファイルから取引のインポートを開始できます。 これを機能させるために、以下のアクションを行ってください:
<ol>
	<li>これを機能させるために、以下のアクションを行ってください:
	<li>「メニュー: 簿記 &gt; 口座概観」に行き、
	<img border="0" src="${images}/import.gif" width="16" height="16">&nbsp;インポートアイコンをクリックして、インポートモジュールに行ってください。
	<li>そのファイルをインポートしてください。 これがエラーになる場合、あなたのインポートが成功するまで、それらを訂正してください。
	<li>インポートされた取引の概観に行ってください。 これは検索結果ウィンドウ(インポートボタンのあるウィンドウの上)から、 <img border="0" src="${images}/preview.gif" width="16" height="16">&nbsp; ビューアイコンをクリックすることにより、これを行えます。
	<li>不完全な取引を削除または回復し、保留中の取引を確認して「チェック済み」状態に変えてください。このすべては、各取引の <img border="0" src="${images}/preview.gif" width="16" height="16">&nbsp;ビューアイコンから行えます。
</ol>
<hr>


この取引概観の上の「処理」ボタンから、チェックされた取引を処理してください。
<h3><A NAME="external_accounts_overview"></A></h3>
外部口座概観
<ul>
	<li>このページは、システムのために設定されたすべての外部口座をリストで示します。 名称列は、その外部口座の名称を表示し、口座残高はすべてのインポートされた取引の合計を表示します。
	<li><img border="0" src="${images}/import.gif" width="16" height="16"> 矢印アイコンをクリックして、その口座についてのインポート機能に入ってください。それにより、外部取引をファイルからインポートできます。過去のすべてのインポートも概観できます。
</ul>
<hr class="help">


<img border="0" src="${images}/preview.gif" width="16" height="16"> 既にインポートされた取引を閲覧および処理するには、虫眼鏡アイコンをクリックしてください。ｄ
<h3><A NAME="external_transfer_import_new"></A></h3>
外部移転インポート新規 
<hr class="help">


このウィンドウでは、新しい外部取引をインポートできます。 ファイルを選んで「送信」をクリックしてください。そのファイルがシンタックスエラーにより読み込めなかった場合は、そのエラーを引き起こしている行とフィールドを特定するエラーレポートが現れます。
<h3><A NAME="external_transfer_import_list"></A></h3>
外部移転インポートリスト
<hr class="help">


このウィンドウでは、期間によってファイルインポートを検索できます。 日付を入力するために、日付選択機能( <img border="0" src="${images}/calendar.gif" width="16" height="16"> )を使うことができます。
<h3><A NAME="external_transfer_import_result"></A></h3>
外部移転インポート結果
<ul>
	<li>このウィンドウは、すべてのインポートされた取引ファイルのリストを表示します。<br>
	<li><img border="0" src="${images}/preview.gif" width="16" height="16"> インポートされた取引を閲覧および処理するには、虫眼鏡アイコンをクリックしてください。<br>
</ul>
<hr class="help">


<img border="0" src="${images}/delete.gif" width="16" height="16"> インポートされた取引を再び削除するには、消去アイコンをクリックしてください。<br> 注:状態が「チェック済み」または「処理済み」の取引があるインポートは消去できません。
<h3><A NAME="external_account_history"></A></h3>
外部口座履歴
<ul>
	<li>このウィンドウでは、インポートされた取引を検索できます。 その機能は、すべてのインポートされたファイル内を検索します。何もオプションが選択されていない検索は、所与の外部口座についてすべてのインポートされた取引を表示します。以下の検索オプションが利用可能です: 
	<li><b><b>タイプ: </b> このオプションにより、支払いタイプ(インポート設定内で定義された)ごとに検索できます。 </b>
	<ul>
		状態:
		<li>インポートされた取引は、以下の状態の1つになり得ます。
		<li><b>保留中: </b> その取引はインポートされましたが、まだ確認されていません。それはまだ「インポートされた残高」に(簿記機能のメインページで)影響を与えておらず、何のアクションも生成していません。<br> 注:保留中状態にあるインポートされた取引を消去することも可能です。 
		<li><b>チェック済み: </b> これらは確認され、「チェック済み」の<a href="#external_transfers_history_result"><u>状態</u></a>に置かれた取引です。
	</ul>
	<li><b>処理済み: </b> これらは、チェック済みの状態に置かれた後に処理された取引です。
	<li><b>ログイン名/メンバー: </b> 特定のメンバーによる取引を検索します。
	<li><b>下限額/上限額: </b> 額の範囲によって検索します。
</ul>
<b>開始日／終了日:</b> 期間によって検索します。
<ul>
	<li>そのウィンドウの下には、アクション(3つのボタンを表示する)があります。それらは、左から右に以下の通りです:
	<li><b>インポートリストへ:</b> これにより、インポートファイルの概観に移動します。そこでは、新しい取引ファイルをインポートすることもできます。
	<ul>
		<li><b>支払いを処理する: </b> これは1つまたは複数の取引を処理できる処理ウィンドウを開きます。<br> その処理は以下のいずれかになります。
		<li>(外部口座から)出て行く支払いを調停する
		<li>銀行口座に入ってきた支払いに関連するCyclos内部の支払いを生成する
	</ul>
	外部口座に入ってきた支払いに関連する(Cyclosの)ローン支払いを放棄する
	<li>処理ボタンは、検索結果リスト内のすべての取引(選択されているか否かに関わらず)に適用されます。取引はその状態が「チェック済み」である場合にのみ処理できるということに注意してください。
</ul>
<b>新しい支払い: </b> 取引が正しくインポートされなかった場合、それを手動で挿入することが可能です。
<hr class="help">


これらの機能に関する詳細な情報は、その機能ウィンドウ自体で発見できます。
<h3><a name="status"></a></h3>
取引状態
<ul>
	<li>各々のインポートされた取引には状態があります。 その状態は、以下の値を持ち得ます:
	<li><b>保留中</b> <img border="0" src="${images}/pending.gif" width="16" height="16">:
	その取引はインポートされていますが、全く影響を与えていません。 それはさらなるアクションのために保留中です。<br> その取引タイプが「調停可能である」としてチェックされた場合、この状態はシステム口座概観の中にも表示されます。この方法で、あなたは口座概観ページから直接、調停状態を辿ることができます。<br> 保留中状態の取引のみを消去できます。
	<li><b>チェック済み</b> <img border="0" src="${images}/checked.gif" width="16" height="16">:
	その取引は、確認されており「チェック済み」です。 これは、それが外部口座残高に入ることを意味します。<br> 「チェック済み」状態の取引を「保留中」に戻すことが可能です。<br>
	<li><b>不完全</b> <img border="0" src="${images}/incomplete.gif" width="16" height="16">:
	その取引は、インポートされていますが、1つまたは複数のフィールドを正しくマップできませんでした。たとえば、インポートされた取引内のメンバーがCyclos内に存在しない場合です。
</ul>
<hr class="help">


<b>調停済み</b> <img border="0" src="${images}/conciliated.gif" width="16" height="16">:
	その取引は処理済みです。それはさらなるアクションのために保留中です。<br>
	その取引タイプが「調停可能である」としてチェックされた場合、この状態はシステム口座概観の中にも表示されます。この方法で、あなたは口座概観ページから直接、調停状態を辿ることができます。<br> 処理された取引には別の状態を与えることも、消去することもできません。
<h3><A NAME="external_transfers_history_result"></A></h3>
外部移転
<ul>
	<li>このウィンドウは、上の検索ウィンドウの結果を表示します。 標準では、すべてのインポートされた取引を表示します。タイプ列は、前に状態アイコンを表示します。 
その状態のための可能な値を概観するには、<a href="#status"><u>ここをクリック</u></a>してください。  
額と日付の列は一目瞭然です。
<br><br> 各取引に関して、以下のアクションが可能です。
	<li><img border="0" src="${images}/preview.gif" width="16" height="16"> プレビューアイコンを選択すると、調停済みと処理済みの支払いに入れます。それらの支払いは変更できません。 ただし、チェックされた取引を保留中に戻して設定することが可能です。<br>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16"> 編集アイコンを選択することにより、保留中の状態にある取引からの取引データを修正できます。<br>
</ul>
<hr class="help">


<img border="0" src="${images}/delete.gif" width="16" height="16"> その取引を消去するには、消去アイコンをクリックしてください。
<h3><A NAME="external_transfers_history_summary"></A></h3>
外的移転履歴概要
<hr class="help">


このウィンドウは、リストで示された取引の合計の概観とレポートを示します。
<br><br>注: 一番上のウィンドウの検索結果である取引のみが数えられます。何もオプションが選択されていない検索は、所与の外部口座についてすべてのインポートされた取引を表示します。
<h3><A NAME="new_external_transfer"></A></h3>
新しい外部移転
<hr class="help">


取引を手動で追加することが可能です。 通常、取引インポートはすべての取引を正しくインポートするように設定できるので、これは必要ではないはずです。しかし、それが必要とされる(稀な)場合には、このウィンドウで行えます。<br> 入力フィールドは一目瞭然です。
<h3><A NAME="edit_external_transfer"></A></h3>
外部移転を閲覧および修正する
<hr class="help">


このページでは、インポートされた移転の詳細を閲覧できます。 移転が保留中<a href="#status"><u>状態</u></a>にある場合、その特性を修正できます。<br> 入力フィールドは一目瞭然です。
<h3><A NAME="external_transfer_process"></A></h3>
外部移転処理
<ul>
	<li>このページでは、支払いを処理できます。 支払いは、<a href="#status"><u>「チェック済み」状態</u></a>になければならず、 そうでなければ、処理できる取引のリストには表示されないということに注意してください。<br><br>そのウィンドウでは、処理可能な支払いを概観できます。 各項目において、上の行は取引ファイルから読み込まれる元の行を示し、下の行は送信をクリックした後に処理される取引を示します。最初の列のチェックボックスにチェックして、処理したい取引を選択してください。これにより、もし日付や額が正しくなければ、それらを修正することができます。<br> 「送信」をクリックすると、選択された取引を処理します。<br><br> 処理は3種類あります。 <br>
	<li><b>調停する: </b>
	このオプションは、内部の(Cyclos)ユニットが外部で裏付けられたシステム(たとえば、銀行口座にある伝統的な貨幣)の場合に一般的です。1セットの取引(外部取引とCyclos取引)の調停は、両方の取引が管理上関連づけられ、結び付けられることを意味します。これは、外部口座機能の口座概観とシステム口座概観機能において、支払いの前に <img border="0" src="${images}/conciliated.gif" width="16" height="16">とともに表示されます。これらの機能の検索ウィンドウには、調停状態によって検索するオプションがあります。Cyclos内の取引タイプを用いて取引を調停するには、取引タイプ設定でオプション「調停可能である」をチェックしなければなりません。
	<li><b>支払いを生成する: </b><br> 入ってきた(外部)支払い(プラスの額のみ)は、Cyclos支払い(システムからメンバーへ、またはその逆)を生成するように設定できます。支払いを処理するには、それを選択する必要があります。取引が選択されると、額と日付を修正できますが、これが必要なのは稀な場合です。<br> 生成された支払いは、自動的に調停状態になります。
</ul>
<hr class="help">

</div> <%--  page-break end --%>

<div class='help'>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
</div>
