<div style="page-break-after: always;">
<br><br>Cyclosには、ユーザーのグループへのカテゴリー化があります。 システム内の各ユーザーは、1つのグループにしか入れません。 3つの<a href="#group_categories"><u>主なカテゴリー</u></a>のグループがあります。<br> グループは、ソフトウェア内のユーザーに対して<a href="#permissions"><u>権限</u></a>を与えるために使われます。ユーザーは、グループがそのための権限を許していない場合、Cyclos機能にアクセスできません。当然、グループ権限を変更するか、ユーザーを1つの権限グループから別の権限グループに移動することが可能です。<br> 権限とは別に、グループには、制限や可能なアクセスのタイプのようなグループの振る舞いを定める特定のグループ<a href="#edit_member_group"><u>設定</u></a>もあります。メンバーグループには、管理者グループよりも多くの設定オプションがあります。メンバーグループ設定では、たとえば、特定のグループのためのレイアウトやコンテンツ項目と同様に、そのグループがどの口座を持つかを定められます。<br><br>メンバーが、1つのグループにしか入れないからといって、すべてのシステム設定がグループに固有のものだということではありません。システムは、依然として非常に柔軟です。設定は、システムレベル、グループレベル、個人レベルにおいて存在します。同様の設定が様々なレベルに存在する場合は、低いレベルが常に優先権を持ちます。たとえば、個人のクレジット制限は、グループのクレジット制限を上書きします。カスタマイズされたグループページ(たとえば、連絡先ページ)は、 システムの連絡先ページを上書きします。<br> 多くの設定は、複数のグループについて設定できます。たとえば、寄付は、いくつかのメンバーグループに対して賦課されるように設定できます。<br><br>Cyclosには、標準的な一組のグループが備わっています。 通常、これらのグループは、システムを動かすために十分であるはずです。<br> 権限を与えるためだけでなく、グループを管理するためにも、標準グループを使えます。たとえば、あるメンバーがシステムから削除されるべきならば、「グループを変更する」機能から、そのメンバーを「削除済みメンバー」グループへと単に移動できます。この機能は、日付、時間、そのアクションを行った管理者とともに、すべてのグループ変更も記録します。<br> 標準グループに伴う設定は、たいていの組織にうまく適合しますが、新しいグループを作成することも可能です。しかしながら、これは、しばらくの間システムを動かした経験がある場合にのみ行うべきです。<br><br><span class="admin"> <i>見つけ方</i><br>
グループ管理は、メイン「メニュー: ユーザーとグループ &gt; 権限グループ」下で見つけられます。<br>
グループフィルタは、「メニュー: ユーザーとグループ &gt; グループフィルタ」で見つけられます。<br><br><i>動かし方</i><br> 新しいメンバーは、常に、あるグループの一員になります。したがって、新しいメンバーまたは管理者を作成する時には、グループが選択される必要があります。これは、セクション「ユーザーとグループ &gt; <a href="${pagePrefix}user_management#search_member_by_admin"><u>メンバーを管理する</u></a>」と「ユーザーとグループ &gt; <a href="${pagePrefix}user_management#search_admin"><u>管理者を管理する</u></a>」セクションにおいて行われます。<br>
</span>
<hr>


<a name="group_categories"></a>
<h2>グループのための主なカテゴリー</h2>
3つの主なグループのカテゴリーがあります:
<ul>
	<li><a href="#member_groups"><u>メンバーグループ</u></a> - Cyclosのメンバーセクションにアクセスできる通常のメンバー
	<li><a href="#broker_groups"><u>仲介人グループ</u></a> - 一種の「スーパーメンバー」、つまり、他のメンバーの集合のためのいくらかの管理機能を許されたメンバー。
	<li><a href="#admin_groups"><u>管理者グループ</u></a> - 管理機能を持つユーザー。
</ul>
主なカテゴリーをこのように分離するのは、メンバーに対して偶然にいくらかの管理者<a href="#permissions"><u>権限</u></a>を与えてしまうことが起こらないようにするというセキュリティ上の理由によります。<br> すべてのグループには標準の権限が備わっていますが、これらを修正することは可能です。

<hr class="help">


<a name="member_groups"></a>
<h2>標準のメンバーグループ</h2>
これらのグループのメンバーは、Cyclosのメンバーセクションにアクセスできます。<br> システムには、以下の標準メンバーグループが備わっています:
<ul>
	<li><a href="#inactive_members"><u>非アクティブなメンバー</u></a>:このグループが初期グループとして設定された場合、ユーザーはログインすることができず、ログインできるようになる前に、管理者によって「アクティベートされる」(アクティブなメンバーグループに置かれる)必要があります。
	<li><a href="#full_members"><u>完全なメンバー</u></a> :&nbsp;通常のメンバー。
	<li><a href="#disabled_members"><u>無効化されたメンバー</u></a> :&nbsp;一時的に非アクティブなメンバー。
	<li><a href="#removed_members"><u>削除済みメンバー</u></a> :&nbsp;確実にシステムを去ったメンバー。
</ul>

標準グループは、固定的なものでも「決め打ちされた」ものでもなく、私たちが一般的に使われると考えたグループ<a href="#permissions"><u>権限</u></a>と<a href="#edit_member_group"><u>設定</u></a>を使って作成されています。しかし、これらのグループを修正したり、異なる設定を持つ新しいグループを作成することが可能です。
<hr class="help">


<a name="inactive_members"></a>
<h3>非アクティブなメンバーグループ</h3>
ユーザーが登録ページから登録する場合、自動的に「非アクティブなメンバー」グループに入れられます。このグループのメンバーは、システムにログインおよびアクセスをすることができず、アクティブな口座を持っていません。アカウント管理者は、このグループのユーザーのリストをリクエストできます。このユーザーの認証の後、「アクティブな」グループ、通常は<a href="#full_members"><u>完全なメンバー</u></a>グループへと入れられます。<br> 非アクティブなメンバーは関連する口座を持たないので、それはシステムから完全にメンバーを消去できるということを意味します。一度、あるメンバーが「アクティブ」グループ(口座を持つ)に入れられると、そのメンバーはもはや消去することができず、<a href="#removed_members"><u>削除済みメンバー</u></a>グループに移すことしかできません。グループの非アクティブ/アクティブ状態についてのさらなる情報は、この<a href="#group_details"><u>ヘルプセクション</u></a>で見つけられます。
<hr class="help">


<a name="full_members"></a>
<h3>完全なメンバーグループ</h3>
これはメンバーのための通常のグループです。 「完全なメンバー」は、ログインして、任意のメンバー機能を選択できます。メンバーは保留中から完全なメンバーグループへと移されると「アクティベート」されます。 これは、標準のクレジットがある(設定された場合)口座を受け取り、システムにログインするためのパスワードも受け取るということを意味します。<br> 設定された場合、ログイン名と口座状態についての情報が書かれた「アクティベーションメール」が送信されます。
<hr class="help">


<a name="disabled_members"></a>
<h3>無効化されたメンバーグループ</h3>
管理者がメンバーを「無効化されたメンバー」グループに入れると、そのメンバーはもはやログインできません。その口座は「休止」状態にあります。このグループ内のメンバーは、税や寄付支払いを賦課されません。「無効化されたメンバー」が持つ唯一のアクティブな機能は、依然として支払いを受け取れるということです(ただし、これを見るためにログインすることはできません)。<br> 無効化されたメンバーの広告は、他のメンバーによって行われる広告検索に表示されません。しかし、無効化されたメンバーのプロフィールは、メンバー検索に表示されます。無効化されたメンバーのプロフィールを見ると、そのメンバーが無効化されており、(現時点では)システムにアクセスできないというメッセージが表示されます。<br> このグループのメンバーが再アクティベートされるには、 管理者によって<a href="#full_members"><u>完全なメンバー</u></a>グループに戻される必要があります。<br> メンバーを無効化されたグループに入れる典型的な理由は、あるメンバーが(4ヶ月のような)限られた期間、海外に移住するというようなことでしょう。それは、不審なメンバーを(さらなる調査を待ちながら)このグループに移して、彼らがログインすることを避けるためにも使えます。
<hr class="help">


<a name="removed_members"></a>
<h3>削除済みメンバーグループ</h3>
あるメンバーを「削除済みメンバー」グループに移す理由は、そのメンバーがシステムを去ったということです。一度、削除済みグループに入れられると、他のどのグループにも戻ることはできません。 データは依然としてデータベースの中にあり、管理者によって閲覧可能ですが、バックアップ機能としての役割しか果たしません。<br>削除済みメンバーの任意のデータ(広告、プロフィール)は、他のメンバーによって閲覧可能ではありません。 取引履歴のみが、このメンバーとの過去の取引を表示します。この場合、アクティブなメンバーが古い取引履歴からそのメンバー名を選択すると、そのプロフィールが表示される代わりに、そのメンバーが削除済みであるというメッセージを受け取ります。メンバーの連絡先リストの中に、依然として削除済みメンバーがいる場合、彼らは同様のアラートメッセージを受け取ります。<br><br> 削除済みグループは、アーカイブ機能としてのみ働きます。何年か後に、システムがクリーンアップを必要とした場合、管理者は、削除済みグループのデータを安全に消去(バックアップ)できるということを知るでしょう。<br><b>注:</b> このルールには例外があります。 口座を持つグループに一度も属さなかったメンバーは、システムから永久的に削除できます。これについては、別個の管理者権限があります。 <br>
<hr class="help">


<a name="broker_groups"></a>
<h2>標準の仲介人グループ</h2>
仲介人は、一種の「スーパーメンバー」で、他のメンバーの集合のための一定の管理アクションを行うことを許せます。彼らは、Cyclosのメンバーセクションにアクセスできます。<br> Cyclosでは、以下の標準の仲介人グループが利用可能です:
<ul>
	<li><a href="#full_brokers"><u>完全な仲介人</u></a>: 通常の、標準的な仲介人タイプ。
	<li><a href="#disabled_brokers"><u>無効化された仲介人</u></a>: 一時的に無効化されている仲介人。
	<li><a href="#removed_brokers"><u>削除済みの仲介人</u></a>:
	永久的に削除された仲介人。
</ul>

標準のメンバーグループのように、標準の仲介人グループは、固定されたものでも、「決め打ちされた」ものでもなく、私たちが一般的に使われると考えたグループ<a href="#permissions"><u>権限</u></a>と<a href="#edit_broker_group"><u>設定</u></a>を使って作成されています。しかし、これらのグループを修正したり、異なる設定を持つ新しいグループを作成することが可能です。
<hr class="help">


<a name="full_brokers"></a>
<h3>完全な仲介人グループ</h3>
仲介人は、追加的な機能を持つメンバーです。 仲介人は、他のメンバーを登録することができ、システム設定次第では、仲介人をしているメンバーに対して一定のアクセスを持ち得ます。仲介人がメンバーを登録した場合、このメンバーはまず管理者によってアクティベートされる必要があります。仲介人が、1つまたは複数の「アクティブ」なグループにメンバーを直接入れることも可能ですが、これは設定される必要があるでしょう。そのメンバーの(取引)活動に関して、仲介人が<a href="${pagePrefix}brokering#commission"><u>委託手数料</u></a>を受け取ることも可能です。委託手数料は、完全な仲介人グループに対して設定されてますが、アクティブ化されていません。
<hr class="help">


<a name="disabled_brokers"></a>
<h3>無効化された仲介人グループ</h3>
このグループ内の仲介人は、メンバーとしてもログインできません。 その口座は、依然としてアクティブです。つまり、その仲介人は、支払いを受け取ることができ、寄付を賦課されます(該当する場合)。<br> このグループは、仲介人を一時的に無効化するために使えます。 たとえば、その仲介人が数ヶ月間海外にいる場合や、仲介人による濫用や詐欺行為の疑いがあって調査を待っている場合です。<br><br>
仲介人に関するさらなる説明については、<a href="${pagePrefix}brokering"><u>仲介人セクション</u></a>を見てください。
<hr class="help">


<a name="removed_brokers"></a>
<h3>削除済み仲介人グループ</h3>
このグループは、<a href="#removed_members"><u>「削除済みメンバー」</u></a>グループとほとんど同じです。仲介人が、削除済み仲介人グループに入れられたとしても、「仲介人 - メンバー」履歴は、依然として管理者に見えます。<br> その仲介人は、決して別のグループに戻すことができないことに注意してください。「削除済み」は、本当に「削除済み」であることを意味します。<br><br>
仲介人に関するさらなる説明については、<a href="${pagePrefix}brokering"><u>仲介人セクション</u></a>を見てください。
<hr class="help">


<a name="admin_groups"></a>
<h2>標準の管理者グループ</h2>
管理者グループ内のユーザーは、ソフトウェア内で管理タスクを行えます。
彼らはCyclosの管理者セクションにアクセスできます。
<span class="admin">Cyclosには、以下の標準の管理者グループが備わっています:
<ul>
	<li><a href="#system_admins"><u>システム管理者</u></a>: 任意の管理機能を使えます。
	<li><a href="#account_admins"><u>アカウント管理者</u></a>:
	メンバーに関連する管理のためです。
	<li><a href="#disabled_admins"><u>無効化された管理者</u></a>:
	一時的に削除された管理者。
	<li><a href="#removed_admins"><u>削除済み管理者</u></a>:
	確実に削除された管理者。
</ul>

これらのグループには、標準の<a href="#permissions"><u>権限</u></a>が備わっていますが、これらを修正することは可能です。</span>
<hr class="help">


<span class="admin"> <a name="system_admins"></a>
<h3>システム管理者グループ</h3>
このグループのユーザーは、新しい管理者の作成、権限の設定とシステム設定の変更を含む、任意の管理機能を使えます。設定のためにのみシステム管理者グループを使い、運営上のタスクのために使わないのは良いことです。
<hr class="help">
</span>


<span class="admin"> <a name="account_admins"></a>
<h3>アカウント管理者グループ</h3>
このグループ内のユーザーは、任意のメンバー関連の管理と広告管理を使えます。アカウント管理者は、いかなるシステム設定も変更できません。また、アカウント管理者は、システム状態、統計などのようなすべての「閲覧」機能にアクセスできます。アカウント管理を「水平的に」分業するために、特定のメンバーグループを管理するための複数のアカウント管理者グループを作成することが可能です。
<hr class="help">
</span>


<span class="admin"> <a name="disabled_admins"></a>
<h3>無効化された管理者グループ</h3>
このグループ内の管理者は、何もすることができず、ログインさえもすることができません。
このグループは、管理者を消去せずに一時的に無効化するために使えます。
<hr class="help">
</span>


<span class="admin"> <a name="removed_admins"></a>
<h3>削除済み管理者グループ</h3>
このグループは、管理者をシステムから確実に削除するためのものです。
<a href="#removed_members"><u>削除済みメンバー</u></a>と同様で、それを戻す方法はないことに注意してください。一度削除されると、その管理者を戻すことはできません。依然として利用可能な唯一のオプションは、システムとデータベースから、その管理者を完全に削除することです。
<hr class="help">
</span>


<span class="admin"> <a name="change_group"></a>
<h3>グループを変更する</h3>
ここでは、メンバー(または<a href="${pagePrefix}brokering"><u>仲介人</u></a>)が属しているグループを変更できます。単にドロップダウンボックスから新しいグループを選択してください。「説明」テキストエリア内に、このグループの変更に関するコメントを書かなければなりません。「送信」ボタンをクリックすることにより、変更内容を送信できます。<br><br><a href="#member_groups"><u>メンバーグループ</u></a>の概観については、ここをクリックしてください。<br><br>グループの変更を送信すると、履歴ボックス内に日付順で最新のものが一番上になるように置かれます。コメント履歴は、すべてのコメントの上に、その変更を送信した管理者の氏名、日付、行われた実際のグループ変更(「グループxからyへ」)が書かれた状態の行を表示します。<br> これにより管理者は、メンバーアカウントに起こったことを素早く概観し、なぜ変更が行われたかを読むことができます。コメント行に書けるのは、その変更の理由についての短い文だけです。顧客についての任意の他の追加的情報は、<a href="${pagePrefix}profiles#member_info_actions"><u>所見</u></a>機能内に入力されるべきです。<br><br>グループの変更に関するいくらかの所見:
<ul>
	<li>あるメンバーが<a href="#inactive_members"><u>非アクティブなメンバー</u></a>グループ内にいる場合、そのメンバーをシステムから完全に消去するオプションがあります。これは、登録が重複または偽の場合に便利です。
	一度、メンバーアカウントがアクティベートされると、もはや消去できませんが、「削除済みメンバー」グループに入れることはできます。
	<li>あるメンバーを<a href="#full_brokers"><u>仲介人</u></a>グループから通常のメンバー(非仲介人)グループへと移すと、その仲介人の下にいるすべてのメンバーには、もはや仲介人がいなくなります。(これは、その仲介人を別の仲介人グループ、たとえば、<a href="#disabled_brokers"><u>無効化された仲介人</u></a>に移す場合には、当てはまりません。)もしメンバーを仲介人不在のままにしたくなければ、まずすべての関係するメンバーの仲介人を変更し、その後で元の仲介人を非仲介人グループへと移すのが賢明かもしれません。これは<a href="${pagePrefix}user_management#bulk_actions"><u>バルクアクション</u></a>機能によって行えます。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="change_group_admin"></a>
<h3>管理者グループを変更する</h3>
ここでは、管理者が属する<a href="#admin_groups"><u>管理者グループ</u></a>を変更できます。単にドロップダウンボックスから新しいグループを選択してください。
「説明」テキストエリア内にこのグループの変更に関するコメント(たとえば、理由)を書けます。
テキストの入力を終えた後に、忘れずに「グループを変更する」というラベルの送信ボタンをクリックしてください。<br><br>その変更を送信した後、それは履歴ボックス内に日付順で、最新のものが一番上になるように置かれます。コメント履歴は、すべてのコメントの上に、その変更を送信した管理者の氏名、日付、行われた実際のグループ変更(「グループxからyへ」)が書かれた状態の行を表示します。<br><br>これにより、管理者は、管理者アカウントに何が起きたかを素早く概観して、なぜ変更が行われたのかを読むことができます。コメントに書けるのは、その変更の理由についての短い文だけです。管理者についての他の追加的な情報は、所見機能において入力されるべきです。<br><br>このウィンドウでは、もし必要であれば、システムから管理者を完全に削除することも可能です。しかし、望ましい方法は、その管理者を「無効化された管理者グループ」に入れることでしょう。
<hr>
</span>


<span class="admin"> <a name="group_management"></a>
<h2>グループ管理</h2>
あなたは、Cyclos内で様々なグループ管理アクションを行えます。 グループ特性の変更、権限の修正、権限グループの消去または追加を行えます。グループ管理には「メニュー: ユーザーとグループ &gt; 権限グループ」から行けます。
<hr class="help">
</span>


<span class="admin"> <a name="search_groups"></a>
<h3>グループを検索する</h3>
「タイプ」ドロップダウン内の<a href="#group_categories"><u>カテゴリー</u></a>の1つによって検索することができ、システムに<a href="#group_filters"><u>グループフィルタ</u></a>がある場合には、これらのフィルタについての検索オプションも現れます。
<hr class="help">
</span>


<span class="admin"> <a name="manage_groups"></a>
<h3>権限グループを管理する</h3>
このウィンドウでは、様々な権限グループを管理できます。 このウィンドウによって、利用可能なグループを概観し、新しいグループを作成することができます。<br><br>リストに示されたグループの各々について、以下のアイコンをクリックできます:
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;編集アイコンを選択すると、グループ特性を設定できるページが開きます。
	<li><img border="0" src="${images}/permissions.gif" width="16" height="16">&nbsp;権限アイコンを選択すると、そのグループのための権限を設定できるページが開きます。
	<li><img border="0" src="${images}/permissions_gray.gif" width="16" height="16">&nbsp;もし、権限グループアイコンが灰色ならば、そのグループは「削除済み」グループのため、いかなる権限も設定できないということを意味します。このグループに入れられるメンバーは削除されますが、そのデータの一部(たとえば、取引)はシステム内に留まります。これに関するさらなる情報については、「新しい」グループの<a href="#insert_group"><u>ヘルプファイル</u></a>を見てください。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">&nbsp;削除アイコンを選択すると、そのグループを削除できます。グループは、その中に1人もユーザーがいない場合にのみ削除できます。
</ul>
「新しいグループを挿入する」ボタンをクリックして、新しいグループを挿入できます。標準グループの取り扱いをいくらか経験してから、これを行うことを強く推奨します。<br> <a href="#group_categories"><u>グループカテゴリー</u></a>の概観については、ここをクリックしてください。
<hr class="help">
</span>


<span class="admin"> <a name="edit_admin_group"></a>
<h3>管理者グループを修正する</h3>
ここで、<a href="#admin_groups"><u>管理者グループ</u></a>の特性を編集/修正できます。「変更」ボタンをクリックした後、名称、説明、「アクセス設定」を変更できます。その状態は、グループ作成の時にのみ定義できます。
<br><br>ここでは権限を設定することはできず、グループ特性と設定は権限と同じものではないということに留意してください。<a href="#manage_groups"><u>グループ概観</u></a>から<img border="0" src="${images}/permissions.gif" width="16" height="16">権限アイコンをクリックすることにより、グループ権限を修正できますが、「グループ権限」というラベルの付いたウィンドウの下にあるショートカットボタンを使うこともできます。<br> <br><br>以下のグループ設定が利用可能です:
<ul>
	<li><b>パスワード長:</b> パスワードの最大長および最小長。<br>
	<li><b>パスワードポリシー:</b> 3つのオプションから選べます。それらのオプションの意味は一目瞭然です(誕生日、数列など)。<br> パスワードポリシーが選ばれた場合、ユーザーは、過去に使われたものを新しいパスワードとして選ぶことができません。
	<li><b>パスワード最大試行回数:</b> ユーザーがその最大試行回数に達すると、そのユーザーは非アクティブ化時間が過ぎるまでログインできません(次の設定を見てください)。<br>
	<li><b>パスワード最大試行回数後の非アクティブ化時間:</b> これは、ユーザーがパスワード最大試行回数に達した後、ログインできない時間です。<br>
	<li><b>ログインパスワードの有効期間:</b> この設定によって、ログインパスワードが有効である期間を定められます。その期間が期限切れになると、そのメンバーは、新しいパスワードを入力するように強いられます。「0」を入力すると、そのパスワードは決して期限切れになりません。<br>
	<li><b>取引パスワード:</b> ここでは、取引のための特別なパスワードの使用を設定できます。以下のオプションがあります:
	<ul>
		<li><b>「使用されていない」</b>: 取引パスワードは使用されず、メンバーは最初に取引パスワードを入力せずに任意の取引を行えます(もちろん、権限がある場合です)。
		<li><b>「自動」</b>: このオプションが「自動」に選択されると、システムは、新しいメンバーのアカウント作成時に(あるいは、既存メンバーについては今)取引パスワードを生成します。そのメンバーは、パーソナルメッセージの受信箱内に(一度のみ)そのパスワードを受け取ります。
		<li><b>「手動」</b>: これが選択された場合、取引パスワードは、そのメンバーのプロフィールページ内の<a href="${pagePrefix}profiles#access_actions"><u>「取引パスワードを管理する」</u></a>アクションから手動でのみ生成できます。取引パスワードについてのさらなる情報は、そのページで見つけられます。
	</ul>
	<li><b>取引パスワード長:</b> 取引パスワードの長さを設定してください。このパスワードは、常に固定された長さを持ちます。(もちろん、取引パスワードが使われていない場合、この設定は効力を持ちません。)
	<li><b>取引パスワード最大試行回数:</b> この数の取引が失敗した後、そのパスワードはブロックされます。管理者は、<a href="${pagePrefix}profiles#access_actions"><u>「取引パスワードを管理する」</u></a>アクションから、パスワードをリセットできます。(もちろん、取引パスワードが使われていない場合、この設定は効力を持ちません。)</li>
</ul>
変更を行った後に、忘れずに「送信」ボタンをクリックしてください。
<hr class="help">
</span>


<span class="admin"> <a name="edit_member_group"></a>
<h3>メンバーグループを修正する</h3>
ここで<a href="#member_groups"><u>メンバーグループ</u></a>の特性を編集/修正できます。「変更」ボタンをクリックした後、その名称、説明、いくつかの設定カテゴリーを変更できます。<br><br>ここでは権限を設定することはできず、グループ特性と設定は権限と同じものではないということに留意してください。<a href="#manage_groups"><u>グループ概観</u></a>から<img border="0" src="${images}/permissions.gif" width="16" height="16">権限アイコンをクリックすることにより、グループ権限を修正できますが、「グループ権限」というラベルの付いたウィンドウの下にあるショートカットボタンを使うこともできます。<br> <br><br>メンバーグループ設定は、カテゴリー順になっています。以下のカテゴリーが利用可能です。リンクをクリックして、これらのカテゴリー内のフィールドについての詳細を得られます:
<ul>
	<li><b><a href="#group_details"><u>グループ詳細</u></a></b>は、主な概要を与えます。
	<li><b><a href="#group_registration_settings"><u>登録設定</u></a></b>は、そのメンバーの登録に関係するグループ行動を定める設定です。それは、いくつかのその他の設定も含みます。
	<li><b><a href="#group_access_settings"><u>アクセス設定</u></a></b>は、そのグループのアクセスを定める設定です。
	<li><b><a href="#group_notification_settings"><u>通知設定</u></a></b>は、このグループへのEメール通知に関するものです。
	<li><b><a href="#group_ad_settings"><u>広告設定</u></a></b>は、広告に関するそのグループの振る舞いを定める設定です。
	<li><b><a href="#group_scheduled_payment_settings"><u>支払い設定</u></a></b>は、 支払いに関する指定を可能にします。 
	<li><b><a href="#group_loans_settings"><u>ローングループ設定</u></a></b>は、ローンに関係したそのグループの振る舞いを定める設定です。
</ul>
<hr class="help">
</span>

<span class="admin"> 
<a name="group_details"></a>
<h3>グループ詳細</h3>
ここでは、いくつかの一般的なグループ設定を設定できます。 
以下の設定が利用可能です:
<ul>
	<li><b>タイプ</b>: グループのタイプ(メンバー、仲介人、管理者)。 これは<a href="#insert_group"><u>グループ挿入</u></a>時に定められ、変更はできません。
	<li><b>削除済み</b>: このフィールドは、そのグループが「削除済み」かどうかを表示します。これも<a href="#insert_group"><u>グループ挿入</u></a>時に定められ、変更はできません。
	<li><b>名称</b>: そのグループの名称。 これもグループ挿入時に定められますが、変更はできません。
	
	
	<li><b>ログインページ名</b>: このオプションは、あなたがこのグループのためのログインページを(下のカスタマイズされたファイルウィンドウ内で)カスタマイズした場合にのみ表示されます。カスタマイズされた(グループ)ログインページは、「グローバル」なログインページの後に疑問符とともにログインページ名をつけることによってアクセスできます。ログインページ名には、スペースを含みられません。 
	一例は、以下のようになるでしょう:<br> http://www.yourdomain.org/cyclos?yourgrouploginpagename.<br> <a href="${pagePrefix}groups#group_filter"><u>グループフィルタ</u></a>ごとにログインページ名を指定することもできるということに留意してください。
	
	
	<li><b>コンテナページURL:</b> あるWebサイトの内部からCyclosにアクセスしたければ、この設定が使われます。その設定は、グローバルコンテナページ(<a href="${pagePrefix}settings#local"><u>設定 - ローカル設定</u></a>を見てください)と同じように機能しますが、これはこのグループ専用のものです。このフィールドには、Cyclosを含むiframeまたはframeセットを開くページを書く必要があるでしょう。 
	例:http://www.yourgroupdomain.org/cycloswrapper.php<br> <a href="${pagePrefix}groups#group_filter"><u>グループフィルタ</u></a>ごとにログインコンテナページを指定することもできるということに留意してください。
	
	
	
	<li><b>説明</b>: ここには、そのグループの説明を記入できます。そのフィールドは、グループ設定内の追加的な情報のためにのみ役立つものであって、Cyclos内の他のどの場所でも使われません。
	<li><b>グループをアクティブ化する</b>: このオプションは、口座を持たないグループについてのみ表示されます。このグループのメンバーが、他のメンバーに見えるべきでない場合、この選択ボックスは空のままにしておくべきでしょう。<br> メンバーが口座を持っていないとしても、他のユーザーに対して表示されるようにしたい場合、このオプションに印を付けるべきです。たとえば、単に管理業務のみを行う必要がある(したがって、トレード自体はできない)仲介人や、システム内で何が提供されているかを垣間見るためにログインするだけでトレードができないデモユーザーです。<br> この設定を変更すると、そのグループのすべての既存のメンバーと新しいメンバーに対して適用されます。
	<br><br>
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="group_registration_settings"></a>
<h3>グループのための登録設定</h3>
これらは、メンバーの登録に関係するグループの振る舞いを定める設定です。その設定は、「<a href="#edit_member_group"><u>メンバーグループを修正する</u></a>」フォームの一部です。以下のものが利用可能です:
<ul>
	<li><b>初期グループ</b>: そのグループを、ユーザーが一般登録ページから自ら登録した直後に入る初期グループにしたい場合は、このチェックボックスを選択できます。Cyclos内には、1つまたは複数の初期グループが存在し得ます。<br> そのグループに対して、表示される別な名称を指定することもできます。これは、複数の初期グループが存在する場合にのみ表示されます。それから登録ユーザーは、このフィールド内で定めるグループ名を表示するドロップダウン選択から選ばなければなりません。<br>
	
	<li><b>Eメール認証</b>: 
	ここでは、どのグループとどのユーザータイプ(メンバー、仲介人、管理者、またはWebサービス)がEメールで認証されるかを定められます。登録時やプロフィール内でEメールを変更した時に認証が要求されます。送信後、そのユーザーは、登録処理のために返信される必要がある確認Eメールを受け取る旨のメッセージを受信します。<br>
	登録が確認されるか、最大確認期間が期限切れになるまで、そのメンバーは保留中状態に置かれます。最大確認期間は、ローカル設定(<a	href="${pagePrefix}settings#local"><u>ヘルプファイル</u></a>)の「制限」セクションで定められます。
	保留中のメンバーは、<a 	href="${pagePrefix}user_management#search_pending_member"><u>保留中メンバー</u></a>ページで閲覧できます。<br>
	以下の認証オプションが利用可能です:<br>
	
	
	<li><b>登録同意書</b>: ここでは、登録ページに表示される登録同意書を選べます。<a href="#list_registration_agreements"><u>登録同意書リスト</u></a>ページで、新しい登録同意書を追加できます。<br> あるグループのために登録同意書が定められると、そのグループのすべてのユーザーは、Cyclosにログインできるようになるためにその同意書を承諾する必要があります。ユーザーが管理者または仲介人によって登録された場合、その同意書ページは、彼らが最初にログインした時に表示されます。<br> 既にシステムに登録されているユーザーが、登録同意書が定められたグループに移される場合、そのユーザーは、次回ログイン時にその同意書を提示されます(そして、ログインできるようになるには、その同意書を承諾する必要があります)。<br> 新たに作成された登録同意書に変更する場合、追加的なオプション「次回ログイン時に承諾を強制する」が現れます。このオプションが選択された場合、そのグループのすべての新しいユーザーと既存のユーザーが、その登録同意書を提示されます。選択されなかった場合は、新たに登録されたユーザーのみが、その同意書を承諾しなければなりません。 <br>
	<li><b>Eメールによってパスワードを送信する:</b> このオプションがチェックされた場合、管理者と仲介人について2つのオプションが現れます。第1のオプションでは、このグループのために新しいメンバーを作成する仲介人と管理者が、登録フォーム内にパスワードを入力しないことを選択できます。メンバーはすぐにEメールによって一時的なパスワードを受け取ります。メンバーはログイン時に新しいパスワードを入力するよう促されます。<br> 第2のオプションでは、管理者と仲介人がメンバープロフィールからパスワードをリセットできます。メンバーは上で述べたのと同じ方法で一時的なパスワードを受け取ります。<br> そのメッセージは、<a href="${pagePrefix}settings#mail"><u>メール設定</u></a>内で定められます。このオプションを使う場合、Eメールフィールドが必須であることを確認してください。これは、<a href="${pagePrefix}settings#local"><uローカル設定</u></a>内で設定できます。<br>
	<li><b>メンバーごとの最大プロフィール画像数</b>: メンバーが<a href="${pagePrefix}profiles"><u>プロフィール</u></a>内に置いてよい画像の最大数。<br>
	<li><b>メンバー有効期間</b>: このフィールドを「0」以外の別の値に設定すると、このグループへのメンバー登録が自動的に期限切れするように設定できます。そのメンバーはそのグループに入ってからこの時間が過ぎた後、自動的に別のグループへと入れられます(次の項目を見てください)。<br>
	<li><b>期限切れ後のグループ</b>: 前の項目でグループのメンバー登録について期限切れ時間を設定したならば、ここでは、そのメンバーが期限切れ後に移される先のグループを入力しなければなりません。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="list_registration_agreements"></a>
<h3>登録同意書</h3>
このウィンドウは、登録同意書のリストを表示します。 登録同意書についてのさらなる情報は、同意書の修正についての<a href="#group_registration_agreement"><u>ヘルプページ</u></a>で見つけられます。<br> 新しい同意書を挿入するか、既存のものを修正することができます。<br> 同意書は、その同意書を持つグループが1つもなく、誰もその同意書を承諾していない場合にのみ、消去できます。 <br>
<hr class="help">
</span>


<span class="admin"> <a name="registration_agreement"></a>
<h3>登録同意書を新規作成/修正する</h3>
登録同意書は登録ページに表示できるテキストで、登録したいユーザーは、送信できるようになるために、この同意書に同意するというチェックボックスを選択<b>しなければなりません</b>。<br> 同意書は、1つまたは複数のグループに結び付けられます。これは、<a href="#group_registration_settings"><u>グループ登録設定</u></a>内で設定できます。<br> 同意書に変更を加えて、既存の(既にその同意書を承諾した)ユーザーに再びそれを承諾して欲しい場合、新しい同意書を作成して、グループ設定内でそれを変更しなければなりません(「次回ログイン時に承諾を強制する」オプションも選ばなければなりません)。
<hr class="help">
</span>


<span class="admin"> <a name="group_access_settings"></a>
<h3>グループのアクセス設定</h3>
これらは、そのグループのアクセスの振る舞いを定める設定です。 その設定は、「<a href="#edit_member_group"><u>メンバーグループを修正する</u></a>」フォームの一部です。以下のものが利用可能です:
<ul>
	<li><b>アクセス可能なチャネル:</b> チャネルは、Cyclosへのアクセスの手段です。ここでは、Cyclosがこのグループによって、どのアクセス手段によりアクセス可能かを選択できます。このグループの<a href="${pagePrefix}settings#channels"><u>チャネルセクション</u></a>も見てください。以下のオプションの1つまたは複数を選択できます:
	<ul>
		<li><b>メインWebアクセス:</b> ブラウザで通常のWebページからCyclosにアクセスします。
		<li><b>PosWeb支払い:</b> 店舗がCyclosから支払いを可能にするための<b>P</b>oint <b>O</b>f <b>S</b>aleアクセス。このオプションが有効化された場合、その支払人(消費者)グループが、このアクセス設定を必要とすることを意味します。
		<li><b>SMS:</b> このモジュールは開発中です。
		<li><b>WAP1およびWAP2アクセス:</b> 携帯電話からCyclosへのアクセス。
		<li><b>Webショップ支払い:</b> Webショップ内の「Cyclosによって支払う」ボタンからのアクセス。
	</ul>
	<li><b>標準のチャネル:</b> このグループの各メンバーは、チャネルについての個人的な好みを設定できます。前の項目(「アクセス可能なチャネル」)によって選択されたすべての項目は、ユーザーの個人ページからユーザー自身によってオフにすることができます。たとえば、「標準のメンバーアクセス」ドロップダウン内で「WAP1」をチェックすると、このグループ内のすべてのメンバーについて、個人設定ページ内で「WAP1」チャネルが標準で選択されチェックされることを意味します。ただし、その後、各メンバーはこの設定を再びオフにするかもしれません。 <br>
	<li><b>PINの長さ:</b> SMSとWebショップのような一部の支払いチャネルについては、PIN(番号のみ)の使用を設定できます。このオプションでは、PINの最大長と最小長を定められます。<br> このオプションが表示されるようにするには、「アクセス可能なチャネル」内でPINを使うチャネルが選択されなければなりません。PINでアクセス可能な最初のチャネルを追加する時は、PINの長さオプションが表示される前に、まずそのグループ設定を保存しなければなりません。 <br>
	<li><b>PIN最大試行回数:</b>(そのグループに対して、PINを使うチャネルが有効な場合にのみ見えます。)ユーザーが最大試行回数に達すると、そのユーザーは非アクティブ化時間(次の設定を見てください)が過ぎるまで、支払いを行えません。 <br>
	<li><b>最大試行回数後のPINブロック時間:</b>(そのグループに対して、PINを使うチャネルが有効な場合にのみ見えます。)これは、ユーザーがパスワード最大試行回数に達した後に、支払いを行えなくなる時間です。 <br>
	<li><b>パスワード長:</b> ユーザーがログインのために必要とするパスワードの最小長と最大長を設定します。<br>
	<li><b>パスワードポリシー:</b> 3つのオプションから選べます。それらのオプションの意味は一目瞭然です。<br>
	<li><b>パスワード最大試行回数:</b> ユーザーがその最大試行回数に達すると、そのユーザーは非アクティブ化時間が過ぎるまでログインできません(次の設定を見てください)。<br>
	<li><b>パスワード最大試行回数後の非アクティブ化時間:</b> これは、ユーザーがパスワード最大試行回数に達した後、ログインできない時間です。<br>
	<li><b>ログインパスワードの有効期間:</b> この設定によって、ログインパスワードが有効である期間を定められます。その期間が期限切れになると、そのメンバーは、新しいパスワードを入力するように強いられます。「0」を入力すると、そのパスワードは決して期限切れになりません。<br>
	<li><b>取引パスワード:</b> ここでは、取引のための特別なパスワードの使用を設定できます。以下のオプションがあります:
	<ul>
		<li><b>「使用されていない」</b>: 取引パスワードは使用されず、メンバーは最初に取引パスワードを入力せずに任意の取引を行えます(もちろん、権限がある場合です)。
		<li><b>「自動」</b>: このオプションが「自動」に選択されると、システムは、新しいメンバーのアカウント作成時に(あるいは、既存メンバーについては今)取引パスワードを生成します。そのメンバーは、パーソナルメッセージの受信箱内に(一度のみ)そのパスワードを受け取ります。
		<li><b>「手動」</b>: これが選択された場合、取引パスワードは、そのメンバーのプロフィールページ内の<a href="${pagePrefix}profiles#access_actions"><u>「取引パスワードを管理する」</u></a>アクションから手動でのみ生成できます。取引パスワードについてのさらなる情報は、そのページで見つけられます。
	</ul>
	<li><b>取引パスワード長:</b> 取引パスワードの長さを設定してください。このパスワードは、常に、一定の長さを持ちます。<br>
	<li><b>取引パスワード最大試行回数:</b> この数の取引が失敗した後、そのパスワードはブロックされます。管理者は、<a href="${pagePrefix}profiles#access_actions"><u>「取引パスワードを管理する」</u></a>アクションから、パスワードをリセットできます。
</ul>
<hr class="help">
</span>

<span class="admin"> <a name="group_notification_settings"></a>
<h3>通知設定</h3>
これらは、グループのメンバーが有効化できる個人的な通知についての設定です。
<ul>
	<li><b>Eメールによって送信される標準のメッセージ:</b> これらは、(このグループの)メンバー作成の際に標準で印が付けられる通知メッセージです。<br> このドロップダウン内で項目をチェックすると、このグループの各メンバーの個人設定ページ内でそれが標準でチェックされることを意味します。しかしながら、そのメンバー自身が、この通知のチェックを外すか覆すことを選ぶかもしれません。
	<li><b>SMS可能なメッセージ:</b> これらは、SMS通知で利用可能なメッセージです。<br> 注:このオプションは、SMSチャネルがアクティブ(ローカル設定 - チャネル)である場合にのみ利用可能です。
	<li><b>SMSによって送信される標準のメッセージ:</b> これらは、(このグループの)メンバー作成時に標準で印がつけられる通知メッセージです。このドロップダウン内で項目をチェックすると、このグループの各メンバーの個人設定ページ内でそれが標準でチェックされることを意味します。ただし、メンバー自身が、この通知のチェックを外すか覆すかもしれません。 <br>
	<li><b>標準でSMSへの賦課を許可する: </b>メンバーは個人設定ページにおいて、(出て行った)SMSメッセージへの賦課を許可または禁止する。これを選択すると、メンバー作成時にそのオプションがチェックされます。   	
	<li><b>標準で無料メールを受け入れる: </b>上のように、これもメンバー設定内のオプションです。メンバーは無料のSMSメールを許可できます。 そのメンバーは、このメールのSMS費用を賦課されません。 
	<li><b>標準で有料のメールを受け入れる: </b>上と同じですが、SMSメールの費用を賦課されます。
	<li><b>SMS賦課移転タイプ: </b>これは、出ていったSMS(システムからメンバーへ、たとえば、通知)に対して賦課するために使われる取引タイプです。
	<li><b>SMSの内容をカスタマイズするためにクラスを使用する: </b> 設定により行えない無料SMSの賦課または提供に関して、特定の振る舞いまたは機能が必要ならば、独自のJavaクラスを作成して必要な振る舞いを実装できます。 
	<li><b>無料のSMS: </b>これは月毎の無料のSMSの額です。 このグループのメンバーは、出て行ったSMS(通知、支払い確認など)のためにこのクレジットを使えます。
	<li><b>以下の場合にのみ無料のSMSを表示する: </b> SMSの無料の通数がかなり多い、たとえば100ならば、メンバーが多くの(不必要な)通知を有効化するインセンティブになります。 If the Free amount of SMS is rather high, say 100, it could be an incentive for the member to enable a lot of (unnecessary) notifications. これを避けるために、残りのSMSが少ない時にのみ無料SMSの数を表示することができます。たとえば、無料SMSを100通に定めてこの設定で3を入力すると、無料SMSの数は、そのメンバーが96通の無料SMSを費やした後にのみ表示されます。
  	<li><b>追加的に賦課されるSMSパッケージ: </b>メンバーが「SMSに対する賦課を許可する」を有効にした場合(上を見てください)、メンバーは無料のメッセージが残っていない場合に賦課されます。すべてのメッセージに賦課する代わりに、「パッケージ」を定義することができます。たとえば、10を入力することは、メンバーが10メッセージ分のクレジットを受け取ることを意味します。<br> 注:もちろん、この設定に1を入力すると、メンバーは各メッセージに対して個別に賦課されます。
   	<li><b>追加的なSMS額:</b> これは各々の新しい「賦課された」SMSパッケージに対して賦課される額です。
	<li><b>追加的なSMSパッケージの有効期限: </b>SMSパッケージには期限日を付けられます。これは組織は通常、たいてい期限日のあるバルクSMS送信を購入するからです。  
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="group_ad_settings"></a>
<h3>広告設定</h3>
これらは、広告に関するグループの振る舞いを定める設定です。
その設定は、「<a href="#edit_member_group"><u>メンバーグループを修正する</u></a>」フォームの一部です。以下のものが利用可能です:
<ul>
	<li><b>メンバーごとの最大広告数:</b> 一目瞭然です。<br>
	<li><b>永久的な広告を有効にする</b>: チェックされた場合、これにより、このメンバーグループのための<a href="${pagePrefix}advertisements#ad_modify"><u>永久的な「期限切れしない」広告</u></a>が可能になります。<br>
	<li><b>標準の広告掲載時間:</b> 新しい広告のための標準の期間。メンバーは、いつでも、各広告についてのアクティブ化の期間を変更できます。<br>
	<li><b>最大広告掲載時間:</b> メンバーが1つの広告に対して与えられる最大掲載期間。<br>
	<li><b>広告外部掲載</b>: これにより、広告の外部掲載が可能になります。つまり、このグループの広告は、その組織のWebサイト上に自動的に掲載され得るので、非メンバーからも閲覧可能になります。すべてのオプションは、一目瞭然です。「選択を可能にする」は、メンバーの広告を外部掲載のために使えるかどうかを、そのメンバー自身が選べることを意味します。<br>
	<li><b>広告ごとの最大画像数:</b> メンバーが1つの広告に載せてよい画像の最大数。<br>
	<li><b>広告説明最大サイズ</b>: バイト/文字数での広告説明の最大サイズ。
</ul>
<hr class="help">
</span>


<a name="group_scheduled_payment_settings"></a>
<h3>グループの支払い設定</h3>
これらは、<a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a>に関係した設定です。その設定は、「<a href="#edit_member_group"><u>メンバーグループを修正する</u></a>」フォームの一部です。<br><br>これらの設定のすべてが<a href="${pagePrefix}payments#pay_scheduled"><u>複数のスケジュールされた支払い</u></a>に言及します。以下のものが利用可能です:
<ul>
	<li><b>最大スケジュール支払い:</b> 支払いを分割およびスケジュールできる期間(または部分的支払い)の最大数。 例:例:10個の部分的支払いで、2週間ごとに1つ。
	<li><b>最大スケジュール期間:</b> 今回と前回の支払いの間の最大合計期間。
	<li><b>PosWeb支払いで説明フィールドを表示する:</b> このボックスが選択されると、PosWebページでログインしているユーザーのために、PosWebページ内に支払い説明フィールドが表示されます。   	
</ul>
<hr class="help">


<span class="admin"> <a name="group_loans_settings"></a>
<h3>グループのローン設定</h3>
これらは、<a href="${pagePrefix}loans"><u>ローン</u></a>に関係する設定です。
その設定は、「<a href="#edit_member_group"><u>メンバーグループを修正する</u></a>」フォームの一部です。以下のものが利用可能です:
<ul>
	<li><b>ローングループに与えられたローンを閲覧する</b>: メンバーは、自分の<a href="${pagePrefix}loan_groups"><u>ローングループ</u></a>に対して与えられた<a href="${pagePrefix}loans"><u>ローン</u></a>を閲覧できます。
	<li><b>任意のローングループメンバーによって許可されたローン返済:</b> このオプションが選択された場合、そのローングループの任意のメンバーが、ローンを返済できます。そのオプションが選択されていない場合、責任者として印が付けられたメンバーのみが、そのローンを返済できます。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="group_brokering_settings"></a>
<h3>仲介人グループの仲介設定</h3>
これらは、仲介人の<a href="${pagePrefix}brokering"><u>仲介</u></a>機能に関係した設定です。その設定は、「<a href="#edit_member_group"><u>メンバーグループを修正する</u></a>」フォームの一部です。以下のものが利用可能です:
<ul>
	<li><b>可能な初期グループ:</b> ここで、仲介人によって登録されたメンバーの初期グループを選べます。これは仲介人の使用法によって異なります。それは、管理者またはアクティブなグループによるアクティベーションを必要とするアクティベーション保留中のような非アクティブなグループにすることができます。<br> 1つまたは複数のグループを選択すると、仲介人は、その仲介人が選択できるグループのリストを提示されます。<br> ここで1つまたは複数のグループを選択しなければ、仲介人は、任意のメンバーを登録することができ<b>ない</b>ということに留意してください。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="edit_broker_group"></a>
<h3>仲介人グループを修正する</h3>
ここで<a href="#broker_groups"><u>仲介人グループ</u></a>の特性を編集できます。「変更」ボタンをクリックした後、「設定」の名称、説明、いくつかのカテゴリーを変更できます。<br> <br><br>ここで権限を設定することはできず、グループ特性と設定は権限と同じものではないということに留意してください。<a href="#manage_groups"><u>グループ概観</u></a>から、<img border="0" src="${images}/permissions.gif" width="16" height="16">権限アイコンをクリックすることにより、グループ設定を修正できますが、「グループ権限」というラベルの付いたウィンドウの下のショートカットボタンを使うこともできます。<br> <br><br>仲介人グループ設定は、カテゴリー順です。以下のカテゴリーが利用可能です。リンクをクリックして、これらのカテゴリー内のフィールドについての詳細を得られます:
<ul>
	<li><b><a href="#group_details"><u>グループ詳細</u></a></b>は、主な概要を与えます。ここでは、(もちろん、そのボックスの下の「変更」ボタンをクリックした後)表示されるそのグループの「名称」と「説明」を変更できます。
	<li><b><a href="#group_registration_settings"><u>登録設定</u></a></b>は、そのメンバーの登録に関係するグループ行動を定める設定です。それは、いくつかのその他の設定も含みます。
	<li><b><a href="#group_access_settings"><u>アクセス設定</u></a></b>は、そのグループのアクセスを定める設定です。
	<li><b><a href="#group_notification_settings"><u>通知設定</u></a></b>は、このグループへのEメール通知に関するものです。
	<li><b><a href="#group_brokering_settings"><u>仲介設定</u></a></b>は、他のメンバーの仲介に関する設定です。
	<li><b><a href="#group_ad_settings"><u>広告設定</u></a></b>は、広告に関するそのグループの振る舞いを定める設定です。
	<li><b><a href="#group_loans_settings"><u>ローン設定</u></a></b>は、ローンに関係するグループ行動を定める設定です。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="insert_group"></a>
<h3>新しいグループを挿入する</h3>
このウィンドウにより、新しいグループを作成することができます。 <br>
以下のオプションがあります
<ul>
	<li><b>タイプ:</b> グループの<a href="#group_categories"><u>タイプ</u></a>。これは「メンバー」、「仲介人」、または「管理者」になり得ます。
	<li><b>削除済み:</b> グループが「削除済み」として印がつけられた場合、このグループ内のメンバーが本当にシステムを去ったということを意味します。一度、「削除済み」グループに入ると、どの他のグループにも戻ることはできません。そのデータは、依然としてデータベース内にあり、管理者によって閲覧可能ですが、バックアップ機能としてのみ役立ちます。
	<li><b>名称:</b> ユーザーに対して表示されるそのグループの名称。
	<li><b>説明:</b> そのグループの説明。
	<li><b>設定コピー元:</b> このドロップダウンによって、この新しいグループのための設定を既存のグループからコピーできます。設定と権限の両方がコピーされます。
</ul>
情報を追加した後は、もちろん、「送信」ボタンをクリックして、変更を保存するべきです。<br> <b>重要:</b> 新しいメンバーグループを作成したら、グループリストページから、権限と特性を設定すべきです。<br><br>注: グループを作成した後に、そのグループのタイプと状態を変更することはできません。
<hr class="help">
</span>


<span class="admin"> <a name="manage_group_accounts"></a>
<h3>グループ口座を管理する</h3>
<a href="#member_groups"><u>メンバーグループ</u></a>(と<a href="#broker_groups"><u>仲介人グループ</u></a>)は、様々な関連付けられた<a href="${pagePrefix}account_management#accounts"><u>口座</u></a>を持てます。下のリストは、そのグループと関連付けられたメンバー口座タイプを示します。そのリスト内の口座は、このグループのメンバーに対して、個人的な口座概観の中に表示されます。口座タイプは、様々なグループが共有することができ、これは、様々なグループが同一の関連付けられた口座タイプを持ちうることを意味します。そのような場合、依然として、各グループのための様々な口座設定と権限を定められます。<br><br><img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp; 編集アイコンをクリックすることにより、口座設定を修正できます。<br> <b>注</b>:この口座について支払いを行い、受け取ることができるようになるには、それを作成または修正するだけでは十分でないということに注意してください。そのグループのための<a href="#permissions"><u>権限</u></a>を設定する必要もあり、さもなければ、その口座は使えません。<br><br><img border="0" src="${images}/delete.gif" width="16" height="16">&nbsp;消去アイコンをクリックすることにより、このグループのための口座タイプを分離することもできます。グループから口座を「分離」すると、その口座はユーザーに見えるままでユーザーはその口座の取引を見られますが、その口座は「非アクティブ」な状態になるということを意味します。それは支払いのためにはもはや使えません。
<br><br>このボックスの下にある「新しい口座を関連付ける」送信ボタンをクリックすることにより、新しい口座タイプをこのグループに関連付けることもできます。これにより、<a href="#insert_group_account"><u>「グループ口座を挿入する」</u></a>ウィンドウへと移動します。
<hr class="help">
</span>


<span class="admin"> <a name="edit_group_account"></a> <a
	name="insert_group_account"></a>
<h3>口座設定を修正する/グループに口座を追加する</h3>
このページでは、選択されたグループの口座タイプのための口座設定を定められます。これは、既存の関連付けられた口座タイプについて、または、初めてこのグループに関連付けたい口座タイプについて可能です。<br> 既存の口座を修正する場合、修正を行えるようにするために、「変更」をクリックしてください。新しい口座タイプを関連付ける場合、直接そのフィールドに入れます。完了したら、「送信」をクリックして、変更を保存してください。<br> 以下の設定を定められます:
<ul>
	<li><b>口座:</b> 関連付けたい口座タイプです。 一度口座がタイプが作成されるとそれは変更できないので、それは新しい口座タイプについてのみ利用可能です。既に作成されている口座タイプを関連付けることしかできません。適切な口座を作成していない場合は、それを関連付けられるようになる前に、まずこれを行うべきです。
	<li><b>標準である:</b> 複数のメンバー口座を作成することが可能なので、システムは、どの口座が標準のものになるかを知る必要があります。これは2つの理由のためです。 第1に、システムは、メンバーに標準口座の残高を知らせるメールを送信するように設定できます。第2に、携帯電話によって行われる支払いは、標準の口座を使います。
	<li><b>取引パスワードを必要とする:</b> このオプションがチェックされた場合、そのメンバーは、取引パスワードを記入するように求められます。<br> 注:このオプションは、取引パスワードがそのグループについて(グループ設定内で)有効化された場合にのみアクティブ化できます。そうでなければ、それは見えるようになりません。
	<li><b>クレジット制限がない場合に隠す:</b> 一部の金融商品については、個人的なクレジット制限が定義されていない場合、メンバー口座を表示させたくないかもしれません。たとえば、追加的なメンバー口座がクレジットカード支払いのために使われる場合です。通常、そのような口座には、メンバーがカード支払いのために使えるマイナスのクレジット制限があります。定期的にそのメンバーは自分の負債を返済するために賦課されます。すべてのメンバーが個人のマイナスクレジット制限を持っているわけではないかもしれず、それらのメンバーにはクレジット制限を表示したくないかもしれません。<br> もちろん、これは「クレジットカードメンバー」のための別個のグループを作成し、その新しいグループにクレジット口座を割り当てることによって解決できます。しかし、これではさらに複雑になってしまいます。異なるグループを作成しなくてよいように、メンバーにマイナスのクレジット制限が設定されている場合のみ、口座が表示されるようにすることが可能です。もちろん、これは個人のクレジット制限に対して適用されます。グループ全体にくれ取引がある口座はすべて表示されるというCyclos内の一般的なルールは、このオプションに優先します。つまり、ある口座に対してこのオプションが設定されおり、メンバーがクレジット制限を持たないがその口座上で取引している場合、その口座は表示されます。
	<li><b>クレジット下限:</b> その口座についての標準のクレジット制限。その額は、典型的に、ゼロまたはマイナスの額になります。
	これを変更すると、既存の口座に影響を与えるかもしれません。それは、このページの少し下の方にある「既存のメンバーについてのクレジット制限を更新する」チェックボックス(以下を見てください)に依存します。グループ全体に対して有効な標準のクレジット制限に加えて、個々のメンバーのための<a href="${pagePrefix}account_management#credit_limit"><u>クレジット制限</u></a>も設定できます。個人毎の設定は、グループクレジット制限を上書きします。
	<li><b>クレジット上限:</b> クレジット上限を定めると、その口座がこの制限に達した場合、支払いを受け取らないということを意味します。支払人は、その支払いが失敗したということを知らせるメッセージを受け取ります。
	<li><b>既存のメンバーについてのクレジット制限を更新する:</b> 既存の口座タイプ関連づけのクレジット制限を変更した場合、この選択ボックスにより、既存のメンバーについてのクレジット制限(個人クレジット制限またはグループクレジット制限)が変更されるかどうかを定められます。この選択ボックスを選択しなければ、新しいクレジット制限は、このグループの新しいメンバーに対してのみ適用されます。このボックスは、第1のタイプのためにこの口座を関連付ける場合には見えません。
	<li><b>初期クレジット:</b> これは、新しいメンバーが自動的に受け取る額です。これはゼロまたはプラスの額にすることができます。
	<li><b>初期クレジット取引タイプ:</b> このすぐ上の編集ボックス内で、0以外の初期クレジットが設定されている場合、このドロップダウンボックスで、このクレジットのための<a href="${pagePrefix}account_management#transaction_types"><u>移転タイプ</u></a>の種類を指定しなければなりません。移転タイプには、移転元口座と移転先口座があるので、それにより、どの口座から初期クレジット額が取られるかを指定できます。標準のシステムデータベースには、デビット口座からメンバー口座への「初期クレジット」移転タイプが備わっていますが、もちろん、あなたは自由に別の移転タイプを使用できます。
	<li><b>低ユニットアラート:</b> メンバー口座がこの額に達すると、パーソナルアラートメッセージ(下を見てください)が送信されます。ここにはプラスの額のみを入力できます。入力する額はクレジット制限に関連しています。たとえば、クレジット制限が-200で低ユニット設定が10の場合、そのメンバーは、残高が-190に達した時に、低ユニットアラートを受け取ります。クレジット制限がゼロであり、低ユニット設定が10ならば、そのメンバーは、残高が10(プラスの)ユニットに達した時に、低ユニットアラートを受け取ります。
	<li><b>低ユニットメッセージ:</b> 低ユニット額に達した時に、メンバーが受け取るパーソナルメッセージ。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="manage_group_customized_files"></a>
<h3>カスタマイズされたファイルを管理する</h3>
Cyclosは、高度にカスタマイズ可能です。 独自のスタイルやテキストが表示されるように定める(<a href="${pagePrefix}content_management"><u>「コンテンツ管理」</u></a>から)だけでなく、グループレベルでこれを指定することもできます。つまり、各グループは、ソフトウェア内に表示されるグループ固有のスタイルやグループ固有のテキストを持つことができます。これらは「カスタマイズされたファイル」と呼ばれます。<br><br>このウィンドウは、このグループのためのカスタマイズされたファイルの概観を与えます。
カスタマイズされたファイルがまだ1つも定められていなければ、利用可能なものがないというメッセージが表示されます。以下のオプションがあります:
<ul>
	<li><b>挿入する</b> 「新しいファイルをカスタマイズする」ボタンからカスタマイズされた新しいファイルを挿入します。カスタマイズされたグループファイルは、システムのカスタマイズされたファイル(<a href="${pagePrefix}content_management"><u>「コンテンツ管理」</u></a>から設定できる)を上書きします。
	<li><b>修正する:</b> <img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;編集アイコンから、既存のカスタマイズされたファイルを修正します。
	<li><b>閲覧する:</b> <img border="0" src="${images}/view.gif" width="16" height="16">&nbsp;ビューアイコンによって、そのグループのメンバーにその結果がどのように見えるかを閲覧します。
	<li><b>消去する:</b> <img border="0" src="${images}/delete.gif" width="16" height="16">&nbsp;消去アイコンから、カスタマイズされたファイル定義を消去します。それが消去された場合、もし利用可能ならば、システムのための標準のカスタマイズされたファイルが使われます。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="customize_group_file"></a>
<h3>...のためにカスタマイズされたファイルを修正する /...のために新しいファイルをカスタマイズする</h3>
このページでは、静的ファイルまたはCSSファイルをカスタマイズできます。 それは、<a href="${pagePrefix}content_management"><u>コンテンツ管理</u></a>内と同様に機能しますが、今回はそれをこのグループだけのために指定します。<br> 入力すべきことに関する具体的な指示については、<a href="${pagePrefix}content_management#edit_customized_file"><u>ここ</u></a>を見てください。<br><br> <b>注:</b>静的ファイル内に画像を含めたい場合、それらは<a href="${pagePrefix}content_management#custom_images"><u>アップロードされる</u></a>必要があります。</span>


<hr>
<a name="permissions"></a>
<h2>権限</h2>
<br><br>Cyclosでは、権限はグループごとに組織化されます。各グループについて、Cyclosソフトウェア内の諸機能にアクセスする権限を管理できます。通常、メンバーグループがアクセスできないCyclosのセクションは、これらのメンバーグループには見えません。<br> <span class="admin">システムは非常に柔軟です。たとえば、それによって様々な管理者グループを作成できます。そこでは、各管理者グループは、特定のメンバーグループを管理する権限を持っています。より複雑なシステムのために、「垂直的に」追加的な管理を作成し、アカウント管理者、システム管理者、簿記管理者、バウチャー/スクリップ管理者などのような具体的なタスク領域を定めることが可能です。「メニュー: グループ &gt; 権限グループ」で、権限アイコン(<img border="0" src="${images}/permissions.gif" width="16" height="16">&nbsp;)をクリックすることにより、グループ権限を修正できます。</span>
<hr class="help">


<a name="manage_group_permissions_basic"></a>
<h3>グループの基本的権限</h3>
このウィンドウでは、基本的な権限を設定できます。 基本的権限は、すべての<a href="#group_categories"><u>グループタイプ</u></a>(メンバー、管理者、仲介人)について同様である権限です。<br>
これらの基本的権限は、他の機能に影響しません。たとえば、メンバーがログインできない場合でも、依然として支払いを受け取れるかもしれません。<br> 以下の権限を設定できます:
<ul>
	<li><b>ログイン</b>: これがチェックされなかった場合、このグループのメンバーはログインできません。
	<li><b>招待メッセージ</b>: チェックされると、このグループのメンバーには、メインページ内に(ログイン後)ウィンドウボックスが見えます。それにより、<a href="${pagePrefix}home#home_invite"><u>あなたの組織を試用する</u></a>ために友人を招待できます。
</ul>
<hr class="help">


<span class="admin"> <a	name="manage_group_permissions_admin_system"></a>
<h3>システム管理者権限</h3>
このウィンドウでは、管理者グループのシステム機能のための権限を設定できます。したがって、この権限ウィンドウは、メンバーグループに関連したいかなる権限も含みません。変更を行うには、一番下までスクロールして、「変更」ボタンを選択しなければなりません。そのボタンにより変更が可能になります。変更は、そのページの完全に一番下にある「送信」をクリックした後に保存されます。<br><br>権限構造は、単純明快です。 たいていの機能には、2つの権限、「閲覧する」と「管理する」があります。<br> 閲覧が選択されなかった場合、その項目は、そのグループの管理者のためのメニューの中に表示されません。<br> 「管理する」オプションは、作成、編集、消去する権限を与えます。<br><br> 以下の権限が利用可能です(追加的な情報のためのリンクを使いたいかもしれません):
<ul>
	<li><b>口座手数料:</b> 閲覧権限は、管理者が<a href="${pagePrefix}account_management#account_fee_overview"><u>口座手数料概観</u></a>ページに行けるようにします。<br> 「賦課する」権限は、<a href="${pagePrefix}account_management#account_fee_history"><u>口座手数料履歴</u></a>ページ内で、「手動の」または失敗した口座手数料を賦課できるようにします。<br>
	<li><b>口座:</b> このセクションは、あなたが以下の権限を設定できるようにします:
	<ul>
		<li><b><a href="${pagePrefix}account_management#account_search"><u>口座を管理する</u></a></b> 口座構造を作成および修正する権限。
		<li><b>口座管理を閲覧する:</b> 前の項目と同じですが、管理者が変更できません。
		<li><b>システム口座情報を閲覧する:</b> ここでは、管理者によってどのシステム口座概要が閲覧可能かを設定できます。
		<li><b><a href="${pagePrefix}payments#authorized"><u>認可された支払い</u></a>を閲覧する</b> 認可された支払いメニュー項目を閲覧します。
		<li><b><a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a>を閲覧する</b> スケジュールされた支払いメニュー項目を閲覧します。
	</ul>
	<li><b>広告カテゴリー:</b> <a href="${pagePrefix}advertisements#categories"><u>広告カテゴリー</u></a>のための権限を設定します。<br>
	<li><b>管理者グループ:</b>
	<ul>
		<li><b>閲覧する</b>が選択されると、管理者は、<a href="#manage_groups"><u>グループ権限ウィンドウ</u></a>内で様々な管理者グループを見られます。
		<li><b>カスタマイズされたファイルを管理する:</b> 管理者が、他の管理者のために<a href="#manage_group_customized_files"><u>カスタマイズされたファイル</u></a>を管理できるようにします。
	</ul>
		<li><b>管理タスク:</b> 管理者がシステム状態を見られるようにします。
	<ul>
		<li><b>システム利用可能性を設定する:</b> 選択されると、管理者は<a href="${pagePrefix}settings#online_state"><u>システム利用可能性</u></a>を制御できます。
		<li><b>インデックスを管理する:</b> 選択されると、管理者は<a href="${pagePrefix}settings#search_indexes"><u>インデックスを管理する</u></a>ことができます。
	</ul>
	<li><b><a href="${pagePrefix}alerts_logs#system_alerts"><u>アラート</u></a></b>は、特別な場合のシステムからの警告です。<br>
	<li><b><a href="${pagePrefix}access_devices#list_card_type"><u>カードタイプ</u></a></b> 管理者がカードタイプ(リンクを見てください)を管理し閲覧できるようにします。 
	<br>
	<li><b><a href="${pagePrefix}settings#channels"><u>チャネル</u></a></b>は、どの手段によって、そのユーザーがCyclosにアクセスするかを定めます(例: Web、携帯電話など)。 <br>
	<li><b><a href="${pagePrefix}account_management#currencies"><u>通貨</u></a>:</b>
	管理者が、Cyclos内で様々な通貨を閲覧および/または管理できるようにします。<br>
	<li><b><a href="${pagePrefix}custom_fields"><u>カスタムフィールド</u></a>:</b> 管理者が、カスタムフィールドを管理できるようにします。 <br>
	<li><b><a href="${pagePrefix}content_management#custom_images"><u>カスタマイズされた画像</u></a></b> 管理者が、カスタム画像を管理できるようにします。これは「コンテンツ管理」メインメニューの下にある以下のメニュー項目の可視性に影響します:
	<ul>
		<li>システム画像
		<li>カスタム画像
		<li>スタイルシート画像
	</ul>
	<li><b><a href="${pagePrefix}alerts_logs#error_log"><u>エラーログ</u></a></b> エラーを閲覧および管理できるようにします。<br> <br>
	<li><b><a href="${pagePrefix}bookkeeping"><u>外部口座(簿記)</u></a>:</b> 管理権限は、管理者が外部口座の作成および修正やフィールドと取引タイプの定義のようなモジュールを設定可能にします。<br> 閲覧権限は、外部口座設を閲覧可能にします。<br> 詳細権限は、支払いを閲覧可能にしますが、それらに対して任意のアクションを実行可能にはしません。<br><br> その他の権限(処理、チェック、管理)は、外部支払いのための運営上の権限です。 <br>
	<li><b><a href="#group_filters"><u>グループフィルタ</u></a></b> グループの集合をまとめて、その集合に特定の名称を与えられるようにします。この方法で、一種の「スーパーグループ」を作成することができ、それをCyclos内のいくつかの機能のために使えます。<br> もちろん、権限を設定するために「管理する」および「閲覧する」を選べますが、「カスタマイズされたファイルを管理する」を選ぶこともできます。これは、あるグループフィルタに対して、したがって、一度にグループの集合に対して、管理者がカスタマイズされたファイルを設定できるようにします。 <br>
	<li><b>保証書タイプ: </b> 保証書システムでは、様々な<a href="${pagePrefix}guarantees"><u>保証書のタイプ</u></a>を定められます。 <br>
	<li><b><a href="${pagePrefix}content_management#infotexts"><u>情報テキスト</u></a></b>.
	管理者に情報テキストの閲覧と管理の権利を与えてください(リンクを見てください)。<br>
	<li><b><a href="${pagePrefix}loan_groups"><u>ローングループ</u></a></b> - ローングループを閲覧および作成します。ローングループは、マイクロクレジットの方法で、ローンを受け取りおよび返済できるグループです。 <br>
	<li><b><a href="${pagePrefix}member_records"><u>メンバー記録タイプ:</u></a></b> メンバー記録により、メンバーに関して収集される情報を定められます。この権限によって、管理者は、そのようなメンバー記録タイプを作成/定義できます。<br>
	<li><b>メッセージカテゴリー:</b> 管理者が、内部<a href="${pagePrefix}messages"><u>メッセージ</u></a>システムのための様々なカテゴリーを閲覧および/または管理できるようにします。<br>
	<li><b>権限グループ:</b> 様々な<a href="#group_categories"><u> グループカテゴリー</u></a>を<a href="#manage_groups"><u>管理</u></a>できるようにします。<br>
	<li><b><a href="${pagePrefix}groups#list_registration_agreements"><u>登録同意書</u></a></b> 管理者が登録同意書を閲覧して管理できるようにします。 <br>
	<li><b>レポート:</b> 各項目は、メインメニュー項目に対応します:
	<ul>
		<li><b><a href="${pagePrefix}reports#current_state"><u>状態レポート</u></a></b>
		<li><b><a href="${pagePrefix}reports#member_lists"><u>メンバーリスト</u></a></b>
		<li><b>送信されたSMSメッセージ:</b> システムは、設定に依っては、様々な場合にいくつかのSMSメッセージを送信するかもしれません。この権限は、管理者が、送信されたSMSメッセージを概観するレポートにアクセスできるようにします。
		<li><b><a href="${pagePrefix}statistics"><u>統計</u></a></b>は、統計モジュールへのアクセスを与えます。
	</ul>
	<li><b>設定:</b> これは、管理者に設定メニューへのアクセスを与えます。
	<ul>
		<li><b><a href="${pagePrefix}settings#local"><u>ローカル設定を管理する</u></a></b>
		<li><b><a href="${pagePrefix}settings#alerts"><u>アラート設定を管理する</u></a></b>
		<li><b><a href="${pagePrefix}settings#access"><u>アクセス設定を管理する</u></a></b>
		<li><b><a href="${pagePrefix}settings#mail"><u>メール設定を管理する</u></a></b>
		<li><b><a href="${pagePrefix}settings#log"><u> ログ設定を管理する</u></a></b>
		<li><b>設定を閲覧する</b> (設定を閲覧するのみ)
		<li><b><a href="${pagePrefix}settings#import_export"><u>設定をエクスポート/インポートする</u></a></b>
	</ul>
	<li><b>システム支払い:</b> ここでは、<a href="${pagePrefix}account_management#standard_accounts"><u>システム口座</u></a>からの支払いのための権限を割り当てられます。
	<ul>
		<li><b>システム支払い:</b> 管理者は、選択された<a href="${pagePrefix}account_management#transaction_types"><u>移転タイプ</u></a>に属するシステム支払いを行えます。
		<li><b>認可する:</b> システム支払いを<a href="${pagePrefix}payments#authorized"><u>認可する</u></a>権限。
		<li><b>キャンセルする:</b> <a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a>をキャンセルする権限。
		<li><b>チャージバック支払い:</b> この権限のある管理者は、支払いを「チャージバック」することができ、 それは、反対の支払いが同じ額で行われるということを意味します。その支払いが他の取引(たとえば、手数料とローン)を生成した場合、すべての取引がチャージバックされます。<br>
	<a href="${pagePrefix}settings#local"><u>ローカル設定</u></a>内で取引タイプがチャージバックされ得る最大回数を定められます。
		<li><b>スケジュールされた支払いをキャンセルする:</b> (一目瞭然です。)
		<li><b>スケジュールされた支払いをブロックする:</b> (一目瞭然です。) 
	</ul>
	<li><b>システム状態:</b> 管理者が、システム状態を見られるようにします:
	<ul>
		<li><b>システム状態を閲覧する:</b> 選択された場合、管理者は、ホームページ内で、<a href="${pagePrefix}home#home_status"><u>システム状態を閲覧する</u></a>ウィンドウを見られます。
		<li><b>接続中の管理者を閲覧する:</b> ここでは、管理者が<a href="${pagePrefix}user_management#connected_users"><u>接続中のユーザー</u></a>ウィンドウ内で閲覧できる<a href="#admin_groups"><u>管理者グループ</u></a>を選択してください。
		<li><b>接続中の仲介人を閲覧する:</b> 同様に機能します。 管理者は、閲覧権限を持っている<a href="#broker_groups"><u>仲介人グループ</u></a>の接続中の仲介人のみを閲覧できます。
		<li><b>接続中のメンバーを閲覧する:</b> 同様に機能します。 すべての<a href="#member_groups"><u>メンバーグループ</u></a>のための1つのチェックボックスがあります。管理者は、閲覧権限を持っている接続中のグループのメンバーのみを閲覧します。
		<li><b>接続中のオペレータを閲覧する:</b> 同様に機能します。 それはオペレータとそのオペレータが属するメンバーを表示します。
	</ul>
	<li><b><a href="${pagePrefix}content_management"><u> システム全体のカスタマイズされたファイル</u></a> :</b> 管理者がシステム全体のカスタマイズされたファイル(グループごとにカスタマイズされたファイルではなく)を設定できるようにします。これは「コンテンツ管理」メインメニューの下の、以下のメニュー項目に影響します:
	<ul>
		<li>静的ファイル
		<li>ヘルプファイル
		<li>CSSファイル
		<li>アプリケーションページ
	</ul>
	<li><b>テーマ:</b> <a href="${pagePrefix}content_management"><u>コンテンツ管理</u></a>メニューの下にある<a href="${pagePrefix}content_management#themes"><u>テーマ</u></a>を管理します。<br>
	<li><b>翻訳:</b> <a href="${pagePrefix}translation"><u>翻訳</u></a>メインメニューへのアクセスを可能にします。そこでは、あなたの言語での翻訳を閲覧/管理できます。
	<br>
	<li><b><a href="${pagePrefix}settings#web_services_clients"><u>Webサービスクライアント</u></a></b> CyclosのWebサービスに接続するための外部ソフトウェアのアクセスレベルを定めます。 <br>
</ul>
<hr class="help">
</span>


<span class="admin"> <a
	name="manage_group_permissions_admin_member"></a>
<h3>メンバー管理権限</h3>
このウィンドウでは、管理者グループのメンバー機能のための権限を設定できます。これらの権限は、典型的に「アカウント管理者」グループに適用されます。権限構造は、単純明快です。たいていの機能には、「閲覧する」および「管理する」権限があり、時には、追加的な固有の権限があります。<br> 閲覧が選択されていない場合、その機能は、そのメニュー内に表示されず、メンバーアクションボタンとしても表示されません(その管理者が、ブラウザ内に直接その位置を入力すると、根底にある権限構造は「権限がありません」ページを表示するでしょう)。<br> 「管理する」オプションは、作成、編集、消去する権限を与えます。<br><br>最初の選択ボックス(「グループを管理する」)内で、1つまたは複数のメンバーグループを選択できます。これは、このグループの管理者が、それらのグループのメンバーのみを管理でき、それらのグループに関する情報のみを見られるということを意味します。これは、ローン、レポート、アラート、ログイン中のユーザーなどのような、メンバーに関連した任意の他の情報が、選択されたグループに関連した結果のみを表示するということを意味します。<br> このオプションによって、特定のメンバーグループを特定のアカウント管理者に管理させることができます。<br><br>以下の権限を設定できます - さらなる情報のために、リンクを使いたいかもしれません:
<ul>
	<li><b>アクセス:</b> そのメンバーグループのメンバーによるアクセスを制御する権限。それは、以下の下位項目を含みます:
	<ul>
		<li><b>ログインパスワードを変更する:</b> その管理者が、そのメンバーのプロフィール(メンバーアクション「パスワードを管理する」内)から、そのメンバーのログインパスワードを変更できるようにします。<br> この権限がチェックされていないとしても、管理者は、依然として、メンバー登録の際に一時的なパスワードを定められます(メンバーは、初回ログイン時にパスワードを変更するように強いられます)。しかし、これは、<a href="#edit_member_group"><u>グループ設定</u></a>の「Eメールでパスワードを送信する」がチェックされていない場合のみです。<br> グループ設定の「Eメールでパスワードを送信する」がチェックされた場合(メンバーグループ設定内)、その管理者は、登録時にパスワードを定められません。この場合、そのメンバーは、一時的なパスワードを自動的にメールで受け取りますが、それは初回ログイン時に変更される必要があります。<br> グループ設定の「Eメールでパスワードを送信する」と「ログインパスワードを変更する」の両方がチェックされた場合、その管理者は、登録時に確定的な(一時的でない)パスワードを定めるか、初回ログイン時にユーザーにそのパスワードの変更を強いることができます。
		<li><b>ログインパスワードをリセットする:</b> その管理者が、メンバーのパスワードをリセットできるようにします。それは一般的に、(設定次第では)パスワードが自動的に再生成され、メールで送信されるということを意味します。
		<li><b><a href="${pagePrefix}passwords#transaction_password"><u>取引パスワード</u></a>を管理する:</b> 取引のために設定され得る特別なパスワードを管理できるようにします。
		<li><b>ログイン中のメンバーを切断する:</b> その管理者が、現在システムを使用中のメンバーを即座に切断できるようにします。
		<li><b>ログイン中のオペレータを切断する:</b> その管理者が、現在システムを使用中の<a href="${pagePrefix}operators"><u>オペレータ</u></a>を即座に切断できるようにします。
		<li><b>無効化されたメンバー(ログイン試行失敗のため)を再アクティブ化する:</b> メンバーがパスワードを忘れて、何度も誤ったパスワードでログインを試行すると、そのメンバーは一時的に無効化されます。この権限が設定された場合、管理者は、そのようなメンバーを即座に再びログイン可能にすることができます。そのような場合、メンバープロフィール内に「メンバーのログインを今すぐ可能にする」ボタンが現れます。
		<li><b>PINを変更する:</b> その管理者が、<a href="${pagePrefix}passwords#pin"><u>PIN番号</u></a>を変更できるようにします。それは、Webショップのような特定の<a href="${pagePrefix}settings#channels"><u>チャネル</u></a>へのアクセスのための数字のパスワードです。
		<li><b>PINをブロック解除する:</b> そのメンバーが最大試行回数を超過した時、PINをブロック解除します。
		<li><b>チャネルアクセスを変更する:</b> Web、携帯電話からのようなチャネルへのアクセス方法を変更します。
	</ul>
	<li><b>口座:</b> 管理者グループがメンバー口座を管理または閲覧するための権限。それは以下の下位項目を含みます。
	<ul>
		<li><b>情報を閲覧する:</b> その管理者が、口座情報(残高、取引概観など)を閲覧できるようにします。
		<li><b>認可された支払いを閲覧する:</b> その管理者が、<a href="${pagePrefix}payments#authorized"><u>認可された支払い</u></a>を閲覧できるようにします。
		<li><b>スケジュールされた支払いを閲覧する:</b> その管理者が、<a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a>を閲覧できるようにします。	
		<li><b>クレジット制限を設定する:</b> その管理者が、個人のクレジット制限を設定できるようにします。これは、そのグループのために設定されたクレジット制限を覆します。
	</ul>
	<li><b><a href="${pagePrefix}reports#member_activities"><u>活動レポート</u></a>:</b> 特定のメンバーの活動についてのレポートです。それは、そのメンバーのプロフィールの下にあるアクションボタンからアクセス可能です。下位項目は、一目瞭然です。<br>
	<li><b>仲介:</b> <a href="${pagePrefix}brokering"><u>仲介人</u></a>によるメンバーの仲介に関する権限。
	<ul>
		<li><b>仲介人を変更する:</b> メンバーの集合の仲介人を変更する。
		<li><b>メンバーリストを閲覧する(仲介人として):</b> その管理者が、ある仲介人のメンバーを閲覧できるようにします。
		<li><b>メンバーリスト内のローン詳細を閲覧する(印刷する):</b> 仲介人によって管理または調整されるメンバーのリスト内でローンを閲覧できるようにします。
		<li><a href="${pagePrefix}brokering#commission"> <u>委託手数料を</u></a><b>管理する</b>:ある仲介人が得るかもしれない委託手数料を管理します。
	</ul>
	<li><b>バルクアクション:</b> <a href="${pagePrefix}user_management#bulk_actions"><u>バルクアクション</u></a>を使って、あなたはメンバーの集合に対し特定のアクションを行えます。
	<ul>
		<li><b>グループを変更する:</b> メンバーの集合のグループを変更します。
		<li><b>仲介人を変更する:</b> メンバーの集合の仲介人を変更します。
		ある仲介人が仲介業務を辞め、そのメンバーが別の仲介人を必要とする時に、これを行いたいかもしれません。
		<li><b>カードを生成する:</b> ユーザーのグループに対して、(対応する<a href="${pagePrefix}access_devices#list_card_type"><u>カードタイプ</u></a>に基づく)カードの生成を可能にします。
		<li><b>チャネルアクセスを変更する:</b> Web、携帯電話からのようなチャネルへのアクセス方法を変更します。					
	</ul>
	<li><b>カード:</b> 管理者がメンバーの<a href="${pagePrefix}access_devices#list_card_type"><u>カード</u></a> に対する操作を行えるようにします。 
	<br>
	<li><b>ドキュメント:</b> その管理者が、メンバー<a href="${pagePrefix}documents"> <u>ドキュメント</u></a>を管理および閲覧できるようにします。以下の下位項目に適用されます:
	<ul>
		<li><b>ドキュメントを閲覧する:</b> ここで、その管理者が閲覧できるドキュメントを選択できます。ドキュメントが1つも利用可能でない場合、ドロップダウンは空になります。
		<li><b><b><a href="${pagePrefix}documents"><u>動的</u></a>ドキュメントを管理する</b></b>
		<li><b><b><a href="${pagePrefix}documents"><u>静的</u></a>ドキュメントを管理する</b></b>
		<li><b><b><a href="${pagePrefix}documents#member_document"><u>メンバー</u></a>ドキュメントを管理する</b></b>
	</ul>
	<li><b>保証書:</b> 管理者が<a href="${pagePrefix}guarantees#guarantees_search"><u>保証書</u></a>システムに関する操作を行えるようにします。 
	<br>
	<li><b><a href="${pagePrefix}loan_groups"><u>ローングループメンバーシップ</u></a></b> ここでは、管理者がローングループのメンバーを追加および削除できるか、ローングループを閲覧するだけかを定められます。 <br>
	<li><b><a href="${pagePrefix}loans"><u>ローン</u></a>:</b> メンバーローンへのアクセスを許可するための設定です。以下の下位項目を含みます:
	<ul>
		<li><b>メンバーローンを閲覧する</b> メンバーの通常のローンを閲覧します。
		<li><b>認可されたローンを閲覧する:</b> 一部のローンについては、特別な認可が必要とされます。
		<li><b>ローンを認可する:</b> ドロップダウンにより、その管理者がユーザーに認可することを許される様々なタイプのローンを指定できます。
		
		<li><b>過去の日付でローンを認可する:</b> ローン日付を現在の日付にできない特別な場合のためのものです。 
		<li><b><a href="${pagePrefix}loans"><u>ローンを放棄する</u></a>:</b> その残額をゼロにすることによって、ローンを「キャンセル」することを可能にします。
		<li><b>ローンを返済する:</b> その管理者が、そのメンバーのためのローンを返済できるようにします。
		<li><b>過去の日付でローンを返済する:</b> 前の項目と同じですが、今度はその管理者が、返済の日付を過去のある日付に設定できるようにします。
		<li><b>満期ローン状態を管理する:</b> 満期ローンに<a href="${pagePrefix}loans#status"><u>追加的な状態/印</u></a>を与えられるようにします。
	</ul>
	<li><b>メンバーグループ:</b>
	<ul>
		<li><b>閲覧する:</b> これが設定された場合、メンバーグループの<a href="#manage_groups"><u>概観</u></a>は、その管理者によって閲覧され得ます。
		<li><b>口座設定を管理する:</b> その管理者が<a href="#manage_group_accounts"><u>グループ口座設定を管理する</u></a>ことを可能にします。これが設定されて<b>いない</b>場合、その管理者は、(前の権限項目によっては)設定を閲覧できますが、それらを変更することはできません。
		<li><b>カスタマイズされたファイルを管理する:</b> 管理者が、このグループのために<a href="${pagePrefix}content_management#customized_files"><u>カスタマイズされたファイル</u></a>を管理できるようにします。
	</ul>
	<li><b>メンバー請求書:</b> その管理者によるメンバー<a href="${pagePrefix}invoices"><u>請求書</u></a>へのアクセスを可能にする様々な設定です。これらの項目のすべては十分に一目瞭然なので、私たちは、ここで下位項目の説明を提供しません。 <br>
	<li><b>メンバー支払い:</b> これは、<a href="${pagePrefix}payments"><u>支払い</u></a>に関する権限の集合です。下位項目は、以下の通りです:
	<ul>
		<li><b>システムからメンバーへの支払い:</b> ここで、その管理者が、システム口座からそのメンバーに支払うために使えるシステム支払いを選択してください。
		<li><b>過去の日付でのメンバー支払い:</b> その管理者が、システムからメンバーへの支払いを、「前の日付で」行えるようにします。つまり、過去の日付を支払い日として設定できます。
		<li><b>メンバーからメンバーへの支払い:</b> その管理者が、あたかもそのメンバーであるかのように、別のメンバーに支払う際に行える支払いタイプを、ここで選択してください。
		<li><b>メンバー自己支払い:</b> これらは、あるメンバーの1つの口座から、同じメンバーの別の口座への支払いです。管理者は、あたかもそのメンバーであるかのように、これらの支払いを行えます。
		<li><b>メンバーからシステムへの支払い:</b> その管理者は、あたかもそのメンバーであるかのように、メンバー口座からシステム口座への支払いを行えます。ここでこれを可能にしたい支払いタイプを選択してください。
		<li><b><a href="${pagePrefix}payments#authorized"><u>認可された支払い</u></a></b> 特別な認可が必要とされる支払いです。ここでは、その管理者が、あたかもそのメンバーであるかのように支払いを認可できるよう設定します。
		<li><b>認可された支払いをメンバーとしてキャンセルする</b>
		<li><b><a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a>をメンバーとしてキャンセルする</b><br> この設定が機能するためには、取引タイプ設定も、スケジュールされた支払いのキャンセルを可能にしなければなりません。
		<li><b>スケジュールされた支払いをメンバーとしてブロックする:</b> スケジュールされた支払いをブロックできるようにします。ブロックとキャンセルの間の違いは、ブロックされたスケジュールされた支払いは、ブロック解除できるということです。キャンセルは決定的です。<br> この設定が機能するためには、取引タイプ設定も、スケジュールされた支払いのブロックを可能にしなければなりません。
		<li><b><a href="${pagePrefix}payments#charge_back"><u>チャージバック支払い</u></a>:</b> その管理者が、メンバーのために支払いを元に戻せるようにします。
	</ul>
	<li><b><a href="${pagePrefix}member_records"><u>メンバー記録</u></a>:</b> その管理者が、メンバー記録を管理できるようにします。これらは、そのメンバーに関して収集される情報を定められるようにします。下位項目は、一目瞭然です。<br>
	<li><b>メンバー:</b> 管理者がメンバーについて何を行えるかに関するいくつかのその他の権限です。下位項目：
	<ul>
		<li><b>登録する:</b> これが選択された場合、その管理者は、ユーザー検索ページから新しいメンバーを登録できます。
		<li><b>保留中のメンバーを管理する:</b> その管理者は、登録済みだがまだ(メールによって)登録を認証していないメンバーを閲覧できます。<br> さらなる情報は、<a href="${pagePrefix}user_management#search_pending_member"><u>ヘルプファイル</u></a>で利用可能です。
		<li><b>プロフィールを変更する:</b> これが選択された場合、その管理者は、メンバーの<a href="${pagePrefix}profiles"><u>プロフィール</u></a>フィールド内で変更を行えます。
		<li><b>ログイン名を変更する:</b> (一目瞭然です。)
		<li><b>メンバー名を変更する:</b> (一目瞭然です。)
		<li><b>永久的に削除する:</b> その管理者は、データベースからメンバーを永久に削除できます。これは、そのメンバーが、口座を持つグループに一度も属していなかった場合にのみ行えます(アクティブ化された後は、メンバーは、常に<a href="#removed_members"><u>削除済みメンバー</u></a>グループに入れることができます)。
		<li><b>グループを変更する:</b> その管理者がメンバーのグループを変更できるようにします。
		<li><b>インポートする:</b> その管理者が、メンバーリストをCyclosにインポートできるようにします(通常、他のシステムからの移動です)。<br> さらなる情報は、<a href="${pagePrefix}user_management#import_members"><u>ヘルプファイル</u></a>で利用可能です。
	</ul>
	<li><b>メッセージ:</b> 管理者によるCyclosの<a href="${pagePrefix}messages"> <u>メッセージ</u></a>システムへのアクセスを可能にします。
	<ul>
		<li><b>閲覧する:</b> 管理者が、どのタイプのメッセージカテゴリーの閲覧を許されるかを選べるドロップダウンがあります。<a href="${pagePrefix}messages#categories"><u>メッセージカテゴリー</u></a>から、新しいタイプのメッセージを作成できます。
		
		<li><b>メンバーに送信する:</b> 管理者が、個々のメンバーにメッセージを送信できるようにします。
		<li><b>グループに送信する:</b> 管理者が、メンバーグループ内の全員にメッセージを送信できるようにします。
		<li><b>管理する:</b> メッセージの管理を可能にします。 これにより、たとえば、古いメッセージを検索したり、メッセージカテゴリーを作成することが可能になります。
    </ul>
	<li><b>POS:</b> 管理者がメンバーの<a href="${pagePrefix}access_devices#search_pos"><u>POSデバイス </u></a>を管理できるようにします。
	<br>
	<li><b>個人設定:</b> 管理者がユーザー<a href="${pagePrefix}preferences"><u>個人設定</u></a>を管理できるようにします。
	<br>	
	<li><b>商品とサービス:</b> これらの権限により、この管理者グループの管理者は、メンバーの広告を閲覧および/または管理できるようにします。<br> <a href="${pagePrefix}advertisements#import_ads"><u>広告のインポート</u></a>を可能にする権限もあります。 <br>
	<li><b><a href="${pagePrefix}references"><u>評価</u></a>:</b> その管理者が、評価を管理または閲覧できるようにします。メンバーが互いに良いまたは悪い資格を割り当てできるシステムです。<br>
	<li><b><a href="${pagePrefix}reports#sms_log"><u>SMSログ</u></a>:</b> このメンバーのために送信されたSMSメッセージのログへのアクセスを与えます。システムは、いくつかの場合にSMSメッセージを送信するように設定できます。<br>
	<li><b><a href="${pagePrefix}reports#sms_mailings"><u>SMSメール送信</u></a>:</b> メンバーまたはメンバーのグループに対してSMSメッセージを送信する権限を与えます。<br>
	<li><b><a href="${pagePrefix}transaction_feedback"><u>取引フィードバック</u></a></b>:これらは、特定の取引に関する他のメンバーによるフィードバックです。この権限によって、管理者による取引フィールバックを閲覧、あるいは、閲覧かつ修正することが可能になります。<br>
	取引フィードバックは、<a href="${pagePrefix}account_management#transaction_type_details"><u>取引タイプ</u></a>設定内で有効化されます。<br> <br>
</ul>	
<hr class="help">
</span>


<span class="admin"> <a
	name="manage_group_permissions_admin_admin"></a>
<h3>管理者管理権限</h3>
このウィンドウでは、管理者グループの管理者機能の権限を設定できます。それは、管理者がシステム内で持つアクセスレベルをあなたが定められるということを意味します。つまり、指定された管理者グループは、チェックした権限を受け取ります。この種の権限を持つ管理者は、(1人でないとしても)限られた数にするのが一般的な慣習です。なぜなら、これらはトップレベルの権限だからです。<br> 権限構造は、単純明快です。たいていの機能には、「閲覧する」および「管理する」権限があり、時には、追加的な固有の権限があります。<br> 閲覧が選択されていない場合、その機能は、メニュー内に表示されず、メンバーアクションボタンとしても表示されません(管理者が、ブラウザに位置を直接入力すると、根底にある権限構造は「権限がありません」というページを表示します)。<br>
「管理する」オプションは、作成、編集、消去するための権限を与えます。<br><br>その機能が固有の権限(管理や閲覧とは別の)を持つ場合、その権限は、その権限のタイプを示す名称を持ちます(たとえば、ログイン中のメンバーを切断する)。<br> <br> 以下のものが利用可能です。説明が必要かもしれない項目にのみ言及します:
<ul>
	<li><b>アクセス:</b>
	<ul>
		<li><b>ログインパスワードを変更する:</b> (一目瞭然です。)
		<li><b>取引パスワードを変更する:</b> (一目瞭然です。) 
		<li><b>切断する:</b> 切断ボタンをクリックした瞬間に、別の管理者をシステムから切断できるようにします。
		<li><b>(ログイン試行失敗のために)無効化された管理者を再アクティベートする:</b> 管理者が、パスワードを覚えていないために無効化された場合、その管理者を再びログイン可能にすることができます。
	</ul>
	<li><b>管理者記録:</b> <a href="${pagePrefix}member_records"><u>メンバー記録</u></a>と同様ですが、管理者のための情報を保持できるようにします。下位項目は、単純明快です。 <br>
	<li><b>管理者:</b> これらは、他の管理者を登録したり、別のグループ内に入れるような、他の管理者に関する権限です。管理者機能は、メンバー機能よりも少ないです。管理者は、口座を持っておらず、システム口座への一定レベルのアクセスのみを持つことができます。<br> その項目は、十分に一目瞭然です。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="manage_group_permissions_member"></a>
<h3>メンバーグループのためのメンバー権限</h3>
このグループに属するメンバーは、これらの権限を受け取ります。
<ul>
	<li><b>チャネルアクセスを変更する:</b> このオプションが選択されると、メンバーはチャネル(たとえば、SMS、POS)を有効/無効にすることができます。<br>
	<li><b>アクセス:</b> そのメンバーが最大試行回数を超過した時に、PINをブロック解除します。<br>
	<li><b>口座:</b> メンバーは、自身の口座に常にアクセスできます。したがって、ある人自身の口座の閲覧/管理に関する権限はありません。このセクションでは、そのメンバーが以下のものを閲覧できるかどうかのみを設定できます:
	<ul>
		<li><b><a href="${pagePrefix}payments#authorized"><u>認可された支払い</u></a></b>
		<li><b><a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a></b>
	</ul>
	<li><b>広告(商品とサービス):</b><br>
	<ul>
		<li><b>閲覧する:</b> 「閲覧する」ドロップダウン内で、1つもグループが選択されない場合、広告機能は、このメンバーグループのために利用可能になりません。それは、検索メニューや、プロフィールの下にある<a href="${pagePrefix}profiles#actions_for_member"><u>「メンバーのアクション」</u></a>ページの中にも現れません。<br>
		1つ以上のグループが選択された場合、<a href="${pagePrefix}advertisements#advertisement_search"><u>「商品とサービスを検索する」</u></a>機能は、選択されたグループのメンバーの結果のみを表示します。<br>
		通常は、すべてのグループを選択するでしょう。同じシステム内だが完全に別個に機能する必要があるグループがあれば、特定のグループのみを選択することにより、可視性を制限できます。一例は、ビジネスグループがあり、このグループには消費者広告を表示したくない場合でしょう。
		<li><b>掲載する:</b> 「掲載する」が選択された場合、メンバーは広告を掲載でき、メニュー項目「パーソナル - 広告」がメンバーメニュー内に表示されます。<br>
	</ul>
	<li><b>カード:</b> ここでは、メンバー自身の<a href="${pagePrefix}access_devices#search_cards"><u>カード</u></a>に対するメンバーの権限を定義できます。<br>
	<li><b>ドキュメント:</b> このオプションにより、メンバーメニュー「パーソナル - ドキュメント」内に表示される<a href="${pagePrefix}documents"><u>ドキュメント</u></a>を決められます。1つもドキュメントが選択されないと、そのメニュー項目は(このメンバーグループのために)表示されません。<br>
	<li><b>保証書:</b> これは、Cyclosの<a href="${pagePrefix}guarantees"><u>請求書</u></a>システムの一部です。そこでは、Cyclos内の各口座残高は、貨幣の裏付けされた総額によって保証されます。あなたは以下の権限を選べます:
	<ul>
		<li><b>保証書を管理する(発行者として):</b> 保証書を作成および編集できます。
		<li><b>証明書発行先:</b> 選択されたグループに証明書を発行できます。
		<li><b>グループから支払債務で購入する:</b> ここでは、そのメンバーが、<a href="${pagePrefix}guarantees"><u>支払債務</u></a>でどのグループから購入できるかを選択できます。
		<li><b>グループに支払債務で販売する:</b> グループから支払債務を受け入れられます。
	</ul>
	<li><b>請求書:</b> このセクションでは、メンバーが他のメンバーにユーザープロフィールから<a href="${pagePrefix}invoices"><u>請求書</u></a>を送信できるか、それとも、「口座」メニューから直接送信できるかを定められます。
		<ul>
			<li><b>閲覧する: </b> 選択された場合、メンバーは請求書メニュー項目を見られます。
	    	請求書が全く使われていない場合、このオプションは通常チェックされません。 
			<li><b>メンバーに送信する: </b> メンバーが他のメンバーに請求書を送信できるようにするには、これを選択してください。 
			<li><b>システムに送信する: </b> メンバーがシステム口座に請求書を送信できるようにするには、これを選択してください。 
		</ul>
	<li><b>ローン:</b> このセクションでは、メンバーのための<a href="${pagePrefix}loans"><u>ローン</u></a>のための権限を定められます。
	<ul>
		<li><b>閲覧する:</b> 「閲覧する」オプションが選択された場合、そのグループのメンバーは、そのローンを閲覧できます。閲覧が選択されていなければ、そのメニュー項目は表示されません。
		<li><b>返済する:</b> メンバーがローン返済を行えるようにするには、これを選択してください。
	</ul>
	<li><b>メンバープロフィール:</b> 
	<ul>
		<li><b>閲覧する:</b> ここでは、このメンバーグループの「メンバーを検索する」の中に表示されるメンバーを指定できます。通常は、すべての(削除済みまたは無効の)グループが選択されます。グループをシステム内で独立に機能させたい場合、特定のグループが閲覧され得るようにしたいだけかもしれません。たとえば、顧客とビジネスグループは互いを見られません。閲覧するために特定のグループを使うならば、広告内で権限を閲覧するための同じ権限を設定する必要があります。
		<li><b>自分のログイン名を変更する:</b> チェックされた場合、このグループのメンバーは、プロフィール内で自分のログイン名を変更できます。<br> <b>注:</b> このオプションは、生成されていないユーザー名についてのみ利用可能です。
		<li><b>自分のユーザー名を変更する:</b> チェックされると、このグループのメンバーはプロフィール内で自分のユーザー名を変更できます。 
	</ul>
	<li><b>メンバーレポート:</b> 「閲覧する」が選択されると、メンバーグループは他のメンバーの="${pagePrefix}reports#member_reports"><u>レポートページ</u></a>を閲覧できます。「口座情報を表示する」で口座を選ぶと、そのメンバーはこれらのレポート内で他のメンバーの口座情報(残高)を閲覧できます。 <br>
	<li><b>メッセージ:</b> このセクションでは、どの程度、Cyclosの<a href="${pagePrefix}messages"><u>メッセージ</u></a>システムを使ってよいかを定められます。 
	<ul>
		<li><b>閲覧する: </b>メッセージの閲覧を可能にします。
		<li><b>メンバーに送信する: </b>他のメンバーへのメッセージ送信を可能にします。
		<li><b>管理者に送信する: </b> 管理者へのメッセージの送信を可能にします。
		<li><b>管理する: </b>この権限があれば、メンバーはメッセージに対して、閲覧する以外の消去する、未読として印をつけるなどのアクションを行えます。		
	</ul>
	注:メッセージが管理者のために表示されるようにするには、管理者グループも権限を持つ必要があります。<br> 管理者は、<a href="${pagePrefix}messages#categories"><u>メッセージカテゴリー</u></a>を定められます。これらは、必須オプションとして、メンバーから管理者へのメッセージに表示されます。<br>
	<li><b>オペレータ:</b> ここでは、メンバーがCyclosの<a href="${pagePrefix}operators"><u>オペレータ</u></a>システムを利用できるかどうかを定められます。それにより、1つの口座のために一種の下位メンバーを定められます。オンまたはオフにするチェックボックスが1つあるだけです。<br>
	<li><b>支払い:</b> ここでは、このメンバーグループのために、どのような<a href="${pagePrefix}account_management#transaction_type_details"><u>支払いのタイプ</u></a>が許されるかを指定できます。たいてい、あなたは1つのみ、または2,3のタイプを選択するでしょう。もちろん、利用可能なタイプは、あなたがいくつの支払いタイプを定義したかに依存します。<br>
	<ul>
		<li><b>自己支払い:</b> これが選択された場合、そのメンバーは、自身の口座間で支払いを行えます。ドロップダウン内で、可能な取引タイプを指定できます。このオプションは、このグループについて複数のメンバー口座を持っている場合にのみ、意味をなします。	
		<li><b>メンバー支払い:</b> ここでは、そのメンバーが別のメンバーに支払う際に、どの支払いタイプを使えるかを選択できます。
		<li><b>システム支払い:</b> ここで、メンバーがシステム口座への支払いを行うために、どの支払いタイプを選べるかを指定できます。何も選択されなかった場合、メニュー項目「システム支払い」は表示されません。
		<li><b>外部支払いチケットを生成する:</b><br> これは、メンバーショップによって使われるチケッティングシステムについてです。それは、たいてい、Cyclosを外部支払いシステムとして使いたいWebショップによって使われます。このオプションが選択された場合、メンバー(ショップ)は、チケットを生成することを許されます。チケットシステムは、ユーザーにとって平明です。 それは、Webショップが、消費者のログイン詳細にアクセスすることなく、消費者と支払いデータを認証し確認できる構造を提供します。技術的な詳細は、Cyclos wikiページ(webservices - tickets)で見つけられます。
		<li><b>支払い受取人として認可する:</b> そのメンバーが支払いを<a href="${pagePrefix}payments#authorized"><u>認可</u></a>できるようにします。これは支払いの受取人であるか、オプションとしては、受取人が認可した後の支払人によっても行えます。<br> 認可の設定は、<a href="${pagePrefix}account_management#edit_authorization_level"><u>取引タイプ</u></a>の設定の中で見つけられます。<br> 注:このオプションは、請求書に似た仕方で機能するので、請求書と組み合わせられるべきではありません。
		<li><b>認可保留中の支払いをキャンセルする:</b> <a href="${pagePrefix}payments#authorized"><u>認可された支払い</u></a>が使われた場合、これにより、メンバーは、一度作成されたがまだ認可されていない自分の認可された支払いをキャンセルできます。
		<li><b>スケジュールされた支払いをキャンセルする:</b> <a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a>が使われた場合、これにより、メンバーは、計画された日付が始まる前に、自分のスケジュールされた支払いをキャンセルできます。<br> この設定が機能するようにするには、取引タイプ設定もスケジュールされた支払いのキャンセルを可能にしなければなりません。
		<li><b>スケジュールされた支払いをブロックする:</b> メンバーが自分のスケジュールされた支払いを一時的にブロックできるようにします。<br> この設定が機能するようにするには、取引タイプ設定もスケジュールされた支払いのブロックを可能にしなければなりません。			
		<li><b>他のチャネルから支払いをリクエストする:</b> これがチェックされた場合、そのメンバーは、他の<a href="${pagePrefix}settings#channels"><u>チャネル</u></a>から、「<a href="${pagePrefix}payments#request"><u>支払いリクエスト</u></a>」(請求書)を送信できます。ドロップダウンボックスからこれらのチャネルを選べます。現時点では、これについてはSMSのみが利用可能ですが、将来、他のチャネルが追加されるかもしれません。
	    <li><b>受け取った支払いをチャージバックする:</b> この権限があれば、ユーザーは支払いをチャージバック(キャンセル)できます。<a href="${pagePrefix}settings#local_chargeback"><u>ローカル設定</u></a> &gt; チャージバックを見てください。 
	</ul>
	<li><b>個人設定:</b> これによって、そのグループのメンバーは、自分の設定メインメニュー項目にアクセスできるようになります。このメニュー内、したがって、これらの権限には、2つしか項目がありません:
	<ul>
		<li><b>通知を管理する</b>は、そのメンバーが、彼らのEメール<a href="${pagePrefix}notifications"><u>通知</u></a>を管理できるようにします。
		<li><b>広告関心を管理する</b>は、そのメンバーが、自分の<a href="${pagePrefix}ads_interest"><u>広告関心</u></a>を管理できるようにします。
		<li><b>領収書プリンタ設定を管理する: </b> これにより、そのメンバーが<a href="${pagePrefix}preferences#receipt_printers"><u>領収書プリンタ</u> </a>を閲覧および管理できるようにします。
	</ul>
	<li><b>評価:</b> これにより、そのメンバーは、<a href="${pagePrefix}references"><u>評価</u></a>を閲覧するか、他のメンバーに対してそれらを与えることができます。評価機能を(1つまたは複数のグループについて)全く使いたくない場合、「閲覧する」オプションを空のままにしてください。この場合、評価メニューと他の評価ボタンは、表示されません。 <br>
	<li><b><a href="${pagePrefix}reports#sms_log"><u>SMSログ</u></a>:</b> メンバーが、自分のために送信されるSMSメッセージのログにアクセスできるようにします。システムは、いくつかの場合にSMSメッセージを送信するように設定できます。<br>
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="manage_group_permissions_broker"></a>
<h3>仲介人権限</h3>
これらは、典型的に、仲介人が行うかもしれない<a href="${pagePrefix}brokering"> <u>仲介</u></a>機能についての権限です。これは、このグループの仲介人が、メンバーに関して行える機能のタイプを定められるということを意味します。権限構造は、単純明快です。たいていの機能には、「閲覧する」および「管理する」権限があり、時には、追加的な固有の権限があります。<br> 閲覧が選択されていない場合、その機能は、仲介人のメニュー内に表示されず、メンバーアクションボタンとしても表示されません(仲介人が、ブラウザ内に直接位置を入力すると、根底にある権限構造が「権限がありません」というページを表示します)。<br>
「管理する」オプションは、作成、編集、消去するための権限を与えます。<br> <br> 仲介人が仲介したメンバーのための以下の機能にアクセスできようにすることができます:
<ul>
	<li><b>アクセス:</b> これらは、仲介人がそのメンバーのためのアクセスを制御できるようにします。それは、以下の下位項目を含みます:
	<ul>
		<li><b>ログインパスワードを変更する:</b> 仲介人が、そのメンバーのプロフィール(メンバーアクション「パスワードを管理する」内)から、そのメンバーのログインパスワードを変更できるようにします。<br> もし、この権限がチェックされていない場合でも、仲介人は、依然として、メンバー登録時に一時的なパスワードを定められるということに留意してください(そのメンバーは、初回ログイン時にパスワードを変更するように強いられます)。しかし、これは、<a href="#edit_member_group"><u>グループ設定</u></a>「Eメールでパスワードを送信する」がチェックされていない場合のみです。<br> グループ設定「Eメールでパスワードを送信する」がチェックされている場合(メンバーグループ設定内)、仲介人は、登録時にパスワードを定めることができません。この場合、そのメンバーは、初回ログイン時に変更される必要がある一時的なパスワードを自動的にメールで受け取ります。<br> もし、グループ設定「Eメールでパスワードを送信する」と「ログインパスワードを変更する」の両方がチェックされた場合、仲介人は、登録時に確定的な(一時的でない)パスワードを定めるか、初回ログイン時にパスワードを変更するようユーザーに強いるかを選べます。
		<li><b>ログインパスワードをリセットする:</b> 仲介人がメンバーログインパスワードをリセットできるようにします。それは、それが自動的に再生成されてメールにより送信されるということを(設定に依っては)一般的に意味します。
		<li><b><a href="${pagePrefix}passwords#transaction_password"><u>取引パスワード</u></a>を管理する:</b> 取引のために設定され得る特別なパスワードを管理できるようにします。
		<li><b>PINを変更する:</b> 仲介人が<a href="${pagePrefix}passwords#pin"><u>PIN番号</u></a>を変更できるようにします。それは、Webショップのような一定の<a href="${pagePrefix}settings#channels"><u>チャネル</u></a>へのアクセスのための数字のパスワードです。
		<li><b>PINをブロック解除する:</b> そのメンバーが最大試行回数を超過した時、PINをブロック解除します。<br>
		<li><b>チャネルアクセスを変更する:</b> Web、携帯電話からのような<a href="${pagePrefix}settings#channels"><u>チャネル</u></a>へのアクセス方法を変更します。
	</ul>
	<li><b>口座:</b>
	<ul>
		<li><b>口座情報を閲覧する:</b> 仲介人は、仲介しているメンバーの口座情報を閲覧できます。
		<li><b>認可された支払いを閲覧する:</b> これが選択された場合、仲介しているメンバーの<b><a ref="${pagePrefix}payments#authorized"><u>認可された支払い</u></a>の閲覧</b>が許されます。
		<li><b><b><a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a>を閲覧します</b>。</b>
	</ul>
		<li><b>仲介:</b>
	<ul>
		<li><b>登録する:</b> 仲介人が新しいメンバーを登録できるようにします。
		<li><b>保留中のメンバーを管理する:</b> 仲介人は、登録したがまだ(メールによって)登録を確認していないメンバーを閲覧できます。<br>さらなる情報は、<a href="${pagePrefix}user_management#search_pending_member"><u>ヘルプファイル</u></a>で利用可能です。
		<li><b>プロフィールを変更する:</b> 仲介人が、仲介しているメンバーの<a href="${pagePrefix}profiles"><u>プロフィール</u></a>を変更できるようにします。
		<li><b>氏名を変更する:</b> 仲介人が仲介しているメンバーの氏名を変更できるようにします。
		<li><b>ログイン名を変更する:</b> 仲介人が仲介しているメンバーのログイン名を変更できるようにします。
		<li><b>標準の委託手数料を管理する:</b> これにより、仲介人は、<a href="${pagePrefix}brokering#commission"><u>委託手数料</u></a>の標準値を自身で設定できるようになります。
		<li><b>契約を管理する:</b> これが選択された場合、仲介人は、メンバーとの委託手数料に関する<a href="${pagePrefix}brokering#commission_contract"><u>契約</u></a>を管理できます。これは、<a href="${pagePrefix}profiles"><u>プロフィール</u></a>の下にあるボタンから行えます。
	</ul>
	<li><b><a href="${pagePrefix}access_devices#search_cards">カード:</a></b> 仲介人にメンバーのカードに対してアクションを行う権限を与えます。
	<br>
	<li><b><a href="${pagePrefix}documents">ドキュメント:</a></b>
	<ul>
		<li><b>閲覧する:</b> ここでは、どのシステム全体ドキュメントを仲介人が閲覧できるかを選べます。
		<li><b>メンバー個人ドキュメントを閲覧する:</b> 仲介人がメンバーの<u><a href="${pagePrefix}documents#member_document">個人ドキュメント</a></u>を閲覧できるようにします。
		<li><b>メンバー個人ドキュメントを管理する:</b> 前の項目と同じですが、管理権限です。
	</ul>
	<li><b>請求書:</b> ここの項目の意味は、一目瞭然です。 <br>
	<li><b><a href="${pagePrefix}loan_groups"><u>ローングループ</u></a></b> <br>ローングループメニュー項目を閲覧します。 <br>
	<li><b><a href="${pagePrefix}loans"><u>ローン</u></a></b><br> ローンメニュー項目を閲覧します。 <br>
	<li><b>メンバー支払い:</b> その仲介人が、メンバーのためのどの支払い項目にアクセスできるかを制御します。<br> 下位項目は以下の通りです:
	<ul>
		<li><b>メンバーとしてのメンバーへの支払い:</b> その仲介人が、あたかもそのメンバーであるかのように実行できる、別のメンバーに支払う際の支払いタイプを選択してください。
		<li><b>メンバー自己支払い:</b> これらは、あるメンバーの1つの口座から、同じメンバーの別の口座への支払いです。仲介人は、あたかもそのメンバーかのようにこれらの支払いを行えます。		
		<li><b>メンバーとしてのシステムへの支払い:</b> 仲介人は、あたかもそのメンバーであるかのように、メンバー口座から、システム口座への支払いを行えます。ここでこれを可能にしたい支払いタイプを選択してください。
		<li><b>認可する:</b> 仲介人は、<a href="${pagePrefix}payments#authorized"><u>認可された支払い</u></a>システムのために、メンバーの支払いを認可できます。
		<li><b>認可された支払いをメンバーとしてキャンセルする</b>
		<li><b>メンバーとして<a href="${pagePrefix}payments#scheduled"><u>スケジュールされた支払い</u></a>をキャンセルする</b>。<br> この設定が機能するようにするには、取引タイプ設定もスケジュールされた支払いのキャンセルを許可しなければなりません。
		<li><b>メンバーとしてスケジュールされた支払いをブロックする:</b> スケジュールされた支払いを一時的にブロックします。ブロックとキャンセルの間の違いは、ブロックされたスケジュールされた支払いは、ブロック解除できるということです。キャンセルは決定的です。
		<br> この設定が機能するようにするには、取引タイプ設定が、スケジュールされた支払いのブロックを許可しなければなりません。
	</ul>
	<li><b><a href="${pagePrefix}member_records"><u>メンバー記録</u></a>:</b> その管理者が、メンバー記録を管理できるようにします。これらは、そのメンバーに関して収集される情報を定められるようにします。下位項目は、一目瞭然です。
	<br>
	<li><b><a href="${pagePrefix}access_devices#pos">POS(デバイス):</a></b> 仲介人にメンバーのPOS(point of sale)デバイスを管理する権限を与えます。
	<br>
	<li><b>パーソナルメッセージ:</b> ここには1つの項目があり、それによって仲介人は、仲介したすべてのメンバーにパーソナル<a href="${pagePrefix}messages"><u>メッセージ</u></a>を送信できます。
	<br>
	<li><b>個人設定:</b> 仲介人が、仲介中のすべてのメンバーのパーソナル<a href="${pagePrefix}preferences"><u>設定</u></a>を行えるようにします。
	<br>
	<li><b>商品とサービス(広告):</b> 仲介人が、仲介されたメンバーの広告を閲覧または管理する権限を可能にします。<br>
	<br>
	<li><b>評価:</b> 仲介人がメンバーのための<a href="${pagePrefix}references"><u>評価</u></a>を管理(授与、消去、修正)できるようにします。 
	<br>
	<li><b><a href="${pagePrefix}reports#member_activities">レポート:</a></b> メンバーのレポートを閲覧し、オプションとしてメンバーの口座情報も閲覧するための権限を仲介人に与えます。
	<br>
	<li><b><a href="${pagePrefix}reports#sms_log"><u>SMSログ</u></a>:</b> 仲介されるメンバーに送信されたSMSのログへのアクセスを与えます。システムは、いくつかの場合にSMSメッセージを送信するように設定できます。
	<br>
	<li><b><a href="${pagePrefix}reports#sms_mailings"><u>SMSメール送信</u></a>:</b> メンバーにSMSメッセージを送信するための権限を仲介人に与えます(メール送信)。
	<br>
</ul>
<hr class="help">
</span>


<a name="group_filters"></a>
<h2>グループフィルタ</h2>
グループフィルタは、一種の「スーパーグループ」、つまり、一定のアクションを行える対象で、まとめられ名称を与えられたグループの集合です。したがって、要するに、グループフィルタは「グループのグループ」です。
<br> グループフィルタは、Cyclos内のいくつかのタスクのために役立ちます。グループフィルタに対する統計的計算を行うことができ、メンバーと管理者は、グループフィルタに関する検索を行えます。<i>見つけ方</i><br>
グループフィルタは、「メニュー: ユーザーとグループ &gt; グループフィルタ」で見つけられます。
<hr>


<span class="admin"> <a name="group_filter"></a>
<h3>グループフィルタを修正/作成する</h3>
このウィンドウでは、<a href="#group_filters"><u>グループフィルタ</u></a>を定義または修正できます。既存のグループを修正するならば、そのフォーム内のフィールドを変更できるようにするために、まず「変更」というラベルのボタンをクリックしてください。<br> 忘れずに「送信」をクリックして変更を保存してください。
<ul>
	<li><b>名称:</b> 新しいグループフィルタにつけたい名称を選んでください。
	<li><b>ログインページ名:</b> このオプションは、このグループフィルタのためのログインページを(下のカスタマイズされたファイルウィンドウ内で)カスタマイズした場合のみ表示されます。カスタマイズされた(グループ)ログインページは、「グローバル」なログインページの後に疑問符とともにログインページ名をつけることによってアクセスできます。ログインページ名には、スペースを含みられません。一例は、以下のようになるでしょう:<br> http://www.yourdomain.org/cyclos?yourgrouploginpagename.<br> <a href="${pagePrefix}groups#group_details"><u>グループ</u></a>ごとにログインページ名を指定することも可能だということに留意してください。
	<li><b>コンテナページURL:</b> あるWebサイトの内部からCyclosにアクセスしたければ、この設定が使われます。その設定は、グローバルコンテナページ(<a href="${pagePrefix}settings#local"><u>設定 - ローカル設定</u></a>を見てください)と同じように機能しますが、これはグループフィルタのためだけのものです。このフィールドには、Cyclosを含むiframeまたはframeセットを開くページを書く必要があるでしょう。例:
	http://www.yourgroupdomain.org/cycloswrapper.php<br> <a href="${pagePrefix}groups#group_details"><u>グループ</u></a>ごとにログインコンテナページを指定することも可能だということに留意してください。
	<li><b>説明:</b> グループフィルタの使用者を明確にするための、管理者のための説明です。
	<li><b>プロフィール内に表示する:</b> これが選択された場合、そのグループフィルタは、そのメンバーの<a href="${pagePrefix}profiles"><u>プロフィール</u></a>内のグループフィールドに表示されます。
	<li><b>グループ:</b> このフォーム内で最も重要な要素です。
	ここでは、そのグループフィルタ内に入れたいグループを選択します。
	<li><b>閲覧可能者:</b> どのグループがグループフィルタを見られるかを選べます。その場合、そのグループフィルタは、メンバーセクション内のメンバーおよび広告検索に表示されます。注: 「プロフィール内に表示する」チェックボックスを選択した場合、それは「閲覧可能者」で選択するグループとは独立に、常に、プロフィール内で見えるようになります。したがって、この設定は、検索機能にのみ影響を与えます。
</ul>
<hr class="help">
</span>


<span class="admin"> <a name="manage_group_filters"></a>
<h3>グループフィルタを管理する</h3>
このウィンドウは、<a href="#group_filters"><u>グループフィルタ</u></a>のリストを表示し、それらを管理するためのオプションを与えます。
<ul>
	<li><b>修正する:</b> <img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;編集アイコンから、既存のグループフィルタを修正(または閲覧)します。
	<li><b>消去する:</b> <img border="0" src="${images}/delete.gif" width="16" height="16">&nbsp;消去アイコンから、グループフィルタを消去します。
	<li><b>作成する:</b> 「新しいグループフィルタを挿入する」というラベルの付いた送信ボタンをクリックすることにより、新しいグループを作成します。
</ul>
<hr class="help">
</span>


<span class="admin"> <a
	name="manage_group_filter_customized_files"></a>
<h3>カスタマイズされたファイル(グループフィルタのための)</h3>
この機能により、<a href="#group_filters"><u>グループフィルタ</u></a>のための<a href="${pagePrefix}content_management"><u>カスタマイズされたファイル</u></a>を設定できます。これは、各グループフィルタが、レイアウト(色、スタイル)、ロゴのようなそれ独自のカスタマイゼーションと、ニュース、連絡先、マニュアルなどのページを持てることを意味します。いかなる特定のグループまたはグループフィルタのカスタマイゼーションもなされていないならば、主なレイアウトとページが現れます。<br> グループカスタマイゼーションは、グループフィルタカスタマイゼーションを覆すので、もし両方定めた場合は、まずシステムはそのグループのためにカスタマイズされたファイルがあるかどうかを確認し、それを表示します。そうでない場合は、そのファイルがグループフィルタのためにカスタマイズされているかどうか確認します。さらに、そうでない場合は、もし利用可能ならば、そのファイルのシステム全体でカスタマイズされたバージョンを表示します。<br> そのフォーム内の要素:
<ul>
	<li><b>閲覧する:</b> <img border="0" src="${images}/view.gif" width="16" height="16">&nbsp;ビューアイコンから、その結果がどのように見えるかを閲覧します。
	<li><b>修正する:</b> <img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;編集アイコンから、既存のカスタマイズされたファイルを修正します。
	<li><b>消去する:</b> <img border="0" src="${images}/delete.gif" width="16" height="16">&nbsp;消去アイコンから、カスタマイズされたファイル定義を消去します。
	<li><b>作成する:</b> 「新しいファイルを作成する」というラベルの付いたボタンから、新しいカスタマイズされたファイルを作成します。
</ul>
<hr class="help">
</span>


</div> <%--  page-break end --%>
<div class='help'>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
</div>

