<div style="page-break-after: always;">
<a name="guarantees_top"></a>
<br><br>
保証書モジュールは、支払いシステムとしてCyclosを使うネットワーク内で、商品またはサービスの購入に対する「将来の」支払いを、 ローカルの購買力として提供者(販売者)に直接利用可能にする仕組みを提供します。これは、この「先払いされた」ローカルの購買力が、将来の(伝統的貨幣の)支払いによって裏付けられていることを意味します。なぜなら、販売者は、組織によって(商品の配達時に)ローカル通貨で支払われるので、購入者は、今や(販売者に対してではなく)組織に対して負債を負っているからです。「発行者」、たいていは金融機関がこれらの将来の支払い(購入者から組織への)を保証します。購入者が支払わない、あるいは、支払えない場合、発行者がその支払いの遂行に責任があります。当然、発行者はこのために費用を賦課するでしょう。しかし、これらの費用は一般的に、金融市場における類似のローンよりもはるかに低いです。<br> <br>発行者は、保証書を発行して監視するために(Cyclos内で)自由に使える様々なツールを持っています。発行者は、購入者(地方政府、会社または個人)を評価して、最大の「支出」額と手数料や満期日などの他の条件を定めることができます。保証書モジュールは非常に柔軟で、異なる保証書タイプで定義される様々な用途をサポートしています。<i>見つけ方</i><br> 保証書タイプは次の場所で見つけられます: 「メニュー: 保証書 &gt; 保証書タイプ」。<br>
<hr>


<a name="guarantee_models"></a>
<h3>保証書モジュール</h3>
3つのタイプの保証書モデルがあります:<br>
<ul>
	<li><b>支払債務付きの保証書:</b> 大企業や地方政府にとって、商品やサービスをローカルの供給業者から購入し、後で、たとえば1ヶ月、3ヶ月，6ヶ月のうちに支払いをすることは非常によくあります。典型的な例は、ローカルの供給業者に支払いをするスーパーマーケットまたは地方自治体です。支払債務付きの保証書モジュールは、これらの支払いを管理および監視できるオンラインツールを提供します。そのプロセスは、発行者、通常は金融機関が会社(購入者)を評価してCyclos内に証明書を作成する時に始まります。<br> 証明書は、可能な手数料と最大支出額を定義します。購入者は、この額に達するまで、その供給業者への支払債務、たいてい未決済の請求書ごとの支払債務を「発行」できます。もし、供給業者/販売者が、(後日の貨幣支払いを待つ代わりに)ローカルの購買力で直接受け取りたければ、支払債務を受け付けることができます。販売者にとって、それは(ローカルの購買力の形で)貨幣に直接アクセスできるので、重大な違いを意味します。購入者にとって、支払債務を扱う時の唯一の違いは、伝統的通貨で遅れて供給業者に支払う代わりに、その組織に(同様に遅れて伝統的通貨で)支払うということです。購入者にとって、支払債務を扱う時の唯一の違いは、伝統的通貨で遅れて供給業者に支払う代わりに、その組織に(同様に遅れて伝統的通貨で)支払うということです。</li><br>
	<li><b>購入者のみに保証書:</b> このモデルは、典型的に販売者によって、1回の購入のために顧客への融資を提供するために使われます。販売者と購入者の両方がプロセスの一部です。</li>
	<br>
	<li><b>購入者と販売者に保証書: </b> このモデルは、典型的に販売者によって、1回の購入のために顧客に融資を提供するために使われます。販売者と購入者の両方がプロセスの一部です。</li>
</ul>
<hr class="help">


<span class="admin">
<a name="guarantee_types_list"></a>
<h3>保証書タイプリスト</h3> このウィンドウリストは、すべての設定された保証書タイプを表示します。 <br>
</span>
<hr class="help">


<span class="admin">
<a name="edit_guarantee_type"></a>
<h3>保証書を修正する/新規作成する</h3> 保証書には以下のフィールドがあります:
<ul>
	<li><b>名称: </b> 保証書の名称。<br>
	<li><b>通貨: </b>保証書に関連している通貨。
	<li><b>モデル: </b> これは<a href="#guarantee_models"><u>保証書モデル</u></a>セクション内で説明されているように、保証書のタイプを定めます。
	<li><b>有効: </b> このチェックボックスにより、保証書タイプを有効および無効にできます。
	<li><b>認可者: </b> このオプションは、どのように認可しなければならないかを定めます。 可能なオプションは、発行者、発行者および管理者、なしです(一部のオプションは、すべてのモデルでは利用可能でありません)。
	<li><b>保証書最大保留期間:</b> (支払債務モデルのみ). これは発行者(または管理者)が保証書を認可および却下できる猶予期間です。<br>この期間が過ぎると、保証書は自動的に「アクションなし」の状態に移ります。<br>
	<li><b>債務間の最大期間:</b> (支払債務モデルのみ) これは支払債務がそれらを「パック」として購入者に送信するために持ち得る最大猶予期間です。
	<li><b>クレジット手数料: </b> クレジット手数料は、常にシステム口座に入ります(メンバーからシステムへの取引タイプ)。<br> クレジット手数料の手数料は、読み取り専用に設定された場合、管理者によって変更できますが、発行者によっては変更できません。
	<li><b>発行手数料: </b> 発行手数料は、常に発行者に入ります(メンバーからメンバーへの取引タイプ)。 クレジット手数料のように、購入者または販売者に賦課することができます(保証書タイプ設定に依ります)。発行手数料の手数料は、「読み取り専用」に定められていなければ、発行者により変更できます。管理者は(認可者として)常にクレジット手数料を修正できます。
	<li><b> 手数料計算(一般的ルール) </b> 「購入者と販売者」のモデルの手数料の場合、誰が賦課されるか(購入者または販売者のいずれか)を定められます。手数料は、固定値，保証書額のパーセンテージ、年間のパーセンテージに設定できます。後者の場合、手数料は以下の公式のように計算されます:<br> 年間手数料 = ((1+T/100)^(d/365) - 1) * M<br> ここで:
	<ul>
		<li><b>T</b> = 手数料%</li>
		<li><b>d</b> = 日数で表した保証書有効期間</li>
		<li><b>M</b> = 額</li>
	</ul>
	<li><b> 説明: </b> 保証書タイプの(任意の)説明
	<li><b>取引タイプ: </b> ここでは、保証書の生成された取引のための取引タイプが定められます。
	<li><b>クレジット手数料: </b> メンバーからシステムへの取引タイプから選んでください。</li>
	<li><b>発行手数料:</b> メンバーからメンバーへの取引タイプから選んでください。 タイプ</li>
	<li><b>ローン: </b> ローンを選んでください。</li>
	<li><b>先物: </b> これは、購入者から販売者へと移る(メンバーからメンバーへの)取引タイプです。</li>
</ul>
<b>注: </b> 保証書を作成できる方法は2つあります:
<ul>
	<li><b>手動:</b> 発行者または管理者によるものです(「購入者と販売者」と「購入者のみ」のモデル)。
	<li><b>自動</b> 保証書のアクティベーション時です。 (支払債務モデル)
</ul> </span>
<hr>


<a name="certifications"></a>
<h2>証明書</h2>
<br><br>
証明書は、「発行者」によって作成されるデジタル契約書です。 特定の「購入者」が販売者に対して<a href="#payment_obligations"><u>支払債務</u></a>を発行するために使える最大額を定めます。発行者は、同一の購入者で同一の通貨の「アクティブな」証明書は1つしか持てません。<br>

<i>見つけ方</i><br> 証明書は「メニュー: 保証書 &gt; 証明書」で見つけられます。<br>
<hr class="help">


<a name="new_certification"></a> <a name="edit_certification"></a>
<h3>証明書を新規作成/修正する</h3>
証明書には、以下のエントリーがあります。
<ul>
	<li><b>状態: </b>(証明書の閲覧のみです)。 このフィールドは、証明書の<a href="#statusC"><u>状態</u></a>のリストを表示します。</li>
	<li><b>保証書タイプ: </b> 証明書に関連している保証書タイプです。</li>
	<li><b>購入者: </b> 購入者の氏名とログイン名です。</li>
	<li><b>有効期間: </b> 証明書がアクティブになる期間です。開始日が将来の場合、証明書はその日付からのみアクティブになります。 現在の日付よりも前の開始日で証明書を作成することはできません。</li>
	<li><b>額:</b> これは購入者が支払債務を発行できる最大額です。</li>
	<li><b>使用額:</b> 使用額は、支払債務として発行された(証明書ごとの)合計額です。使用額は、<i>承諾済み</i>と<i>保留中</i>の状態であるすべての保証書の額の合計です。支払債務が購入者によって支払われた場合や管理者により完了された場合、証明書の額は(有効期間がまだアクティブならば)再び利用可能になります。
</ul>
<hr class="help">


<a name="certification_logs"></a>
<h3>証明書状態ログ</h3>
このウィンドウは、証明書の<a href="#statusC"><u>状態</u></a>の変化についての情報を与えます。
<br><br>
<hr class="help">


<a name="statusC"></a>
<h3>証明書状態</h3>
証明書は、保証書タイプと運用上の流れに依って、様々な異なる状態になり得ます。以下にすべての可能な状態をリストにします。どの状態もその状態に至る可能なアクションを説明します。<br><br> <b>状態/アクション</b>
<ul>
	<li>スケジュール済み</li>
	<ul>
		<li>発行者が、開始日が将来の日付である(今日ではない)新しい証明書を作成した場合。</li>
		<li>発行者が、一時停止中の状態にあり開始日が将来の日付である(今日ではない)証明書をアクティブ化した場合。</li>
	</ul>
	<li>アクティブ</li>
	<ul>
		<li>発行者が、過去または現在の日付の開始日で新しい証明書を作成した場合。</li>
		<li>発行者が、一時停止中の状態にあり開始日が過去または現在の日付である証明書をアクティブ化した場合。</li>
		<li>スケジュールされた証明書が現在の日付に到達した場合。</li>
	</ul>
	<li>一時停止中</li>
	<ul>
		<li>発行者が、アクティブまたはスケジュールされた状態にある証明書を一時停止した場合。</li>
		<li>スケジュールされた証明書が現在の日付に到達したが、既に同じ発行者、通貨、購入者のアクティブな証明書が存在する場合。</li>
	</ul>
	<li>期限切れ</li>
	<ul>
		<li>アクティブ状態またはスケジュールされた状態にある証明書が最終日に到達した場合。</li>
	</ul>
	<li>キャンセル済み</li>
		<ul> 
		<li>管理者が以下のいずれかの状態である証明書をキャンセルした場合: アクティブ、一時停止中、またはスケジュール済み。</li>
	</ul>
</ul>

<h3>証明書通知</h3>
証明書に関連する以下の通知が生成され得ます:<br>
<ul>
	<li>証明書が以下のいずれかの状態になった時に購入者に送信されます: アクティブ、一時停止中、期限切れ、またはキャンセル済み。</li>
	<li>証明書が期限切れの状態になった時に発行者に送信されます。</li>
</ul>
<hr class="help">


<a name="certifications_search"></a>
<h3>証明書を検索する</h3>
このリストは、以下の検索オプションで検索できるすべての設定された<a href="#certifications"><u>証明書</u></a>を表示します。<br>
<ul>
	<li><b>状態</b> 証明書の<a href="#statusC"><u>状態</u></a>の1つ:</li>
	<ul>
		<li>アクティブ</li>
		<li>キャンセル済み</li>
		<li>一時停止中</li>
		<li>期限切れ</li>
		<li>スケジュール済み</li>
		<br>
	</ul>
		<li><b>発行者: </b> 発行者の氏名とログイン名です。</li>
		<li><b>購入者: </b> 購入者の氏名とログイン名です。</li>
		<li><b>アクティベーション日</b> ある期間内のアクティベーション日により検索します。</li>
		<li><b>期限切れ日:</b> ある期間内の期限切れ日によって検索します。</li>
	</ul>
<hr class="help">


<a name="certifications_search_results"></a>
<h3>証明書検索結果</h3>
このページは、証明書の検索結果のリストを表示します。<br> 証明書の詳細を見るために、リスト内の証明書の虫眼鏡アイコン<img border="0" src="${images}/view.gif" width="16" height="16">を選択できます。
<br>
<hr>


<a name="guarantees"></a>
<h2>保証書</h2>
<br><br>
<i>見つけ方</i><br> 保証書は、メニュー: 保証書 &gt; 保証書で見つけられます。<br>
<hr class="help">


<a name="guarantee_register"></a>
<h3>(新しい)保証書を登録する</h3>
保証書を作成できる方法は2つあります:<br>
<ul>
	<li>発行者または管理者により手動で(「購入者と販売者」および「購入者のみ」のモデル)
	<li>保証書のアクティベーション時に自動で (支払債務モデル)
</ul>
保証書には以下のフィールドがあります:
<ul>
	<li><b>購入者: </b> 購入者の氏名とログイン名です。</li>
	<li><b>発行者: </b> 発行者の氏名とログイン名です。</li>
	<li><b>販売者: </b> 販売者の氏名とログイン名です。</li>
	<li><b> 識別子:</b> 証明書を特定する固有のコードです(任意)。</li>
	<li><b> 有効期間: </b> 保証書がアクティブになる期間です。</li>
	<li><b>クレジット手数料: </b> クレジット手数料の値<span class="admin">(<a href="#edit_guarantee_type"><u>保証書タイプ</u></a>を見てください)。</span><br> このフィールドは、保証書タイプ設定に依っては編集可能です。
	<li><b>発行手数料: </b> クレジット手数料の値<span class="admin">(<a href="#edit_guarantee_type"><u>保証書タイプ</u></a>を見てください)。</span> <br> このフィールドは、保証書タイプ設定に依っては編集可能です。</li>
	<br>
</ul>
保証書は、有効期間の開始日に承諾済み状態になります。 保証書が承諾済み状態になると、ローンが生成され、可能な手数料が賦課されます。<br> 管理者によって手動で作成された保証書のみを消去できます。 それらが管理者保留中の状態にあり、それらが通過した唯一の状態が発行者保留中である場合。<br> <br>
<hr class="help">


<a name="guarantees_search"></a>
<h3>保証書検索</h3>
このページで保証書を検索できます。 以下の検索オプションが利用可能です:
<ul>
	<li><b>状態: </b> 保証人の<a href="#statusG"><u>状態</u></a>です。</li>
	<li><b>購入者: </b> 購入者の氏名とログイン名です。</li>
	<li><b>発行者: </b> 発行者の氏名とログイン名です。</li>
	<li><b>販売者: </b> 販売者の氏名とログイン名です。</li>
	<li><b> 有効期間: </b> 保証書がアクティブになる期間です。</li>
	<li><b>期限切れ日:</b> ある期間内の期限切れ日によって検索します。</li>
	<li><b>額: </b> 保証書の額です。</li>
</ul>
<hr class="help">


<a name="guarantees_search_results"></a>
<h3>保証書検索結果</h3>
このページは、保証書の検索結果を表示します。 <br> 保証書を見るには、対応するアイコン<img border="0" src="${images}/view.gif" width="16" height="16">を選択してください。
<br><br>
<hr class="help">


<a name="guarantee_details"></a>
<h3>保証書詳細</h3>
このページは、<a href="#guarantee_register"><u>保証書を登録する</u></a>ヘルプセクション内で説明されている保証書の以下の状態を表示します。追加的なフィールドは以下の通りです:
<ul>
	<li><b>状態: </b> 保証書の現在の<a href="#statusG"><u>状態</u></a>です。</li>
	<li><b>登録日: </b> 保証書が登録された日付です。</li>
	<li><b>生成されたローン: </b> 保証書がローンを生成した場合、ローンへのリンクが表示されます。</li>
</ul>
<br><br>
<hr class="help">


<a name="guarantee_payment_obligations"></a>
<h3>保証書の支払債務</h3>
このウィンドウは、保証書に関連する<a href="#payment_obligations"><u>支払債務</u>のリストを表示します。 
<br><br>
<hr class="help">


<a name="guarantee_logs"></a>
<h3>保証書状態変化(ログ)</h3>
このウィンドウは、<a href="#statusG"><u>状態</u></a>のリストを表示します。
<br><br>
<hr class="help">


<h3>保証書状態</h3>
<a name="statusG"></a> 保証書は、保証書タイプと運用上の流れに依って、様々な異なる状態になり得ます。以下にすべての可能な状態をリストにします。どの状態もその状態に至る可能なアクションを説明します。<br><br> <b>状態/アクション</b>
<ul>
	<li>発行者保留中</li>
	<ul>
		<li>管理者が、発行者または発行者と管理者によって認可される必要がある新しい保証書を登録した場合。</li>
		<li>販売者が、支払債務または支払債務の「パック」を承諾した場合。</li>
	</ul>
	<li>管理者保留中</li>
	<ul>
		<li>管理者が、管理者(のみ)によって認可される必要がある新しい保証書を登録した場合。</li>
		<li>「発行者保留中」状態にあり、管理者によっても認可されるよう設定されている保証書を、発行者が認可した場合。</li>
	</ul>
	<li>承諾済み</li>
		<ul>
		<li>管理者が、認可を必要としない新しい保証書を登録した場合。</li>
		<li>管理者が、「管理者保留中」状態にある保証書を承諾した場合。</li>
		<li>発行者が、「発行者保留中」状態にある保証書を承諾した場合。</li>
	</ul>

	<li>拒否済み</li>
	<ul>
		<li>発行者が、「発行者保留中」状態にある保証書を拒否した場合。</li>
		<li>管理者が、「管理者保留中」状態にある保証書を拒否した場合。</li>
	</ul>
	<li>キャンセル済み</li>
	<ul>
		<li>管理者が、発行者保留中または管理者保留中の状態にある保証書をキャンセルした場合。</li>
		<li>管理者が、承諾済みの状態だが別の(ローン)認可を必要とするためにまだ生成されていない保証書をキャンセルした場合。</li>
	</ul>
	<li>アクションなし</li>
	<ul>
		<li>発行者保留中の状態にある保証書の最大期間が期限切れになった場合(発行者が何のアクションも行わなかった場合)。</li>
		<li>管理者保留中の状態にある保証書の最大期間が期限切れになった場合(管理者が何のアクションも行わなかった場合)。</li>
	</ul>
</ul>

<h3>通知</h3>
保証書の状態変化は、以下の通知を生成できます:
<ul>
	<li>新しい保証書が作成され「発行者保留中」の状態になった時に、発行者に送信されます。</li>
	<li>既存の保証書がキャンセルされたか、その保証書状態の最大期間が期限切れになった時に、発行者に送信されます。</li>
	<li>保証書状態が承諾済み、拒否済み、またはキャンセル済みの状態に変化した時に、購入者に送信されます。</li>
	<li>保証書状態が承諾済み、拒否済み、またはキャンセル済みの状態に変化した時に、販売者に送信されます。</li>
	<li>新しい保証書が「管理者保留中」状態になった時に、管理者に送信されます。</li>
</ul>
<br><br>
<hr class="help">


<a name="guarantee_authorization"></a>
<h3>保証書認可</h3>
保証書は、異なる役割によって運用上の流れの様々な段階において、認可を求められます。認可設定は、<a href="#edit_guarantee_type"><u>保証書タイプ</u></a>の中で「認可者」オプションにより定められます。
<hr>


<a name="payment_obligations"></a>
<h2>支払債務</h2>
<br><br>支払債務は、ローンや請求書と同様に、デジタルの(Cyclosの)文書です。この用語が示唆するように、支払債務は「購入者」が「販売者」に支払うための債務です。支払債務は購入者によって、たいてい、供給業者(販売者)の各々の未決済の請求書のために作成されます。支払債務には「額」と「満期日」があり、処理し易くするために「パック」へとまとめることができます。販売者が支払債務を承諾すると、その販売者は支払債務の額の内部ユニットを受け取ります。支払債務が販売者によって承諾され、発行者によって(そしてオプションとしてCyclos管理者によっても)確認されると、ローンと保証書が生成されます。<i>見つけ方</i><br> 支払債務は、「メニュー: 保証書 &gt; 支払債務」で見つけられます。
<br><br>
<hr class="help">


<a name="payment_obligations_search"></a>
<h3>支払債務を検索する</h3> このページでは支払債務を検索できます。 
<br>可能な検索オプションは以下の通りです: 
<ul>
	<li><b>状態: </b> 支払債務の<a href="#statusOP"><u>状態</u></a>です。</li>
	<li><b>通貨: </b> (複数の通貨が存在する場合にのみ表示されます。)</li>
	<li><b>購入者/販売者: </b> ログイン中のユーザーの役割に依存します。</li>
	<li><b>満期日: </b> 掲載日。この日付より後、支払債務はもはや販売者に見えなくなります。掲載日は満期日よりも前でなければなりません。</li>
	<li><b>額: </b> 支払債務の額の範囲です。 </li>
</ul>
<br><br>
<hr class="help">


<a name="payment_obligations_search_results"></a>
<h3>検索結果 支払債務</h3>
このウィンドウは検索の結果を表示します。 支払債務にアクセスするために、そのアイコン <img border="0" src="${images}/view.gif" width="16" height="16">を選択できます。
<br><br>
<hr class="help">


<a name="edit_payment_obligation"></a>
<h3>支払債務を作成および編集する</h3>
有効な<a href="#certifications"><u>証明書</u></a>を持つ購入者は、供給業者(販売者)への支払債務を発行できます。<br>
購入者はメニューオプション「保証書 &gt; 支払債務」で支払債務を作成できます。<br>
必要なフィールドは以下の通りです: <br>
<ul>
	<li><b>販売者: </b> 販売者の氏名とログイン名です。</li>
	<li><b>掲載期日: </b> 掲載日。この日付より後、支払債務はもはや販売者に見えなくなります。掲載日は満期日よりも前でなければなりません。</li>
	<li><b>満期日: </b> 販売者が支払債務を承諾できる期間の最終日です。</li>
	<li><b>額: </b> 支払債務の額(通常は特定の請求書の額)です。</li>
	<li><b>説明: </b> 任意の説明です。</li>
</ul>
<br> 
支払債務が作成されると、以下のオプションが利用可能です:
<ul>
	<li><b>消去する: </b> これは支払債務を消去します。</li>
	<li><b>掲載する: </b> これは支払債務を掲載済みの状態にします。つまり、それが販売者に見えるようになるということです。</li>
	<li><b>変更する: </b> このオプションにより、支払債務を変更できます。</li>
	<li><b>非掲載にする: </b> (掲載済み状態にある時のみ見えます。)
	このオプションを選択することにより、支払債務は再び「登録済み」状態になります。つまり、それを変更したり、再び掲載したりすることができます。</li>
</ul>
<br><br>
<hr class="help">


<a name="accept_payment_obligation"></a>
<h3>販売者によるアクション</h3>
支払債務(または支払債務のパック)が「掲載済み」状態にある場合、 販売者は、支払債務ウィンドウ内でオプションを選択することにより、支払債務を承諾または却下することができます。<br> <br> それをより便利にするために、複数の支払債務を「パック」として販売者に送信することができます。これは支払債務検索結果リスト内の各支払債務の前にある選択ボックスに印をつけることによって行えます。<br> 注: これらの選択オプションは、検索結果が購入者と通貨(複数の通貨が利用可能な場合)により制限されている場合にのみ表示されます。<br>却下すると、支払債務は単にキャンセルされて、購入者は通知を受けるでしょう。<br>販売者が支払債務を承諾すると、以下のことが起こります。
<ul>
	<li>保証書は、支払債務の額で生成されます。</li>
	<li>発行者は、保証書を認可しなければなりません。</li>
	<li>オプションとして、管理者は保証書も認可しなければなりません。</li>
	<li>すべてのレベルによって認可されると、保証書は「承諾済み」状態になり、購入者を宛先口座とするローンが生成されます。</li>
	<li>ローンの額は、販売者の口座に先払いされます。つまり、ローンは購入者にとって未決済になりますが、販売者の借方に保証書の額が記入されます。</li>
	<li>可能なクレジット手数料と発行手数料が賦課されます(<a href="#edit_guarantee_type"><u>保証書タイプ</u></a>内の設定に依ります)
</ul>
支払債務に関するすべての状態変化はログに記録され、通知は購入者と販売者の両方に送信されます。
<br><br>
<hr class="help">


<a name="payment_obligation_logs"></a>
<h3>支払債務の状態変化</h3>
このウィンドウは、<a href="#statusOP"><u>状態</u></a>の変化についての情報を与えます。
<hr class="help">


<h3>支払債務の状態</h3>
<a name="statusOP"></a> 支払債務は、保証書タイプと運用上の流れに依って、様々な異なる状態になり得ます。以下にすべての可能な状態をリストにします。どの状態もその状態に至る可能なアクションを説明します。<br><br> <b>状態/アクション</b>
<ul>
	<li>登録済み</li>
	<ul>
		<li>購入者が新しい支払債務を作成した場合。</li>
		<li>購入者が支払債務を非掲載にした場合。</li>
		<li>掲載済み状態にある支払債務が最大掲載期間に達した場合。</li>
	</ul>
	<li>掲載済み</li>
	<ul>
		<li>購入者が登録済み状態にある支払債務を掲載した場合。</li>
	</ul>
		<li>承諾済み</li>
	<ul>
		<li>販売者が掲載済み状態にある支払債務を承諾した場合。</li>
	</ul>
		<li>拒否済み</li>
	<ul>
		<li>販売者が掲載済み状態にある支払債務を拒否した場合。</li>
		</ul>
	<li>期限切れ</li>
	<ul>
	<li>掲載済み状態にある支払債務の満期日に達した場合。</li>
	</ul>
</ul>
<h3>通知</h3>
支払債務の状態変化は、以下の通知を生成できます:<br>
<ul>
	<li>支払債務が掲載済み状態になった時に販売者に対して。</li>
	<li>支払債務が拒否済み状態になった時に購入者に対して。</li>
</ul>

</div>

<div class='help'>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
	<br><br>
</div>
