<div style="page-break-after: always;">
<br><br>
Cyclos内の設定は、システムレベルでの任意の環境設定を定めます。<i>見つけ方</i><br>
翻訳モジュールは、「メニュー: 設定」からアクセスできます。<br>
以下の種類の設定が存在します:
<ul>
	<li><b> <a href="#local"><u> ローカル設定:</u></a></b> 言語、タイムゾーン、フォーマットのような任意のシステムローカル設定。
	<li><b><a href="#alerts"><u> アラート設定:</u></a></b> システムアラートに関する閾値とその他の設定。
	<li><b><a href="#access"><u> アクセス設定:</u></a></b> アクセスとセキュリティレベルに関する設定。
	<li><b><a href="#mail"><u> メール設定:</u></a></b> メールサーバーの設定。
	<li><b><a href="#log"><u> ログ設定:</u></a></b> ログファイルの設定。
	<li><b><a href="#channels"><u> チャネル:</u></a></b> チャネル(アクセスメディア)の設定。
	<li><b><a href="#web_services_clients"><u> Webサービスクライアント:</u></a></b> Webサービスの環境設定。
	<li><b>システムタスク:</b> 2種類のシステムタスクがあります。 <b><a href="#search_indexes"><u> インデックスの管理</u></a></b>と<b><a href="#online_state"><u>システム利用可能性</u></a></b>です。
	<li><b><a href="#import_export"><u> エクスポートとインポート:</u></a></b> 設定のインポートとエクスポート。
</ul>
<hr>


<A NAME="local"></A>
<h2>ローカル設定</h2>
これらは、ロケールとシステムに関連した設定です。 変更をするには「変更」ボタンをクリックし、変更を保存するには「送信」をクリックしてください。<b>CyclosのID</b>
<ul>
	<li><b>アプリケーション名:</b> これは、あなたのブラウザのトップバーに現れるアプリケーションのタイトルです。
	<li><b>アプリケーションユーザー名:</b> これは、システムがメンバーに対して自動的に生成するメッセージのために使われる名前です。例: 「Cyclos管理者」があなたの...の請求書を承諾しました。
	<li><b>外部チャネルのためのID:</b> この名前は、サードパーティーのソフトウェアがCyclosにアクセスしており、それが接続しているインスタンスを特定する必要がある場合に使われます。通常、これはインスタンス名になるでしょう。
	<li><b>グローバルコンテナページURL</b> このフィールドは、あなたがWebサイト(Cyclosプロジェクトサイト上のデモのような)からCyclosにアクセスしたい場合に必要とされます。そのWebサイトは、Cyclosログインページを含むIframeまたはフレームを持つでしょう。これを行う場合、「トップ」が表示されないように(コンテンツ管理 - 静的ファイル - top.jsp内で)カスタマイズしたいかもしれません。<br> そのURLは、前にhttp://またはhttps://のついた完全なURLである必要があります。通常のページに対するURLリクエストを行うと、直接コンテナページに向けられるということに注意してください。そのコンテナページが正しく動かない場合、通常のURLでCyclosにアクセスできないということを意味します。これが生じる場合は、常にそのURLにdo/loginを付けた元のページでCyclosにアクセスできます。たとえば、http://www.yourdomain.org/cyclos/do/login<br> Cyclosは1つのインスタンス内で複数のコミュニティをサポートします。各コミュニティは、その独自の(カスタマイズされた)ログインページからか、各自のWebサイトからアクセスできます。これを可能にするには、グループまたはグループフィルタごとにコンテナページURLを定義する必要があるでしょう。この種類の環境設定では、グローバルコンテナURLは、Cyclosにアクセスするための独自のWebサイトを持たないグループのための標準の(フォールバック)コンテナになるでしょう。<br> これに関するさらなる情報は、<a href="${pagePrefix}groups#group_details"><u>グループ</u></a> および <a href="${pagePrefix}groups#group_filter"><u>グループフィルタ</u></a> 設定の中で見つけられます。
</ul>

<b>国際化</b>
<ul>
	<li><b>言語: </b> いくつかの言語から選ぶことができます。現時点では、7言語が利用可能です。
	<li><b>数字フォーマット: </b> 数字のカンマ-ドット区切りを表示するフォーマットを選んでください。現時点では、アメリカとヨーロッパの数字フォーマットをサポートしています。
	<li><b>数字の精度: </b> この設定は、カンマ(または小数点)の後ろの桁数を示します。それがゼロに設定されている場合、アプリケーションは整数でのみ機能します。 たいていのシステムにとって、この設定は2に設定されるでしょう。
	<li><b>高精度: </b> この設定は、口座手数料のみのためのカンマ(または小数点)の後ろの桁数を示します。通常、この数字は数字の精度と同じです。しかし、口座手数料計算の正確さのために、より高い精度を持たせることが必要になる場合もあります。
	<li><b>小数入力方法: </b> この設定により、小数区切り(たとえば、カンマ)が自動的に記入される、つまり、ユーザーが単に数字だけを入力する(1つ目の選択肢「右から左へ」)かどうかを定められます。2つ目の選択肢(左から右へ)は、ユーザーが小数区切りを入力しなければならないことを意味します。
	<li><b>タイムゾーン: </b> ここではタイムゾーンを定められます。 これは、サーバーがそのインスタンスを使用するユーザーとは別のタイムゾーンに位置する場合にのみ、設定する必要があります。
	<li><b>日付フォーマット: </b> 画面上に日付を表示するためのフォーマットを選んでください。
	<li><b>時刻フォーマット: </b> 時刻のフォーマットを選んでください。その時刻は、取引、アラート、請求書、所見のための完全な日付/時刻を表示するために使われます。
</ul>

<b>制限: </b>
<ul>
	<li><b>最大反復子結果: </b> あらゆる印刷またはCSVとして「ダウンロード」するオプションにおける最大結果(行数)。このオプションはサーバーへの過負荷を避けるために設定されます。
	<li><b>最大ページ結果: </b> 1つの検索結果ページ上に置かれる項目の最大数。
	<li><b>最大Ajax結果: </b> 「メンバーにジャンプ」のような自動補完フィールドや直接の支払いおよび請求書において置かれる項目の最大数。
	<li><b>最大アップロードサイズ: </b> これはプロフィール画像と広告画像についての最大アップロードサイズです。
	<li><b>最大画像サイズ: </b>
	これは画像(たとえば、広告とプロフィール)の最大サイズ(幅と高さ)です。 アップロードされたサイズがそれよりも大きい場合、Cyclosは自動的に画像を縮小します。
	<li>アップロードされたサイズがそれよりも大きい場合、Cyclosは自動的に画像を縮小します。
	<li><b>最大サムネイルサイズ: </b> これはサムネイル(広告とメンバーのためのクリック可能な画像)の最大サイズ(幅と高さ)です。サムネイルは、元の画像と同じ縦横比で表示されます。したがって、その縦横比が「縦長」の場合には、そのサイズは最大サイズよりも小さくなり得ます。
	<li><b>仲介の期限切れ: </b> この期限が設定されると、仲介人の登録済みメンバーがそのリストから消えます。あなたのシステムが仲介人 <a href="${pagePrefix}brokering#commission"><u>委託手数料</u></a> ありで動いているならば、委託手数料期限が仲介人期限切れ期限よりも先にならないように注意しなければなりません。
	<li><b>ゴミ箱のメッセージを消去するまでの時間: </b> これはメンバーメッセージがゴミ箱に入っている最大期間です。この期間の後、メッセージは削除されます。<b>メンバー登録のための最大Eメール確認時間: </b> メンバーが外部から登録し、Eメール確認が有効化されている場合(グループ設定「一般登録の際にメールアドレスを確認する」内)、そのメンバーはこの期間内に確認をしなければなりません。
</ul>

<b>データ表示 </b>
<ul>
	<li><b>メンバーのEメールを義務化: </b> このオプションが選択された場合、Eメールフィールドは必須になります(管理者による登録時またはメンバーによる一般登録時)。
	<li><b>メンバー表示名: </b> メンバーの氏名かログイン名のいずれか一方が表示される場合もあります。これはたとえばローンと広告の結果リストの場合です。設定により、そのような場合にログイン名が表示されるか、ユーザー名が表示されるかを定められます。
	<li><b>メンバー検索結果のためのソート順序:</b> ここでは、メンバー検索結果がどのように並べられるかを定められます(「メニュー: ユーザーとグループ - メンバーの管理」)。標準は(メンバーの作成日に基づく)日付順です。
	アルファベット順を選ぶと、このフォーム内の前の要素(「メンバー表示名」)が、メンバーが実名で並べられるか、ログイン名で並べられるかを定めます。
	<li><b>広告説明フォーマット: </b> ここでは、説明(テキストエリア)のフォーマットを選べます。それは通常のテキストボックスか、(WYSIWYG - what you see is what you get)エディタにすることができます。
	<li><b>メッセージフォーマット: </b> ここでは、メンバー間と管理者とメンバーの間の通常メッセージのために使うエディタタイプを定められます。
	<li><b>広告カテゴリー内にカウンターを表示する: </b> この設定が選択されると、広告カテゴリーリンク(カテゴリーをブラウズする際の広告検索ページ内)の隣にカウンター(数字)が表示されます。これを使うかもしれない理由は、様々なグループ/コミュニティーを含むインスタンスがあり、それらが孤立したグループとして機能し、したがって互いを(そして、互いの広告を)見られない場合です。<br> カウンターはグローバルなので、それらは常にシステム内のすべての(もちろん特定のカテゴリーについての)広告の数を表示します。そのカウンターは、コミュニティ内の広告の数よりも大きい数を表示するので、これは紛らわしいでしょう。<br> したがって、複数インスタンスセットアップの場合は、カウンターを無効化する方が良いでしょう。
</ul>

<b>CSVエクスポート: </b>
<ul>
	<li><b>ヘッダーを表示: </b> このオプションが選択されている場合、CSVファイルの最初の行が、各列(たとえば、メンバー名、住所など)の最初の行にフィールドの名称を表示します。
	<li><b>文字列引用符: </b>
	このオプションが選択されている場合、説明と題名のような「文字列」フィールドが、引用符の間に置かれます。<br>
	注: このオプションを「なし」にすると、値区切り(カンマ、タブ、セミコロン)を含む文字列フィールドは途切れ、次の(誤った)列に置かれるということに注意してください。	したがって、文字列引用符を使用することが強く推奨されます。
	<li><b>値区切り: </b> これはCSVファイルのための区切り文字です。表計算やテキスト処理プログラムにそのファイルをインポートする際に、この区切りを指定する必要があるかもしれません。
	<li><b>行区切り: </b> これは使われる「行末」文字です。標準のUNIX行区切りは、最も使われる標準的なものです。「DOS」タイプは、Windowsシステムのために使えます。
</ul>

<b>SMS </b>
<ul>
	<li><b>有効: </b> SMSを有効化すると、Cyclosは、SMSからの支払い、支払い要求、情報テキスト、口座情報の参照を可能にします。Cyclos内のSMSモジュールは、外部のSMSコントローラを必要とします。
	<li><b>オペレーションチャネル: </b> ここでは、モジュールのために使われるチャネルを選択します。SMSチャネルが1つもない場合、先にそれを作成しなければなりません(「メニュー: 設定 - チャネル」内)。<br>
	<li><b>SMS送信WebサービスURL: </b> CyclosとSMSコントローラの間の通信は、Webサービスを通じて生じます。したがって、WebサービスURLを与える必要があります。
	<li><b>携帯電話を示すカスタムフィールド: </b>SMSモジュールによって使われるプロフィールフィールドを定めなければなりません。(選択リスト内には、固有で文字列タイプのカスタムフィールドが表示されます。)<br>
</ul>
そのSMSオプションがアクティブになると、それはグループ設定(通知セクション)内に現れ、通知設定内にもチャネルの1つとして現れます。<br> CyclosのSMS設定についての詳細な情報は、<a href="http://project.cyclos.org/wiki/index.php?title=Cyclos_controller_%28SMS%29#Cyclos_setup" target="_blank"><u>Wiki</u></a>で見つけられます。<br><br><b>取引番号 </b>
<ul>
	<li><b>取引番号: </b>このオプションが有効の場合、システム内のすべての取引が、固有の取引番号(識別子)を生成するようになります。この識別子のフォーマットは、以下のフィールドで定義されます:
	<ul>
		<li><b>接頭辞: </b> 識別子の接頭辞(数字または文字)
		<li><b>識別子の長さ: </b>識別子(連番)の長さ
		<li><b>接尾辞: </b>識別子の接尾辞(数字または文字)

	</ul>
	例:プレフィックス=abc、長さ=5、接尾辞=xyzに設定されたシステムにおいて、最初の取引の取引番号は、「abc00001xyz」になります。
</ul>


<b>チャージバック: </b>この設定では、管理者が支払いをチャージバックできる最大時間を定められます。チャージバックは、反対方向の支払いが行われることを意味します。その支払いが他の取引(たとえば、手数料やローン)を生成した場合、すべての取引が反対の取引を生成することになります。あなたが支払いをチャージバックできる日付最大時間も設定できます。生成された反対の取引の説明は、#dateや#descriptionといった変数を含み得ます。そこでの#descriptionは、元の取引の説明です。<br><br>ローンに関連している取引をチャージバックする場合には、気を付けてください。これは、ローンが返済済みの場合には、エラーになるかもしれません。

<br><br><b>スケジュールされたタスク: </b> この設定は、通常、パフォーマンス問題のために使われます。この設定により、いつタスクが実行されるかを定められます。これは、たいてい、同一システム上で複数のCyclosインスタンスが稼働する場合に、パフォーマンス上の理由のために使われます。Cyclosには、1日ごとおよび1時間ごとに実行されるスケジュールされたタスクがあります。
<ul>
	<li><b>スケジュールされたタスクの時: </b> ここでは1日ごとに実行されるタスクのための時(0-24)を設定できます。1日ごとのタスクの例は、期限切れの広告のチェックです。
	<li><b>スケジュールされたタスクの分: </b> ここでは1日ごとおよび1時間ごとに実行されるタスクのための分(0-60)を設定できます(1日ごとのタスクは、上で設定された時に分を加えることになります)。1時間ごとのタスクの例は、口座手数料のチェックです。
	<li><b>次の時間ごとに検索インデックスを再構築する: </b> この設定により、Cyclosインデックスが再構築される時間と頻度を定められます。Cyclos3.5では、メンバーと広告がインデックス化され、それにより検索が速くなります。また、インデックス化は、複数キーワードによる検索を可能にし、すべてのフィールド(メンバープロフィールまたは広告フィールド)が検索されます。<br> インデックスは、時間の経過により損なわれ得るので、頻繁に再インデックス化するのは良い考えです。私たちは、週に1回、平穏な時間帯(夜または朝)にインデックスを再構築することを提案します。広告とメンバープロフィールの量によっては、これはいくらかの時間を要することがあります。そのプロセスは、異なるスレッドで実行され、Cyclosの機能に影響を与えません。<br> 再インデックス化は、サーバーにおいてインデックスを手動で削除(単にWEB-INFディレクトリ内のディレクトリインデックスを削除)し、そのサーバーまたはインスタンスを再起動することによっても行えます。
	<br><br>
</ul>
<br><br><b>追加的: 処理された支払いのためのJavaクラス</b> 支払い(設定により行えない)のために特定の行動または機能が必要とされるならば、支払いが処理される度に発動される独自のJavaクラスを作成できます。この設定は、すべての取引タイプに適用されます。具体的な取引タイプのためのクラスを、(<a href="${pagePrefix}account_management#transaction_type_details"><u>取引タイプ詳細</u></a>) - 「Javaクラスを実行する」において定義することもできます。<br><br> <b>注1:</b> そのクラスは 「処理済み」の支払いに対してのみ発動されます。つまり、その支払いが将来の日付にスケジュールされているか、認可待ちで保留中の場合、それは発動されません。(しかし、スケジュールされた支払いまたは認可された支払いが最終的に処理されると、そのクラスが発動されます。)<br><br>
	<b>注2:</b>
	そのクラスがサーバークラスパス、たとえば、WEB-INF/libで利用可能であることを確認してください。
	<br><br>
<hr>


<A NAME="alerts"></A>
<h2>アラート設定</h2>
アラート設定では、メンバーの行動に関連したアラートのための限界と閾値を定められます。変更をするには「変更」ボタンをクリックし、変更を保存するには「送信」をクリックしてください。<br> 現時点では、以下のアラート閾値を設定できます:
<ul>
	<li><b>アクティベーション保留中の新規メンバー: </b> このオプションが選択されると、新たなユーザーが(ログインページで)登録した時に、アカウントアラートが生成されます。
	<li><b>非常に悪い評価の授与: </b> 誰かが「x」より多い「非常に悪い」評価を与えた時、アラートが生成されます。
	<li><b>非常に悪い評価の受取: </b> 誰かが「x」より多い「非常に悪い」評価を受け取った時、アラートが生成されます。
	<li><b>請求書の期限切れ: </b> 誰かが請求書を受け取ったが、全く反応しない(拒否も承諾もしない)時、期間「x」後にアラートが生成されます。
	<li><b>拒否された請求書: </b> 誰かが「x」より多い請求書を拒否した時、アラートが生成されます。
	<li><b>誤ったログイン試行: </b> 「x」回のログイン試行が失敗した後、システムアラートが生成されます。
</ul>
<hr>


<A NAME="access"></A>
<h2>アクセス設定</h2>
ここでは、Cyclosへのアクセスに関係する設定を定められます。
変更をするには「変更」ボタンをクリックし、変更を保存するには「送信」をクリックしてください。<br>以下のオプションが利用可能です:
<ul>
	<li><b>ログインパスワードのための仮想キーボード: </b> このオプションがチェックされていると、ユーザー(管理者とメンバーの両方)は、ログインページで仮想キーボードを提示されます。パスワードは、仮想キーボードを使って入力される必要があります。仮想キーボードは、悪意のあるキーロギングソフトウェアがパスワードを捕捉するを回避します。
	<li><b>取引パスワードのための仮想キーボード: </b> このオプションがチェックされると、ユーザー(管理者とメンバーの両方)は、取引パスワードが必要な時に仮想キーボードを提示されます。取引パスワードのキーの一はランダムな順序で表示されます。取引パスワードで使える文字は、下の「取引パスワード内で可能な文字」オプションで定められます。
	<li><b>数のパスワード: </b> このオプションが選択されると、メンバーは数のパスワードのみを持ち得ます。メンバーがカードやPIN番号でも支払いをする場合には、このオプションが必要とされるかもしれません。この設定は、管理者には当てはまりません。
	<li><b>同一ユーザーの多重ログインを許可する: </b>このオプションが選択されると、ユーザーは、異なるブラウザから同時に複数回ログインできます。
	<li><b>オペレータログインを可能にする:</b> <a href="${pagePrefix}operators"><u>オペレータ</u></a>を有効にした場合、オペレータのログインを可能にするには、このチェックボックスがチェックされなければなりません。
	<li><b>管理者セッションタイムアウト: </b> 管理者が非アクティブになった後にログアウトされるまでの時間。
	<li><b>メンバーセッションタイムアウト: </b> メンバーが非アクティブになった後にログアウトされるまでの時間。
	<li><b>PosWebセッションタイムアウト: </b> メンバーまたはオペレータが非アクティブになった後にログアウトされるまでの時間。
	<li><b>管理者アクセスホワイトリスト: </b> ここでは、管理者セクションにアクセスできるユーザーのIPアドレスまたはホスト名を入力できます。すべてのホスト名またはIPを新しい行(リターン)に入力してください。「#Any host」エントリを空のままにすると、任意のホストが管理者ログインページへのアクセスを許されます(ただし、ユーザー名とパスワードは依然として必要とされます)。
	<li><b>ログイン名生成: </b>
	<ul>
		<li><b>メンバーによる手動: </b> コミュニティネットワークについては、ユーザーが自身のログイン名または「ニックネーム」を選ぶのが一般的です。この場合、「メンバーによる手動」オプションが選択される必要があります。<br>このオプションが選択されると、ログイン名の最小長および最大長と、ログイン名のフォーマットを強制するための正規表現を指定できます。<br> 任意の文字(行末文字に一致するかもしれないししないかもしれない) \d 数字:[0-9] \D 非数字: [^0-9] \s 空白文字: [ \t\n\x0B\f\r] \S 非空白文字:[^\s] \w 単語文字:[a-zA-Z_0-9] \W 非単語文字: [^\w]<br> http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.htm<br> メンバーまたは管理者によって入力できるログイン名の最小長と最大長を指定することが可能です。
		<li><b>生成される乱数(ログイン番号): </b> ビジネスネットワークについては、生成されたログイン名または「口座番号」を使うのが一般的です。このモジュールがアクティブ化されると、登録フォームにはログイン名入力フィールドがありません。フォームが送信されると、ログイン名(乱数)は自動的に作成されます。このオプションの下で、生成されるログインコードの長さを指定できます。
	</ul>
	<li><b>取引パスワードにおいて可能な文字: </b> ここでは、取引パスワード生成のために(ランダムな順序で)使われる文字を定められます。(取引パスワードの設定については、<a href="${pagePrefix}groups#edit_member_group"><u>グループ設定</u></a>を参照してください。)
	</ul>
<hr>


<A NAME="mail"></A>
<h2>メール設定</h2>
このページでは、メール設定を設定できます。 「送信元アドレス」とSMTPサーバー変数を定められます。あなたのメールサーバーがTLSを要求する場合、TLSオプションをチェックしなければなりません。<br> 変更をするには「変更」ボタンをクリックし、変更を保存するには「送信」をクリックしてください。
<hr>


<A NAME="log"></A>
<h2>ログ設定</h2>
ログ設定は、ログがどこにどのように記録されるかを定めます。 Cyclosのログファイルは、データベースに記録されるのではなく、サーバー上のテキストログファイルに記録されます。したがって、この設定がサーバー管理者によって(または、管理者と協力して)管理されることが重要です。<br> 変更をするには「変更」ボタンをクリックし、変更を保存するには「送信」をクリックしてください。<br><br>以下の設定が可能です:
<ul>
	<li><b>アクションログレベル: </b>このログは、任意のCyclosアクションについての情報を、日付、メンバー名などのようなアクションについての完全な情報(トレース)とともに含みます。<br> 以下のオプションが可能です。
	<ul>
		<li><b>オフ: </b> アクションログは使用されません。
		<li><b>エラーのみ: </b>アクションログはエラーのみを含みます。
		<li><b>単純なトレース: </b>アクションログは、任意の成功とエラーのアクションを記録します。それは連続したメソッドコールを示します。
		<li><b>詳細なトレース:</b> 前のものと同様ですが、受け渡された値(変数)と戻された値も示します。
	</ul>
	<li><b>アクションログファイルパス/ファイル名: </b>ここでは、パスとファイル名を指定できます。サーバー上に複数のインスタンスがインストールされている場合は、各々のインスタンスのために別個のログディレクトリを持つのが良いでしょう。
	<ul>
		<li>&quot;/&quot; ローカルパス名区切り
		<li>&quot;%t&quot; システム一時ディレクトリ
		<li>&quot;%h&quot; &quot;user.home&quot;システム特性の値
		<li>&quot;%g&quot; ローテートされたログを区別するための世代番号
		<li>&quot;%u&quot; 衝突を解決するための固有の番号
	</ul>
	<li><b>データ変更された場合にのみログを生成する: </b> これがチェックされると、データベースが変更されるアクションのみがログに記録されます。つまり、基本的に、何かを書き込み/保存するすべてのアクションがログに記録されますが、検索や印刷などのアクションはログに記録されません。通常、データベースの書き込みのみをログに記録すれば十分です。
	<li><b>取引ログレベル: </b>このログは、取引のみを、メンバー/システムからメンバー/システムへ、額、日付などのようなすべての関連した情報とともに含みます。<br> 以下のオプションが可能です。
	<ul>
		<li><b>オフ: </b>取引ログは使用されません。
		<li><b>通常: </b>このオプションが選択されると、ログはすべての取引を、日付、メンバー/システムからメンバー/システムへ、額とともに含みます。
		<li><b>詳細: </b>このオプションは、通常の場合と同じ情報に加えて、取引の説明と取引タイプを与えます。
	</ul>
	<li><b>取引ログファイルパス/ファイル名</b> <br> ここでは、アクションログファイルパスおよびパス名(上の説明を見てください)と同じ方法で、パスとファイル名を指定できます。
	<li><b>口座手数料ログレベル: </b>このログは、口座手数料(寄付)についての情報を与えます。Cyclos管理セクションには、<a href="${pagePrefix}account_management#account_fee_history"><u> 口座手数料の履歴</u></a>も備わっています。口座手数料をログに含められる理由は、Cyclos内部で生じる任意の出来事をログファイル内に(データベース外部に)完全に記録できるようにするためです。さらに、口座手数料ログは、管理セクション内の口座手数料履歴よりも拡張されています。<br> 以下のオプションが可能です。
	<ul>
		<li><b>オフ:</b> 全くログが記録されません。
		<li><b>エラーのみ:</b> 問題のみを示します。
		<li><b>状態変更とエラー:</b> アラート状態と成功が記録されます。
		<li><b>詳細:</b> すべての取引を記録します。
	</ul>
	<li><b>口座手数料ログファイルパス/ファイル名</b> <br> ここでは、アクションログファイルのパスおよびファイル名(上の説明を見てください)と同じ方法で、パスとファイル名を指定できます。
	<li><b>スケジュールされたタスクのログレベル</b> <br> スケジュールされたタスクのログは、口座手数料ログを含みます。スケジュールされた口座手数料についての情報は、 <a href="${pagePrefix}account_management#account_fee_overview"><u>口座手数料管理</u></a >機能の中でも見つけられます。それらがログにも含まれる理由は、データベースとは別個に、Cyclos内の任意のアクションの完全なログを持つためです。以下のオプションが可能です。
	<ul>
		<li><b>オフ:</b> 全くログ記録が行われません。
		<li><b>エラーのみ:</b> 問題のみを表示します。
		<li><b>要約された実行:</b> タスクが実行されたというタイムスタンプ付きの情報のみ。
		<li><b>詳細な実行:</b> タスクについての詳細な情報。(これは、非常に広範になり得るということに注意してください。多くのメンバーに課す口座手数料は、すべての別個の取引をログに記録するでしょう。)
	</ul>
	<li><b>スケジュールされたタスクのログフィルパス/ファイル名</b> <br> ここでは、アクションログファイルパス/ファイル名(上の説明を見てください)と同じ方法で、パスとファイル名を指定できます。
	<li><b>ログごとの最大ファイル数: </b>ここでは、ログファイルの最大数を指定できます。ログファイル数とファイルサイズの最大値に達すると、最も古いログファイルが消去され、新しいログファイルが作成されます。消去される前にログファイルがバックアップされていることを確かめるのが良いでしょう。
	<li><b>最大ファイルサイズ: </b>最大ファイルサイズに達すると、新しいログファイルが作成されます。もちろん、より集中的にログを記録すれば、もっと大きい最大ファイルサイズが設定されなければならないかもしれません。
</ul>
<hr>


<A NAME="channels"></A>
<h2>チャネル</h2>
Cyclosは、異なるメディアまたは「チャネル」からリクエストを扱えます。これらは、Web、PosWeb、携帯電話のような内部(Cyclos)チャネルと、eコマースサイトのようなサードパーティーのソフトウェア、ATMマシン、POSデバイスからのアクセスのために使われる外部(支払い)チャネルになり得ます。将来、新しいチャネルを追加し易くするために、すべてのチャネルは動的にリストにされています。既存のチャネルは、内部で、通常のCyclos設定のためのものです。それらを変更する必要はありません。<br> 現在、以下の(内部)チャネルが利用可能です:
<ul>
	<li><b>メインWebアクセス: </b>これはWebブラウザからの主要なアクセスです。典型的には、www.yourdomain.org/cyclosのようなURLになります。
	<li><b>POS: </b>このチャネルは、ハードウェアおよびソフトウェアのPOS(point of sale)デバイスのために使われます。このチャネルはPOSを識別するために、POS識別子を使います。POSについてのより詳細な情報は、<a href="${pagePrefix}access_devices#POS"><u>アクセスデバイス</u></a>のヘルプファイルで見つけられます。
	<li><b>PosWeb支払い: </b>店舗における消費者としてのPosWeb(point of sale)アクセス。<a href="${pagePrefix}operators"><u> オペレータ</u></a>または直接的にメンバーによって使われます。それはインスタンスURLの後ろに/poswebまたは/operatorを付けることによってアクセスできます。たとえば、www.yourdomain.org/cyclos/operatorです。<br>
	<li><b>WAP1アクセス: </b> (ワイヤレスアプリケーションプロトコル)は、通常、Wap2をサポートしていない古めの携帯電話によって使われます。そのモジュールは、ドメインの後ろに/wapを付けることによってアクセスできます。
	<li><b>WAP2アクセス: </b>WAP2は、携帯電話からのWebアクセスを提供します。そのモジュールは、Cyclosドメインの後ろに/mobileを付けることによってアクセスできます。
	<li><b>Webショップ支払い: </b>Webショップ支払いチャネルは、eコマースソフトウェアから行われる支払いを可能にします。
</ul>
内部チャネルは、プログラムによってのみ追加できます。 外部チャネルを追加する場合で、あなたがそのチャネルからの支払いを可能にしたければ、<a href="${pagePrefix}account_management#transaction_types"><u>取引タイプ</u></a> (そのチャネルを使う予定のもの)にそのチャネルを追加しなければなりません。チャネルごとに取引タイプをただ１つのみ持つのは良いことです。<br>そのチャネルを使うメンバーグループは、そのチャネルの有効化も(<a href="${pagePrefix}groups#edit_member_group"><u>グループ設定</u></a>内で)しなければならず、そのグループは、特定の取引タイプを実行する権限も持つ必要があるでしょう。
<hr class="help">

<A NAME="channels_detail"></A>
<h3>チャネル詳細(新規または修正)</h3>
新しいチャネルを追加する必要がある可能性は低いです。 既存のチャネルのために、ユーザーが特定され認証する方法を定められます。<br>

<ul>
	<li><b>表示名: </b> リスト内に表示されるチャネルの名称。
	<li><b>内部名称: </b> この名称は、内部利用のためだけのものです。
	<li><b>ユーザーID: </b>ここでは、ユーザーがどのように自分自身を証明しなければならないかを選べます。
	<li><b>標準のユーザーID: </b> 複数のIDオプションが選択されている場合、(たとえば、ログインフォーム内で)表示される標準のIDをここで選択できます。
	<li><b>認証情報: </b>ここではユーザーの認証を確認するために使われる認証情報を選びます。
	<li><b>支払い要求をサポートする: </b>チャネルに支払い要求をサポートさせたい場合、このオプションが選択される必要があります。これはSMSモジュール内のビルドオプションです。 しかし、他のサービス(たとえば、IVR)にとっても有用かもしれません。
	<li><b>WebサービスURL: </b> 支払い要求オプションがチェックされている場合、応答URLを定める必要があります。
</ul>
<hr>


<A NAME="web_services_clients"></A>
<h2>Webサービスクライアント</h2>
Webサービスクライアントでは、どの外部ソフトウェアがWebサービスからCyclosにアクセスできるか、また、どのサービスにアクセスできるかを定められます。<br><br>編集アイコンを選択してWebサービスを編集することができ、消去アイコンをクリックして消去することができます。<br> 新しいWebサービスクライアントを追加したい場合は、「新しいWebサービスクライアント」というラベルの付いた「送信」ボタンをクリックしてください。
<hr class="help">


<A NAME="web_services_clients_detail"></A>
<h3>Webサービスクライアントを挿入/修正する</h3>
ここでは、新しいWebサービスクライアントを挿入するか、既存のものを編集することができます。 完了したら、「送信」ボタンをクリックして変更を保存してください。既存のものを編集するならば、変更をするために、まず「変更」ボタンをクリックしてください。
<ul>
	<li><b>名称: </b>ここでは、名称を指定できます。 これは、内部利用のためだけのものです。
	<li><b>インターネットアドレス: </b>ここでは、Webサービスへのアクセスを許されたIPアドレスまたはドメイン名(IPアドレスへと解決される)を指定できます。<br> ISPからサーバーに接続したい場合は、おそらく同じIPが他のWebサイトのために(ホストヘッダーを使って)使われているということに注意してください。これは、これらのサイトのすべてがそのWebインスタンスにアクセスできることを意味します。多くの場合、Webサイトドメイン名を解決するIPは、そのWebサイトに接続する時の別のIPです。この場合、外部接続をするために使われるIP(の範囲)がどれか、あなたのプロバイダに問い合わせたいかもしれません。<br>
	IPの範囲を指定することも可能です(たとえば、77.88.45.0-255)。範囲の指定は、セキュリティーホールになるかもしれないことに留意してください。広告の閲覧のような比較的重要でないアクセスの場合には、これは問題にならないでしょうが、支払いやメンバーデータの閲覧のようなもっと重大なアクションについては、単一のIPアドレスのみを許可することが好ましいでしょう。<br><br>
	<li><b>チャネル: </b> ここでチャネルを選択できます。 これは追加したチャネルか、「Webショップ支払い」のための「内蔵の」チャネルにすることができます。(Webショップ支払いチャネルは、eコマースサイトからの支払いを可能にします。さらに詳細な情報は、Cyclos wiki上の、セクション: Webサービス - Webshopで見つけられます。)
	<li><b>メンバーに制限: </b>ここでは、Webサービスが特定のメンバーに制限されるかどうかを定められます。アクセスのタイプは、権限に依存します(下を見てください)。
	<li><b>HTTPユーザー名/パスワード: </b>ここでは、ユーザー名とパスワードを指定できます(任意)。Webサービスクライアントによってなされるすべてのhttp(s)リクエストは、このユーザー名とパスワードで認証される必要があります。<br> このオプションが使われる場合、そのユーザー名/パスワードが暗号化されて伝わるようにhttpsを有効にするのが良いでしょう。
	<li><b>要求される認証情報: </b>このオプションは、チャネルが選択され、メンバー毎に制限がない場合にのみ利用可能です。このオプションにより、外部ソフトウェアが支払いを行えるようになりますが、認証情報は依然として必要です。これは典型的に、支払いを行うメンバーが認証情報を入力しなければならず、Webサービスにアクセスしているソフトウェアがこれを捕捉して、支払いデータとともにWebサービスへと渡すということを意味します。
	<li><b>権限: </b>
	<ul>
		<li><b>支払いを行う: </b>このオプションは、チャネルが選択されている場合にのみ利用可能です。そのサービスは、(外部)支払いチャネルからの支払いを可能にします。1つ以上の支払いタイプを選択できます。Webサービスがメンバーによって制限されている場合、このメンバーはそのチャネルから支払いを行うことのみができます(受け取ることはできません)。
		<li><b>支払いを受け取る: </b> このオプションも、チャネルが選択され、(制限された)メンバーが選択された場合にのみ利用可能です。そのサービスは、(外部)支払いチャネルからの支払いを可能にします。1つ以上の支払いタイプを選択できます。選択された制限されたメンバーは、選択されたチャネルからのみ支払いを受け取れます。その支払いは、支払人の<a href="${pagePrefix}passwords#pin"><u>PIN</u></a>を要求します。
		<li><b>支払いをチャージバックする: </b>このオプションは、チャネルが選択されている場合にのみ利用可能です。このサービスによって、(外部)支払いチャネルから<a href="#local"><u>支払いをチャージバックする</u></a>ことができます。1つ以上の支払いタイプを選択できます。
		<li><b>広告を検索する: </b>広告(通常、Webサイト内の)を検索できるようにします。Webサービスがメンバーによって制限された場合、そのサービスは、そのメンバー(グループ)が閲覧できる広告を検索することのみできます。<br>
		<li><b>メンバーを検索する: </b> メンバー(通常、Webサイト内の)を検索できるようにします。Webサービスがメンバーによって制限されると、そのサービスは、そのメンバー(グループ)が閲覧できるメンバーリストとプロフィールフィールドのみを検索できます。 <br>
		<li><b>メンバーを管理する: </b>選択されたグループのためにメンバーを作成および修正できるようにします。メンバー検索を選んだ場合でも、Webサービスクライアントは依然としてシステム内のすべてのメンバーを見られることに留意してください。<br>
		<li><b>Eメールとカスタムフィールドの検証を無視する: </b>このオプションは、メンバーの管理において1人またはグループが選択された場合にのみ利用可能です。選択された場合、メンバープロフィールに関する検証は無視されます。
		<li><b>Webショップ支払い: </b> WebショップからCyclosユーザーによる支払いを受け取れるようにします。Webショップ支払いチャネルには、チェックできるただ1つの権限があります(Webショップ支払い)。メンバーの認証は、チケットシステムから処理されます。これは、Cyclos wikiサイト &gt; Webサービス(<a href="http://project.cyclos.org/wiki/index.php?title=Web_services"><u>
		http://project.cyclos.org/wiki/index.php?title=Web_services</u></a>)で説明されています。
		<li><b>アクセスアカウント詳細: </b> アカウント詳細と取引の検索のすべてです。Webサービスがメンバーによって制限された場合、そのサービスはそのメンバーの取引のみを取得できます。
		<li><b>アクセス情報: </b>このオプションにより、Webサービスがチャネルと認証情報についての情報にアクセスできます。それはたとえば、メンバーがどのチャネルを有効にしたかを知るために使えます。
		<li><b>SMSメッセージを送信する: </b> このオプションが選択されると、WebサービスはCyclosがSMSメッセージを送信するように指示できます。
		<li><b>情報テキストを得る: </b> このオプションにより、<a href="${pagePrefix}content_management#infotexts"><u>情報テキスト</u></a>を取得するためのアクセスを与えられます。
	</ul>
</ul>
<hr>


<h2>システムタスク</h2>

<A NAME="search_indexes"></A>
<h2>インデックスを管理する</h2>
インデックスは、ユーザー、広告、メンバー記録に関する高速な検索を手助けするために使われます。インデックスは、キーワードまたはキーワードの組み合わせによる検索を可能にします。インデックスは、データベース内に保存されておらず、サーバーにおける別個のファイルに保存されています。Cyclosのスタートアップ中にインデックスが見つからない場合、初期化プロセスがそれらを作成します。<br> 再構築オプションがインデックスを再作成します。これは単なるフォールバックオプションであり、問題のある場合にのみ使われるべきです。インデックスタイプごとにインデックスを再構築できます。必要ならば、「すべて再構築」オプションを選択することにより、一度にすべてのインデックスを再構築できます。
<hr class="help">


<A NAME="online_state"></A>
<h2>システム利用可能性</h2>
管理セクション内でいくらかのメンテナンスまたは設定をするため、ユーザーがログインするのを避けたい場合もあるかもしれません。Cyclosをシャットダウンしてエラーページが表示されるのを避けるには、このオプションを使ってユーザーがログインするのを禁止し、すべてのログイン中のユーザーを切断することができます。システムを再びオンラインに設定する権限を持つ管理者のみが、ログインしてシステムを再びオンラインに設定できます。<br>
(権限は次の場所で見つけられます:  管理者グループ権限 &gt; 管理タスク &gt; システム利用可能性を設定する)
<hr>


<A NAME="import_export"></A>
<h2>設定のインポートとエクスポート</h2>
この機能により、複数のCyclosインスタンス間で設定を共有するために、設定をエクスポートおよびインポートできます。チャネルとWebサービスのための設定を除き(これらはたいてい各インスタンスに特有のものなので)、すべての設定はエクスポートおよびインポートできます。エクスポート・インポート機能は、単純明快です。エクスポートは、設定の書かれた(読める)settings.xmlファイルを生成します。インポートは、インポートされるファイルの設定を適用します。


 </div> <%--  page-break end --%>

<div class='help'>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
<br><br>
</div>