<div style="page-break-after: always;">
<br><br>Cyclosにはデータの統計分析のためのセクションがあります。<br> 統計とは、結果がどのくらい正確であるかを数量化しようとする試みです。私たちは、統計的検定を行い、可能な場合にはいつでも、数の正確さを示すことによりこれを行います。<i>見つけ方</i><br>
「メニュー: レポート &gt; 統計分析」からこのセクションに行けます。<br><br><i>動かし方</i> 統計には、それらが見えるようになる前に有効化されなければならない <a href="${pagePrefix}groups#manage_group_permissions_admin_system"><u> 権限</u></a>があります。その権限は、「レポート」というタイトルのブロック内、「統計」チェックボックスで見つけられます。<br><br> 統計の中で、特定の<a href="${pagePrefix}groups#group_filters"><u>グループフィルタ</u></a>または<a href="${pagePrefix}account_management#payment_filters"><u>支払いフィルタ</u></a>を使いたければ、それらが統計に見えるように印をつけなければなりません。これは、これらのフィルタのための設定ページ内で行えます(リンクを辿ってください)。 
<hr>


<a name="choose_category"></a>
<h3>統計カテゴリーを選ぶ</h3>
このウィンドウは、統計カテゴリーを選ぶオプションをあなたに与えます。 ボタンを1つクリックすると、対応するフォームに移動します。そこでは、計算される統計の詳細を指定できます。したがって、この現在のフォームは、主なカテゴリーを指定するためだけのものです。<br> その時点ではカテゴリーを1つしか選べません。統計的計算は、非常に重くなることがあるので、一度にすべての検定と計算が行えるようにすると、サーバーに過負荷を引き起こし得ます。<br> 以下のカテゴリーから選べます:
<ul>
	<li><b>重要な発展</b>: システムの健全さと成長を確定する主なパラメータ(メンバー数、トレード量などのような)。<br>
	<li><b>メンバーの活動</b>: メンバーの個々のトレード活動に関わる統計。<br>
	<li><b>財務統計</b>: システム口座に関する統計:任意のシステム口座についてのすべての収入と支出。 <br>
</ul>
&nbsp; このソフトウェアの将来のバージョンでは、もっと多くのオプションが後に続きます。
<hr class="help">


<a name="forms"></a>
<h2>統計フォーム</h2>
どのような<a href="#choose_category"><u>カテゴリー</u></a>の統計を見たいかに関して選択をした後、どの統計を見たいかを指定できるフォームに移動します。これらのフォームには、常に、チェックボックスで項目を選べる固有のセクション(各カテゴリーについて異なります)と、<a href="#periods"><u>期間</u></a>と様々な<a href="#filters"><u>フィルタ</u></a>のような統計用のパラメータを定義できる共通のセクションとが(それはたいていすべての統計カテゴリーについて同じです)あります。各統計フォームにおいて、まず、<a href="#whattoshow"><u>「何を表示しますか」</u></a>ドロップダウンボックスで、見たい統計のタイプを選んでください。<br> 左側のチェックボックスで、どの項目を見たいか選べます。項目名は十分に分かり易いですが、それらの正確な定義を確かめたければ、<a href="#glossary"><u>用語集</u></a>をチェックしたいかもしれません。ある主題のグラフチェックボックスを選択すると、通常、両方の表とグラフが表示されます。グラフチェックボックスを選択しない場合、表のみが表示されます。<br> 1つまたは複数のチェックボックスを選択した後、下のウィンドウでの選択のために、<a href="#parameters"><u>共通のパラメータ</u></a>を指定しなければなりません。完了してすべてを確認したら、このページの一番下にある「送信」ボタンをクリックして、すべてを計算してください。<br><br><b><u>警告:</u></b> 大規模なデータベースに関する統計計算は、いくらか時間がかかり得るということに注意してください。<hr>


<a name="key_development"></a>
<h2>重要な発展
</h3>
ここでは、あなたがどの重要な発展の統計を計算したいかを指定できます。重要な発展の統計は、あなたのシステム内の発展についての一般的な概観を得るためのものです。複数の期間を比較して傾向を確認できますが、いかなる統計分析も行われません。以下の項目に関して統計を得られます:
<ul>
	<li><b>メンバーの数</b>
	<li><b><a href="#grossProduct"><u>総生産</u></a></b>
	<li><b>取引の数</b>
	<li><b>平均取引額</b>
	<li><b>広告の数</b>
</ul>
<br><br>
そのフォームの説明については、<a href="#forms"><u>ここをクリック</u></a>してください。
<hr>


<a name="member_activity"></a>
<h2>メンバーの活動
</h3>
ここでは、どの財務統計を計算したいかを指定できます。
メンバー活動統計は、メンバーの活動に対する洞察をあなたに与えます。
統計的分析も、異なるメンバーの集合に対して行えます，

以下の項目に関して統計を得られます:
<ul>
	<li><b><a href="#grossProduct"><u>総生産</u></a></b>
	<li><b>取引の数</b>
	<li><b>トレードしていないメンバーの%</b>
	<li><b>ログイン</b> あなたのメンバーがどのくらいの頻度でソフトウェアにログインしているかを示します。
</ul>
<br><br>
そのフォームの説明については、<a href="#forms"><u>ここをクリック</u></a>してください。
<hr>


<a name="finances"></a>
<h2>財務</h2>
ここでは、どの財務統計を計算したいかを指定できます。 財務統計は、任意のシステム口座のすべての流入と流出の正確な概観を与えます。以下の項目に関して統計を得られます:
<ul>
	<li><b>概観</b> 指定されたシステム口座へ出て行った支払いと、指定されたシステム口座へ入ってきた支払いの概観を与えます。収入と支出を棒グラフで比較できます。
	<li><b>収入</b> 指定した支払いフィルタに対して、収入がどのように分配されるかについての円グラフを与えます。
	<li><b>支出</b> 指定した支払いフィルタに対して、支出がどのように分配されるかについての円グラフを与えます。 
</ul>
<br><br>
そのフォームの説明については、<a href="#forms"><u>ここをクリック</u></a>してください。
<hr>


<a name="parameters"></a>
<h2>統計フォームのための共通のパラメータとフィールド</h2>
統計的結果を見られるようになる前に、何を見たいかを指定しなければなりません。一般的に、Cyclosは、統計的結果の計算と提示を始める前に、いくつかのことを知る必要があります。
<ul>
	<li>「<a href="#whattoshow"><u>何を表示するか</u></a>」: このドロップダウンは、そのフォームの一番上にあり、一番最初の項目です。ここでは、統計を表示するための方法を選択してください。<br>
	<li>「<a href="#periods"><u>期間</u></a>」: このボックスは、チェックボックスの下に表示されます。ここでは、結果を計算する期間を指定してください。すべてのデータが定期的なデータであるわけではありません。一部のデータは、期間について計算できません。そのような場合、その期間の最終日が使用されます。これは、常に、ヘルプファイル内で示されます。<br>
	<li>「<a href="#filters"><u>フィルタ</u></a>」: 期間ボックスの下には、フィルタボックスがあります。Cyclosには、メンバーとは何か、トレードとは何かについて、予め定義された概念がないので、フィルタによってこれを指定しなければなりません。 <br>
</ul>

<hr class="help">

<a name="whattoshow"></a>
<h3>「何を表示するか」ドロップダウン</h3>
このドロップダウンを使って、統計を表示する仕方を指定してください。 以下の4つの方法から選べます:
<ul>
	<li>「単一の期間」: これは、単一の<a href="#periods"><u>期間</u></a>についての概要を与えます。通常、いかなる統計分析も行われず、いかなるグラフを表示することもできません。 <br>
	<li>「複数の期間を比較する」: これは、2期間についての結果を比較します。それはバーグラフで表示できます。前の期に比べて、特定の結果が増大したか、減少したかを見たい場合は、これを選んでください。統計分析は、2期間の差違が<a href="#p"><u>統計的に有意</u></a>であるか否かを計算するために行われます。<br>
	<li>「通時的」: 同様ですが、時間範囲に対してです。<br>
	<li>「分布」: 通常、<a href="#histo"><u>ヒストグラム</u></a>、つまり、特定の結果が母集団に対してどのように分布しているかを示すグラフを与えます。 <br>
</ul>
あなたが選ぶ統計のカテゴリーに依っては、これらの項目のすべてが見えるわけではないかもしれません。
<hr class="help">


<a name="periods"></a>
<h3>期間</h3>
あなたは、統計が計算されなければならない期間を指定すべきです。 <br> 選択したアイテムに依って、1期間または2期間、あるいは、一定範囲の期間さえも指定できます。<br><br>「主な期間」は、統計が計算される期間です。これは「比較先の期間」と比較されるかもしれません。 <br> これら2期間の各々について、名称を入力しなければなりません。この名称は、表の列ヘッダーとグラフの凡例の中で使われます。<br> 「通時的」を選択すると、期間ボックスは少々異なって見えるようになります。この場合、まず、年、四半期、または月毎に並べられた結果を見たいかどうかを選択してください。その後、統計を計算する時間範囲を選択してください。<br> <br> 広すぎる範囲を選択しないように気をつけてください:10年間にわたって毎月の結果を見ることを選ぶと、混雑したグラフになるだけでなく、サーバーに非常に重い負荷をかけることにもなり、待ち時間が長くなります。<br> そのような場合は、多くていくつの「データ点」をリクエストするかもしれないか、ポップアップウィンドウによって知らされ、リクエストを制限するよう求められます。「データ点」とは、1つの別個の計算のことです。例: 5項目のチェックボックスと、13ヶ月の範囲を選択すると、この結果は5 x 13 = 65のデータ点になります。グラフチェックボックスは、この場合、数に入りません。それらは、たいてい、追加的な計算を必要としないからです。
<hr class="help">


<a name="filters"></a>
<h3>フィルタ</h3>
もちろんプログラムは、何人のメンバーがいるか、トレード量はいくつかを計算する前に、「メンバー」とは何であるか、「トレード」とは何であるかを知っていなければなりません。Cyclosは、多くのカスタムユーザーグループと取引タイプで機能するので、「メンバー」とは何か、「トレード」とは何かについての予め決められた概念を持っていません。それは「フィルタ」を使って、このウィンドウ内で指定しなければなりません。<br><br>どの項目を選ぶかによっては、すべてのフィルタ編集は見えないかもしれません。
以下のフィルタが見えるかもしれません:
<ul>
	<li><b>メンバーフィルタ: </b> このフィルタによって、どの<a href="${pagePrefix}groups#member_groups"><u>メンバーグループ</u></a>をメンバーと考えるかを指定します。複数のグループを指定しても良いでしょう。 少なくとも1つのグループを指定<b>しなければなりません</b>。<br> 結果ページでは、ここで選択したグループが「メンバー」として示されます。
	<br><br>
	<li><b><a href="${pagePrefix}account_management#payment_filters"><u>支払いフィルタ</u></a>:</b> このフィルタにより、どの取引タイプを結果に含めたいかを指定します。通常、これは、あなたが「トレード」であると考えるものです。<br> 支払いフィルタを1つだけ指定できますが、「<b>複数の</b>支払いフィルタ」ドロップダウンとの違いに留意してください。それは以下で説明されますが、そこでは複数のフィルタを定められます。あなたの目的に適合する利用可能なタイプがなければ、特にこの目的のための新しい支払いフィルタをいつでも作成できます。(以下を見てください。)<br> <br> <b>警告:</b><br> しばしば、支払いフィルタドロップダウンは、既に選択したグループフィルタに関連した支払いのみを含みます。支払いフィルタドロップダウンが空であるということもあり得ます:その場合、おそらく支払いが定義されていないグループが選択されています。この場合、統計を続けることができません。 これは2つの方法でのみ解決できます:別のグループを選択するか、このグループのための新しい支払いフィルタを作成してください。<br><br>統計のための新しい支払いフィルタを作成するには:
	<ol>
		<li>メインメニュー内、「口座 &gt; 口座の管理」に行ってください。
		<li>それから、「メンバー口座」の編集アイコンをクリックしてください。
		<li>表示されるページの一番下にある、「新しい支払いフィルタ」というタイトルのボタンに行ってください。
		<li>ここでは、新しい支払いフィルタの詳細を記入します(このページのヘルプも見てください)。論理名を与え、「レポート内に表示する」チェックボックスに忘れずにチェックをしてください。さもないと、それは統計ページ内に表示されません(「グループ可視性」では何も選択する必要がありません)。<br> 「取引タイプ」ドロップダウンで、このフィルタに含めたい移転を選択できます。<br>
		<li>その支払いフィルタは、統計のための選択ページ上で、支払いフィルタドロップダウン内に表示されるはずです。
	</ol>
	統計の結果ページでは、あなたが指定した支払いタイプは「トレード」として示されます。
	<br><br>
	<li><b>複数の支払いフィルタ:</b> (複数であることに留意してください。) これは前の項目と全く同じですが、ここでのみ、複数のフィルタを選択できます。複数の支払いフィルタを選択すると、選択された支払いフィルタについての結果が表示され比較されます。支払いフィルタを1つしか選択しないと、このフィルタはそれが含む移転タイプへと分割され、各々の 移転タイプについての結果が表示されます。<br> <b>警告:</b> ここで複数の支払いフィルタを選択した場合、すべての選択された項目が別個であり、重複しないことが重要です。各支払いフィルタは、いくつかの移転タイプを含むかもしれないので、いくつかの支払いフィルタが共通の移転タイプを持つことがあり得ます。これが当てはまる場合、円グラフのようなグラフを作成することは不可能でしょう。円グラフでは、すべてのセクションを足して100%になる必要があるからです。この理由のため、プログラムは支払いフィルタが重複していないかどうか確認します。
	<br><br>
	<li><b>仲介人フィルタ: </b> このフィルタにより、あなたはどのユーザーグループを<a href="${pagePrefix}brokering"><u>仲介人</u></a>であると考えるかを指定できます。メンバーフィルタと同様に、複数のグループを指定できますが、少なくとも1つを指定<b>しなければなりません</b>。結果ページでは、これらのグループは「仲介人」として示されます。
</ul>
<br>
Cyclosプログラムは、通常、関連するフィルタのみを表示しますが、特定の組み合わせのフィルタが意味をなさないこともあるかもしれません。たとえば、互いに合致しないグループフィルタと支払いフィルタ(たとえば、グループ「メンバー」と支払い「システムからコミュニティへ」)を選択すると、
当然、奇妙な結果が予期されます。<br><br>あらゆるタイプの統計について、すべてのフィルタが使われるわけではありません。 通常、結果ページにおいて、各々の表またはグラフは、結果の計算のためにどのフィルタが厳密に<a href="#filtersUsed"><u>使われた</u></a>かを示します。
<hr>


<a name="results"></a>
<h2>統計結果</h2>
Cyclos内で統計結果を表示する際に使われる慣習がいくつかあります。
この概観は、それらの慣習について説明します:
<ul>
	<li><a href="#tables"><u>表</u></a>は、統計を提示する標準的な形です。表についての一般的な説明に行くには、リンクをクリックしてください。
	<li><a href="#graphs"><u>グラフ</u></a>は、グラフチェックボックスを選択した場合にのみ表示されます。グラフについての一般的な説明に行くには、リンクをクリックしてください。
	<li><a href="#tests"><u>統計的検定</u></a>は、理にかなっており可能なところではどこでも行われます。
	<li>統計の計算に関する<a href="#calculation"><u>一般的な慣習</u></a>は、ここで見つけられます。
	<li><a href="#numbers"><u>数の提示と厳密さ</u></a>:
	一般的に、3という結果の意味は、3.00という結果の意味とはいくぶん異なります。 数の厳密さと提示に関するCyclos内で使われる慣習の説明に行くには、リンクをクリックしてください。
	<li>利用可能な<a href="#nodata"><u>データが少なすぎる</u></a>場合のCyclosの振る舞い方。
</ul>

<hr class="help">


<a name="tables"></a>
<h3>統計内の表</h3>
Cyclos統計内でデータを提示する標準的な方法は、表によるものです。 たいていの表(すべてではありません)は、以下の形をとります:
<ul>
	<li><b>1番目の列:</b> 前のページで定めたように主要な<a href="#periods"><u>期間</u></a>です。
	<li><b>2番目の列:</b> 前のページでこれを定めたならば、それを比較する先の<a href="#periods"><u>期間</u></a>です。
	<li><b>3番目の列:</b> 第2期間から主要期間への相対的成長(%)です。
	<li><b>4番目の列:</b> 数値群がどのくらい異なるかを検定する統計的検定の<a href="#p"><u>p値</u></a>です。この列は常には表示されません。
</ul>
以上は、通常、「期間の比較」について当てはまります。別の方法を選んだ場合、表は異なって見えるかもしれません。<br> グラフを指定しなかった場合は、その表の下に短い<a href="#filtersUsed"><u>表</u></a>が表示され、この結果のために指定した<a href="#filters"><u>フィルタ</u></a>を表示します。さもなければ、この情報は、<a href="#graphs"><u>グラフ</u></a>の下に表示されます。
<hr class="help">


<a name="graphs"></a>
<h3>統計内のグラフ</h3>
通常、グラフは、そのすぐ上の表にあるものと同一のデータを表示します。
しかしながら、二次的データ(他の列から得られたデータ)のいくつかの列は、その表の中には表示されないかもしれません。たとえば、2つの<a href="#periods"><u>期間</u></a>の間の成長パーセンテージや、<a href="#p"><u>p値</u></a>です。そのデータ自体の説明については、対応する表(グラフウィンドウの上のウィンドウ)のヘルプアイコンをクリックしてください。このセクションは、グラフ内で使われている一般的な慣習についてのみ説明します。<br><br>マウスをグラフ内のバーの上に重ねると、対応するデータの数値があなたのマウスポインタの所に表示されます。<br> グラフの下に短い<a href="#filtersUsed"><u>表</u></a>が表示され、この結果のために指定した<a href="#filters"><u>フィルタ</u></a>を表示します。します。
<hr class="help">


<a name="filtersUsed"></a>
<h3>使用されるフィルタ</h3>
グラフまたは表の下には、追加された表があり、この結果のために指定した<a href="#filters"><u>フィルタ</u></a>を示します。これらの計算を行うために、Cyclosは、そのグラフの中にどの種類のメンバーが含まれるべきかを知る必要があります。これは<a href="${pagePrefix}groups#group_filters"><u>グループ</u></a>フィルタです。Cyclosは、あなたが何を「トレード」と考えるかも知るべきです。これは「支払いフィルタ」によって指定されます。また、他の種類のフィルタも使用されているかもしれません。 <br> あるフィルタが計算のために使用されなかったならば、「使用されていない」が表示されます。そのフィルタが使用されたが、どの特定のグループまたは支払いも指定しなかったならば、すべてのメンバーまたは支払いが含まれます。関連するファイルのみが、この表の中に表示されます。
<hr class="help">


<a name="calculation"></a>
<h3>計算のされ方</h3>
一般的に、結果は、指定された<i><a href="#periods"><u>期間</u></a>に関して</i>計算されます。これは、たとえば、その期間内のある時点にメンバーであった任意のメンバーが含まれることを意味します。稀な場合には、その結果は、その期間の最終日の状態についてのものにすぎません。これは、常に特定のヘルプにおいて述べられます。「部分的なメンバー」については、全く補正がないということに留意してください。例:その期間内の任意のメンバーの総生産は、このメンバーがその期間内の1日だけメンバーであったかもしれないということについて全く補正されずに数えられます。<br> ほとんど常に、結果内では<a href="#median"><u>中央値</u></a>が使われ、平均値ではありません。
<hr class="help">


<a name="numbers"></a>
<h3>数の提示と厳密さ</h3>
数は、一般的に、可能であれば、その周囲の一定範囲とともに提示されます。 この範囲は、平均値または<a href="#median"><u>中央値</u></a>の周囲の95%-<a href="#range"><u>信頼区間</u></a>です。表の中では、これらの数字は、3つの異なる形で提示されるかもしれません:
<ul>
	<li><b>12.0</b> データが少なすぎたか、その数字が数字の集合に基づいていなかったため、信頼区間を作成できなかったことを意味します。
	<li><b>12.0&nbsp;&plusmn;&nbsp;3.4</b> その信頼区間が対称的であることを意味します。12.0 - 3.4はその信頼区間の下限であり、12.0 + 3.4は上限です。
	<li><b>12.0 (9.7 - 19.2)</b> その信頼区間が非対称的であり、<a href="#distribution"><u>分布が歪んでいる</u></a>ことを意味します。括弧の間の数字は、その信頼区間の下限と上限です。
	<li><b>-</b>&nbsp; その数字は計算できなかったということを意味します。おそらく、それは信頼できる計算を可能にするために十分なデータが利用可能でないためです。
</ul>
グラフでは、信頼区間は、データ点の周囲のエラーバーによって示されます。
<hr class="help">


<a name="nodata"></a>
<h3>少なすぎるデータ</h3>
統計分析は、観測値の集合が、グラフ内の1つの数字または点によって結び付けられ提示されるという原理に基づいています。しかし、この観測値の集合が非常に小さかったらどうでしょうか。<br> 理論上、統計的検定は、データ点における3つ以上の観測値で行うことができます。しかしながら、これは、依然として、データ点を非常に信頼できないものにします。 つまり、観測値の数が多ければ多いほど(n)、平均値、中央値、または範囲の信頼性は良くなります。<br> Cyclosでは、15未満の観測値の統計的結果を表示しません。私たちは、その点を超えないと、統計分析は信頼できないと考えるからです。
<hr>

<h2>重要な発展の結果</h2>

<br><br>

<a name="reportsStatsKeydevelopmentsNumberOfMembers"></a>
<h3>メンバーの数についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表の中には、以下の行が表示されます:
<ul>
	<li><b>メンバー</b>: 前のページで設定したメンバー<a href="#filters"><u>フィルタ</u></a>に従ったメンバーの数。それは指定した<a href="#periods"><u>期間</u></a>中にメンバーであった任意のメンバーを、たとえ、その指定された期間中にメンバー登録から削除されているか、新しいメンバーになっているとしても数えます。
	<li><b>新しいメンバー</b>: その指定された期間中に特定のメンバーグループに移動された任意のメンバー。
	<li><b>消えたメンバー</b>: 指定されたメンバーグループから、そのグループフィルタ内にないグループへと(その期間中に)移動された任意のメンバー。
</ul>
<hr class="help">


<a name="reportsStatsKeydevelopmentsGrossProduct"></a>
<h3>総生産についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>単一の行は、あなたが指定した<a href="#filters"><u>フィルタ</u></a>についての <a href="#grossProduct"><u>総生産</u></a>を表示します。
<hr class="help">


<a name="reportsStatsKeydevelopmentsNumberOfTransactions"></a>
<h3>取引数についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>単一の行は、あなたが指定した<a href="#filters"><u>フィルタ</u></a>に従った <a href="#numberOfTransactions"><u>取引の数</u></a>を表示します。
<hr class="help">


<a name="reportsStatsKeydevelopmentsAverageAmountPerTransaction"></a>
<h3>中央値の取引額についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>単一の行は、指定した<a href="#filters"><u>フィルタ</u></a>に従った取引ごとの<a href="#median"><u>中央値の</u></a>額を表示します。
<hr class="help">


<a name="reportsStatsKeydevelopmentsHighestAmountPerTransaction"></a>
<h3>最大の取引額についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>単一の行は、指定した<a href="#filters"><u>フィルタ</u></a>に従った取引ごとの最大額を表示します。
<hr class="help">


<a name="reportsStatsKeydevelopmentsNumberOfAds"></a>
<h3>広告数についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>以下の行が表示されます:
<ul>
	<li><b>アクティブな広告</b>: 期限切れでなく、スケジュール済みでもないが、その<a href="#periods"><u>期間</u></a>の終わりにアクティブな広告の数。
	<li><b>スケジュール済みの広告</b>: その期間の終わりにおける将来の広告(スケジュール済み)の数。
	<li><b>期限切れの広告</b>: その期間の終わりにもはや有効でない(期限切れの)広告の数。
	<li><b>作成された広告</b>: その期間に新たに作成された広告の数。
</ul>
<br><br>最初の3つの項目は、<i>その期間の終わりにおける</i>ものである一方で、最後の項目は、<i>その期間全体にわたっての</i>ものであることに留意してください。
<hr class="help">


<a name="reportsStatsKeydevelopmentsThroughTimeMonths"></a>

<a name="reportsStatsKeydevelopmentsThroughTimeQuarters"></a>

<a name="reportsStatsKeydevelopmentsThroughTimeYears"></a>
<h3>「通時的」についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>「通時的」を選択すると、選択した時間範囲に関して、選択された項目の歴史的概観が表示されます。<br> その項目は「期間を比較する」の下にあるものと同じです。<br> 要約すると:
<ul>
	<li><b>メンバーの数</b>: 各<a href="#periods"><u>期間</u></a>にわたってのメンバーの数。
	<li><b>総生産</b>: 各期間にわたって。
	<li><b>取引の数</b>: 各期間にわたって。
	<li><b>取引額</b>: 各期間にわたっての平均取引額。
	<li><b>広告の数</b>: 各期間の最終日のアクティブな広告の数。
</ul>
そこでは、期間は数ヶ月、数四半期、数年です。 そして、もちろん、すべてがあなたが指定した<a href="#filters"><u>フィルタ</u></a>に従っています。
<hr>

<h2>メンバー活動結果</h2>

<br><br>

<a name="reportsStatsActivitySinglePeriodGrossProduct"></a> <a
	name="reportsStatsActivityComparePeriodsGrossProduct"></a>
<h3>メンバーごとの総生産についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、メンバー毎の<a href="#median"><u>中央値</u></a>と<a href="#grossProduct"><u>総生産</u></a>を2行で表示します:
<ul>
	<li>「収入のあるメンバーごと」: リクエストされた<a href="#periods"><u>期間</u></a>内に何らかの入ってきた取引があったメンバーのみが含まれます。
	<li><i>すべてのメンバーに関して</i>: すべてのメンバーが含まれます。 過半数のメンバーが収入を持たない場合、<a href="#median"><u>中央値</u></a>の性質のために、この値はゼロ(0)になります。
</ul>
もちろん、すべてがあなたが指定した<a href="#filters"><u>フィルタ</u></a>に従っています。<br><br>「期間を比較する」について、列は2つのリクエストした期間についての結果を表示し、それから、その結果が基づくメンバー数が書かれた2つの列を表示し、その後に、それら2期間の間に実現された成長と、2つの結果が異ならないという検定のための<a href="#p"><u>p値</u></a>が続きます。<br> 「1期間」については、結果とメンバー数のみが表示されます。<br>
<hr class="help">


<a name="reportsStatsActivitySinglePeriodNumberTransactions"></a> <a

	name="reportsStatsActivityComparePeriodsNumberTransactions"></a>
<h3>メンバーごとの取引数についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、2行でメンバーごとの<a href="#median"><u>中央値</u></a>の<a href="#numberOfTransactions"><u>取引数</u></a>を表示します:<br>
<ul>
	<li>「トレードしているメンバー」: リクエストされた<a href="#periods"><u>期間</u></a>内でトレードしたメンバーのみが含まれます。入ってきた移転か出て行った移転の両方がトレードとして数えられます。
	<li>「すべてのメンバーにわたって」: すべてのメンバーが含まれます。 過半数のメンバーがトレードしていない場合、<a href="#median"><u>中央値</u></a>の性質のため、この値はゼロ(0)になるでしょう。
</ul>
もちろん、すべてがあなたが指定した<a href="#filters"><u>フィルタ</u></a>に従っています。<br><br>「期間を比較する」について、列は2つのリクエストした期間についての結果を表示し、それから、その結果が基づくメンバー数が書かれた2つの列を表示し、その後に、それら2期間の間に実現された成長と、2つの結果が異ならないという検定のための<a href="#p"><u>p値</u></a>が続きます。<br> 「1期間」については、結果とメンバー数のみが表示されます。<br>
<hr class="help">


<a name="reportsStatsActivitySinglePeriodPercentageNoTrade"></a>

<a name="reportsStatsActivityComparePeriodsPercentageNoTrade"></a>
<h3>トレードしていないメンバーのパーセンテージについての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>1つの行のみが表示され、リクエストした<a href="#periods"><u>期間</u></a>中に全くトレードしなかった(つまり、いかなる金額も支払いまたは受け取りしなかった)メンバーのパーセンテージを示します。いつものように、「メンバー」と「トレード」は、選択した<a href="#filters"><u>フィルタ</u></a>に従って定義されています。<br><br>「期間を比較する」については、列は2つのリクエストされた期間についての結果と、それら2期間の間で実現された成長、2つの結果が異ならないという検定のための<a href="#p"><u>p値</u></a>を表示します。
<hr class="help">


<a name="reportsStatsActivitySinglePeriodLoginTimes"></a>

<a name="reportsStatsActivityComparePeriodsLoginTimes"></a>
<h3>メンバーごとの1期間のログイン回数についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>1つの行のみが表示され、メンバーごとのその<a href="#periods"><u>期間</u></a>にわたってのログイン回数を示します。「メンバー」は、もちろん、指定したグループ<a href="#filters"><u>フィルタ</u></a>に従っています。メンバーは、その指定された期間内の任意の時点にメンバーであった場合に数えられます。<br><br>「期間を比較する」については、列は、2つのリクエストされた期間についての結果、それら2期間の間で実現されたグラフ、2つの結果が異ならないという検定のための<a href="#p">p値</a>を表示します。
<hr class="help">


<a name="reportsStatsActivityThroughTimeGrossProduct"></a>
<h3>通時的なメンバーごとの総生産についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、指定した時間範囲内の各点について、メンバーごとの<a href="#median"><u>中央値</u></a>の<a href="#grossProduct"><u>総生産</u></a>の概観を与えます。それは2つのタイプのメンバーについてこれを行います:
<ul>
	<li>「収入あり」: これは、指定された月、四半期、年内に収入のあったメンバーについての総生産です。
	<li>「すべて」: これは、指定された月、四半期、年内にいたすべてのメンバーを含みます。
</ul>
両方のグループについて、その総生産が基づくメンバー数が、最後の2行で与えられます。<br> 当然、グラフまたは表内の各点について時間範囲が短ければ短いほど、その結果は低くなるということに留意してください。
<hr class="help">


<a name="reportsStatsActivityThroughTimeNumberTransactions"></a>
<h3>通時的なメンバーごとの取引数についての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>入ってきた取引と出ていった取引は、この表は、指定された時間範囲にわたって、メンバーごとの<a href="#median"><u>中央値</u></a>の<a href="#numberOfTransactions"><u>取引数</u></a>を表示します。そこでは、入ってきた取引と出ていった取引が数えられます。<br> それは、2つのタイプのメンバーについてこれを行います:
<ul>
	<li>「トレード」: これは、指定された月、四半期、年内にトレードを行ったメンバーについての取引数を与えます(トレードは、任意の金額を受け取りまたは支払いしたということを意味します)。
	<li>「すべて」: これは、指定された月、四半期、年内にいたすべてのメンバーを含みます。
</ul>
両方のグループについて、その総生産が基づくメンバー数が、最後の2行で与えられます。<br> 当然、グラフまたは表内の各点について時間範囲が短ければ短いほど、その結果は低くなるということに留意してください。
<hr class="help">


<a name="reportsStatsActivityThroughTimePercentageNoTrade"></a>
<h3>通時的な、トレードしていないメンバーのパーセンテージについての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、あなたが指定した時間範囲にわたって、<a href="#periods"><u>期間</u></a>中にトレードしていないメンバーのパーセンテージの概観を与えます。<br><br>あるメンバーは、指定された月、四半期、年内において、いかなる取引(支払いまたは受け取り、あなたが指定した支払い<a href="#filters"><u>フィルタ</u></a>に従います)を行わなかった場合に、「トレードしていない」と見なされます。もちろん、各グラフ点について時間範囲が短ければ短いほど、非トレーダーのパーセンテージは高くなります。月ごとに与えられる結果のグラフにおいて、非トレーダーのパーセンテージは、当然、年ごとに与えられる結果のグラフにおいてよりも高くなります。<br> 表内における最後の列は、各結果値が基づいているメンバー数を与えます。
<hr class="help">


<a name="reportsStatsActivityThroughTimeLoginTimes"></a>
<h3>通時的なメンバーごとのログインについての表</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、指定した時間範囲にわたって、あるメンバーがシステムにログインした回数の<a href="#median"><u>中央値</u></a>の歴史的概観を与えます。各々の月、四半期、年内のログイン回数だけでなく、最後の列では、この計算が基づいているメンバー数も与えられます。<br> 当然、各グラフ点についての時間範囲が短ければ短いほど、メンバーごとのログイン回数は低くなります。
<hr class="help">


<a name="reportsStatsActivityHistogramGrossProduct"></a>
<h3>メンバーごとの総生産についてのヒストグラム</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>このグラフは、指定した<a href="#filters"><u>フィルタ</u></a>に従って、主な期間についてメンバーごとの<a href="#grossProduct"><u>総生産</u></a>の<a href="#histo"><u>ヒストグラム</u></a>を与えます。
<hr class="help">


<a name="reportsStatsActivityHistogramNumberTransactions"></a>
<h3>メンバーごとの取引数についてのヒストグラム</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>このグラフは、指定した<a href="#filters"><u>フィルタ</u></a>に従って、主な<a href="#periods"><u>期間</u></a>について、メンバーごとの<a href="#numberOfTransactions"><u>取引数</u></a>の<a href="#histo"><u>ヒストグラム</u></a>を与えます。
<hr class="help">


<a name="reportsStatsActivityHistogramLogins"></a>
<h3>メンバーごとのログイン回数についてのヒストグラム</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>このグラフは、あなたが定義したグループ<a href="#filters"><u>フィルタ</u></a>に従って、主な<a href="#periods"><u>期間</u></a>について、メンバーごとのログイン回数の<a href="#histo"><u>ヒストグラム</u></a>を与えます。
<hr class="help">


<a name="reportsStatsActivityToptenGrossProduct"></a>
<h3>総生産による上位10名の最も活発なメンバー</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、指定された主な<a href="#periods"><u>期間</u></a>中で最も<a href="#grossProduct"><u>総生産</u></a>が高い10名のメンバーを与えます。
<hr class="help">


<a name="reportsStatsActivityToptenNumberTransactions"></a>
<h3>取引数による上位10名の最も活発なメンバー</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、指定された主な<a href="#periods"><u>期間</u></a>中で、最も<a href="#numberOfTransactions"><u>取引数</u></a>が多い10名のメンバーを与えます。
<hr class="help">


<a name="reportsStatsActivityToptenLogin"></a>
<h3>ログイン回数による上位10名の最も活発なメンバー</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、指定された主な<a href="#periods"><u>期間</u></a>中で、最もログイン回数が多い10名のメンバーを与えます。
<hr class="help">
<br><br>


<a name="reportsStatsFinancesSinglePeriodOverview"></a>
<h3>1期間の財務概観</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、指定されたシステム口座について、入ってきた支払いと出ていった支払いの概観を与えます。最終的な列は、収入と支出の差違を与えます。<br><br>指定した支払い<a href="#filters"><u>フィルタ</u></a>は、表内に表示されます。指定しなかったもののこの口座に関係する支払いフィルタは、集められ「その他」として要約されます。この「その他」カテゴリーは、グラフ内には表示されません。なぜならば、もしこれが大きな数字であるとすると、それは残りの全体像を覆してしまうからです。<br><br>1つの支払いフィルタしか選択しなかった場合、このフィルタはそれが含む移転タイプへと分割され、その移転タイプが表内に表示されます。そうでない場合、支払いフィルタが表示されます。<br> グラフも表示される場合、そのグラフの下に選択されたフィルタが表示され、そうでない場合、これらは表の下に表示されます。
<hr class="help">

<a name="reportsStatsFinancesSinglePeriodIncome"></a>

<a name="reportsStatsFinancesSinglePeriodExpenditure"></a>
<h3>1期間にわたっての収入または支出</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表またはグラフは、システム口座について、収入(収入を選択した場合)または支出(支出を選択した場合)の概観を与えます。<br> その表は、列内に2つの指定された<a href="#periods"><u>期間</u></a>を与え、そこでは第3の列は期間IIから期間Iへの成長を示します。<br> その表の行は、あなたが指定した支払い<a href="#filters"><u>フィルタ</u></a>を与えます。<br><br>概観を維持するために、私たちは、この表/グラフを生成する際に、あまりにも多くの支払いフィルタを選択しないよう忠告します。<br>
<hr class="help">


<a name="reportsStatsFinancesThroughTimeIncome"></a>

<a name="reportsStatsFinancesThroughTimeExpenditure"></a>
<h3>通時的な収入または支出</h3>
Cyclos統計内の一般的な慣習については、
<a href="#results"><u>結果に関する一般的なセクション</u></a>を見てください。<br><br>この表は、通時的な収入(または支出)カテゴリーの概観を与えます。支出がどのくらい確実に発展するかに関心がある場合には、これらを見たいかもしれません。<br> 各々のリクエストされた支払いフィルタは、表内にその列を持ち、グラフ内にその系統を持ちます。私たちは、このグラフ内であまりにも多くの系統(支払いフィルタ)をリクエストしないよう忠告します。なぜなら、グラフは容易に過密になるからです。
<hr>


<br><br><a name="glossary"></a>
<h2>用語集</h2>
<br><br>


<a name="range"></a><b>信頼区間</b> <br><br>信頼区間は、データの正確さの表示です。それは見つかった数字がこれらの範囲内にある可能性が95％であることを意味します。しばしば、データの正確さを示すために、平均値の標準偏差または標準誤差が使われます。私たちはこれらを使いません。なぜなら、私たちは、95%信頼区間の方がはるかに直観的であり、(いくぶん抽象的な標準偏差とは違って)現実世界において意味を持つと信じているからです。<br><br>信頼区間は、たいてい、根底にあるデータの何らかの<a href="#distribution"><u>分布</u></a>の想定に基づいて計算されます。 私たちは正規分布を想定することができないたいていの場合においてそうであるように、信頼区間を計算するために、中央値の周囲の順位和の二項分布を使います。これは、絶対値が直接には使われるわけではなく、低いものから高いものへと並べられ、信頼区間を計算するためにこれらの順位数が使われるということを意味します。これは時には非対称的な信頼区間になるかもしれません。
<hr class='help'>


<a name="distribution"></a> <b>分布と歪み</b> <br><br>統計において、結果は、平均値または<a href="#median"><u>中央値</u></a>を計算した元の観測値の集合に基づいています。これらの単一の観測値をすべて集めると、一定のパターンに従い、それは数の分布と呼ばれます。最も自然かつしばしば見いだされる分布は、正規分布です。そこでは、中央の値は最も豊富であり、外れ値は、それらの中央の値からの距離が遠くなればなるほど少なくなります。正規分布は、完全に対称的です。 <br> たいていの統計的手法は、正規分布の想定に基づいています。しかしながら、日常生活は、しばしば、それほど完全ではありません。経験から学ばれるのは、たいていのCyclosデータベースのデータは、全く正規分布ではないということです。Cyclosデータは、しばしば、非対称的な分布で、歪められているように見えます。一例を挙げると: これは、中央値の総生産よりも高い数値を持っているメンバーは、中央値の総生産よりも低い数値を持っているメンバーよりも、しばしば、中央値からさらに遠くにいるということを意味するかもしれません。<br> 何かの分布を示すために、私たちは、「<a href="#histo"><u>ヒストグラム</u></a>」を使います。<br>
<hr class='help'>


<a name="grossProduct"></a> <b>総生産</b> <br><br>これは、ある<a href="#periods"><u>期間</u></a>にわたっての、すべての<b>入ってきた</b>取引額の合計です。したがって、ある期間にわたって得られたすべてのユニットです。
<hr class='help'>


<a name="histo"></a> <b>ヒストグラム</b> <br><br>ヒストグラムは、観測値が母集団上にどのように広がっているかを示すグラフです。グラフ内の水平方向(x軸上)には、あなたが関心のあるパラメータがあります(たとえば、各メンバーの総生産)。これは、論理的なグループ、たとえば、月あたり0から100ユニットまで、月あたり100から200ユニットまでの範囲の総生産などへと分割されます。垂直方向、y軸上には、各々のx軸グループ内に数えられる観測値の数があります。したがって、私たちの例では: 0から100ユニットグループ内に5メンバー、月あたり100から200ユニットのグループ内に20メンバーなど。<br> これから帰結するグラフは、諸メンバーにわたる個人的な総生産の<a href="#distribution"><u><u>分布</u></u></a>を表示します。<br> ヒストグラム内で、2つのバーの間の境界線上にちょうど位置する観測値は、最も高いカテゴリー値のバーに属するものとして数えられるということに留意してください。<br><br><b>注:</b> プログラムは、x軸の望ましい「階級」への最適な分割を自動的に計算します。根底にあるデータの非常に奇妙な分布(たとえば、全く何もしていないメンバーが圧倒的多数いる)の場合、x軸に沿った階級の分割は視覚的に最適に見えないかもしれません。
<hr class='help'>


<a name="median"></a> <b>中央値</b> <br><br>通常、観測値の集合に基づく数字の値を示すには、平均値が使われるでしょう。しかしながら、中央値は、極端な外れ値に非常に敏感です。つまり、もし、1人のメンバーが残りのメンバーより20倍も多い活動をしていれば、この1人のメンバーが中央値に非常に大きな影響を与えます。たとえ、このメンバーが全く代表的でないとしてもそうです。これを克服する1つの解決策は、平均値の代わりに中央値を使うことです。中央値は<a href="#distribution"><u>分布</u></a>の中央です。つまり、すべての観測値の50%は中央値未満で、すべての観測値の50%は中央値よりも大きいです。中央値は、外れ値に対して敏感ではありません。<br> Cyclosは、しばしば極端な外れ値または歪んだ分布のあるデータを扱うので、Cyclosの統計の至る所では、別様に断りがない限り中央値が使われます。そのような場合における中央値の使用は、統計の世界における一般的な標準です。<br><br>整数(=自然数)の集合から中央値を計算する場合、平衡化または公平さの補正を使います。集合{0,1,2,2,3,3,3,3,4}と{2,3,3,3,3,4,5,6,7}に属する中央値は、両方3です。もっとも、最初のリストでは最初の3が取られ、2番目のリストでは最後の3が取られています。これは「公平」でないと思われるので、値3を持つすべての要素が、2.5から3.5の範囲にわたって一様に広げられます。そして、それから、内挿によって、この範囲からその値が取り出されます。これは、もちろん、端数のリストでは意味をなさないので、このアプローチは整数の場合にのみ使われます。<br><br>平均値の代わりに中央値を使うと、少々の<b>影響</b>があります:
<ul>
	<li>特に、少ない観測値に基づく中央値の場合、結果は切りのよい数になるかもしれません。 <br>
	<li>範囲は順位数に基づいて計算されるので、中央値の周囲に与えられた範囲は、しばしば、非対称的かもしれません。しかし、これは、根底にある分布も対称的でないという事実を考えると、当然のように思われます。<br>
	<li>多くのゼロ(50%よりも多い)がある根底にある分布の場合、中央値も当然0になります。 <br>
</ul>
<hr class='help'>


<a name="membersNotTrading"></a> <b>トレードしていないメンバー</b> <br><br>これらは取引が0であるメンバーです。したがって、入ってくる取引が全くなく、出ていく取引も全くありません。
<hr class='help'>


<a name="N"></a> <b>n</b> <br><br>数の集合内の項目の数。
<hr class='help'>


<a name="numberOfTransactions"></a> <b>取引の数</b> <br><br><a href="#grossProduct"><u>総生産</u></a>とは対照的に、誰かの取引の合計、入ってきた取引と出ていった取引の両方が数えられます。
<hr class='help'>

<b>P値</b> <br><br>2つ以上の<a href="#periods"><u>期間</u></a>を比較する場合、可能な時にはいつも統計的検定が行われます。これらの検定のいずれでも、その目標は、2つの値がどのくらい異なっているかを計算することです。<br>
その検定の結果は、1つの数字「p値」によって提示されます。この値は、2つの平均値(または中央値)が同一の母集団からのものであるという可能性を示します。平易に言うと: それは数字が本当に同一である可能性です。
p値が小さければ小さいほど、2つの数字は異なっています。 <br> 慣習によって、私たちは、pが5%未満ならば、数字が本当に異なっていると言います。これは「統計的に有意な差違」と呼ばれます。 平易に言うと:平易に言うと: 「p &lt; 0.05ならば、私たちは、数字が本当に異なっていると言います。pがもっと大きければ、私たちは、それらの数字が異なっているか否について確信できませんが、確実を期すためにそれらが全く異なっていないと想定します。」<br> 5%未満の任意のp値は、<b>太字</b>で印字されます。<br> <br>
<hr class='help'>


<a name="tests"></a><b>統計的検定</b> <br><br>統計的検定は、たいてい、2つ(以上)の結果が本当に異なるか否かを知りたい場合に行われます。 たとえば、昨年の活動に比べて、今年におけるメンバーの活動が増加したかどうかを知りたい場合です。5%の差違は本当に異なっているのでしょうか。 そして、10%の差違は？
20%? 私たちはどこから差違を本当の差違と呼び始め、どこまでそれを単なる偶然の一致であると考えるでしょうか。<br> 統計的検定は、差違が<b>本当の</b>差違であるかどうか、あるいは、気付かれた「差違」が通常の範囲の変動と偶然の一致の中にちょうど収まり、したがって、本当に異なると見なされるべきではないかどうかを教えます。これは、根底にある<a href="#distribution"><u>分布</u></a>、標本の大きさ、母集団内の変動に依存します。<br> 検定のタイプは、たいてい、ヘルプファイル内で言及されます。Cyclos内で一般的に使用される検定は、ウィルコクソンの順位和検定と、2つの標本比率についての二項検定です。これらの検定は、いかなる根底にある分布も想定しません。たいていの場合、正規分布を想定することができないからです。<br> 統計的検定の結果は、<a href="#p"><u>p値</u></a>として表現されます。<br>

</div> <%--  page-break end --%>