<div style="page-break-after: always;">
<span class="admin broker">
<p class="head_description">账户管理功能可以处理所有与账户和交易有关的配置。</p>

<i>在哪里可以找到它？</i><br>
账户管理可通过 &quot;菜单：账户 ＞ 管理账户&quot; 进入。
<hr>

<A NAME="currencies"></A>
<p class="sub_description">
<h2>货币</h2>
可以增加一种新的货币及联系使用它的账户。每一个账户组别可以设定默认的货币。
</p>
<i>在哪里可以找到它？</i><br>
货币可以通过 &quot;菜单：账户 ＞管理货币&quot; 进入。
<hr class="help">

<A NAME="currency_search"></A>
<h3>货币</h3>
货币列表页显示系统内的配置货币。货币可以绑定到一种账户类型。要増加一种新的货币，请按右下角的 &quot;新増货币&quot;。<br>
若要删除或修改货币，则必须点击在列表中的图标。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">
	单击该图标以修改货币。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">
	单击该图标以删除货币。
</ul>
<hr class="help">

<A NAME="currency_details"></A>
<h3>修改货币/新增货币</h3>
在编辑货币页，您可以设定货币的定义。以下字段可供使用：
<ul>
	<li><b>名称：</b> 内部名称（不显示在任何地方）
	<li><b>符号：</b> 将显示在网页上。例如显示在广告价格字段货币的后面
	<li><b>模式：</b> 在这里，您可以设定货币名称 / 符号及在那里显现，您可以把它显示在金额的前面或后面。一些货币（如美元）会显示符号在金额前面，而其它则在后面。
	货币模式将出现在列表和讯息。<br>
	浏览器并不总是支援符号的，欧洲货币符号便是一个很好的例子，在这种情况下您可能需要使用UTF统一代码符号（如：€）
	<li><b>描述：</b> 供内部参考（不显示在任何地方）
</ul>
<hr class="help">
</span>

<hr>

<span class="admin broker">
<a name="accounts"></a>
<p class="sub_description">
<h2>账户</h2>
联环系统的账户可以是 &quot;系统&quot; 或
&quot;会员&quot; 类型，这两种类型都联系一种货币，并可以包含单位，可从其他账户转入和转出（如果在这些账户之间存在交易类型）。<br>
相对于会员账户，系统账户没有相关的拥有者。
有权限的管理员可以从这些系统付款至其他系统账户或会员账户。<br>
会员可以拥有零个、一个或多个有关的会员账户，并可在自己的账户之间付款，付款给其他会员账户或系统账户。
</p>
如果新增了一个 &quot;会员&quot; 类型账户，它是没有任何相关会员的。您必须采取以下步骤，让会员实际使用这账户类型：
<ol>
	<li><b>给账户配置组别：</b> 只当账户配置到一个会员组别后，该组别的会员才可以访问这账户。
这可以通过<a href="${pagePrefix}groups#manage_groups"><u>组别设置</u></a>做到。
	<li><b>交易类型：</b> 在会员能够从该账户付款或收款之前，您需要建立和联系&quot;<a href="#transaction_types"><u>交易类型</u></a>&quot;。
	这是可以在交易类型的视窗做到，它与设置账户类型属性的视窗位于同一页上。
	<li><b>权限：</b> 当然，您还需要设置<a
		href="${pagePrefix}groups#manage_groups"><u>权限</u></a>。
</ol>
除了交易类型，还有很多事情是直接关系到账户的，例如贷款、交易费用、账户费用和付款筛选器。
<p>联环系统附有一套数据库，具有适用于大多数用户/系统的<a href="#standard_accounts"><u>标准账户</u></a>。
<p>
<i>在哪里可以找到它？</i><br>
账户的管理（新增，删除等）可通过&quot;菜单：账户 ＞ 账户管理&quot;做到。<br>
系统账户可在 &quot;菜单：账户 ＞ 系统账户&quot;查看。
<hr>

<a name="standard_accounts"></a>
<h3>标准账户类型</h3>
虽然有可能从零开始创建出一个全新的账户结构，我们提供了一个数据库，具有适用于大多数互补性货币体系的标准默认值。
该默认的数据库可以延伸至多个账户和转账类型。
<br><br>
我们建立了一个会员账户和各种不同的系统账户。
<a href="#account_fees"><u>账户费用</u></a>（自动、手动和流通税= &quot;滞期费&quot;）和<a
	href="#transaction_fees"><u>交易费用</u></a>在默认情况下是禁用的，但很容易改变默认值及启用它们。
<p>标准数据库具有以下的默认系统账户：
<ul>
	<li><b>贷款（借记）账户：</b> 借记或贷款账户只用于贷款和初始信贷（可以是贷款或赠款）。
	这是主要的系统账户，为了明确原因被称为贷款账户（有时这类账户被称为 &quot;浮动账户&quot; 或 &quot;借记账户&quot;）。
	通常会把借记账户作为<b>唯一的</b>没有负数限制的账户。创建单位时是需要此账户的。
	在创建单位后，贷款账户变为负数，收款账户（通常是会员账户）会变为同样数量单位的正数。<br>
	因此贷款账户的管理是非常重要的，也许对本土交易系统（LETS）这类系统没有那么重要，但对易货（商业）系统或有金钱支持的系统，这必须是保安非常严密和受监控的。<br>
	<br>
	<li><b>社区账户：</b> 社区账户是社区拥有的账户，它可以接收税款（如果已配置）和会员支付缴款。
	管理员可以执行从社区账户到会员账户的付款（例如：会员为社区所做的工作）。就像会员账户，社区账户不能低于信贷额度下限。<br>
	<br>
	<li><b>代用券账户：</b> 代用券账户是记录已流通为（实物）代用券的（数码）单位的账户。当会员要购买代用券，他需要支付代用券账户。
	组织可以核对付款和移交代用券。当会员要兑现代用券为单位，会员将需要交出代用券给组织，而管理员将要执行从代用券账户付款到会员账户。
	<br>
	如果系统的单位（部分）是以传统货币支持，代用券可以用传统货币购买。在这种情况下，购买者没有必要成为系统的会员；您只需购买代用券作为一种
	&quot;奖金优惠券&quot;；而管理员将要从贷款账户付款到代用券账户。<br>
	<br>
	<li><b>组织账户：</b> 组织账户可作为组织的一个额外账户。如果需要，它的名称可以根据其功能而改变（例如社会账户或投资基金）。
</ul>
<hr class="help">

<A NAME="account_search"></A>
<h3>账户列表</h3>
账户类型列表显示了账户名单及其类型（因此我们有时称它为账户类型）的概览。
<p>要新增一个会员或系统账户，您必须点击在视窗下面的
&quot;新增账户&quot; &quot;提交&quot; 按钮。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">
	单击该图标以修改账户。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">
	单击该图标以删除账户。（要删除的账户在系统中必须从没有交易）
</ul>
<hr class="help">

<A NAME="account_details"></A>
<h3>修改账户类型/新增账户</h3>
在账户详情的视窗中，您可以新增或修改一个账户。<br>
如果您要新增一个账户，可以指定这将是一个系统或会员账户。可用下列选项：
<UL>
	<li><b>名称：</b> 账户名称。这将显示在 <a href="#account_search"><u>管理账户列表</u></a> 
	及（如果它是一个系统账户）<a href="${pagePrefix}payments#account_overview"><u>系统账户列表概况</u></a>。
	<li><b>描述：</b> 账户说明（只有管理员可读）。
	<li><b>货币：</b> 在这里设置这个账户的 <a href="#currencies"><u>货币</u></a>。
	<li><b>限制类型（只适用于系统账户）：</b> 一个账户可以是无限的，这意味着它可以变为无限的负数（这主要是
	&quot;借记&quot;、 &quot;浮动&quot; 或 &quot;贷款&quot; 账户）<br>
	如果该账户是有限的，您可以指定信贷额度的上限和下限。限制类型只能在新增账户时指定（以后不能更改）。
</UL>
注：许多账户设置是按组别设置的（例如：信贷额度）。
这些设置可以在 <a href="${pagePrefix}groups#manage_groups"><u>用户组别设置</u></a> 进行修改。
<hr>

<A NAME="transaction_types"></A>
<p class="sub_description">
<h2>交易类型</h2>
每次付款（也称为交易）有一个 &quot;交易类型&quot;。交易类型界定付款的来源和目标的账户类型。
如果一个账户类型还没有联系交易类型，是不能做付款的。交易类型必须联系至来源账户（=付款人账户）。
</p>

<i>在哪里可以找到它？</i><br> 
交易类型可以在管理账户视窗中定义和修改；要到达那里，您应该通过 &quot;菜单：账户 > 管理账户&quot;，
并点击修改图标来更改账户类型。在下一页面会有一个特殊的视窗，显示联系交易类型的概况。
<hr class="help">

<A NAME="transaction_type_search"></A>
<h3>交易类型列表</h3>
交易类型视窗显示与选定账户有关的的交易类型名单。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">
	单击该图标以修改交易类型。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">
	单击该图标以删除交易类型。
</ul>
使用视窗下方的 &quot;新增交易类型&quot; 按钮来新增一个交易类型。
<p>注一：交易类型的权限是以每组别定义的，并可在 &quot;菜单：用户和组别 ＞ 权限组别 ＞ 修改组别权限&quot; 设定。
<p>注二：如果所选的账户是一个会员账户，特定的账户设置（信贷额度等）是以组别定义的。这也可以在 &quot;菜单：用户和组别 ＞ 权限组别&quot;（编辑图标-选择账户）中修改。
<hr class='help'>

<A NAME="transaction_type_details"></A>
<h3>修改/新增交易类型</h3>
在这个视窗，您可以设置一个特定的交易类型的属性。该交易类型有以下字段（并非所有是可以看得见的，要看种类和配置而定）：
<ul>
	<li><b>名称：</b> 交易类型的名称。<br>
	<br>
	<li><b>描述：</b> 交易类型的内部说明。这说明可能出现在交易细节。<br>
	注：如偿还贷款和定期费用，您可以使用某些编号，在描述内包括特定的数据。您可以使用
	&quot;占位符&quot; - 在交易描述内，他们将被其最终的相应值取替。如需要概述，请
	<a href="#placeholders"><u>点击这里</u></a>。<br>
	<br>
	<li><b>确认讯息：</b> 这讯息会显示在确认弹出视窗的交易资料的下面。用这种方式可以设置特定付款方式的讯息。<br>
	<br>
	<li><b>来源：</b> 付款人的账户类型。<br>
	<br>
	<li><b>目标：</b> 收款人的账户类型。<br>
	<br>
	<li><b>指定目标会员：</b> 如果您想这交易类型的目标会员永远是您在这里选择的会员。请注意，这是罕见的情况。这主要使用于如果您想规则和/或自定付款字段绑定到特定会员而非会员组别。<br>
	若您有一个以上的（会员之间）付款方式，您可以使用优先选项（下面详细说明）以隐藏付款。如果是指定目标会员，您可能想要把优先设置设为空白，以隐藏正常会员之间的付款。
	<br>
	<br>
	<li><b>可用性：</b>（只供会员账户之间的付款 - 如果您的会员只有一个这种货币的账户，这个选项将不可看见。在这种情况下，将会显示 &quot;启用&quot; 复选框（下一个项目）。）可用性定义了付款可以来自那里。
	<ul>
		<li><b>禁用：</b> 付款不活跃，不会在任何地方出现。
		
		<li><b>付款给他人：</b> 这是最常见的付款方式。如果拣选此选项，会员可以使用这交易类型执行付款给另一个会员或系统账户。
		<li><b>自我付款：</b> 如果存在有一个以上的会员账户类型（例如支票账户和储蓄账户），您可以新增一种交易类型，让会员在这些账户之间付款。
		如果是自我付款，您可能不想让会员的支票账户付款给另一个会员的储蓄账户；要做到这一点，可在直接付款的复选框不作任何选择。
	</ul>
	注意！：自动生成的交易类型，像账户费用和交易费用，将永远被收取，即使在复选框中没有选择及没有设立会员组别的权限。同样的情况适用于下一个项目，&quot;启用&quot; 复选框。<br>
	<br>
	<li><b>启用：</b> 可以用这交易类型付款，在付款视窗和交易摘要可看见付款方式。请注意，此项目与前述的是相互排斥的：如果
	&quot;可用性&quot; 显示，&quot;启用&quot; 将不会显示，反之亦然。<br>
	<br>
	<li><b>渠道：</b> 本项目容许您定义可以使用这种类型的 <a href="${pagePrefix}settings#channels"><u>渠道</u></a>。
	预设渠道是 &quot;主要网络访问&quot;，但其它（如手机）也是可以使用的。<br>
	<br>
	<li><b>优先：</b> 如果选择了优先选项，该交易类型将优先于其他交易。这意味着当付款可以显示一个以上的可能的交易类型时，只将显示具有优先设置的交易类型。但是，如果没有付款设置为优先，他们将会全部出现。<br>
	优先设置只用于相对复杂的系统，该系统内各种组别只容许在某些情况下与其它组别进行贸易。<br>
	利用组别和交易类型，可以建立一个系统，当中各个社区在同一个系统内可以进行独立贸易，亦可互相进行贸易。<br>
	该设定也可配合上面解释的 &quot;指定会员&quot; 选项使用。<br>
	<br>
	<li><b>每天最高金额：</b> 这交易类型每个会员每天可付款的最高限额。例如这可以用于限制手机的付款。<br>
	<br>
	<li><b>运行的Java类：</b> 如果特定的所需行为或功能不能被配置，您可以创建自己的Java类。
	每次支付这类型的交易，会调用这Java类处理。
	<br><br>
	<b>注1：</b>  
	这Java类只会被调用于“在处理”的付款。这意味着
它不会被调用于预定未来某个日期的付款或等待授权的付款。
（但是，一旦预定或已授权付款终于处理时，将会调用这个类）。
	<br><br>
	<b>注2：</b>
	确保这个类是在服务器的类路径上，例如WEB-INF/lib。
	<br><br>
	<b>注3：</b> 也可以对所有类型的付款调用一个类。这可以配置在
	<a href="${pagePrefix}settings#local"><u>本地设置</u></a> - 附加 - 处理付款的Java类。 
	<br>
	<br>
	<li><b>是贷款：</b>（仅适用于系统付款给会员）拣选此复选框表示交易类型是贷款。当您拣选此复选框，贷款设置会出现在下方。
	如需要更多资料，请点击 <a href="${pagePrefix}loans#make_loan_type"><u>这里</u></a>。<br>
	<br>
	<li><b>需要授权：</b> 如果您拣选并第一次储存它，一个额外的授权视窗会出现在这个视窗的下方。
	有关更多 <a href="${pagePrefix}payments#authorized"><u>授权付款</u></a> 的资料，可以在 <a href="#authorized_payment_levels"><u>此视窗</u></a> 的帮助菜单中找到。<br>
	如果您取消拣选授权选项，所有新增付款的授权级别将被取消。<br>
	<br>
	<li><b>允许预定付款（分期）：</b> 如果拣选此选项，表示这种类型的交易可以 <a href="${pagePrefix}payments#scheduled"><u>预定</u></a>。
		这并不意味着有此交易类型的任何会员或管理员会自动能够使用预定选项。您还需要设置每一组别的权限（查看和允许预定付款）。如需更多资料，请参阅：帮助 ＞手册 ＞付款 ＞预定付款。<br>
	<br>
	<li><b>可对帐：</b> 如果拣选这个选项，此交易类型将是对帐功能的一部份。如需更多资料，请参阅：簿记 ＞对帐功能
	<a href="${pagePrefix}bookkeeping"><u>帮助文件</u></a>。<br>
	<br>
	<li><b>需要交易反馈意见：</b> 此选项只适用于会员之间的付款。如果拣选此选项，会员可以设置执行这种类型的交易后的反馈意见。
	如需要更多有关反馈意见的资料，请参阅 <a href="${pagePrefix}transaction_feedback">帮助页</a>。<br>
	以下内容只在 &quot;需要反馈意见&quot; 的复选框被拣选才能看见：
	<ul>
		<li><b>反馈意见期限：</b> 当完成付款后，付款人（＝买方）可以设置反馈意见的最长时间。这期限可以在此设定。
		<li><b>答复反馈意见期限：</b> 反馈意见的接收人（＝卖方）可以答复反馈意见。这最长期限可以在此设定。
		<li><b>到期时默认的反馈层次：</b> 一旦反馈已过期，默认的反馈将会建立。您可以在此设置中指定默认的层次（通常会是 &quot;中性&quot;）。
		<li><b>到期时默认的反馈评论：</b> 一旦反馈已过期，默认的反馈将会设立。您可以在此设置中指定默认的评论（通常会是 &quot;没有新增反馈&quot;）。
	</ul>
</ul>
<hr class="help">

<a name="placeholders"></a>
<h3>描述字段的占位符</h3>
如果是偿还贷款和周期费用，您可以在 <a href="#transaction_types"><u>交易类型</u></a> 的描述中使用某些编号来包括特定的数据。
您可以使用 &quot;占位符&quot; －在最终交易描述中，他们将被其相应值所取代。
<p><b>偿还贷款：</b>
<ul>
	<li><b>#loanAmount#：</b> 原本的贷款金额。
	<li><b>#loanTotalAmount#：</b> 贷款金额加费用（利息、批出贷款费用）。
	<li><b>#parcelAmount#：</b> 部分贷款的金额，一个特定贷款期段的金额。贷款分为固定数目的偿还部分。
	<li><b>#parcelNumber#：</b> 部分贷款的号码。贷款分为固定次数偿还，&quot;组别成部分&quot;，每一部分可以有自己的号码。
</ul>
如需更多有关贷款的资料，请参阅 <a href="${pagePrefix}loans"><u>帮助 ＞手册 ＞贷款</u></a>。
<p><b><a href="#account_fees"><u>周期费用</u></a>（＝缴款和流通税）：</b>
<ul>
	<li><b>#begin_date#：</b> 开始日期（只有在 <a href="#account_fees"><u>流通税</u></a>）
	<li><b>#end_date#：</b> 结束日期（只有在流通税）
	<li><b>#tax#：</b> ＝金额
	<li><b>#freebase#：</b> 基本免费额，没有税费的基本金额（只有在流通税）
	<li><b>#volume#：</b> ＝贸易总额（只有在流通税）	
	<li><b>#result#：</b> ＝结果
</ul>
<p><b><a href="#transaction_fees"><u>交易费用</u></a></b>.
请注意，这些应是费用的转账类型的描述，而不是费用本身的描述。
<ul>
	<li><b>#fee#: </b> 费用值。如是百分比的费用，这是百分比（包括%符号）；
	或是固定费用情况下的金额。
	<li><b>#fee_amount#: </b> 同上
	<li><b>#member#: </b> 付费的会员
	<li><b>#transfer#: </b> 导致这一费用的原转账的总金额
	<li><b>#original_amount#: </b> 同上
	<li><b>#amount#: </b> 以本地化显示要支付这项费用的金额。
	在固定费用的情况下，这是相同的；
	但在百分比费用的情况下，这是 #fee# 乘 交易金额。
	
</ul>
<hr class="help">


<p><A NAME="payment_fields_list"></A>
<h3>付款自定字段</h3>
在交易（付款）类型，您可以设置自定字段，就像可以给会员个人资料或广告设置自定字段一样。
付款字段将只在现时的交易类型看到（此刻您正在修改的）。<br>
您可以创建付款自定字段的类型：
<ul>
	<li><b>新增自定字段：</b> 您可以使用此选项给付款类型设置自定字段，方式与（例如）会员个人资料设置相同。
	<li><b>连接现有自定字段：</b> 您可以使用此选项连接到现有的付款字段。更多有关的资料可以在连接付款自定字段的详情中找到。
	</ul>
<hr class="help">


<p><A NAME="payment_fields_link"></A>

<h3>连接付款自定字段</h3>
在更复杂的系统中，&quot;转发&quot; 交易是常见的。这通常以征收100％的交易费用和用第三者目标账户。在这种情况下，您可能想两个付款使用相同的自定字段。
为此，您可以在原本的交易类型创建付款自定字段，并在第二个（生成的）交易类型建立连到这个付款自定字段的连接（通过使用选项 &quot;连接现有自定字段&quot;）
</ul>
<hr>


<p><A NAME="authorized_payment_levels"></A>
<h3>授权级别</h3>
这项功能将允许定义需要 <a href="${pagePrefix}payments#authorized"><u>授权</u></a> 付款方式的授权级别。
<p>有各种可能的授权级别，并且每一付款类型可能有一个以上的授权级别
，意指不同的人将需要授权一个具有（可能）不同标准的付款。会员和授权者（经纪或管理员）将获得一份需要授权的等待付款列表。
<p>这视窗会显示交易类型的所有授权级别。如果没有一个可用，您必须单击 &quot;新增授权付款级别&quot;，因为您必须为每个授权付款类型定义最少一个授权级别。当您增加了一个新的级别，这将出现在列表上。<br>
如果级别已被定义，您可以选择以下选项：
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">
	单击该图标以修改授权付款级别。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">
	单击该图标以删除授权付款级别。
</ul>
<p>如果您取消拣选交易类型中的授权选项，这意味着该交易类型的所有授权被禁用。授权级别将消失，但会留在历史中。如果在交易类型配置的授权复选框再次被拣选，授权级别将再次出现。
<p>如果授权付款产生了其他付款（例如偿还贷款、税费等），全组别付款可一同授权（并封锁/保留总金额直到授权）。
<hr class="help">

<A NAME="edit_authorization_level"></A>
<h3>修改授权级别</h3>
在此视窗中您可以定义 <a href="#authorized_payment_levels"><u>授权级别</u></a>。
您可以定义最多五个授权级别。每个级别可以有授权 &quot;类型&quot;，这取决于授权级别和什么种类的授权可用。
<ul>
	<li><b>收款人：</b> 当授权类型是 &quot;收款人&quot;
	这意味着收取付款的（目标）会员将首先要授权付款。当收款人授权这付款（从付款等待授权列表中，点击 &quot;接受&quot;），金额将被转移和状态将从 &quot;待处理 &quot; 变为
	&quot;授权&quot;。<br>
	这项授权类型是相当罕见的。如果系统已使用 <a href="${pagePrefix}invoices">发票</a>，我们建议不要使用此选项，因为发票提供类似的功能。
	<li><b>付款人：</b>此选项只适用于如果第一级别选项是 &quot;收款人&quot; 授权类型。<br>
	它在 &quot;收款人&quot; 授权类型之后，提供一个额外的（可选择的）授权级别。如果配置这种类型，在收款人授权后，付款将留在待处理状态，等待付款人（创始人）授权付款；当这完成后金额将被转移。
	<li><b>经纪/管理员：</b> 这授权级别可设置为第一级别，或在收款人类型级别之后的第二级别。
	这意味着付款会员的 <a href="${pagePrefix}brokering"><u>经纪</u></a> 将需要授权该付款，并且选择性地也需要管理员授权。<br>
	您可以选择除了经纪之外可以授权付款的管理员组别；经纪或管理员之间没有优先，谁都可以授权。
	<li><b>管理员：</b> 此授权类型可用作第一级别，或在经纪/管理员之后的第二级别，或在付款人或任何其他只有管理员类型之后的第三级别。<br>
	这意味着您可以链接各个级别与管理员授权级别类型，及不同的金额和组别。您将需要选择可以授权付款的管理员组别。
</ul>
您需要指定每个授权类型和级别的金额。如果您想付款永远要授权的，您可以在金额字段中键入一个零。如果您键入金额，例如1000，这意味如果一个会员在24小时内付款超过1000，该超过的付款将需要授权。<br>
授权级别的金额可以与前一级别的金额相同或更高。
<hr>


<A NAME="payment_filters"></A>
<p class="sub_description">
<h2>付款筛选器</h2>
可以把几个交易类型组合为 &quot;付款筛选器&quot;。这些筛选器可方便地把某些相关的交易类型组合在一起，例如交易摘要视窗或统计。
例如：不同类型的缴款和其它特定的社区支付可组合为一个称为 &quot;支付社区&quot; 的筛选器。
付款筛选器也可以用来建立自订报表。对于管理员，付款筛选器提供一个很好的工具来纪绿付款和检取特定的报告。

</p>
<i>在哪里可以找到它？</i><br>
付款筛选器总是与某个账户类型有关，所以它们必须通过 &quot;菜单：账户 > 管理账户&quot;，选择账户类型，
然后按修改 <img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;图标。除了其它视窗，将有一个有联系的筛选器的特殊视窗。
<hr class="help">

<A NAME="payment_filter_search"></A>
<h3>付款筛选器列表</h3>
此视窗列出了与账户联系的 <a href="#payment_filters"><u>付款筛选器</u></a>。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">
	单击该图标以修改付款筛选器。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">
	单击该图标以删除付款筛选器。
</ul>
如果您想增加一个新的筛选器，您必须点击在视窗下方 &quot;新增付款筛选器&quot; 的 &quot;提交&quot; 按钮。
<hr class="help">

<A NAME="payment_filter_details"></A>
<h3>修改/新增付款筛选器</h3>
在这里您可以修改现有的或新增一个 <a href="#payment_filters"><u>付款筛选器</u></a>。下列字段可以设定：
<ul>
	<li><b>筛选器名称</b>：筛选器的名称。
	<li><b>描述</b>：筛选器的描述。
	<li><b>在账户历史记录显示</b>：如果拣选此复选框，筛选器将显示在选定的账户历史。
	<li><b>在报表显示</b>：如果您拣选 &quot;在报表显示&quot; 复选框，
	 <a href="${pagePrefix}reports"><u>报表职能</u></a> 将包括有关此筛选器的报表。它会显示有关付款筛选器的所有交易金额的总和。
	 它也可用于 <a href="${pagePrefix}statistics"><u>统计模块</u></a>。<br>
	您可以只为了报表职能而新增付款筛选器，为此，您必须取消拣选 &quot;在账户历史记录显示&quot; 的复选框。
	<li><b>交易类型</b>：在这里您必须选择将包括在筛选器的 <a href="#transaction_types"><u>交易类型</u></a>。
	<li><b>组别可见性</b>：在这里您可以选择将能够查看付款筛选器的组别，这方法可以为不同的组别创建不同的筛选器。
	例如经纪组别可以有一个 &quot;支付经纪佣金&quot; 筛选器。管理员通常会需要更特定的付款筛选器，而会员组别会有基本的付款筛选器，例如：贸易交易－税费。
</ul>
<hr>

<A NAME="transaction_fees"></A>
<p class="sub_description">
<h2>交易费用</h2>
交易类型可以包含一项或多项 &quot;交易费用&quot;； 每当用户进行交易类型已配置费用的付款，可以被收取费用（取决于费用配置的准则）。
通常的交易费用是交易税，每次会员进行 &quot;贸易&quot; 转账类型的付款时收取。有各种不同的方法来计算费用（固定的、百分比等），并设定向谁收费。<br>
<br>
一个典型的费用例子是贸易的 &quot;普通&quot; 交易费用。每次发生 &quot;贸易&quot; 交易，将套用费用（如果已配置）。
由于这费用本身是一笔付款，它有自己的交易类型，因而它将被分开收取，并将在交易历史中显示为不同的付款类型。费用的交易细节将显示费用的原本（产生）付款。
</p>
<i>在哪里可以找到它？</i><br>
交易费用将永远 &quot;属于&quot; 一个<a href="#transaction_types"><u>交易类型</u></a>，
因此交易费用的配置是位于交易类型配置内：进入 &quot;菜单：账户 > 管理账户&quot;，选择账户（通过修改图标），进入交易类型视窗，选择交易类型（通过修改图标）；
在这页里您亦可以找到一个显示相关的交易费用的特殊视窗。
<hr class="help">

<A NAME="transaction_fee_search"></A>
<h3>交易费用</h3>
这个视窗列出 <a href="#transaction_types"><u>交易类型</u></a> 的相关 <a href="#transaction_fees"><u>交易费用</u></a>。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">
	单击该图标以修改交易费用。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">
	单击该图标以删除交易费用。
</ul>
如果您想新增一个交易费用，您必须点击在视窗下方 &quot;新增交易费用&quot; 的 &quot;提交&quot; 按钮。
<hr class="help">


<A NAME="transaction_fee_details"></A>
<h3>修改/新增交易费用</h3>
此视窗用于修改现有的、或定义一个新的 <a href="#transaction_fees"><u>交易费用</u></a>。<br>
当发生一个特定的交易，便会产生交易费用。然而，费用本身也是交易，因此，他们也需要有自己的交易类型。
在配置新的费用之前，您必须首先为该费用新增一个 <a href="#transaction_types"><u>交易类型</u></a>。
<p><b>字段：</b>
<ul>
	<li><b>交易类型</b>：这是产生交易费用的交易类型；对于贸易的费用，您通常会选择例如 &quot;贸易&quot;。<br>
	<li><b>名称</b>：费用的名称。<br>
	<li><b>描述</b>：费用的描述。<br>
	<li><b>启用</b>：当拣选后，费用将是活跃的；如果不拣选，便不收取费用，系统将当作它不存在。<br>
	<li><b>支付者</b>：在这里您可以定义谁将被收取费用。有不同的选项。
	要留意，如果配置了代理，会员必须有经纪人，才能收取费用。<br>
	<li><b>接收者</b>：在这里您可以定义谁将收到费用。有不同的选项。
	要留意，如果配置了代理，会员必须有经纪人，才能接收费用。<br>
	<li><b>允许任何账户</b>：正常情况下，在下面一项（&quot;生成交易类型&quot;）中，只显示同一种货币的有关交易类型。
	如果您拣选此复选框，则没有限制可套用于交易费用中的货币：所有交易类型会显示，即使是另一种货币。<br>
	<li><b>生成交易类型</b>：在这里您可以定义这项费用将会产生什么交易类型－收费本身的交易类型。
	通常会为此新增一个特定的交易类型，这可让您进行筛选（例如在账户历史：费用及税费）。
	默认的数据库已有一项交易费用及其交易类型。例如，贸易的费用通常被称为 &quot;交易税&quot;。<br> 
	请注意，您必需首先新增这个交易类型，才能新增费用（见上述注释）。<br>
	<li><b>费用类型</b>: 它指定计算费用的方式。可以有以下几种类型：
	<ul>
		<li><b>固定值</b>：费用值一直相同。您可以在下面的“费用额”输入这个值。
		<li><b>百分比</b>：将收取费用是生成的交易金额的百分比。
		您可以在下面的“费用额”输入这个百分比。
	</ul>
	<br>
	<li><b>费用额</b>：在这里，您可以填写费用的金额。
	如果您想费用的金额是原本交易金额的一个百分比，您必须选择 &quot;百分比&quot; 和输入这个百分比。
	如选择 &quot;固定值&quot;，将收取一个与原本交易金额无关的固定金额。<br>
	<li><b>扣款</b>：使用此设置，您可以定义交易费用将计算为原本付款的 &quot;额外&quot; 付款，或将它从原本付款的总金额中 &quot;扣除&quot;。<br>
	这可以用一个例子解释：如果支付了100，费用是3，并已拣选从总额中扣款，将产生以下的付款：
	<ul>
		<li>主要（产生）交易：97
		<li>费用：3
	</ul>
	以上情况是比较罕见。通常费用是不从总额中扣除的。以相同的金额和不扣除费用为例：
	<ul>
		<li>主要（产生）交易：100
		<li>费用：3
	</ul>
	<br>
	<li><b>套用条件</b>：在这里您可以定义在什么条件下，费用将被套用。只在符合条件的情况下才套用该费用。各条件可以结合在一起。
	<ul>
		<li><b>金额大于或等于</b>：如果产生交易的交易金额是大于或等于指定的金额，才收取费用。
		<li><b>金额少于或等于</b>：如果产生交易的交易金额是少于或等于指定的金额，才收取费用。
		<li><b>支付组别</b>：如果拣选所有支付组别，费用将套用于任何组别的付款会员。
		如果您想收费只套用于特定的组别，您需要取消拣选 &quot;所有支付组别&quot; 的复选框，并在之后出现的多种选择组合中，选择一个或多个组别。
		<li><b>接收组别</b>：类似前一项目，但适用于产生交易类型的收款会员。
	</ul>
</ul>
<hr class="help">



<A NAME="account_fees"></A>
<p class="sub_description">
<h2>账户费用</h2>
&quot;账户费用&quot; 通常被称为 &quot;缴款&quot;，是周期性预定的或由管理员手动执行。账户费用是与账户有关的，并可以套用于一个或多个会员组别。
当执行账户费用时，所有在账户费用配置中已选定的会员组别将被收取费用－然而，尽管 &quot;费用&quot; 一字暗示由会员支付，但账户费用也可以配置成由系统账户支付给会员。
一个典型的账户费用是会员每月支付缴款给系统账户（但亦可以从相反方向）。另一个例子是 &quot;滞期费&quot; 或
&quot;流通税&quot;，即用户为整个时段的正结余付税，作为某种 &quot;负利息&quot;；背后的概念是刺激人们使用他们的结余，而不是保留在账户内。
</p>
<i>在哪里可以找到它？</i><br>
由于账户费用联系至账户类型，它的配置是通过账户管理：&quot;菜单：账户 > 管理账户&quot;，选择账户类型，然后按修改
<img border="0" src="${images}/edit.gif" width="16" height="16">&nbsp;图标。
<p>账户费用的管理和概况是从账户概况页（&quot;菜单：账户 > 账户费用&quot;）做到；在这页里您获得所有账户费用的概况和它们的状态，您也可以手动收取账户费用。
<hr class="help">

<A NAME="account_fee_overview"></A>
<h3>账户费用概况</h3>
账户费用概况页显示启用给任何账户类型的所有 <a href="#account_fees"><u>账户费用</u></a>。
<p>该视窗会显示一个活跃（启用）的账户费用列表，最后一次和下一次执行日期及它们的状态（&quot;失败&quot;、&quot;成功&quot;）。
<p>账户费用可以是自动（预定）或手动的。手动账户费用只当单击 &quot;立即执行&quot; 链接时才执行。
当账户费用正在执行中，是可以取消执行账户费用的，单击 &quot;取消&quot; 链接便可。<br>
被取消或因为技术问题而失败的费用，一定会执行 &quot;回滚&quot;，这意味着您将永远不会有完成一半的账户费用。
在账户费用已成功执行后，将设置最后一次执行的日期，条目会显示在 <a href="#account_fee_history"><u>账户费用历史列表</u></a>（视窗下方）。
<p>如果账户费用执行失败，警示会显示在警示日志和状态将显示费用是失败的。失败的费用是可以恢复执行的，只需在账户费用历史列表中点击 &quot;再收取账户费用&quot; 链接。
<hr class="help">

<a name="account_fee_history"></a>
<h3>账户费用历史</h3>
本页面显示所有 <a href="#account_fees"><u>账户费用</u></a> 的收费历史。如果收取账户费用已经失败，状态将显示费用是失败的。通过点击
&quot;再收取账户费用&quot; 链接，便可以恢复执行该费用。
<hr class="help">

<A NAME="account_fee_list"> </A>
<h3>账户费用</h3>
此视窗列表显示这账户类型的所有配置了（启用或禁用）的 <a href="#account_fees"><u>账户费用</u></a>。
<ul>
	<li><img border="0" src="${images}/edit.gif" width="16" height="16">
	单击该图标以修改账户费用。
	<li><img border="0" src="${images}/delete.gif" width="16" height="16">
	单击该图标以删除账户费用。
</ul>
要增加新的账户费用，在列表的下方单击 &quot;新增账户费用&quot;。
<hr class="help">

<A NAME="account_fee_details"></A>
<h3>修改/新增账户费用</h3>
在此视窗中您可以配置（新的或现有的）<a href="#account_fees"><u>账户费用</u></a>。
请注意，费用本身是一个交易，因此它需要一个 <a href="#transaction_types"><u>交易类型</u></a>；您需要新增这种交易类型后，才可以新增和配置账户费用。
<p>可用以下的配置选项：</b>
<ul>
	<li><b>账户费用名称</b>：账户费用的名称。<br>
	<br>
	<li><b>描述</b>：账户费用的描述。<br>
	<br>
	<li><b>启用</b>：只有拣选此复选框后，才会收取账户费用；如果此框未被拣选，无论费用是预定或手动，也不会收费。<br>
	<br>
	<li><b>收费模式</b>：有五种可能的收费模式：
	<ul>
		<li><b>固定金额</b>：固定金额可以是缴款（会员付款给系统账户）或系统账户一次性或预定付款给会员组别。
		<li><b>正使用量百分比</b>：正使用量百分比的计算方法与利息的计算方式相同。
		实际上，当定义付款方向（见下文）为 &quot;系统付给会员账户&quot; 时，这将是利息。
		如果方向是 &quot;会员付给系统账户&quot; 费用将是反向利息（滞期费）。<br>
滞期费是根据“周期”字段选择的期段来计算。
在此期段内的每一天结束时的账户余额被用来计算“平均”的账户余额。
例如，如果某一会员在一段期间内的在账户有100个单位，
1个月的平均账户余额正好是100。
收取这个会员的平均余额1％的滞期费，便是1个单位。
		<li><b>负使用量百分比</b>：负使用量百分比以同样的计算方式运作，但只发生在负结余。
		<li><b>正账户余额百分比</b>：账户余额百分比费用不计算数量（时间+余额），只计算余额。
		当执行费用时（手动或预定），费用将只考虑收取时候的余额。
		这就意味着，如果在上面的例子中，在费用执行之前，若会员降低他的余额为零，他将不会支付任何费用。
		<li><b>负账户余额百分比</b>：负账户余额百分比以同样的计算方式运作，但只发生在负结余。
	</ul>
	请注意，收费模式不能改变现有的费用，它只能设置在新的账户费用。<br>
	<br>
	<li><b>宽限期</b>：这个项目，只在 &quot;收费模式&quot; 的数据值拣选为 &quot;正使用量&quot; 时才看见。
	宽限期是一种设置，它可以用来避免会员收到了系统付款（如贷款），而且在短期内把它耗尽（转换或购买东西），仍要支付这个金额和期段的滞期费。
	例如，假若一个会员收到100个单位，并在24小时内把它们花费尽，如果容忍期设置为24小时，该会员将不会支付这期段/金额的费用。
	如果在同一事例中，会员在两天内花费了100单位，他将被收取两天（而不是一天）作为整个期段的费用。<br>
	<br>
	<li><b>付款方向</b>：这定义账户费用的方向，无论是会员付款给系统或从相反方向。<br>
	<br>
	<li><b>生成交易类型</b>：账户费用将需要一个交易类型，交易会使用所选择的交易类型。<br>
	<br>
	<li><b>金额</b>：如果您在 &quot;收费模式&quot; 选择 &quot;固定金额&quot; 
	，这是将收取的金额；否则，将会是根据数量或金额收取的百分比。<br>
	<br>
	<li><b>基本免费额</b>：如果有基本免费额，可以在超过一定（平均）金额后才实行收费。<br>
	如果用使用量百分比的收费模式，情况如下（用之前提到的例子）：
	<ul>
		<li><b>收费模式：</b> &quot;正使用量百分比&quot;
		<li><b>金额：</b> 1％
		<li><b>基本免费额：</b> 40
		<li><b>会员账户的数量：</b>在整个月 100 单位
		
	</ul>
	在这种情况下，如果没有基本免费额（0 的基本免费额），收取的费用将是1单位；由于基本免费额，首40单位将不会被收取，所以收取的费用将是0.60单位。<br>
	在固定金额收费模式下，余额等于或低于基本免费额的会员是根本不会收费的。<br>
	<br>
	<li><b>发送发票</b>：这个项目只在付款方向是 &quot;会员付给系统&quot; 的情况下才能看到。<br>
	这决定如果会员已被收取账户费用，但没有足够的信贷支付时，会发生什么。下列选项可用：
	<ul>
		<li><b>只有当会员账户没有足够余额才发送：</b> 在这种情况下，只有没有足够余额的会员将会收到发票，其余的都是从账户中收取。
		<li><b>不发送（自动收费，可能使会员账户余额变为负数）：</b> 在这种情况下，所有会员会被收取和会支付费用，即使这使他们的账户低于其信贷额度。
		<li><b>永远发送（不会自动向会员收费）：</b> 在这种情况下，会员的账户费用将不会自动收取，而只发送发票，无论会员是否已达到其信贷额度。
	</ul>
	<br>
	<li><b>执行模式</b>：在这里，您可以定义账户费用将是预定或手动收费。请注意，一旦费用已经建立，该设置是不能改变的；这设置只能用于新的费用。<br>
	如果是手动收费，管理员需要从 <a href="#account_fee_overview"><u>账户费用概况视窗</u></a> 启动收取费用。
	如果执行模式是 &quot;预定&quot;，费用将在配置的时间被自动收取；在这种情况下，您将有下列额外的选项：
	<ul>
		<li><b>周期</b>：这是执行账户费用的相隔周期，例如每月或每年。<br>
		例如：如果设置为 &quot;3&quot; &quot;月&quot;，账户费用将会每3个月执行。如果设置为 &quot;0&quot;，账户费用将只执行一次。
		<li><b>日</b>：每月或每周将执行账户费用的日子；当然，如果您选择的期段为每日，这是看不见的。
		<li><b>时</b>：将执行账户费用的时间（1－24）。
	</ul>
	<br>
	<li><b>启用日期</b>：此字段将只在有拣选“启用”费用选项时显示。如果您想配置预定税项，但不希望它在第一次收费的日期收取，在这里可以定义未来的日期。
	从该日起将根据日程安排收取费用。<br>
	例如，您预定每月1日收取费用，但您只要从2011年1月开始收费（现在是2010年6月）；您必须设置“启用日期”在2010年12月1日和2011年1月1日之间。<br>
	注：“启用日期”只能设置一次。该选项一旦被使用，将不会显示。当然您可以随时手动禁用/启用上面的“启用”选项。
	<br>
	<li><b>组别</b>：在这里，您可以选择将支付或接收账户费用的组别。
</ul>
<hr>

<A NAME="credit_limit"></A>
<h3>个人信贷额度</h3>
<p>
<i>在哪里可以找到它？</i><br>
个人信贷额度可通过 <a href="${pagePrefix}profiles#accounts_actions"><u>会员账户行动</u></a>（在会员个人资料下面的视窗）进入。
<p>
这个功能可为会员设置个人信贷额度。在新增会员账户时，会员将得到在 <a href="${pagePrefix}groups#manage_groups"><u>组别设置</u></a> 中配置的默认信贷额度。<br>
在这个视窗中，您可以推翻这些组别的信贷额度；在这里，您可以为这个会员的所有账户设置信贷额度的上限和下限；当会员达到信贷额度下限，他将无法付款。
<p>上限额度是一个很少使用的功能。当会员达到信贷额度上限，他将无法接收付款；付款人将收到收款人不允许接收付款的讯息。有个例外是在会员接收单位的预定缴款，这些付款将一定会发生。
<hr class="help">
</span>

</div> <%--  page-break end --%>

<div class='help'>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
</div>