<div style="page-break-after: always;">
<a name="guarantees_top"></a>
<p class="head_description">
担保模块提供了一种机制，透过使用联环系统作为支付系统的网络，
让“未来”购买商品或服务的付款，
可以直接提供本地购买力给供应商（卖方）。
这意味着，这“预期”的本地购买力是由未来的（常规货币）支付来支持。
因为卖方是由组织以本土货币支付（交付货物时），
现在是买方（而不是卖方）欠下组织的债务。
一个“发行人”，通常是金融机构，担保这些（从买方给组织的）未来付款。
万一买方没有，或无法付款，发行人将负责将完成付款。
当然，发行人将收取费用，但这些费用一般比同样在金融市场的贷款低得多。
<br>
<br>发行人（在联环系统）有各种工具来发出和监控担保。
他们可以评估买方（本地政府，公司或个人），并定义一个最大“支出”的数额和其他条件，
如收费和届满日期。
担保模块非常灵活，定义不同的担保类型，支持各种用途。
</p>

<i>在哪里可以找到它？</i><br> 担保类型可以见于：
&quot;菜单：担保＞担保类型&quot;。<br>
<hr>


<a name="guarantee_models"></a>
<h3>担保模式</h3>
担保模式有三种类型：<br>
<ul>
	<li><b>担保付款义务：</b>规模较大的公司或本地政府从本地供应商购买商品和服务，并在稍后的时刻支付，
	例如在一个、三个或六个月，这是很常见的。一个典型的例子是一家超市或市政府支付当地供应商。
	付款义务的担保模块提供在线工具，可以管理和监视这些付款。
	这个过程开始时，发行人，通常是金融机构，评估公司（买方），并在联环系统创建一个认证。<br>
	认证定义可能的费用和最大的消费金额。买方可以“发布”最多这一付款义务数额给提供者，通常是每张待付发票一个付款义务。
	如果供应商/卖方决定要直接收取本土货币（代替等待在以后的日子的付款），它可以接受付款义务。
	对于卖方这意味着一个显著的区别，因为他已直接取到钱（以本土购买力的形式）。
	对于买方，付款义务的唯一的区别，是它会支付组织（与传统的货币有相同的延迟），
	而不是延迟支付传统货币与供应商。</li><br>
	<li><b>给买方担保：</b>这种模式通常由卖方向客户的单一购买提供融资。卖方和买方都是这一进程的一部分。</li><br>
	<li><b>给买方和卖方担保：</b>这种模式通常由卖方向客户的单一购买提供融资。卖方和买方都是这一进程的一部分。</li>
</ul>
<hr class="help">

<span class="admin">
<a name="guarantee_types_list"></a>
<h3>担保类型列表</h3> 此视窗显示所有配置的担保类型。<br>
</span>
<hr class="help">

<span class="admin">
<a name="edit_guarantee_type"></a>
<h3>修改/新的担保</h3> 担保有以下字段：
<ul>
	<li><b>名称：</b>担保名称。<br>
	<li><b>货币：</b>货币有关的担保。<br>
	<li><b>模式：</b>此定义担保的类型，如在 <a
	href="#guarantee_models"><u>担保模式</u> </a> 一节解释。<br>
	<li><b>启用：</b>此复选框可以启用和禁用担保的类型。<br>
	<li><b>授权者：</b>此选项定义谁可授权。可能的选项是：
发行人，发行人和管理员，没有（有些选项不是所有模式都可用的）。<br>
	<li><b>最长等待的担保期：</b>（只是付款义务模式）。
	这是等待发行人（或管理员）授权或拒绝担保的最长时期。<br>
	当这时期届满，担保将自动转为“没有行动”的状态。<br>
	<li><b>义务之间的最长时期：</b>（只是付款义务模式）。
	这是付款义务可以“打包”提交给买方的最长时期。<br>
	<li><b>信用费：</b>信用费总是转入一个系统账户（会员到系统交易类型）。<br>
	信用费如果设置为只读，管理员可以修改，但发行人永不可以。<br>
	<li><b>发放费：</b>发放费总是转给发行人（会员到会员交易类型），
	与信用费一样，可以从买方或卖方取收（取决于担保类型配置）。
	发放费如果没有被定义为“只读”，可以由发行人改变。管理员（作为授权人）可以随时修改信贷费用。
	<li><b>费用计算（通用规则）：</b>在“买方和卖方”的费用模式，是可以定义谁付费（买方或卖方）。
	费用可以配置为一个固定值、担保金额的百分比、或每年的百分比。
	在后一种情况，费用将以下列公式计算：<br>
	年费=((1+T/100)^(d/365) - 1) * M<br>如下：
	<ul>
		<li><b>T</b> = 费用%</li>
		<li><b>d</b> = 担保的有效期天数</li>
		<li><b>M</b> = 金额</li>
	</ul>
	<li><b>描述：</b>（可选的）担保类型的解释说明。
	<li><b>交易类型：</b>在这里定义担保生成的各种交易的类型。
	<li><b>信用费：</b>选择从会员到系统的交易类型</li>
	<li><b>发放费：</b>选择从会员到会员的交易类型</li>
	<li><b>贷款：</b>选择贷款</li>
	<li><b>转递：</b>这是（会员到会员的）交易类型，将从买方转到卖方。</li>
</ul>
<b>注意：</b>有两种方式可以创建担保：
<ul>
	<li><b>手动：</b>由“发行人”或“管理员”（只是“买方和卖方”和“买方”类型）
	<li><b>自动</b>在激活担保时。 （担保付款义务类型）
</ul>
</span>
<hr>

<a name="certifications"></a>
<h2>认证</h2>
<p class="sub_description">
认证是由“发行人”创建的数字合同。
它定义了一个最大的数量，可以由一个特定的“买方”发出
<a href="#payment_obligations"><u>付款义务</u></a>
给卖方。发行人与同一个买方的同一种货币只可以有一个“活跃”的认证。
<br>
</p>
<i>哪里可以找到它？</i><br>认证可以在“菜单：担保 > 认证”找到。
<br>
<hr class="help">


<a name="new_certification"></a> <a name="edit_certification"></a>
<h3>新增/修改认证</h3>
认证有下列项目：
<ul>
	<li><b>状态：</b>（只是查看认证）。这里列出认证的
	<a href="#statusC"><u>状态</u></a>。</li>
	<li><b>担保类型：</b>有关认证的担保类型。</li>
	<li><b>买方：</b>买方的名称和登录名。</li>
	<li><b>有效期：</b>认证将是活跃的期间。
	如果初始化的（从）日期是在未来，认证只从该日期起才会活跃。
不能创建认证的开始日期是早于当前日期的。</li>
	<li><b>金额：</b>这是买方可以发出付款义务的最高金额。</li>
	<li><b>已使用金额：</b>已使用金额是（每个认证）发出付款义务的总金额。
	已使用总金额是担保金额的状态是<i>已接受</i>和<i>待定</i>的总和。
	当买方正在付清的付款义务和行政上关闭了的时候，
	认证金额将再次可用（只要是认证期间仍活跃）。
</ul>
<hr class="help">


<a name="certification_logs"></a>
<h3>认证状态日志</h3>
这个视窗提供了关于认证<a
href="#statusC"><u>状态</u></a>变化的信息。
<p>
<hr class="help">


<a name="statusC"></a>
<h3>认证状态</h3>
认证可以有各种不同的状态，取决于担保类型和运作流程。
下面列出所有可能的状态，每个状态描述可能导致这状态所采取的行动。
<p>
<b>状态/行动</b>
<ul>
	<li>预定</li>
	<ul>
		<li>当发行人创建了一个新的认证的初始化日期是在未来某一日期（不是今天）。</li>
		<li>当发行人激活认证的状态原本是暂停，并且初始化日期是在未来某一日期（不是今天）。</li>
	</ul>
	<li>活跃</li>
	<ul>
		<li>当发行人创建一个新的认证的初始化日期是在过往或当前日期。</li>
		<li>当发行人激活认证的状态原本是暂停，并且初始化日期是在过往或当前日期。</li>
		<li>当预定的认证达到目前的日期时。</li>
	</ul>
	<li>暂停</li>
	<ul>
		<li>当发行人暂停认证的活跃或预定状态。</li>
		<li>当预定的认证达到当前的日期，但同一发行人、货币和买方已经有一个活跃的认证。</li>
	</ul>
	<li>过期</li>
	<ul>
		<li>当一个认证在活跃或预定状态达到最后日期。</li>
	</ul>
	<li>取消</li>
		<ul> 
		<li>当管理员取消一个在活跃、暂停或预定状态的认证。</li>
	</ul>
</ul>

<h3>认证通知</h3>
可产生以下相关认证的通知：<br>
<ul>
	<li>当认证进入以下状态之一：活跃、暂停、过期或取消时，发送给买方。</li>
	<li>当认证进入过期状态时，发送给发行人。</li>
</ul>
<hr class="help">


<a name="certifications_search"></a>
<h3>搜索认证</h3>
此列表显示所有已配置的<a href="#certifications"><u>认证</u></a>，
可以用下面的选项搜索：<br>
<ul>
	<li><b>状态：</b> 认证的<a href="#statusC"><u>状态</u></a>之一：</li>
	<ul>
		<li>活跃</li>
		<li>取消</li>
		<li>暂停</li>
		<li>过期</li>
		<li>预定</li>
		<br>
	</ul>
		<li><b>发行人：</b>发行人的名称和登录名</li>
		<li><b>买方：</b>买方的名称和登录名</li>
		<li><b>激活日期：</b>搜索期间内的激活日期</li>
		<li><b>过期日期：</b>搜寻期间内的过期日期</li>
	</ul>
<hr class="help">


<a name="certifications_search_results"></a>
<h3>认证搜索结果</h3>
此页将显示认证搜索结果列表。<br>
为了查看认证细节，您可以选择在列表中的认证的放大镜图标
<img border="0" src="${images}/view.gif" width="16" height="16">。
<br>
<hr>


<a name="guarantees"></a>
<h2>担保</h2>
<p class="sub_description"></p>
<i>在哪里找到它？</i><br> 担保可在菜单中找到：担保 > 担保。<br>
<hr class="help">


<a name="guarantee_register"></a>
<h3>注册（新）担保</h3>
可以有两个方式创建担保：<br>
<ul>
	<li>由发行人或管理员手动（“买方和卖方”和“买方”类型）</li>
	<li>自动在担保激活后（付款义务类型）</li>
</ul>
担保可以有以下字段：
<ul>
	<li><b>买方：</b>买方的名称和登录名</li>
	<li><b>发行人：</b>发行人的名称和登录名</li>
	<li><b>卖方：</b>卖方的名称和登录名</li>
	<li><b>标识符：</b>一个独特的担保标识代码（可选）</li>
	<li><b>有效期：</b>担保活跃的期间</li>
	<li><b>信贷费：</b>信贷费的值<span class="admin">（见<a
	href="#edit_guarantee_type"><u>担保类型</u>）</a></span><br>
	此字段是可编辑的，取决于担保类型的配置。</li>
	<li><b>发放费：</b>发放费的值<span class="admin">（见<a
	href="#edit_guarantee_type"><u>担保类型</u>）</a></span><br>
	此字段是可编辑的，取决于担保类型的配置。</li>
	<br>
</ul>
担保在有效期起始日期将进入接受状态。当担保获取接受状态，会产生贷款和收取可能的费用。
<br>只能删除由管理员手动创建的担保，条件是在等待管理员的状态和唯一通过的状态是等待发行人。
<br> <br>
<hr class="help">


<a name="guarantees_search"></a>
<h3>搜索担保</h3>
在此页中，您可以搜索担保。下面的搜索选项可供选择：
<ul>
	<li><b>状态：</b>担保者的<a href="#statusG"><u>状态</u> </a>。</li>
	<li><b>买方：</b>买方的名称和登录名</li>
	<li><b>发行人：</b>发行人的名称和登录名</li>
	<li><b>卖方：</b>卖方的名称和登录名</li>
	<li><b>有效期：</b>担保活跃的期间</li>
	<li><b>届满日期：</b>搜寻期间内的届满日期</li>
	<li><b>金额：</b>担保的金额</li>
</ul>
<hr class="help">


<a name="guarantees_search_results"></a>
<h3>搜索担保结果</h3>
此页显示担保的搜索结果。
<br>要查看担保细节，请选择相应的图标
<img border="0" src="${images}/view.gif" width="16" height="16">。
<p>
<hr class="help">


<a name="guarantee_details"></a>
<h3>担保细节</h3>
本页面显示以下担保的细节，如
<a href="#guarantee_register"><u>注册担保</u> </a> 的帮助所述。
其他字段：
<ul>
	<li><b>状态：</b>担保目前的<a href="#statusG"><u>状态</u></a></li>
	<li><b>注册日期：</b>担保注册的日期</li>
	<li><b>生成的贷款：</b>如果担保产生了贷款，将显示贷款的链接</li>
</ul>
<p>
<hr class="help">


<a name="guarantee_payment_obligations"></a>
<h3>担保的付款义务</h3>
这个视窗将显示与担保有关的
<a href="#payment_obligations"><u>付款义务</u></a> 清单。 
<p>
<hr class="help">


<a name="guarantee_logs"></a>
<h3>担保状态的变化（日志）</h3>
这个视窗将显示 <a href="#statusG"><u>状态</u></a> 清单。
<p>
<hr class="help">


<h3>担保状态</h3>
<a name="statusG"></a>担保可以有各种不同的状态，取决于担保类型和运作流程。
下面列出了所有可能的状态，每个状态会描述导致这状态的可能采取的行动。
<p>

<b>状态/行动</b>
<ul>
	<li>等待发行人</li>
	<ul>
		<li>当管理员注册一个新的担保，需要由发行人或发行人及管理员授权。</li>
		<li>当卖方接受一个或“一套”付款义务。</li>
	</ul>
	<li>等待管理员</li>
	<ul>
		<li>当管理员注册一个新的担保，（只）需要由管理员授权。</li>
		<li>当发行人授权一个“等待发行人”状态的担保，而它被配置为也等待管理员授权。</li>
	</ul>
	<li>接受</li>
		<ul>
		<li>当管理员注册了一个新的不需要授权的担保。</li>
		<li>当管理员接受了一个在“等待管理员”状态的担保。</li>
		<li>当发行人接受了一个在“等待发行人”状态的担保。</li>
	</ul>

	<li>拒绝</li>
	<ul>
		<li>当发行人拒绝了一个在“等待发行人”状态的担保。</li>
		<li>当管理员拒绝了一个在“等待管理员”状态的担保。</li>
	</ul>
	<li>取消</li>
	<ul>
		<li>当管理员取消了一个在“等待管理员”或“等待发行人”状态的担保。</li>
		<li>当管理员取消了一个在“接受”状态的担保，但贷款尚未产生，
		因为它需要另一个（贷款）的授权。</li>
	</ul>
	<li>没有行动</li>
	<ul>
		<li>当一个在“等待发行人”状态的担保的最长期间已过期（发行人不执行任何行动）。</li>
		<li>当一个在“等待管理员”状态的担保的最长期间已过期（管理员不执行任何行动）。</li>
	</ul>
</ul>

<h3>通知</h3>
担保的状态变化可以产生以下通知：
<ul>
	<li>当一个新创建的担保取得“等待发行人”状态时发送给发行人。</li>
	<li>当现有的担保已被取消或最长期限过期时发送给发行人。</li>
	<li>当担保状态变为接受、拒绝或取消时发送给买方。</li>
	<li>当担保状态变为接受、拒绝或取消时发送给卖方。</li>
	<li>当一个新创建的担保取得“等待管理员”状态时发送给管理员。</li>
</ul>
<p>
<hr class="help">


<a name="guarantee_authorization"></a>
<h3>担保授权</h3>
在运作流程的各个步骤和不同的授权角色中，担保可能需要授权。授权配置是在
<a href="#edit_guarantee_type"><u>担保类型</u></a> 的“授权”选项中定义。
<p>
<hr>


<a name="payment_obligations"></a>
<h2>付款义务</h2>
<p class="sub_description">付款义务是（联环系统）数码文件，正如一个贷款或发票。
正如这个词所暗示的，付款义务是“买方”支付“卖方”的义务。
付款义务由买方创建，通常是为了每一个未偿还的供应商（卖方）的发票。
付款义务有一个“金额”和“届满日期”，可以捆绑在一个“包”内，以便更方便地处理。
当卖方接受付款义务，他/她将收到付款义务金额的内部单位。
一旦付款义务被卖方接受及由发行人（可选地也由联环系统管理员）验证，他们会产生一个贷款和一个担保。
</p>

<i>在哪里可以找到它？</i><br>付款义务可在“菜单：担保>付款义务”找到。
<p>
<hr class="help">


<a name="payment_obligations_search"></a>
<h3>搜索付款义务</h3>
在此页面您可以搜索付款义务。
<br>可能的搜索选项：
<ul>
	<li><b>状态：</b>是付款义务的<a href="#statusOP"><u>状态</u></a></li>
	<li><b>货币：</b>（如果存在多种货币时才显示）</li>
	<li><b>买方/卖方：</b>根据登录用户的角色</li>
	<li><b>届满日期：</b>在发布日期后，卖方将不会见到付款义务。
	发布日期必须在届满日期之前。</li>
	<li><b>金额：</b>付款义务的金额范围</li>
</ul>
<p>
<hr class="help">


<a name="payment_obligations_search_results"></a>
<h3>搜索付款义务结果</h3>
这个视窗将显示搜索结果。要访问一个付款义务，您可以选择图标
<img border="0" src="${images}/view.gif" width="16" height="16">。
<p>
<hr class="help">


<a name="edit_payment_obligation"></a>
<h3>创建和编辑付款义务</h3>
买方有了一个有效的 <a href="#certifications"><u>认证</u></a>，
可以发出付款义务给他们的供应商（卖方）。<br>
买方可以在菜单选项“担保>付款义务”创建付款义务。<br>
必要的字段是：<br>
<ul>
	<li><b>卖方：</b>卖方的名称和登录名</li>
	<li><b>发布到期日期：</b>发布到期日期，之后，卖方将不会见到付款义务。
	发布到期日期必须在届满日期之前。</li>
	<li><b>届满日期：</b>卖方可以接受付款义务的最后日期</li>
	<li><b>金额：</b>付款义务的金额（通常是具体发票的金额）</li>
	<li><b>描述：</b>可选的描述</li>
</ul>
<br> 
一旦付款义务已创建，以下选项可供选择：
<ul>
	<li><b>删除：</b>这将删除付款义务</li>
	<li><b>发布：</b>将付款义务置于发布状态。意思是卖方将可见到它。</li>
	<li><b>变更：</b>使用此选项可改变付款义务。</li>
	<li><b>取消发布： </b>（仅在发布状态时可见）。
	选择此选项，付款义务将重回“注册”状态。意思是可以改变它和再次发布。</li>
</ul>
<p>
<hr class="help">


<a name="accept_payment_obligation"></a>
<h3>卖方的行动</h3>
当一个（或一包）付款义务是在“发布”状态，卖方可以在付款义务的视窗选择选接受或拒绝付款义务。
<br><br> 
为了更方便，是可以由卖方提交多个付款义务作为一个“包”。
这可以在付款义务搜索结果的每个付款义务前标记选择框。
<br>注意：这些选项只当搜索结果是受限于买方和货币（如果有一种以上的货币）时才出现。
<br>在被拒绝时，付款义务将简单地被取消，买方将得到通知。 
<br>当卖方接受付款义务，将发生以下情况。
<ul>
	<li>将产生一个担保，金额是付款义务的金额。</li>
	<li>发行人将要授权这个担保。</li>
	<li>可选地，管理员也将要授权这个担保。</li>
	<li>在各级授权后，担保将进入“接受”状态，会产生以买方作为目标账户的贷款。</li>
	<li>贷款金额将被转发到卖方账户。这意味着贷款将在买方开启，但卖方已扣除担保金额。</li>
	<li>贷款费和发放费会被收取（取决于
	<a href="#edit_guarantee_type"><u>担保类型</u></a>
	的配置）。</li>
</ul>
所有关于付款义务的状态变化会被记录和发送通知到买方和卖方。
<p>
<hr class="help">


<a name="payment_obligation_logs"></a>
<h3>付款义务状态的变化</h3>
这个视窗提供了有关
<a href="#statusOP"><u>状态</u></a>
变化的信息。
<hr class="help">


<h3>付款义务的状态</h3>
<a name="statusOP"></a>付款义务可以有各种状态，取决于担保类型和运作流程。
下面列出所有可能的状态，每一个状态将说明导致状态的可能行动。
<p>

<b>状态/行动</b>
<ul>
	<li>注册：</li>
	<ul>
		<li>当买方创建一个新的付款义务。</li>
		<li>当买方取消发布付款义务。</li>
		<li>当一个在发布状态的付款义务已达到最后的发布日期。</li>
	</ul>
	<li>发布：</li>
	<ul>
		<li>当买方发布在注册状态的付款义务。</li>
	</ul>
		<li>接受：</li>
	<ul>
		<li>当卖方接受在发布状态的付款义务。</li>
	</ul>
		<li>拒绝：</li>
	<ul>
		<li>当卖方拒绝在发布状态的付款义务。</li>
		</ul>
	<li>过期：</li>
	<ul>
	<li>当在发布状态的付款义务达到届满日期。</li>
	</ul>
</ul>
<p>
	
<h3>通知</h3>
付款义务状态的变化可以产生以下通知：<br>
<ul>
	<li>当付款义务得到发布状态时通知卖方。</li>
	<li>当付款义务得到拒绝状态时通知买方。</li>
</ul>

</div>

<div class='help'>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
</div>